/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruFilterUnitService;
import com.jxdinfo.hussar.authorization.organ.vo.StruFilteredVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.SysStruFilterUnitServiceImpl")
public class SysStruFilterUnitServiceImpl
implements ISysStruFilterUnitService {
    @Resource
    private SysStruMapper sysStruMapper;

    public StruFilteredVo getFilteredStruInfo(Long struId) {
        SysStru closestUnitStru = new SysStru();
        SysStru currentStru = (SysStru)this.sysStruMapper.selectById(struId);
        if (HussarUtils.isEmpty((Object)currentStru)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_ORGAN_INFORMATION_EMPTY.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)currentStru) && "1".equals(currentStru.getStruType())) {
            closestUnitStru = currentStru;
        } else if (HussarUtils.isNotEmpty((Object)currentStru) && "2".equals(currentStru.getStruType())) {
            String struFid = currentStru.getStruFid();
            String[] struIdStr = struFid.split("/");
            List struIdList = Arrays.stream(struIdStr).filter(HussarUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
            List parentStru = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, struIdList)).eq(SysStru::getStruType, (Object)"1"));
            HashMap sysStruMap = new HashMap();
            for (SysStru sysStru : parentStru) {
                sysStruMap.put(sysStru.getId(), sysStru);
            }
            for (int i = struIdList.size() - 1; i >= 0; --i) {
                if (!sysStruMap.containsKey(struIdList.get(i))) continue;
                closestUnitStru = (SysStru)sysStruMap.get(struIdList.get(i));
                break;
            }
        }
        HashSet<Long> filteredStruIds = new HashSet<Long>();
        filteredStruIds.add(closestUnitStru.getId());
        List directChildDeptStru = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)closestUnitStru.getId())).eq(SysStru::getStruType, (Object)"2"));
        if (HussarUtils.isNotEmpty((Object)directChildDeptStru)) {
            List childDeptStruFids = directChildDeptStru.stream().map(SysStru::getStruFid).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            for (String childDeptStruFid : childDeptStruFids) {
                ((LambdaQueryWrapper)queryWrapper.or()).likeRight(SysStru::getStruFid, (Object)childDeptStruFid);
            }
            List allChildStru = this.sysStruMapper.selectList((Wrapper)queryWrapper);
            List allChildStruIds = allChildStru.stream().map(SysStru::getId).collect(Collectors.toList());
            filteredStruIds.addAll(allChildStruIds);
        }
        StruFilteredVo result = new StruFilteredVo();
        result.setClosestUnitStru(closestUnitStru);
        result.setFilteredStruIds(filteredStruIds);
        Long rootId = this.sysStruMapper.getStruRootId(struId);
        result.setRootId(rootId);
        return result;
    }
}

