/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.post.dto.QueryAuditPostDto;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.dao.SysPostRoleAuditMapper;
import com.jxdinfo.hussar.authorization.relational.manager.QueryPostRoleAuditManager;
import com.jxdinfo.hussar.authorization.relational.vo.PostRoleAuditVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.relational.manager.impl.queryPostRoleAuditManagerImpl")
public class QueryPostRoleAuditManagerImpl
implements QueryPostRoleAuditManager {
    @Resource
    private SysPostRoleAuditMapper sysPostRoleAuditMapper;
    @Autowired
    private IHussarBasePostService hussarBasePostService;
    @Autowired
    private ISysRolesService sysRolesService;

    @Override
    public Page<PostRoleAuditVo> queryPostRoleAuditList(PageInfo pageInfo, QueryAuditPostDto queryAuditPostDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("roleName", SqlQueryUtil.transferSpecialChar((String)queryAuditPostDto.getRoleName()));
        queryParams.put("postName", SqlQueryUtil.transferSpecialChar((String)queryAuditPostDto.getPostName()));
        if (HussarUtils.isNotEmpty((Object)queryAuditPostDto.getAuditStatus())) {
            queryParams.put("auditStatus", String.valueOf(queryAuditPostDto.getAuditStatus()));
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List list = this.hussarBasePostService.list((Wrapper)new LambdaQueryWrapper().eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List rolesList = this.sysRolesService.list();
        if (HussarUtils.isEmpty((Object)list) || HussarUtils.isEmpty((Object)rolesList)) {
            return page;
        }
        List postIds = list.stream().map(SysPost::getId).collect(Collectors.toList());
        List roleIds = rolesList.stream().map(SysRoles::getId).collect(Collectors.toList());
        queryParams.put("postIds", postIds);
        queryParams.put("roleIds", roleIds);
        List<PostRoleAuditVo> postRoleAuditVos = this.sysPostRoleAuditMapper.queryPostRoleAuditList((Page<PostRoleAuditVo>)page, queryParams);
        page.setRecords(postRoleAuditVos);
        return page;
    }
}

