/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.impl.FunctionRoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserAuditMapper;
import com.jxdinfo.hussar.authorization.relational.manager.AuditStruUserManager;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.relational.manager.impl.auditStruUserManagerImpl")
public class AuditStruUserManagerImpl
implements AuditStruUserManager {
    @Resource
    private SysStruUserAuditMapper sysStruUserAuditMapper;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private UserChangeNotify userChangeNotify;
    @Resource
    private FunctionRoleUserAuthorizationChangeReporter functionRoleUserAuthorizationChangeReporter;

    @Override
    public Boolean pass(Long auditId) {
        boolean result;
        SysStruUserAudit struUserAudit = (SysStruUserAudit)this.sysStruUserAuditMapper.selectById(auditId);
        String operateType = struUserAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAdd(struUserAudit);
        } else if ("2".equals(operateType)) {
            result = this.doAuditDelete(struUserAudit);
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UNSUPPORTED_OPERATION_TYPE.getMessage()));
        }
        if (result) {
            this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"user", Collections.singletonList(struUserAudit.getUserId())});
        }
        return result;
    }

    @Override
    public Boolean reject(Long auditId) {
        SysStruUserAudit struUserAudit = (SysStruUserAudit)this.sysStruUserAuditMapper.selectById(auditId);
        struUserAudit.setAuditStatus("2");
        return this.sysStruUserAuditMapper.updateById(struUserAudit) > 0;
    }

    private boolean doAuditDelete(SysStruUserAudit struUserAudit) {
        List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getStruId, (Object)struUserAudit.getStruId())).eq(SysStruUser::getUserId, (Object)struUserAudit.getUserId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)struUsers)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_FAIL_NO_EXIST_USER_ORGAN_RELATION.getMessage()));
        }
        boolean remove = this.sysStruUserService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getStruId, (Object)struUserAudit.getStruId())).eq(SysStruUser::getUserId, (Object)struUserAudit.getUserId()));
        struUserAudit.setAuditStatus("1");
        boolean updateFlag = this.sysStruUserAuditMapper.updateById(struUserAudit) > 0;
        SysUsers user = this.sysUsersService.getById(struUserAudit.getUserId());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
        return remove && updateFlag;
    }

    private boolean doAuditAdd(SysStruUserAudit struUserAudit) {
        List struList = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)struUserAudit.getStruId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)struList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_ORGAN_NOT_EXIST.getMessage()));
        }
        List rolesList = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)struUserAudit.getUserId())).ne(SysUsers::getAccountStatus, (Object)"2"));
        if (HussarUtils.isEmpty((Object)rolesList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_ROLE_NOT_EXIST.getMessage()));
        }
        List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getStruId, (Object)struUserAudit.getStruId())).eq(SysStruUser::getUserId, (Object)struUserAudit.getUserId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)struUsers)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_USER_ORGAN_RELATION.getMessage()));
        }
        SysStruUser struUser = new SysStruUser();
        struUser.setStruId(struUserAudit.getStruId());
        struUser.setUserId(struUserAudit.getUserId());
        boolean saveFlag = this.sysStruUserService.save((Object)struUser);
        struUserAudit.setAuditStatus("1");
        boolean updateFlag = this.sysStruUserAuditMapper.updateById(struUserAudit) > 0;
        SysUsers user = this.sysUsersService.getById(struUser.getUserId());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
        return saveFlag && updateFlag;
    }
}

