/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.ResPermitDto;
import com.jxdinfo.hussar.authorization.permit.model.SysModules;
import com.jxdinfo.hussar.authorization.permit.model.SysStruResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.StruResVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysStruResourcesServiceImpl
extends HussarServiceImpl<SysStruResourcesMapper, SysStruResources>
implements ISysStruResourcesService {
    @Resource
    private SysStruResourcesMapper sysStruResourcesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruService sysStruService;

    public List<SysModules> getGradeAdminModuleId(List<Long> functionIdList) {
        return this.sysStruResourcesMapper.getGradeAdminModuleId(functionIdList);
    }

    public List<Long> getFunId(List<Long> resourceIdList) {
        return this.sysStruResourcesMapper.getFunId(resourceIdList);
    }

    public List<Long> getResIdList(Long struId) {
        return this.sysStruResourcesMapper.getResIdList(struId);
    }

    public List<String> getUserResIdList(List<String> roleResult) {
        return this.sysStruResourcesMapper.getUserResIdList(roleResult);
    }

    public List<Long> getResourceIdList(Long resourceId, String type) {
        List<Object> resourceIdList = new ArrayList();
        if ("isModule".equals(type)) {
            resourceIdList = this.sysStruResourcesMapper.getResourceIdByModuleId(resourceId);
        } else if ("isFun".equals(type)) {
            resourceIdList = this.sysStruResourcesMapper.getResourceIdByFuncId(resourceId);
        } else {
            resourceIdList.add(resourceId);
        }
        return resourceIdList;
    }

    @HussarTransactional
    public ApiResponse saveRetrieveResource(ResPermitDto resPermitDto) {
        String resourceId = resPermitDto.getResourceIdHidden();
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RECYCLING_RESOURCE_ID_EMPTY.getMessage()));
        }
        String[] struIdArr = resPermitDto.getStruIdHidden() == null ? "".split(",") : resPermitDto.getStruIdHidden().split(",");
        String type = resPermitDto.getTypeHidden();
        String[] orginalIds = resPermitDto.getOriginal() == null ? "".split(",") : resPermitDto.getOriginal().split(",");
        List<String> originalIdList = Arrays.asList(orginalIds);
        ArrayList originalIds = new ArrayList();
        originalIdList.forEach(id -> originalIds.add(Long.valueOf(id)));
        ArrayList<List<Long>> originalIdDoubleList = new ArrayList<List<Long>>();
        int size = originalIds.size();
        for (int i = 0; i < originalIdList.size(); i += 999) {
            if (i + 999 < size) {
                originalIdDoubleList.add(originalIds.subList(i, i + 999));
                continue;
            }
            originalIdDoubleList.add(originalIds.subList(i, size));
        }
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        List<Long> resourceIdList1 = this.getResourceIdList(Long.valueOf(resourceId), type);
        this.sysStruResourcesMapper.deleteStruResource(originalIdDoubleList, resourceIdList1);
        this.sysRoleResourceMapper.deleteStruRoleResource(originalIdDoubleList, resourceIdList1);
        ArrayList<SysStruResources> resourceList = new ArrayList<SysStruResources>();
        for (String tmpStruId : struIdList) {
            if ("".equals(tmpStruId)) continue;
            for (Long tmpResourceId : resourceIdList1) {
                SysStruResources sysStruResources = new SysStruResources();
                sysStruResources.setStruId(Long.valueOf(tmpStruId));
                sysStruResources.setResourceId(tmpResourceId);
                resourceList.add(sysStruResources);
            }
        }
        if (ToolUtil.isNotEmpty(resourceList) && !super.saveBatch(resourceList, resourceList.size())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.RETRIEVE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.RETRIEVE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse saveDelegateResource(ResPermitDto resPermitDto) {
        String resourceId = resPermitDto.getResourceIdHidden();
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_ID_DELEGATION_EMPTY.getMessage()));
        }
        String[] struIdArr = resPermitDto.getStruIdHidden() == null ? "".split(",") : resPermitDto.getStruIdHidden().split(",");
        String type = resPermitDto.getTypeHidden();
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        ArrayList struIds = new ArrayList();
        struIdList.forEach(struId -> struIds.add(Long.valueOf(struId)));
        ArrayList<List<Long>> struIdDoubleList = new ArrayList<List<Long>>();
        int size = struIds.size();
        for (int i = 0; i < struIds.size(); i += 999) {
            if (i + 999 < size) {
                struIdDoubleList.add(struIds.subList(i, i + 999));
                continue;
            }
            struIdDoubleList.add(struIds.subList(i, size));
        }
        List<Long> resourceIdList1 = this.getResourceIdList(Long.valueOf(resourceId), type);
        this.sysStruResourcesMapper.deleteStruResource(struIdDoubleList, resourceIdList1);
        ArrayList<SysStruResources> resourceList = new ArrayList<SysStruResources>();
        for (String tmpStruId : struIdList) {
            for (Long tmpResourceId : resourceIdList1) {
                SysStruResources sysStruResources = new SysStruResources();
                sysStruResources.setStruId(Long.valueOf(tmpStruId));
                sysStruResources.setResourceId(tmpResourceId);
                resourceList.add(sysStruResources);
            }
        }
        if (ToolUtil.isEmpty(resourceList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ALL_RES_DEPLOYED.getMessage()));
        }
        if (!super.saveBatch(resourceList, resourceList.size())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DECENTRALIZE_FAILED.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.DELEGATE_SUCCESS.getMessage()));
    }

    public List<Long> getStruResourceCountMap(List<JSTreeModel> list, List<Long> resourceIdList) {
        ArrayList<Long> struIdList = new ArrayList<Long>();
        for (JSTreeModel jsTreeModel : list) {
            Long struId = jsTreeModel.getId();
            struIdList.add(struId);
        }
        int maxSize = resourceIdList.size();
        ArrayList<Long> rtnList = new ArrayList<Long>();
        ArrayList<List<Long>> array = new ArrayList<List<Long>>();
        int size = struIdList.size();
        for (int i = 0; i < size; i += 999) {
            if (i + 999 < size) {
                array.add(struIdList.subList(i, i + 999));
                continue;
            }
            array.add(struIdList.subList(i, size));
        }
        List<StruResVo> result = this.sysStruResourcesMapper.getStruResourceCountMap(array, resourceIdList);
        for (StruResVo struResVo : result) {
            Long struId = struResVo.getStruId();
            String countStr = struResVo.getStruCount();
            Long count = Long.parseLong(countStr);
            if (count.intValue() != maxSize) continue;
            rtnList.add(struId);
        }
        return rtnList;
    }

    public boolean checkHaveSuperiorOrg(String[] struIdArr) {
        List<String> struIdList = Arrays.asList(struIdArr);
        Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
        Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
        List childrenStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "01");
        boolean haveSuperiorOrg = false;
        for (String chooseStruId : struIdList) {
            if (childrenStruIdList.contains(Long.valueOf(chooseStruId))) continue;
            haveSuperiorOrg = true;
            break;
        }
        return haveSuperiorOrg;
    }
}

