/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.manager.AuditResourceRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResourceAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.service.impl.SysRoleResourceServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleResourceChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.auditResourceRoleManagerImpl")
public class AuditResourceRoleManagerImpl
implements AuditResourceRoleManager {
    public static Logger logger = LoggerFactory.getLogger(SysRoleResourceServiceImpl.class);
    @Resource
    private SysRoleResourceAuditMapper sysRoleResourceAuditMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private RoleResourceChangeNotify roleResourceChangeNotify;
    @Resource
    @Lazy
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    @Override
    public Boolean pass(Long auditId) {
        SysRoleResourceAudit roleResourceAudit = (SysRoleResourceAudit)this.sysRoleResourceAuditMapper.selectById(auditId);
        if (HussarUtils.isEmpty((Object)roleResourceAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_RESOURCE_AUDIT_NOT_FOUND.getMessage()));
        }
        Long roleId = roleResourceAudit.getRoleId();
        String operateType = roleResourceAudit.getOperateType();
        Long resourceId = roleResourceAudit.getResourceId();
        String relationSource = roleResourceAudit.getRelationSource();
        if ("3".equals(operateType)) {
            this.sysRoleResourceMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)roleId)).eq(SysRoleResource::getResourceId, (Object)resourceId)).eq(SysRoleResource::getRelationSource, (Object)relationSource));
        }
        if ("1".equals(operateType)) {
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setRelationSource(relationSource);
            this.sysRoleResourceMapper.insert(sysRoleResource);
        }
        List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
        SysRoles role = (SysRoles)this.sysRolesService.getById((Serializable)roleId);
        if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
            this.roleResourceChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
        }
        if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
            this.userAuthorizationChangeReporter.report(new Object[]{"resource", roleId});
        }
        roleResourceAudit.setAuditStatus("1");
        return this.sysRoleResourceAuditMapper.updateById(roleResourceAudit) > 0;
    }

    @Override
    public Boolean reject(Long auditId) {
        SysRoleResourceAudit roleResourceAudit = (SysRoleResourceAudit)this.sysRoleResourceAuditMapper.selectById(auditId);
        roleResourceAudit.setAuditStatus("2");
        return this.sysRoleResourceAuditMapper.updateById(roleResourceAudit) > 0;
    }
}

