/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.manager.ApproveRoleFunctionsAuditManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteRoleStruRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctionsAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResourceAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.service.impl.SysRoleFunctionsServiceImpl;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleFunctionChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleResourceChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.manager.impl.approveRoleFunctionsAuditManagerImpl")
public class ApproveRoleFunctionsAuditManagerImpl
implements ApproveRoleFunctionsAuditManager {
    @Resource
    private ISysRoleFunctionsAuditService sysRoleFunctionsAuditService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;
    @Resource
    private DeleteRoleStruRightManager deleteRoleStruRightManager;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private ISysFunctionsService functionsService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysResourcesService resourcesService;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Lazy
    @Resource
    private ISysFunctionResourcesService iSysFunctionResourcesService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private RoleFunctionChangeNotify roleFunctionChangeNotify;
    @Resource
    private RoleResourceChangeNotify roleResourceChangeNotify;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;
    @Resource
    private QueryDataRightManager queryDataRightManager;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private ISysRoleResourceAuditService sysRoleResourceAuditService;
    private static Logger logger = LoggerFactory.getLogger(SysRoleFunctionsServiceImpl.class);

    @Override
    @Transactional
    public String approve(Long auditId) {
        SysRoles role;
        List roleDataRights;
        SysRoleFunctionsAudit sysRoleFunctionsAudit = (SysRoleFunctionsAudit)this.sysRoleFunctionsAuditService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleFunctionsAudit::getId, (Object)auditId)).eq(SysRoleFunctionsAudit::getAuditStatus, (Object)"0"));
        if (HussarUtils.isEmpty((Object)sysRoleFunctionsAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_FUNCTION_AUDIT_NOT_FOUND.getMessage()));
        }
        Long roleId = sysRoleFunctionsAudit.getRoleId();
        Long functionId = sysRoleFunctionsAudit.getFunctionId();
        String operateType = sysRoleFunctionsAudit.getOperateType();
        if ("3".equals(operateType) && HussarUtils.isNotEmpty((Object)(roleDataRights = this.sysRoleDataRightService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleDataRight::getRoleId, (Object)roleId)).eq(SysRoleDataRight::getFunctionId, (Object)functionId))))) {
            List<Long> rightIds = roleDataRights.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
            logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u5220\u9664\u6570\u636e\u6743\u9650ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)rightIds.size(), rightIds);
            this.sysRoleDataRightService.removeByIds(rightIds);
            this.deleteRoleStruRightManager.deleteCustomStruBatch(rightIds);
        }
        if ("3".equals(operateType)) {
            List<Long> sysRoleResourceIds = this.sysFunctionResourcesMapper.getRelateResourceIdsByFunctionId(functionId);
            if (HussarUtils.isNotEmpty(sysRoleResourceIds)) {
                this.sysRoleResourceMapper.deleteBatchIds(sysRoleResourceIds);
            }
            this.sysRoleFunctionsMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)functionId));
        }
        if ("1".equals(operateType)) {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
            sysRoleFunctions.setRoleId(roleId);
            sysRoleFunctions.setFunctionId(functionId);
            sysRoleFunctions.setCreator(securityUser.getId());
            sysRoleFunctions.setLastEditor(securityUser.getId());
            sysRoleFunctions.setLastTime(now);
            sysRoleFunctions.setCreateTime(now);
            this.sysRoleFunctionsService.save((Object)sysRoleFunctions);
            List sysFunctionResources = this.iSysFunctionResourcesService.selectFunctionResByFuncIds(Collections.singletonList(functionId));
            ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
            for (SysFunctionResources functionResources : sysFunctionResources) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(roleId);
                sysRoleResource.setResourceId(functionResources.getResourceId());
                sysRoleResource.setRelationSource("1");
                sysRoleResource.setCreator(securityUser.getId());
                sysRoleResource.setLastEditor(securityUser.getId());
                sysRoleResource.setLastTime(now);
                sysRoleResource.setCreateTime(now);
                sysRoleResourceList.add(sysRoleResource);
            }
            if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
                List resIds = sysRoleResourceList.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList());
                logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u65b0\u589e\u7684\u5173\u8054\u5173\u7cfb\u4e2d\uff0c\u8d44\u6e90ID\u96c6\u5408\uff0c\u5171\u8ba1{}\u4e2a: {}", (Object)resIds.size(), resIds);
                this.iSysRoleResourceService.saveBatch(sysRoleResourceList);
                if (HussarUtils.isNotEmpty((Object)sysFunctionResources)) {
                    LambdaUpdateWrapper sysRoleResourceAuditUpdate = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)sysRoleResourceAuditUpdate.set(SysRoleResourceAudit::getAuditStatus, (Object)"1")).in(SysRoleResourceAudit::getResourceId, resIds)).eq(SysRoleResourceAudit::getRoleId, (Object)roleId)).eq(SysRoleResourceAudit::getAuditStatus, (Object)"0")).eq(SysRoleResourceAudit::getOperateType, (Object)"1");
                    this.sysRoleResourceAuditService.update((Wrapper)sysRoleResourceAuditUpdate);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(role = (SysRoles)this.sysRolesService.getById((Serializable)roleId)).getAppId()) && role.getAppId() != 1L) {
            this.roleFunctionChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
            this.roleResourceChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
        }
        if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
            this.userAuthorizationChangeReporter.report(new Object[]{"function", roleId});
        }
        List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        roleIdList.add(roleId);
        this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIdList);
        sysRoleFunctionsAudit.setAuditStatus("1");
        this.sysRoleFunctionsAuditService.updateById((Object)sysRoleFunctionsAudit);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_FUNCTION_AUDIT_APPROVE_SUCCESS.getMessage());
    }
}

