/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.jxdinfo.hussar.authorization.permit.model.SysUserAttachment;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentBoService;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserAttachmentVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7b7e\u540d\u4fe1\u606f"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.HussarBaseUserAttachmentController")
@RequestMapping(value={"/hussarBase/authorization/permit/signature"})
public class HussarBaseUserAttachmentController {
    @Autowired
    private IHussarBaseUserAttachmentBoService hussarBaseUserAttachmentBoService;

    @ApiOperation(value="\u4fdd\u5b58\u7b7e\u540d", notes="\u4fdd\u5b58\u7b7e\u540d")
    @PostMapping(value={"/saveOrUpdateSignature"})
    @AuditLog(moduleName="\u4fdd\u5b58\u7b7e\u540d", eventDesc="\u4fdd\u5b58\u7b7e\u540d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> saveOrUpdateSignature(@RequestBody SysUserAttachment sysUserAttachment) {
        return ApiResponse.success((Object)this.hussarBaseUserAttachmentBoService.updateUserSignInfo(sysUserAttachment));
    }

    @ApiOperation(value="\u67e5\u8be2\u7b7e\u540d", notes="\u67e5\u8be2\u7b7e\u540d")
    @PostMapping(value={"/getSignature"})
    @AuditLog(moduleName="\u67e5\u8be2\u7b7e\u540d", eventDesc="\u67e5\u8be2\u7b7e\u540d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysUserAttachmentVo> getSignature(@RequestBody SysUserAttachment sysUserAttachment) {
        return ApiResponse.success((Object)this.hussarBaseUserAttachmentBoService.queryUserSign(sysUserAttachment));
    }

    @GetMapping(value={"/getSystemTime"})
    @CheckSafe
    public ApiResponse<String> getSystemTime() {
        return ApiResponse.success((String)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

