/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dto.ResModuleBackDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceModuleTreeDto;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.authorization.permit.vo.ModuleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchModuleVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b0\u7248\u8d44\u6e90\u7ef4\u62a4"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseResourceController")
@RequestMapping(value={"/hussarBase/authorization/permit/resource"})
public class HussarBaseResourceController {
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private ISysResourceMosulesService sysResourceMosulesService;

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u4e0b\u9875\u9762\u53ca\u5143\u7d20\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u6a21\u5757\u4e0b\u9875\u9762\u53ca\u5143\u7d20\u8d44\u6e90\u5217\u8868")
    @GetMapping(value={"/getPageAndElementResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6a21\u5757\u4e0b\u9875\u9762\u53ca\u5143\u7d20\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> getPageAndElementResources(@ApiParam(value="\u6a21\u5757id") Long moduleId) {
        return ApiResponse.success((Object)this.sysResourcesService.getPageAndElementResources(moduleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u5185\u5143\u7d20\u8d44\u6e90", notes="\u83b7\u53d6\u9875\u9762\u5185\u5143\u7d20\u8d44\u6e90")
    @GetMapping(value={"/elementResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u9875\u9762\u5185\u5143\u7d20\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ElementResourceVo>> elementResources(@ApiParam(value="\u9875\u9762\u8def\u7531") String pagePath) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_CURRENT_LOGIN_USER.getMessage()));
        }
        List roleIds = user.getRolesList();
        return ApiResponse.success((Object)this.sysResourcesService.elementResources(pagePath, roleIds));
    }

    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u5185\u6240\u6709\u5143\u7d20\u8d44\u6e90ID", notes="\u83b7\u53d6\u9875\u9762\u5185\u6240\u6709\u5143\u7d20\u8d44\u6e90ID")
    @GetMapping(value={"/elementResourceIds"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u9875\u9762\u5185\u6240\u6709\u5143\u7d20\u8d44\u6e90ID", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> elementResourcesIds(@ApiParam(value="\u9875\u9762\u8def\u7531") String pagePath) {
        return ApiResponse.success((Object)this.sysResourcesService.getElementResIds(pagePath));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u8d44\u6e90\u6a21\u5757\u6811", notes="\u61d2\u52a0\u8f7d\u8d44\u6e90\u6a21\u5757\u6811")
    @GetMapping(value={"/lazyLoadResModuleTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u8d44\u6e90\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ModuleTreeVo>> lazyLoadResModuleTree(@ApiParam(value="\u8d44\u6e90\u6a21\u5757\u6811dto") ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)this.sysResourceMosulesService.lazyLoadResModuleTree(resTreeDto));
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u8d44\u6e90\u6a21\u5757\u5217\u8868", notes="\u6a21\u7cca\u67e5\u8be2\u8d44\u6e90\u6a21\u5757\u5217\u8868")
    @GetMapping(value={"/searchResModule"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6a21\u7cca\u67e5\u8be2\u8d44\u6e90\u6a21\u5757\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchModuleVo>> searchResModule(@ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo pageInfo, @ApiParam(value="\u6a21\u5757\u540d\u79f0") @RequestParam(value="name") String name) {
        return ApiResponse.success((Object)this.sysResourceMosulesService.searchResModule(pageInfo, name));
    }

    @ApiOperation(value="\u70b9\u51fb\u8d44\u6e90\u6a21\u5757\u8fd4\u56de\u8d44\u6e90\u6a21\u5757\u6811", notes="\u70b9\u51fb\u8d44\u6e90\u6a21\u5757\u8fd4\u56de\u8d44\u6e90\u6a21\u5757\u6811")
    @GetMapping(value={"/backResModuleTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u70b9\u51fb\u8d44\u6e90\u6a21\u5757\u8fd4\u56de\u8d44\u6e90\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ModuleTreeVo>> backResModuleTree(@ApiParam(value="\u9009\u4e2d\u8282\u70b9") @RequestParam(value="id") Long id) {
        return ApiResponse.success((Object)this.sysResourceMosulesService.backResModuleTree(id));
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u8d44\u6e90\u53ca\u6a21\u5757\u5217\u8868", notes="\u6a21\u7cca\u67e5\u8be2\u8d44\u6e90\u53ca\u6a21\u5757\u5217\u8868")
    @GetMapping(value={"/searchModuleAndRes"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6a21\u7cca\u67e5\u8be2\u8d44\u6e90\u53ca\u6a21\u5757\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchModuleVo>> searchModuleAndRes(@ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo pageInfo, ResourceModuleTreeDto resourceModuleTreeDto) {
        return ApiResponse.success((Object)this.sysResourceMosulesService.searchModuleAndRes(pageInfo, resourceModuleTreeDto));
    }

    @ApiOperation(value="\u70b9\u51fb\u8d44\u6e90/\u6a21\u5757\u8fd4\u56de\u8d44\u6e90\u6811", notes="\u70b9\u51fb\u8d44\u6e90/\u6a21\u5757\u8fd4\u56de\u8d44\u6e90\u6811")
    @GetMapping(value={"/backModuleAndResTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u70b9\u51fb\u8d44\u6e90/\u6a21\u5757\u8fd4\u56de\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> backModuleAndResTree(ResModuleBackDto resModuleBackDto) {
        return ApiResponse.success((Object)this.sysResourceMosulesService.backModuleAndResTree(resModuleBackDto));
    }
}

