/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.jxdinfo.hussar.authorization.permit.dto.DataRightsByRoleIdDto;
import com.jxdinfo.hussar.authorization.permit.dto.DataRightsDto;
import com.jxdinfo.hussar.authorization.permit.dto.DeleteDataRightDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseDataRightsService;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeTypeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6743\u9650\u4fe1\u606f"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseDataRightController")
@RequestMapping(value={"/hussarBase/authorization/permit/dataRight"})
public class HussarBaseDataRightsController {
    @Autowired
    private IHussarBaseDataRightsService hussarBaseDataRightsService;

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6743\u9650\u4fe1\u606f", notes="\u4fdd\u5b58\u6570\u636e\u6743\u9650\u4fe1\u606f")
    @PostMapping(value={"/saveOrUpdateDataRight"})
    @AuditLog(moduleName="\u6570\u636e\u6743\u9650\u4fe1\u606f", eventDesc="\u4fdd\u5b58\u6570\u636e\u6743\u9650\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:authorization:permit:dataRight:saveOrUpdateDataRight"})
    public ApiResponse saveRoleDataRight(@ApiParam(value="\u6743\u9650\u4fe1\u606fdto") @RequestBody List<DataRightsDto> dataRightsDtoList) {
        return this.hussarBaseDataRightsService.saveOrUpdateDataRight(dataRightsDtoList);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6743\u9650\u4fe1\u606f", notes="\u4fdd\u5b58\u6570\u636e\u6743\u9650\u4fe1\u606f")
    @PostMapping(value={"/saveOrUpdateDataRightByRoleId"})
    @AuditLog(moduleName="\u6570\u636e\u6743\u9650\u4fe1\u606f", eventDesc="\u4fdd\u5b58\u6570\u636e\u6743\u9650\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"hussarBase:authorization:permit:dataRight:saveOrUpdateDataRight"})
    public ApiResponse<Boolean> saveOrUpdateDataRightByRoleId(@ApiParam(value="\u6743\u9650\u4fe1\u606fdto") @RequestBody DataRightsByRoleIdDto dataRightsByRoleIdDto) {
        return this.hussarBaseDataRightsService.saveOrUpdateDataRightByRoleId(dataRightsByRoleIdDto);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6743\u9650\u4fe1\u606f", notes="\u5220\u9664\u6570\u636e\u6743\u9650\u4fe1\u606f")
    @PostMapping(value={"/deleteDataRight"})
    @AuditLog(moduleName="\u6570\u636e\u6743\u9650\u4fe1\u606f", eventDesc="\u5220\u9664\u6570\u636e\u6743\u9650\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse deleteDataRight(@ApiParam(value="\u6570\u636e\u6743\u9650id") @RequestBody DeleteDataRightDto deleteDataRightDto) {
        return this.hussarBaseDataRightsService.deleteDataRight(deleteDataRightDto);
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u53ef\u89c1\u8303\u56f4\u4e0b\u62c9\u5217\u8868", notes="\u6839\u636e\u8d44\u6e90\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u53ef\u89c1\u8303\u56f4\u4e0b\u62c9\u5217\u8868")
    @GetMapping(value={"/getScopeTypeList"})
    @AuditLog(moduleName="\u6570\u636e\u6743\u9650\u4fe1\u606f", eventDesc="\u6839\u636e\u8d44\u6e90\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u53ef\u89c1\u8303\u56f4\u4e0b\u62c9\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DataScopeTypeVo>> getScopeTypeList(@ApiParam(value="\u8d44\u6e90\u7c7b\u578b\u7f16\u7801") @RequestParam String resTypeCode) {
        return ApiResponse.success((Object)this.hussarBaseDataRightsService.getScopeTypeList(resTypeCode));
    }
}

