/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.util.UserLogoutCacheUtil;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteOutsideUserManagerImpl")
public class DeleteOutsideUserManagerImpl
extends CommonOutsideUserManager
implements DeleteOutsideUserManager {
    @Override
    public R<String> deleteUser(String userAccount) {
        boolean convert;
        R result = new R();
        String account = StringUtils.trimToEmpty((String)userAccount);
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
        ArrayList errors = new ArrayList();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)userAccount, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && sysUsers != null) {
            Long employeeId = sysUsers.getEmployeeId();
            this.sysStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)employeeId));
            this.sysUsersService.removeById((Serializable)sysUsers.getId());
            this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId()));
            this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
            this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)employeeId));
            this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)sysUsers.getId()));
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
            UserLogoutCacheUtil.kickOutUser((Long)sysUsers.getId());
        }
        return result;
    }

    @Override
    public R<String> deleteOnlyUser(String userAccount) {
        boolean convert;
        R result = new R();
        String account = StringUtils.trimToEmpty((String)userAccount);
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
        ArrayList errors = new ArrayList();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)userAccount, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && sysUsers != null) {
            this.sysUsersService.removeById((Serializable)sysUsers.getId());
            this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId()));
            this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
            this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)sysUsers.getId()));
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
        }
        return result;
    }

    @Override
    public R<String> deleteLogicalUser(String userAccount) {
        boolean convert;
        R result = new R();
        String account = StringUtils.trimToEmpty((String)userAccount);
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()), false);
        ArrayList errors = new ArrayList();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)userAccount, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && sysUsers != null) {
            Long employeeId = sysUsers.getEmployeeId();
            this.sysStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)employeeId));
            sysUsers.setAccountStatus(UserStatus.DELETE.getCode());
            this.sysUsersService.updateById((Object)sysUsers);
            this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId()));
            this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
            this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)employeeId));
            this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)sysUsers.getId()));
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
        }
        return result;
    }
}

