/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteOutsideOrganizationManagerImpl")
public class DeleteOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements DeleteOutsideOrganizationManager {
    @Override
    public R<String> deleteOrganization(String organCode) {
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isNotEmpty(errors)) {
            result.setErrorList(errors);
            result.setSuccess(false);
            return result;
        }
        String code = StringUtils.trimToEmpty((String)organCode);
        SysOrgan sysOrgan = (SysOrgan)this.organService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)code));
        if (HussarUtils.isEmpty((Object)sysOrgan)) {
            result.setSuccess(true);
            result.setErrorList(null);
            return result;
        }
        SysStru sysStru = (SysStru)this.struService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrgan.getId()));
        List strus = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
        List<Long> struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
        List<Long> userStruIds = this.sysStruUserMapper.getDuplicateStruIdByStruIds(struIds);
        List<Long> postStruIds = this.sysStruPostMapper.getDuplicateStruIdByStruIds(struIds);
        List<Long> roleStruIds = this.sysStruRoleMapper.getDuplicateStruIdByStruIds(struIds);
        List<Long> staffStruIds = this.sysStruStaffMapper.getDuplicateStruIdByStruIds(struIds);
        if (HussarUtils.isNotEmpty(userStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_USER_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty(staffStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_STAFF_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty(postStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_POST_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty(roleStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_ROLE_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            Long parentId = sysStru.getParentId();
            SysStru parentSysStru = (SysStru)this.struService.getById((Serializable)parentId);
            Long count = this.struService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)parentId)).ne(SysStru::getId, (Object)sysStru.getId()));
            if (count == null || count < 1L) {
                parentSysStru.setIsLeaf("Y");
            }
            HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
            queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)sysOrgan.getOrganFcode()));
            queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            this.sysOrganMapper.deleteSubOrganByFcode(queryOrgParams);
            String struFid = sysStru.getStruFid();
            this.sysOfficeMapper.deleteBatchByStruFid(struFid);
            this.sysStruMapper.delete((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            this.sysStruMapper.updateById(parentSysStru);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }

    @Override
    public R<String> deleteOrganUserRelation(String organCode) {
        String code;
        SysStru sysStru;
        List strus;
        List struIds;
        List struUsers;
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(struUsers = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIds = (strus = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)(sysStru = this.sysStruMapper.selectStruByOrganCode(code = StringUtils.trimToEmpty((String)organCode))).getStruFid()))).stream().map(SysStru::getId).distinct().collect(Collectors.toList())))))) {
            Map<Long, List<Long>> userStruMap = this.getUserStruMap(struUsers);
            Set<Long> userIds = userStruMap.keySet();
            List struUserT = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds));
            Map<Long, List<Long>> userStruMapT = this.getUserStruMap(struUserT);
            ArrayList<Long> delUserIds = new ArrayList<Long>();
            for (Long userId : userIds) {
                List<Long> struIdList;
                List<Long> delStruIds = userStruMap.get(userId);
                if (!delStruIds.containsAll(struIdList = userStruMapT.get(userId))) continue;
                delUserIds.add(userId);
            }
            this.sysStruUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIds));
            if (HussarUtils.isNotEmpty(delUserIds)) {
                this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, userIds));
                this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserPost::getUserId, userIds));
                this.sysUsersMapper.deleteBatchIds(userIds);
            }
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }

    @Override
    public R<String> deleteOrganStaffRelation(String organCode) {
        String code;
        SysStru sysStru;
        List strus;
        List struIds;
        List struStaffs;
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(struStaffs = this.sysStruStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStruId, struIds = (strus = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)(sysStru = this.sysStruMapper.selectStruByOrganCode(code = StringUtils.trimToEmpty((String)organCode))).getStruFid()))).stream().map(SysStru::getId).distinct().collect(Collectors.toList())))))) {
            Map<Long, List<Long>> staffStruMap = this.getStaffStruMap(struStaffs);
            Set<Long> staffIds = staffStruMap.keySet();
            List struStaffT = this.sysStruStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
            Map<Long, List<Long>> staffStruMapT = this.getStaffStruMap(struStaffT);
            ArrayList<Long> delStaffIds = new ArrayList<Long>();
            for (Long staffId : staffIds) {
                List<Long> struIdList;
                List<Long> delStruIds = staffStruMap.get(staffId);
                if (!delStruIds.containsAll(struIdList = staffStruMapT.get(staffId))) continue;
                delStaffIds.add(staffId);
            }
            this.sysStruStaffMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStruId, struIds));
            if (HussarUtils.isNotEmpty(delStaffIds)) {
                List users = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, delStaffIds));
                if (HussarUtils.isNotEmpty((Object)users)) {
                    List userIds = users.stream().map(SysUsers::getId).distinct().collect(Collectors.toList());
                    this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, userIds));
                    this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserPost::getUserId, userIds));
                    this.sysStruUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds));
                    this.sysUsersMapper.deleteBatchIds(userIds);
                }
                this.sysStaffMapper.deleteBatchIds(delStaffIds);
            }
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }

    @Override
    public R<String> deleteOrganPostRelation(String organCode) {
        String code;
        SysStru sysStru;
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(sysStru = this.sysStruMapper.selectStruByOrganCode(code = StringUtils.trimToEmpty((String)organCode))))) {
            List strus = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            List struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            this.sysStruPostMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, struIds));
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }

    @Override
    public R<String> deleteOrganRoleRelation(String organCode) {
        String code;
        SysStru sysStru;
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(sysStru = this.sysStruMapper.selectStruByOrganCode(code = StringUtils.trimToEmpty((String)organCode))))) {
            List strus = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            List struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            this.sysStruRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, struIds));
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }
}

