/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAssistOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.enums.StruRoleStatus;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.manager.impl.EditOrganizationAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.properties.HussarSystemIdProperties;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.organmanager.OrganChangeNotify;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonOrganizationManager {
    @Autowired
    protected ISysOrgEventService sysOrgEventService;
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    protected ISysOrganService sysOrganService;
    @Autowired
    protected ISysStruService sysStruService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysOrganMapper sysOrganMapper;
    @Resource
    protected SysStruRuleMapper sysStruRuleMapper;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysRolesMapper sysRolesMapper;
    @Resource
    protected SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    protected SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    protected SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Autowired
    protected ISysStaffService sysStaffService;
    @Autowired
    protected ISysOfficeService sysOfficeService;
    @Autowired
    protected ISysStruAssistOrganService sysStruAssistOrganService;
    @Autowired
    protected ISysOrganAuditService sysOrganAuditService;
    @Autowired
    protected ISysStaffAuditService sysStaffAuditService;
    @Autowired
    protected ISysOfficeAuditService sysOfficeAuditService;
    @Autowired
    protected ISysStruAuditService sysStruAuditService;
    @Autowired
    protected ISysUsersAuditService sysUsersAuditService;
    @Autowired
    protected ISysStruAssistOrganAuditService sysStruAssistOrganAuditService;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    protected ISysCodeRuleService sysCodeRuleService;
    @Autowired
    protected ISysStruPostService sysStruPostService;
    @Autowired
    protected ISysStruStaffService sysStruStaffService;
    @Autowired
    protected ISysStruRoleService sysStruRoleService;
    @Autowired
    protected ISysUserRoleService sysUserRoleService;
    @Autowired
    protected ISysStruUserService sysStruUserService;
    @Autowired
    protected ISysStruPostAuditService sysStruPostAuditService;
    @Autowired
    protected ISysStruRoleAuditService sysStruRoleAuditService;
    @Autowired
    protected ISysStruStaffAuditService sysStruStaffAuditService;
    @Autowired
    protected ISysStruUserAuditService sysStruUserAuditService;
    @Resource
    protected OrganChangeNotify organChangeNotify;
    @Resource
    protected ISysStruRuleService sysStruRuleService;
    @Resource
    protected IHussarBasePostService hussarBasePostService;
    @Resource
    protected SysStruPostMapper sysStruPostMapper;
    @Resource
    protected EditOrganizationAuthorizationChangeReporter editOrganizationAuthorizationChangeReporter;
    @Resource
    protected IConvertPinyinService convertPinyinService;
    @Autowired(required=false)
    protected HussarExpansionProperties hussarExpansionProperties;
    @Resource
    protected HussarSystemIdProperties hussarSystemIdProperties;

    protected void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, SysOffice sysOffice, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if ("2".equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setId(null);
        }
        if (HussarUtils.isNotEmpty((Object)sysOrgan.getExpansionMap())) {
            sysOrganAudit.setExpansionMap(sysOrgan.getExpansionMap());
        }
        this.sysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getId());
        if ("2".equals(flag)) {
            sysStruAudit.setOrganId(sysOrganAudit.getId());
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.sysStruAuditService.save((Object)sysStruAudit);
        if (HussarUtils.isNotEmpty((Object)sysStaff)) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag)) {
                sysStaffAudit.setStruId(sysStruAudit.getId());
                sysStaffAudit.setRealStaffId(sysStaff.getId());
                sysStaffAudit.setId(null);
            }
            this.sysStaffAuditService.save((Object)sysStaffAudit);
        }
        if (HussarUtils.isNotEmpty((Object)sysOffice)) {
            SysOfficeAudit sysOfficeAudit = new SysOfficeAudit();
            CopyPropertieUtils.copyProperties((Object)sysOfficeAudit, (Object)sysOffice);
            sysOfficeAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag)) {
                sysOfficeAudit.setStruId(sysStruAudit.getId());
                sysOfficeAudit.setRealOfficeId(sysOffice.getId());
                sysOfficeAudit.setId(null);
            }
            this.sysOfficeAuditService.save((Object)sysOfficeAudit);
        }
    }

    protected String getCode(SysOrgan sysOrgan) {
        String fieldName = "ORGAN_CODE_4";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        String code = StringUtils.trimToEmpty((String)sysOrgan.getOrganCode());
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode(fieldName, "SYS_ORGAN");
                lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)code);
                currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)code);
            currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_ORGAN_CODE.getMessage()));
            }
        }
        return code;
    }

    protected String getOrganCode(SysOrgan sysOrgan) {
        String ruleCode = "SYS_ORGAN:ORGAN_CODE_4";
        CodePlusDto codePlusDto = new CodePlusDto();
        codePlusDto.setRuleCode(ruleCode);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        String code = StringUtils.trimToEmpty((String)sysOrgan.getOrganCode());
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysCodeRuleService.getCurrentCodeByCache(codePlusDto);
                ((LambdaQueryWrapper)lambdaQueryWrapper.ne(SysOrgan::getOrganType, (Object)"9")).eq(SysOrgan::getOrganCode, (Object)code);
                currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            ((LambdaQueryWrapper)lambdaQueryWrapper.ne(SysOrgan::getOrganType, (Object)"9")).eq(SysOrgan::getOrganCode, (Object)code);
            currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_ORGAN_CODE.getMessage()));
            }
        }
        return code;
    }

    protected void updateOrganCodeCacheToDb() {
        String ruleCode = "SYS_ORGAN:ORGAN_CODE_4";
        CodePlusDto codePlusDto = new CodePlusDto();
        codePlusDto.setRuleCode(ruleCode);
        this.sysCodeRuleService.updateCacheToDb(codePlusDto);
    }

    protected String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.sysStruMapper.getMaxStruSeq(pFid, level);
        String struSeq = "";
        if (HussarUtils.isBlank((CharSequence)maxStruSeq)) {
            struSeq = pSeq + "/0001";
        } else {
            String[] arr = maxStruSeq.split("/");
            if (StringUtils.isNotBlank((CharSequence)pSeq)) {
                int len = arr.length - 1;
                if (len < level) {
                    StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                    for (int i = 0; i < level - len; ++i) {
                        stringBuilder.append("/0001");
                    }
                    struSeq = stringBuilder.toString();
                } else {
                    struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf("/")) + "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
                }
            } else {
                struSeq = "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        }
        return struSeq;
    }

    protected boolean delOrganByStruId(long struId) {
        boolean flag;
        SysStru sysStruById = (SysStru)this.sysStruMapper.selectById(Long.valueOf(struId));
        int struLevel = sysStruById.getStruLevel();
        Long parentId = sysStruById.getParentId();
        LambdaQueryWrapper delOrgan = new LambdaQueryWrapper();
        delOrgan.eq(SysOrgan::getId, (Object)sysStruById.getOrganId());
        this.sysOrganMapper.delete((Wrapper)delOrgan);
        this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)struId));
        this.sysStruPostAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPostAudit::getStruId, (Object)struId)).eq(SysStruPostAudit::getAuditStatus, (Object)"0"));
        this.handleStruStaffAudit(struId);
        this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStruId, (Object)struId));
        this.sysStruStaffAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruStaffAudit::getStruId, (Object)struId)).eq(SysStruStaffAudit::getAuditStatus, (Object)"0"));
        this.sysStruUserAuditService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getStruId, (Object)struId)).eq(SysStruUserAudit::getAuditStatus, (Object)"0"));
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getStruId, (Object)struId));
        this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)struId));
        LambdaQueryWrapper delOffice = new LambdaQueryWrapper();
        delOffice.eq(SysOffice::getStruId, (Object)struId);
        this.sysOfficeMapper.delete((Wrapper)delOffice);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysStruRoleAudit::getStruId, (Object)struId)).eq(SysStruRoleAudit::getStatus, (Object)StruRoleStatus.LOCKED.getCode());
        this.sysStruRoleAuditMapper.delete((Wrapper)queryWrapper);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruAssistOrgan::getStruId, (Object)struId);
        this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
        boolean bl = flag = this.sysStruMapper.deleteById(Long.valueOf(struId)) > 0;
        if (struLevel > 1) {
            SysStru stru = (SysStru)this.sysStruMapper.selectById(parentId);
            LambdaQueryWrapper wrapperC = new LambdaQueryWrapper();
            wrapperC.eq(SysStru::getParentId, (Object)parentId);
            wrapperC.ne(SysStru::getId, (Object)struId);
            wrapperC.ne(SysStru::getStruType, (Object)"9");
            Long count = this.sysStruMapper.selectCount((Wrapper)wrapperC);
            stru.setIsLeaf(count > 0L ? "N" : "Y");
            this.sysStruMapper.updateById(stru);
        }
        return flag;
    }

    private void handleStruStaffAudit(Long struId) {
        List struStaffAudits = this.sysStruStaffAuditService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruStaffAudit::getAuditStatus, (Object)"0"));
        if (HussarUtils.isEmpty((Object)struStaffAudits)) {
            return;
        }
        Map<Long, List<SysStruStaffAudit>> map = struStaffAudits.stream().collect(Collectors.groupingBy(SysStruStaffAudit::getStaffId));
        ArrayList staffIds = new ArrayList();
        map.forEach((key, value) -> {
            if (value.size() == 1 && HussarUtils.equals((Object)((SysStruStaffAudit)value.get(0)).getStruId(), (Object)struId)) {
                staffIds.add(key);
            }
        });
        if (HussarUtils.isNotEmpty(staffIds)) {
            this.sysStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().in(SysStaffAudit::getRealStaffId, staffIds));
        }
    }

    protected Map<String, List<SysStru>> getSubOrganByIds(List<Long> organIds) {
        HashMap<String, List<SysStru>> result = new HashMap<String, List<SysStru>>();
        if (HussarUtils.isEmpty(organIds)) {
            return result;
        }
        List list = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        List fIdList = list.stream().map(SysStru::getStruFid).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        for (String fid : fIdList) {
            ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
        }
        List strus = this.sysStruMapper.selectList((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        for (SysStru stru : list) {
            String struFid = stru.getStruFid();
            ArrayList<SysStru> struList = new ArrayList<SysStru>();
            for (SysStru child : strus) {
                String fid = child.getStruFid();
                if (HussarUtils.equals((Object)fid, (Object)struFid) || !fid.startsWith(struFid)) continue;
                struList.add(child);
            }
            result.put(struFid, struList);
        }
        return result;
    }
}

