/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppFuncResDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleFunctionsBoServiceImpl
implements ISysRoleFunctionsBoService {
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;

    public boolean remove(List<Long> roleIds, List<Long> funIds) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(HussarUtils.isNotEmpty(roleIds), SysRoleFunctions::getRoleId, roleIds)).in(HussarUtils.isNotEmpty(funIds), SysRoleFunctions::getFunctionId, funIds);
        return this.sysRoleFunctionsService.remove((Wrapper)wrapper);
    }

    public boolean saveBatch(List<SysRoleFunctions> roleFunctionsList) {
        return this.sysRoleFunctionsService.saveBatch(roleFunctionsList);
    }

    public List<SysFunctions> getFunctions(QueryAppFuncResDto queryAppFuncResDto) {
        Long roleId = queryAppFuncResDto.getRoleId();
        Long appId = queryAppFuncResDto.getAppId();
        Long formId = queryAppFuncResDto.getFormId();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("roleId", roleId);
        queryParams.put("appId", appId);
        queryParams.put("formId", formId);
        return this.sysFunctionsMapper.getFunctions(queryParams);
    }

    public List<SysRoleFunctions> list(List<Long> roleIds, List<Long> funIds) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(HussarUtils.isNotEmpty(roleIds), SysRoleFunctions::getRoleId, roleIds)).in(HussarUtils.isNotEmpty(funIds), SysRoleFunctions::getFunctionId, funIds);
        return this.sysRoleFunctionsService.list((Wrapper)wrapper);
    }

    public List<Long> getRoleIdsByFormId(Long formId) {
        String functionCode = "menu_" + formId;
        return this.sysRoleFunctionsMapper.getRoleIdsByFunctionCode(functionCode);
    }

    public Boolean removeByIds(List<Long> ids) {
        return this.sysRoleFunctionsService.removeByIds(ids);
    }
}

