/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.organ.dto.ExportUserExcelDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryOrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.CopyUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.SwitchUserAccountDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserActivateDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserSecureDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.authorization.permit.vo.EnableSwitchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserMobileVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.expansion.core.annotations.ExpansionModelId;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u65b0\u7248\u7528\u6237\u7ba1\u7406"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseUserController")
@RequestMapping(value={"/hussarBase/authorization/permit/user"})
@ExpansionModelId(modelId="userExtendColumnInfo")
public class HussarBaseUserController {
    @Resource
    private IHussarBaseUserService userService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Value(value="${hussar.unify.authentication.enable:false}")
    private Boolean unifyAuthEnable = false;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e")
    @CheckPermission(value={"hussarBase:authorization:permit:user:searchUsers"})
    @GetMapping(value={"/searchUsers"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserVo>> searchUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") QueryUserDto queryUserDto) {
        return this.userService.searchUsers(pageInfo, queryUserDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u590d\u5236\u89d2\u8272\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u590d\u5236\u89d2\u8272\u7528\u6237\u5217\u8868\u6570\u636e")
    @CheckPermission(value={"hussarBase:authorization:permit:user:searchCopyRoleUsers"})
    @GetMapping(value={"/searchCopyRoleUsers"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u67e5\u8be2\u590d\u5236\u89d2\u8272\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserVo>> searchCopyRoleUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") QueryCopyRoleUserDto queryCopyRoleUserDto) {
        return this.userService.searchCopyRoleUsers(pageInfo, queryCopyRoleUserDto);
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u61d2\u52a0\u8f7d\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:permit:user:lazyLoadingUserTree"})
    @GetMapping(value={"/lazyLoadingUserTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u7ea7\u8054\u83b7\u53d6\u7528\u6237\u90e8\u95e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserTreeVo>> lazyLoadingUserTree(@ApiParam(value="\u7528\u6237\u6240\u5728\u673a\u6784ID") @RequestParam Long parentId, @RequestParam String organProperty) {
        return this.userService.lazyLoadingUserTree(parentId, organProperty);
    }

    @ApiOperation(value="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7528\u6237\u6811", notes="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7528\u6237\u6811")
    @CheckPermission(value={"hussarBase:authorization:permit:user:getOrderUserTree"})
    @GetMapping(value={"/getOrderUserTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserTreeVo>> getOrderUserTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.userService.getOrderUserTree(parentId);
    }

    @ApiOperation(value="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:permit:user:backUserTree"})
    @GetMapping(value={"/backUserTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserTreeVo>> backUserTree(@ApiParam(value="\u9009\u4e2d\u8282\u70b9") @RequestParam Long id) {
        return this.userService.backUserTree(id);
    }

    @ApiOperation(value="\u67e5\u770b\u7528\u6237\u4fe1\u606f", notes="\u67e5\u770b\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/viewUser"})
    @CheckPermission(value={"hussarBase:authorization:permit:user:viewUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u67e5\u770b\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<UserPartialVo> viewUser(@ApiParam(value="\u7528\u6237ID") @RequestParam Long id) {
        return this.userService.viewUser(id);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636eID\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/loadUser"})
    @CheckPermission(value={"hussarBase:authorization:permit:user:loadUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u6839\u636eID\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<UserInfolVo> loadUser(@ApiParam(value="\u7528\u6237ID") @RequestParam Long id) {
        return this.userService.loadUser(id);
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65b0\u589e\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:addUser"})
    @PostMapping(value={"/addUser"})
    @CacheEvict(value={"user_ip", "menu_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u65b0\u589e\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addUser(@ApiParam(value="\u65b0\u589e\u7528\u6237DTO") @RequestBody AddUserDto addUserDto) {
        return this.userService.addUser(addUserDto);
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237", notes="\u4fee\u6539\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:editUser"})
    @PostMapping(value={"/editUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4fee\u6539\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CacheEvict(value={"resource_info", "menu_info"}, allEntries=true)
    @CheckSafe
    public ApiResponse<String> editUser(@ApiParam(value="\u4fee\u6539\u7528\u6237DTO") @RequestBody EditUserDto editUserDto) {
        return this.userService.editUser(editUserDto);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u5220\u9664\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:deleteUser"})
    @PostMapping(value={"/deleteUser"})
    @CheckSafe
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u5220\u9664\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.deleteUser(id);
    }

    @ApiOperation(value="\u590d\u5236\u7528\u6237\u89d2\u8272", notes="\u590d\u5236\u7528\u6237\u89d2\u8272")
    @CheckPermission(value={"hussarBase:authorization:permit:user:copyUserRole"})
    @PostMapping(value={"/copyUserRole"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u590d\u5236\u7528\u6237\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> copyUserRole(@ApiParam(value="\u590d\u5236\u7528\u6237\u89d2\u8272DTO") @RequestBody CopyUserRoleDto copyRoleDto) {
        return this.userService.copyUserRole(copyRoleDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u91cd\u7f6e\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u91cd\u7f6e\u7528\u6237\u5217\u8868\u6570\u636e")
    @CheckPermission(value={"hussarBase:authorization:permit:user:searchResetSecureUsers"})
    @GetMapping(value={"/searchResetSecureUsers"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u91cd\u7f6e\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<ResetSecureUserVo>> searchResetSecureUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") ResetSecureUserDto resetSecureUserDto) {
        return this.userService.searchResetSecureUsers(pageInfo, resetSecureUserDto);
    }

    @ApiOperation(value="\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801", notes="\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/resetUserSecure"})
    @CheckPermission(value={"hussarBase:authorization:permit:user:resetUserSecure"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.RESET_PASS)
    public ApiResponse<UpdateInfoVo> resetUserSecure(@ApiParam(value="\u4fee\u6539\u5bc6\u7801dto") @RequestBody UserSecureDto userSecureDto) {
        return this.userService.resetUserSecure(userSecureDto);
    }

    @ApiOperation(value="\u4f11\u7720\u7528\u6237", notes="\u4f11\u7720\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:dormancyUser"})
    @PostMapping(value={"/dormancyUser"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4f11\u7720\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> dormancyUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.dormancyUser(id);
    }

    @ApiOperation(value="\u6fc0\u6d3b\u7528\u6237", notes="\u6fc0\u6d3b\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:activateUser"})
    @PostMapping(value={"/activateUser"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4f11\u7720\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> activateUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.activateUser(id);
    }

    @ApiOperation(value="\u6fc0\u6d3b\u4e34\u65f6\u7528\u6237", notes="\u6fc0\u6d3b\u4e34\u65f6\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:activateUser"})
    @PostMapping(value={"/activateTempUser"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u6fc0\u6d3b\u4e34\u65f6\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> activateTempUser(@ApiParam(value="\u7528\u6237\u6fc0\u6d3bdto") @RequestBody UserActivateDto activateDto) {
        return this.userService.activateTempUser(activateDto);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f", notes="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f")
    @CheckPermission(value={"hussarBase:authorization:permit:user:sortUser"})
    @PostMapping(value={"/sortUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> sortUser(@ApiParam(value="\u7528\u6237id\u96c6\u5408") @RequestBody List<Long> idList) {
        return this.userService.sortUser(idList);
    }

    @ApiOperation(value="\u6ce8\u9500\u7528\u6237", notes="\u6ce8\u9500\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:cancelUser"})
    @PostMapping(value={"/cancelUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u6ce8\u9500\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckSafe
    public ApiResponse<String> cancelUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.cancelUser(id);
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", notes="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811")
    @GetMapping(value={"/getUserTreeInitVos"})
    @AuditLog(moduleName="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventDesc="\u521d\u59cb\u5316\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getUserTreeInitVos(@RequestParam(value="parentId") Long parentId, @RequestParam(value="ifLazy") int ifLazy, @RequestParam(required=false, value="defaultLevel") Integer defaultLevel) {
        return ApiResponse.success((Object)this.userService.getUserTreeInitVos(parentId, ifLazy, defaultLevel));
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784\u53ca\u7528\u6237\u6570\u636e", notes="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784\u53ca\u7528\u6237\u6570\u636e")
    @GetMapping(value={"/getChildrenUsersByParentId"})
    @AuditLog(moduleName="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7528\u6237\u6570\u636e", eventDesc="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7528\u6237\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getChildrenUsersByParentId(@RequestParam(value="parentId") Long parentId) {
        return ApiResponse.success((Object)this.userService.getChildrenUsersByParentId(parentId));
    }

    @ApiOperation(value="\u6309\u7167\u7528\u6237\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", notes="\u6309\u7167\u7528\u6237\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/getUsersLikeName"})
    @AuditLog(moduleName="\u6309\u7167\u7528\u6237\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", eventDesc="\u6309\u7167\u7528\u6237\u540d\u79f0\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getUsersLikeName(@RequestParam(value="searchValue") String searchValue) {
        return this.userService.getUsersLikeName(searchValue);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\uff0c\u83b7\u53d6\u5230\u4ece\u6839\u8282\u70b9\u5230\u8be5\u7528\u6237\u6240\u5728\u5c42\u7ea7\u7684\u7528\u6237\u6811", notes="\u6839\u636e\u7528\u6237id\uff0c\u83b7\u53d6\u5230\u4ece\u6839\u8282\u70b9\u5230\u8be5\u7528\u6237\u6240\u5728\u5c42\u7ea7\u7684\u7528\u6237\u6811")
    @GetMapping(value={"/getUpUserTreeByUserId"})
    @AuditLog(moduleName="\u6839\u636e\u7528\u6237id\uff0c\u83b7\u53d6\u5230\u4ece\u6839\u8282\u70b9\u5230\u8be5\u7528\u6237\u6240\u5728\u5c42\u7ea7\u7684\u7528\u6237\u6811", eventDesc="\u6839\u636e\u7528\u6237id\uff0c\u83b7\u53d6\u5230\u4ece\u6839\u8282\u70b9\u5230\u8be5\u7528\u6237\u6240\u5728\u5c42\u7ea7\u7684\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getUpUserTreeByUserId(@RequestParam(value="id") Long id, @RequestParam(value="parentId") Long parentId) {
        return ApiResponse.success((Object)this.userService.getUpUserTreeByUserId(id, parentId));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237Id \u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237Id \u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/getUserInfoByUserId"})
    @AuditLog(moduleName="\u6839\u636e\u7528\u6237Id \u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f", eventDesc="\u6839\u636e\u7528\u6237Id \u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<OrganTreeInitVo> getUserInfoByUserId(@RequestParam(value="id") Long id) {
        return this.userService.getUserInfoByUserId(id);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u5230\u4e0b\u7ea7\u6240\u7528\u7528\u6237", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u5230\u4e0b\u7ea7\u6240\u7528\u7528\u6237")
    @GetMapping(value={"/getUsersByParentId"})
    @AuditLog(moduleName="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u5230\u4e0b\u7ea7\u6240\u7528\u7528\u6237", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u5230\u4e0b\u7ea7\u6240\u7528\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<OrganTreeInitVo>> getUsersByParentId(@RequestParam(value="id") Long id) {
        return this.userService.getUsersByParentId(id);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u672a\u5173\u8054\u4eba\u5458\u7528\u6237\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u672a\u5173\u8054\u4eba\u5458\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/unRelateStaffUserList"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u5206\u9875\u67e5\u8be2\u672a\u5173\u8054\u4eba\u5458\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserVo>> unRelateStaffUserList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") QueryUserDto queryUserDto) {
        return this.userService.unRelateStaffUserList(pageInfo, queryUserDto);
    }

    @ApiOperation(value="\u901a\u8fc7\u5c97\u4f4did\u67e5\u8be2\u5c97\u4f4d\u5df2\u5173\u8054\u7528\u6237", notes="\u901a\u8fc7\u5c97\u4f4did\u67e5\u8be2\u5c97\u4f4d\u5df2\u5173\u8054\u7528\u6237")
    @GetMapping(value={"/getUserByPostId"})
    @AuditLog(moduleName="\u6743\u9650\u4f53\u7cfb-\u4eba\u5458\u7ec4\u4ef6", eventDesc="\u901a\u8fc7\u5c97\u4f4did\u67e5\u8be2\u5c97\u4f4d\u5df2\u5173\u8054\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserVo>> getUserByPostId(@ApiParam(value="\u5c97\u4f4did") @RequestParam Long postId) {
        return this.userService.getUserByPostId(postId);
    }

    @ApiOperation(value="\u5c97\u4f4d\u5173\u8054\u4eba\u5458\u65f6\uff0c\u6839\u636e\u7c7b\u578b\u8fd4\u56de\u4e0d\u540c\u4eba\u5458\u5217\u8868", notes="\u5c97\u4f4d\u5173\u8054\u4eba\u5458\u65f6\uff0c\u6839\u636e\u7c7b\u578b\u8fd4\u56de\u4e0d\u540c\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"/postUserList"})
    @AuditLog(moduleName="\u5e94\u7528\u8bbf\u95ee\u6743\u9650-\u5c97\u4f4d\u5173\u8054\u4eba\u5458", eventDesc="\u5c97\u4f4d\u5173\u8054\u4eba\u5458\u65f6\uff0c\u6839\u636e\u7c7b\u578b\u8fd4\u56de\u4e0d\u540c\u4eba\u5458\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserVo>> postUserList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801") @RequestParam String organTypeCode, @ApiParam(value="\u7ec4\u7ec7\u7ed3\u6784id\u96c6\u5408") @RequestParam List<Long> organIds, @ApiParam(value="\u7528\u6237\u540d\u79f0") @RequestParam String userName, @ApiParam(value="\u7528\u6237\u8d26\u53f7") @RequestParam String userAccount) {
        return this.userService.postUserList(pageInfo, organTypeCode, organIds, userName, userAccount);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5206\u9875\u5217\u8868", notes="\u83b7\u53d6\u7528\u6237\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/getUserList"})
    @AuditLog(moduleName="\u5e94\u7528\u8bbf\u95ee\u6743\u9650-\u5c97\u4f4d\u5173\u8054\u4eba\u5458", eventDesc="\u83b7\u53d6\u7528\u6237\u5206\u9875\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserVo>> getUserList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u7528\u6237\u540d\u79f0") @RequestParam String userName, @ApiParam(value="\u7528\u6237\u8d26\u53f7") @RequestParam String userAccount) {
        return this.userService.getUserList(pageInfo, userName, userAccount);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u7528\u6237\u4fe1\u606f", notes="\u67e5\u8be2\u89d2\u8272\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/roleUserView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserVo>> getRoleUserView(@ApiParam(value="\u89d2\u8272id") @RequestParam String id) {
        return this.userService.getRoleUser(id);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u8be5\u673a\u6784\u4e0b\u7528\u6237", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u8be5\u673a\u6784\u4e0b\u7528\u6237")
    @GetMapping(value={"/getUsersByStruId"})
    @AuditLog(moduleName="\u79fb\u52a8\u7aef", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u8be5\u673a\u6784\u4e0b\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SearchUserMobileVo>> getUsersByStruId(@ApiParam(value="\u673a\u6784id") @RequestParam Long id) {
        return this.userService.getUsersByStruId(id);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u96c6\u5408\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u53ca\u673a\u6784\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237id\u96c6\u5408\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u53ca\u673a\u6784\u4fe1\u606f")
    @PostMapping(value={"/getUsersByUserIds"})
    @AuditLog(moduleName="\u79fb\u52a8\u7aef", eventDesc="\u6839\u636e\u7528\u6237id\u96c6\u5408\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u53ca\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SearchUserMobileVo>> getUsersByUserIds(@ApiParam(value="\u7528\u6237id\u96c6\u5408") @RequestBody List<Long> userIds) {
        return this.userService.getUsersByUserIds(userIds);
    }

    @GetMapping(value={"/exportUserExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237Excel\u6587\u4ef6", notes="\u5bfc\u51fa\u7528\u6237Excel\u6587\u4ef6")
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u7528\u6237Excel\u6587\u4ef6\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportUserExcel(@ApiParam(value="\u7ec4\u7ec7ids") @RequestParam String ids, @ApiParam(value="\u4efb\u52a1ids") @RequestParam Long taskId, @ApiParam(value="\u662f\u5426\u5bfc\u51fa\u4e3b\u952e") @RequestParam(required=false) Boolean exportKey, @ApiParam(value="\u5bfc\u51fa\u6587\u4ef6\u5bc6\u7ea7") @RequestParam(required=false) String securityLevel) throws Exception {
        exportKey = HussarUtils.isNotEmpty((Object)exportKey) && exportKey != false;
        this.userService.exportUserExcelWithSecurity(ids, taskId, exportKey.booleanValue(), securityLevel);
    }

    @PostMapping(value={"/exportUserExcelForBigDate"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237Excel\u6587\u4ef6", notes="\u5bfc\u51fa\u7528\u6237Excel\u6587\u4ef6")
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u7528\u6237Excel\u6587\u4ef6\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportUserExcelForBigDate(@RequestBody ExportUserExcelDto exportUserExcelDto) throws Exception {
        Boolean exportKey = exportUserExcelDto.getExportKey();
        List idList = exportUserExcelDto.getIdList();
        String securityLevel = exportUserExcelDto.getSecurityLevel();
        Long taskId = exportUserExcelDto.getTaskId();
        exportKey = HussarUtils.isNotEmpty((Object)exportKey) && exportKey != false;
        Boolean isAssociateSub = exportUserExcelDto.getAssociateSub();
        this.userService.exportUserExcelWithSecurityForBigDate(idList, taskId, exportKey, securityLevel, isAssociateSub);
    }

    @GetMapping(value={"/downloadUserExcelImpTpl"})
    @CheckPermission(value={"hussarBase:authorization:user:downloadUserExcelImpTpl"})
    @ApiOperation(value="\u7528\u6237\u4eba\u5458Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", notes="\u7528\u6237\u4eba\u5458Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d")
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u7528\u6237\u4eba\u5458Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void downloadUserExcelImpTpl(HttpServletResponse response, @RequestParam(value="fileKey", required=false) String fileKey) {
        this.userService.downloadUserExcelImpTpl(response, fileKey);
    }

    @PostMapping(value={"/checkUserExcel"})
    @CheckPermission(value={"hussarBase:authorization:user:checkUserExcel"})
    @ApiOperation(value="\u6821\u9a8c\u5bfc\u5165\u7528\u6237\u4eba\u5458excel\u6587\u4ef6", notes="\u6821\u9a8c\u5bfc\u5165\u7528\u6237\u4eba\u5458excel\u6587\u4ef6")
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u6821\u9a8c\u5bfc\u5165\u7528\u6237\u4eba\u5458excel\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void checkUserExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="scenario") String scenario, @RequestParam(value="taskId") Long taskId, @RequestParam(value="organProperty") String organProperty, @RequestParam(required=false) String securityLevel) {
        this.userService.checkUserExcelWithSecurity(file, scenario, taskId, organProperty, securityLevel);
    }

    @PostMapping(value={"/importUserExcel"})
    @CheckPermission(value={"hussarBase:authorization:user:importUserExcel"})
    @ApiOperation(value="\u5bfc\u5165\u7528\u6237excel\u6587\u4ef6", notes="\u5bfc\u5165\u7528\u6237excel\u6587\u4ef6")
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u5bfc\u5165\u7528\u6237excel\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void importUserExcel(@RequestParam(value="scenario") String scenario, @RequestParam(value="taskId") Long taskId, @RequestParam(value="organProperty") String organProperty) {
        this.userService.importUserExcel(scenario, taskId, organProperty);
    }

    @GetMapping(value={"/checkUnifyAuthentication"})
    @ApiOperation(value="\u662f\u5426\u5bf9\u63a5\u7edf\u4e00\u8ba4\u8bc1", notes="\u662f\u5426\u5bf9\u63a5\u7edf\u4e00\u8ba4\u8bc1")
    public ApiResponse<Boolean> checkUnifyAuthentication() {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        return ApiResponse.success((Object)(HussarUtils.isEmpty((Object)application) && this.unifyAuthEnable != false ? 1 : 0));
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u8d26\u53f7", notes="\u5207\u6362\u7528\u6237\u8d26\u53f7")
    @PostMapping(value={"/switchUserAccount"})
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u5207\u6362\u7528\u6237\u8d26\u53f7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> switchUserAccount(@ApiParam(value="\u5207\u6362\u7528\u6237\u8d26\u53f7Dto") @RequestBody SwitchUserAccountDto switchUserAccountDto) {
        return this.userService.switchUserAccount(switchUserAccountDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u53ef\u5207\u6362\u7684\u7528\u6237\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u53ef\u5207\u6362\u7684\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/getUserAccountList"})
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u53ef\u5207\u6362\u7684\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<EnableSwitchUserVo>> getUserAccountList(@ApiParam(value="\u539f\u59cb\u7528\u6237ID") @RequestParam(value="originalUserId") Long originalUserId) {
        return this.userService.getUserAccountList(originalUserId);
    }

    @ApiOperation(value="\u80fd\u5426\u5207\u6362\u7528\u6237\u8d26\u53f7", notes="\u80fd\u5426\u5207\u6362\u7528\u6237\u8d26\u53f7")
    @GetMapping(value={"/switchUserFlag"})
    @AuditLog(moduleName="\u7528\u6237\u7ba1\u7406", eventDesc="\u80fd\u5426\u5207\u6362\u7528\u6237\u8d26\u53f7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> switchUserFlag(@ApiParam(value="\u539f\u59cb\u7528\u6237ID") @RequestParam(value="originalUserId") Long originalUserId) {
        return this.userService.switchUserFlag(originalUserId);
    }

    @PostMapping(value={"/lazyOrganUserTree"})
    @AuditLog(moduleName="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganUserTreeVo>> lazyOrganUserTree(@RequestBody QueryOrganTreeDto queryOrganTreeDto) {
        List parentOrganIds = queryOrganTreeDto.getParentOrganIds();
        Boolean needParentOrganInfo = queryOrganTreeDto.getNeedParentOrganInfo();
        Integer resultType = queryOrganTreeDto.getResultType();
        List userTreeVos = this.userService.lazyOrganUserTree(parentOrganIds, needParentOrganInfo, resultType);
        return ApiResponse.success((Object)userTreeVos);
    }
}

