/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dto.EditOnlyOutsideStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editOutsideStaffManagerImpl")
public class EditOutsideStaffManagerImpl
implements EditOutsideStaffManager {
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStruStaffService sysStruStaffService;

    @Override
    public R<EditOnlyOutsideStaffDto> editOnlyStaff(EditOnlyOutsideStaffDto staff) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)staff);
        String staffCode = StringUtils.trimToEmpty((String)staff.getStaffCode());
        SysStaff sysStaff = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(SysStaff::getStaffCode, (Object)staffCode));
        if (sysStaff == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)staff, (String)"staffCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty((Object)errors) && sysStaff != null) {
            this.initializationEdit(staff, sysStaff);
            List struIds = staff.getOrganIds();
            if (HussarUtils.isNotEmpty((Object)struIds)) {
                ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
                struIds = struIds.stream().distinct().collect(Collectors.toList());
                for (Long struId : struIds) {
                    SysStruStaff sysStruStaff = new SysStruStaff();
                    sysStruStaff.setStruId(struId);
                    sysStruStaff.setStaffId(sysStaff.getId());
                    struStaffList.add(sysStruStaff);
                }
                this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)sysStaff.getId()));
                this.sysStruStaffService.saveBatch(struStaffList);
            }
            this.sysStaffMapper.updateById(sysStaff);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStaff.getId(), StringUtils.trimToEmpty((String)sysStaff.getStaffCode()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEdit(EditOnlyOutsideStaffDto staffDto, SysStaff sysStaff) {
        String staffName = StringUtils.trimToEmpty((String)staffDto.getStaffName());
        String staffPosition = StringUtils.trimToEmpty((String)staffDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)staffDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)staffDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)staffDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)staffDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)staffDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)staffDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)staffDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)staffDto.getGraduateSchool());
        String staffRemark = StringUtils.trimToEmpty((String)staffDto.getStaffRemark());
        if (StringUtils.isNotBlank((CharSequence)staffName)) {
            sysStaff.setName(staffName);
        }
        if (StringUtils.isNotBlank((CharSequence)sex)) {
            sysStaff.setSex(sex);
        }
        sysStaff.setStaffPosition(staffPosition);
        sysStaff.setBirthday(birthday);
        sysStaff.setIdcard(idcard);
        sysStaff.setAddress(address);
        sysStaff.setWorkId(workId);
        sysStaff.setWorkDate(workDate);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setRemark(staffRemark);
    }
}

