/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.audit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.dao.SysFunctionResourcesAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysFunctionsAuditMapper;
import com.jxdinfo.hussar.authorization.audit.service.ISysFunctionResourcesAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAuditFunctionResourceDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionsAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysFunctionResourcesAuditVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysFunctionResourcesAuditServiceImpl
extends HussarServiceImpl<SysFunctionResourcesAuditMapper, SysFunctionResourcesAudit>
implements ISysFunctionResourcesAuditService {
    private static Logger logger = LoggerFactory.getLogger(SysFunctionResourcesAuditServiceImpl.class);
    @Autowired
    private ISysFunctionsService functionsService;
    @Autowired
    private ISysResourcesService resourcesService;
    @Autowired
    private SysFunctionsAuditMapper functionsAuditMapper;
    @Autowired
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Autowired
    private ISysFunctionResourcesService functionResourcesService;
    @Autowired
    private SysFunctionResourcesAuditMapper sysFunctionResourcesAuditMapper;
    @Autowired
    private SysFunctionsAuditMapper sysFunctionsAuditMapper;

    public boolean functionResourcesAuditSave(List<SysFunctionResources> sysFunctionResourcesSaveList) {
        if (HussarUtils.isNotEmpty(sysFunctionResourcesSaveList)) {
            ArrayList<SysFunctionResourcesAudit> SysFunctionResourcesAuditList = new ArrayList<SysFunctionResourcesAudit>();
            for (SysFunctionResources functionResources : sysFunctionResourcesSaveList) {
                SysFunctionResourcesAudit functionResourcesAudit = new SysFunctionResourcesAudit();
                BeanUtils.copyProperties((Object)functionResources, (Object)functionResourcesAudit);
                functionResourcesAudit.setId(null);
                functionResourcesAudit.setOperateType("0");
                functionResourcesAudit.setAuditStatus("0");
                SysFunctionResourcesAuditList.add(functionResourcesAudit);
            }
            return this.saveBatch(SysFunctionResourcesAuditList);
        }
        return false;
    }

    public boolean saveUnAuditFuncResByIdAndResInfo(Long functionId, List<Map<String, String>> resources, String operationType) {
        if (HussarUtils.isNotEmpty((Object)functionId) && HussarUtils.isNotEmpty(resources)) {
            ArrayList<SysFunctionResourcesAudit> SysFunctionResourcesAuditList = new ArrayList<SysFunctionResourcesAudit>();
            for (Map<String, String> resource : resources) {
                SysFunctionResourcesAudit functionResourcesAudit = new SysFunctionResourcesAudit();
                functionResourcesAudit.setResourceId(Long.valueOf(resource.get("id")));
                functionResourcesAudit.setFunctionId(functionId);
                functionResourcesAudit.setId(null);
                functionResourcesAudit.setOperateType(operationType);
                functionResourcesAudit.setAuditStatus("0");
                SysFunctionResourcesAuditList.add(functionResourcesAudit);
            }
            return this.saveBatch(SysFunctionResourcesAuditList);
        }
        return false;
    }

    public boolean compareAndSaveFunctionResAuditInfo(Long functionId, List<Map<String, String>> resources) {
        QueryWrapper queryWrapperFr = new QueryWrapper();
        queryWrapperFr.eq((Object)"FUNCTION_ID", (Object)functionId);
        List<FuncResVo> sysFunctionResourcesList = this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
        if (HussarUtils.isEmpty(sysFunctionResourcesList) && HussarUtils.isEmpty(resources)) {
            return true;
        }
        List<Object> functionResourceIds = new ArrayList();
        if (HussarUtils.isNotEmpty(sysFunctionResourcesList)) {
            functionResourceIds = sysFunctionResourcesList.stream().map(FuncResVo::getResourceId).collect(Collectors.toList());
        }
        List<Object> preResourcesIds = new ArrayList();
        if (HussarUtils.isNotEmpty(resources)) {
            preResourcesIds = resources.stream().map(resource -> Long.valueOf((String)resource.get("id"))).collect(Collectors.toList());
        }
        ArrayList<Long> addResourceIds = new ArrayList<Long>();
        ArrayList<Long> delResourceIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(functionResourceIds) && HussarUtils.isEmpty(preResourcesIds)) {
            delResourceIds.addAll(functionResourceIds);
        } else if (HussarUtils.isEmpty(functionResourceIds) && HussarUtils.isNotEmpty(preResourcesIds)) {
            addResourceIds.addAll(preResourcesIds);
        } else {
            for (Long l : functionResourceIds) {
                if (preResourcesIds.contains(l)) continue;
                delResourceIds.add(l);
            }
            for (Long l : preResourcesIds) {
                if (functionResourceIds.contains(l)) continue;
                addResourceIds.add(l);
            }
        }
        return this.saveUnAuditFuncResByIdAndResId(functionId, addResourceIds, delResourceIds);
    }

    public boolean saveUnAuditFuncResByIdAndResId(Long functionId, List<Long> addResourceIds, List<Long> delResourceIds) {
        SysFunctionResourcesAudit functionResourcesAudit;
        ArrayList<SysFunctionResourcesAudit> SysFunctionResourcesAuditList = new ArrayList<SysFunctionResourcesAudit>();
        if (HussarUtils.isNotEmpty((Object)functionId) && HussarUtils.isNotEmpty(addResourceIds)) {
            for (Long resourceId : addResourceIds) {
                functionResourcesAudit = new SysFunctionResourcesAudit();
                functionResourcesAudit.setResourceId(resourceId);
                functionResourcesAudit.setFunctionId(functionId);
                functionResourcesAudit.setId(null);
                functionResourcesAudit.setOperateType("1");
                functionResourcesAudit.setAuditStatus("0");
                SysFunctionResourcesAuditList.add(functionResourcesAudit);
            }
        }
        if (HussarUtils.isNotEmpty((Object)functionId) && HussarUtils.isNotEmpty(delResourceIds)) {
            for (Long resourceId : delResourceIds) {
                functionResourcesAudit = new SysFunctionResourcesAudit();
                functionResourcesAudit.setResourceId(resourceId);
                functionResourcesAudit.setFunctionId(functionId);
                functionResourcesAudit.setId(null);
                functionResourcesAudit.setOperateType("3");
                functionResourcesAudit.setAuditStatus("0");
                SysFunctionResourcesAuditList.add(functionResourcesAudit);
            }
        }
        if (HussarUtils.isNotEmpty(SysFunctionResourcesAuditList)) {
            return this.saveBatch(SysFunctionResourcesAuditList);
        }
        return false;
    }

    public boolean functionResourcesAuditSaveByIdAndRes(Long functionId, List<Map<String, String>> resources) {
        return this.compareAndSaveFunctionResAuditInfo(functionId, resources);
    }

    public boolean functionResourcesAuditUpdateByIdAndRes(Long functionId, List<Map<String, String>> resources) {
        return this.compareAndSaveFunctionResAuditInfo(functionId, resources);
    }

    public boolean functionResourcesAuditSaveByIdAndAddDel(Long functionId, Set<Long> addResourceIds, Set<Long> delResourceIds) {
        return this.saveUnAuditFuncResByIdAndResId(functionId, new ArrayList<Long>(addResourceIds), new ArrayList<Long>(delResourceIds));
    }

    public IPage<SysFunctionResourcesAuditVo> queryList(PageInfo pageInfo, QueryAuditFunctionResourceDto queryAuditFunctionResourceDto) {
        if (ToolUtil.isEmpty((Object)pageInfo)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("functionName", queryAuditFunctionResourceDto.getFunctionName());
        queryParams.put("resourceName", queryAuditFunctionResourceDto.getResourceName());
        queryParams.put("type", queryAuditFunctionResourceDto.getAuditStatus());
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        LambdaQueryWrapper sysFunctionsAuditQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysFunctionsAuditQuery.ne(SysFunctionsAudit::getAuditStatus, (Object)"1")).eq(SysFunctionsAudit::getOperateType, (Object)"1");
        List noFunctionAudit = this.sysFunctionsAuditMapper.selectList((Wrapper)sysFunctionsAuditQuery);
        List<Object> noFunctionAuditIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)noFunctionAudit)) {
            noFunctionAuditIdList = noFunctionAudit.stream().map(SysFunctionsAudit::getFunctionId).collect(Collectors.toList());
        }
        queryParams.put("noFunctionAudit", noFunctionAuditIdList);
        List<SysFunctionResourcesAuditVo> sysFunctionResourcesAuditVoList = this.sysFunctionResourcesAuditMapper.querySysFunctionResourcesAudit((Page<SysFunctionResourcesAuditVo>)page, queryParams);
        page.setRecords(sysFunctionResourcesAuditVoList);
        return page;
    }

    public boolean reject(SysFunctionResourcesAudit functionResourcesAudit) {
        if (HussarUtils.isEmpty((Object)functionResourcesAudit) || HussarUtils.isEmpty((Object)functionResourcesAudit.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
        }
        SysFunctionResourcesAudit functionResourcesAuditUpdate = new SysFunctionResourcesAudit();
        functionResourcesAuditUpdate.setId(functionResourcesAudit.getId());
        functionResourcesAuditUpdate.setAuditStatus("2");
        boolean flag = this.updateById((BaseEntity)functionResourcesAuditUpdate);
        return flag;
    }

    @HussarTransactional
    public boolean pass(SysFunctionResourcesAudit functionResourcesAudit) {
        if (HussarUtils.isEmpty((Object)functionResourcesAudit) || HussarUtils.isEmpty((Object)functionResourcesAudit.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
        }
        SysFunctionResourcesAudit functionResourcesAuditInfo = (SysFunctionResourcesAudit)this.getById(functionResourcesAudit.getId());
        List functionsNotAuditList = this.functionsAuditMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionsAudit::getFunctionId, (Object)functionResourcesAuditInfo.getFunctionId())).eq(SysFunctionsAudit::getAuditStatus, (Object)"0")).in(SysFunctionsAudit::getOperateType, new Object[]{"1", "2"}));
        if (HussarUtils.isNotEmpty((Object)functionsNotAuditList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_UPDATE.getMessage()));
        }
        functionResourcesAuditInfo.setAuditStatus("1");
        this.updateById((BaseEntity)functionResourcesAuditInfo);
        String operationType = functionResourcesAuditInfo.getOperateType();
        if ("1".equals(operationType)) {
            this.functionResourcesService.saveAddFunctionRes(functionResourcesAuditInfo.getFunctionId(), Arrays.asList(functionResourcesAuditInfo.getResourceId()));
        } else if ("3".equals(operationType)) {
            this.functionResourcesService.delFunctionRes(functionResourcesAuditInfo.getFunctionId(), Arrays.asList(functionResourcesAuditInfo.getResourceId()));
        } else {
            logger.error("\u529f\u80fd\u8d44\u6e90\u5ba1\u6838\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff1a\u5ba1\u6838id-{}\uff0c\u64cd\u4f5c\u7c7b\u578b-{}", (Object)functionResourcesAudit.getId(), (Object)operationType);
        }
        return true;
    }
}

