/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.publish.service.IHussarBasePublishService;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

@HussarTokenDs
public class DefaultPublishServiceImpl
implements IHussarBasePublishService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;

    public Map<String, Object> getAppIdAndModuleId(PublishDTO publishDTO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String extensionId = publishDTO.getExtensionId();
        Long appId = null;
        Long parentModuleId = null;
        if (HussarUtils.isNotEmpty((Object)extensionId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysApplication::getAppCode, (Object)extensionId);
            SysApplication app = (SysApplication)this.sysApplicationService.getOne((Wrapper)queryWrapper);
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            queryWrapper2.eq(SysResourceModules::getModuleCode, (Object)extensionId);
            SysResourceModules moduleNode = (SysResourceModules)this.sysResourceModulesMapper.selectOne((Wrapper)queryWrapper2);
            if (HussarUtils.isNotEmpty((Object)moduleNode)) {
                parentModuleId = moduleNode.getId();
                appId = app.getId();
            }
        }
        map.put("appId", appId);
        map.put("parentModuleId", parentModuleId);
        return map;
    }

    public Map<String, Object> getAppIdAndModuleIdForFunction(PublishDTO publishDTO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String extensionId = publishDTO.getExtensionId();
        Long appId = null;
        Long parentModuleId = null;
        if (HussarUtils.isNotEmpty((Object)extensionId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysApplication::getAppCode, (Object)extensionId);
            SysApplication app = (SysApplication)this.sysApplicationService.getOne((Wrapper)queryWrapper);
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            queryWrapper2.eq(SysFunctionModules::getFunctionModuleCode, (Object)extensionId);
            SysFunctionModules moduleNode = (SysFunctionModules)this.sysFunctionModulesMapper.selectOne((Wrapper)queryWrapper2);
            if (HussarUtils.isNotEmpty((Object)moduleNode)) {
                parentModuleId = moduleNode.getId();
                appId = app.getId();
            }
        }
        map.put("appId", appId);
        map.put("parentModuleId", parentModuleId);
        return map;
    }

    public List<SysResourceModules> getAllModules(Long appId) {
        return this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getApplicationId, (Object)1L)).eq(HussarUtils.isNotEmpty((Object)appId), SysResourceModules::getAppId, (Object)appId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        })).orderByAsc(SysResourceModules::getSeq));
    }

    public Long getParentMenuId(String extensionId) {
        Long parentId = null;
        if (HussarUtils.isNotEmpty((Object)extensionId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysApplication::getAppCode, (Object)extensionId);
            SysApplication app = (SysApplication)this.sysApplicationService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)app)) {
                parentId = app.getId();
            }
        }
        return parentId;
    }

    public List<SysResources> getResourceList(String resourceName, SysResourceModules sysResourceModules, Long appId) {
        return null;
    }
}

