/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.audit.dao.SysFunctionResourcesAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysFunctionsAuditMapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dto.ModuleTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryFuncOrderTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryResTransferTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResListDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceExpandDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceModuleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourcePathDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceRoleRelationDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeByIdDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceUniqueDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionsAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpandAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceType;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResourceAudit;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseChangeResourceService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResTypeExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceTypeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceExpandAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.impl.FunctionRoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.vo.CheckResourceVo;
import com.jxdinfo.hussar.authorization.permit.vo.ImportVueResVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResMapperSelectVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResMapperVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResTypeExpandVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceExpandViewVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceExpandVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysFunctionVO;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleResourcesVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleVO;
import com.jxdinfo.hussar.authorization.permit.vo.SysResourceViewVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysResourcesPartVo;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.base.config.shortcutconfig.service.IShortCutConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.ResourceWithAdminException;
import com.jxdinfo.hussar.common.exception.ResourceWithFunctionException;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.common.properties.UnifyPermissionProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.common.properties.HussarBaseDataScopeProperties;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.functionmanager.FunctionChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.functionmanager.FunctionModuleChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager.ResourceChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager.ResourceModuleBatchDeleteChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager.ResourceModuleChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager.ResourceRoleChangeNotify;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataRightFactory;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysResManageServiceImpl
extends HussarServiceImpl<SysResourcesMapper, SysResources>
implements ISysResManageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysResManageServiceImpl.class);
    private static final String TENANT_TYPE_PROPERTY = "hussar.core.tenant.type";
    private static final String FALSE = "false";
    private static final String DEFAULT_LANGLE = "zh-CN";
    private static final String RES_MENU = "res_menu";
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysModulesMapper sysModulesMapper;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysModulesService sysModulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private IGlobalService globalService;
    @Resource
    private QueryDataRightManager queryDataRightManager;
    @Resource
    private HussarBaseDataScopeProperties dataScopeProperties;
    @Resource
    @Lazy
    ISysRoleResourceService sysRoleResourceService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Autowired
    private UnifyPermissionProperties unifyPermissionProperties;
    @Autowired
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;
    @Autowired
    private IHussarBaseResourceTypeService hussarBaseResourceTypeService;
    @Autowired
    private IHussarBaseResTypeExpandService hussarBaseResTypeExpandService;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysRoleGroupService sysRoleGroupService;
    @Autowired
    private ISysRoleFunctionsService sysRoleFunctionsService;
    private static final List<Long> ADMIN_ROLE_IDS = Collections.singletonList(SysUserAndRole.SYSTEMADMIN_ROLE.getValue());
    @Resource
    private HussarTenantProperties tenantProperties;
    @Autowired
    private IHussarBaseChangeResourceService changeResourceService;
    @Resource
    private ResourceChangeNotify resourceChangeNotify;
    @Resource
    private ResourceRoleChangeNotify resourceRoleChangeNotify;
    @Resource
    private ResourceModuleBatchDeleteChangeNotify resourceModuleBatchDeleteChangeNotify;
    @Resource
    private ResourceModuleChangeNotify resourceModuleChangeNotify;
    @Resource
    private FunctionChangeNotify functionChangeNotify;
    @Resource
    private FunctionModuleChangeNotify functionModuleChangeNotify;
    @Resource
    private IShortCutConfigService shortCutConfigService;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private FunctionRoleUserAuthorizationChangeReporter functionRoleUserAuthorizationChangeReporter;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private ISysAppDevelopTeamMemberService sysAppDevelopTeamMemberService;
    @Resource
    private ISysAppDevelopTeamService sysAppDevelopTeamService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private SysResourcesAuditMapper sysResourcesAuditMapper;
    @Resource
    private ISysResourcesAuditService sysResourcesAuditService;
    @Resource
    private ISysResourceExpandAuditService sysResourceExpandAuditService;
    @Resource
    private ISysRoleResourceAuditService sysRoleResourceAuditService;
    @Resource
    private SysFunctionResourcesAuditMapper sysFunctionResourcesAuditMapper;
    @Resource
    private SysFunctionsAuditMapper sysFunctionsAuditMapper;
    private static final int CH_MAX_LENGTH = 32;
    private static final int EN_MAX_LENGTH = 128;

    public List<JSTreeModel> getResTree() {
        return this.sysModulesMapper.getModulesTree();
    }

    public SysResourceModules getModuleInfoById(String moduleId) {
        this.checkParams(moduleId, "getModuleInfoById");
        SysResourceModules moduleInfoById = this.sysResourceModulesMapper.getModuleInfoById(Long.parseLong(moduleId));
        TranslateUtil.translate((Object)moduleInfoById, SysResourceModules::getNameLangKey, SysResourceModules::setModuleName);
        if (HussarUtils.isNotEmpty((Object)moduleInfoById.getParent())) {
            SysResourceModules parent = moduleInfoById.getParent();
            TranslateUtil.translate((Object)parent, SysResourceModules::getNameLangKey, SysResourceModules::setModuleName);
        }
        return moduleInfoById;
    }

    public ApiResponse saveModules(SysResourceModules sysResourceModules) {
        this.checkParams(sysResourceModules, "saveModules");
        if (ToolUtil.isEmpty((Object)sysResourceModules)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MODULE_INFORMATION_EMPTY.getMessage()));
        }
        Long userId = null;
        if (sysResourceModules.getCreator() != null && "godaxe".equals(sysResourceModules.getCreator())) {
            userId = sysResourceModules.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysResourceModules.getId())) {
            sysResourceModules.setId(null);
            Integer max = this.sysResourceMosulesService.getMaxOrderByParentIdAndAppId(sysResourceModules.getParentModuleId(), sysResourceModules.getApplicationId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                sysResourceModules.setSeq(Integer.valueOf(max + 1));
            } else {
                sysResourceModules.setSeq(Integer.valueOf(1));
            }
            sysResourceModules.setCreator(userId);
            if (HussarUtils.isNotEmpty((Object)TranslateUtil.getDefaultTranslateName((String)sysResourceModules.getNameLangKey()))) {
                sysResourceModules.setModuleName(TranslateUtil.getDefaultTranslateName((String)sysResourceModules.getNameLangKey()));
            }
            if (!this.sysResourceMosulesService.save((Object)sysResourceModules)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()));
            }
            if (!HussarUtils.equals((Object)1L, (Object)sysResourceModules.getApplicationId())) {
                this.resourceModuleChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysResourceModules});
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
        }
        sysResourceModules.setLastEditor(userId);
        if (!this.sysResourceMosulesService.updateById((Object)sysResourceModules)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        SysResourceModules module = (SysResourceModules)this.sysResourceMosulesService.getById((Serializable)sysResourceModules.getId());
        if (!HussarUtils.equals((Object)1L, (Object)module.getApplicationId())) {
            this.resourceModuleChangeNotify.notify(DataChangeType.UPDATE, new Object[]{module});
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    public ApiResponse updateModules(SysModules sysModules) {
        if (ToolUtil.isEmpty((Object)sysModules)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MODULE_INFORMATION_EMPTY.getMessage()));
        }
        this.checkParams(sysModules, "updateModules");
        boolean isAllowEditModule = this.isAllowEditModule(sysModules);
        if (!isAllowEditModule) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_HAVE_SUPERIOR_OR_SUBORDINATE.getMessage()));
        }
        if (!this.sysModulesService.updateById((Object)sysModules)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    public List<JSTreeModel> moduleTreeById(String moduleId, boolean isRoot) {
        this.checkParams(moduleId, "moduleTreeById");
        List<JSTreeModel> result = this.sysResourceModulesMapper.moduleTreeById(moduleId);
        if (isRoot) {
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.RES_NODE_ID);
            root.setCode(String.valueOf(Constants.RES_NODE_ID));
            root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return TreeModelUtils.merge(result);
    }

    public ApiResponse saveFunction(SysFunctions sysFunctions) {
        if (ToolUtil.isEmpty((Object)sysFunctions)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_INFO_EMPTY.getMessage()));
        }
        this.checkParams(sysFunctions, "saveFunction");
        sysFunctions.setId(null);
        Integer max = this.sysFunctionsService.getMaxOrderByParentId(sysFunctions.getFunctionModuleId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            sysFunctions.setSeq(Integer.valueOf(max + 1));
        } else {
            sysFunctions.setSeq(Integer.valueOf(1));
        }
        if (!this.sysFunctionsService.save((Object)sysFunctions)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
    }

    public ApiResponse updateFunction(SysFunctions sysFunctions) {
        if (ToolUtil.isEmpty((Object)sysFunctions)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_INFO_EMPTY.getMessage()));
        }
        this.checkParams(sysFunctions, "updateFunction");
        if (!this.sysFunctionsService.updateById((Object)sysFunctions)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    public SysFunctionVO getFunctionInfoById(String functionId) {
        this.checkParams(functionId, "getFunctionInfoById");
        return this.sysFunctionsMapper.getFunctionInfoById(functionId);
    }

    public Long resourceSave(SysResources sysResources) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Long userId = null;
        if (sysResources.getCreator() != null && "godaxe".equals(sysResources.getCreator())) {
            userId = sysResources.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        Long parentResourceId = sysResources.getParentResourceId();
        if (HussarUtils.isNotEmpty((Object)parentResourceId) && HussarUtils.equals((Object)sysResources.getId(), (Object)parentResourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SUPER_RES_NOT_SELECT_SELF.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysResources.getId())) {
            sysResources.setId(null);
            Integer max = this.sysResourcesService.getMaxOrderByParentId(sysResources.getModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                sysResources.setSeq(Integer.valueOf(max + 1));
            } else {
                sysResources.setSeq(Integer.valueOf(1));
            }
            sysResources.setCreator(userId);
            this.sysResourcesMapper.insert(sysResources);
        } else {
            sysResources.setLastEditor(userId);
            this.sysResourcesMapper.updateById(sysResources);
        }
        return sysResources.getId();
    }

    @HussarTransactional
    public ApiResponse<Long> saveResource(ResourceDto resourceDto) {
        if (ToolUtil.isEmpty((Object)resourceDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
        }
        SysResources sysResources = new SysResources();
        BeanUtils.copyProperties((Object)resourceDto, (Object)sysResources);
        if (ToolUtil.isEmpty((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
        }
        this.validParams(sysResources);
        Long userId = null;
        if (sysResources.getCreator() != null && "godaxe".equals(sysResources.getCreator())) {
            userId = sysResources.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        Long resourceId = IdWorker.getId((Object)new SysResources());
        if (HussarUtils.isEmpty((Object)sysResources.getId())) {
            sysResources.setId(resourceId);
            resourceDto.setId(resourceId);
            Integer max = this.sysResourcesService.getMaxOrderByParentId(sysResources.getModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                sysResources.setSeq(Integer.valueOf(max + 1));
            } else {
                sysResources.setSeq(Integer.valueOf(1));
            }
            sysResources.setCreator(userId);
            String result = this.processAddAuditIfNecessary(sysResources, resourceDto);
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isResourceAudit()) {
                return ApiResponse.success((Object)0L, (String)result);
            }
            return ApiResponse.success((Object)sysResources.getId(), (String)result);
        }
        sysResources.setLastEditor(userId);
        String result = this.processEditAuditIfNecessary(sysResources, resourceDto);
        return ApiResponse.success((Object)sysResources.getId(), (String)result);
    }

    private String processEditAuditIfNecessary(SysResources sysResources, ResourceDto resourceDto) {
        SysResources newResource;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isResourceAudit()) {
            Long resourceId = sysResources.getId();
            SysResourcesAudit sysResourcesAudit = (SysResourcesAudit)this.sysResourcesAuditMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourcesAudit::getAuditStatus, (Object)"0")).eq(SysResourcesAudit::getResourceId, (Object)resourceId));
            AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)sysResourcesAudit), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
            SysResourcesAudit audit = new SysResourcesAudit();
            BeanUtils.copyProperties((Object)sysResources, (Object)audit, (String[])new String[]{"id", "createTime", "lastTime", "creator", "lastEditor"});
            audit.setResourceId(sysResources.getId());
            audit.setUserRights(sysResources.getUserRight());
            audit.setDeptRights(sysResources.getDeptRight());
            audit.setOperateType("2");
            audit.setAuditStatus("0");
            this.sysResourcesAuditMapper.insert(audit);
            List resourceExpandDtos = resourceDto.getResourceExpandDtos();
            if (HussarUtils.isNotEmpty((Object)resourceExpandDtos)) {
                ArrayList<SysResourceExpandAudit> resourceExpands = new ArrayList<SysResourceExpandAudit>();
                for (ResourceExpandDto dto : resourceExpandDtos) {
                    SysResourceExpandAudit resourceExpand = new SysResourceExpandAudit();
                    BeanUtils.copyProperties((Object)dto, (Object)resourceExpand);
                    resourceExpand.setResourceId(resourceId);
                    resourceExpand.setOperateType("1");
                    resourceExpand.setAuditStatus("0");
                    resourceExpands.add(resourceExpand);
                }
                this.sysResourceExpandAuditService.saveBatch(resourceExpands);
            }
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        this.hussarBaseResourceExpandService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceId, (Object)sysResources.getId()));
        if (!this.sysResourcesService.updateById((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        List sysFunctions = this.sysFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctions::getDefaultResourceId, (Object)sysResources.getId())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        if (HussarUtils.isNotEmpty((Object)sysFunctions)) {
            for (int i = 0; i < sysFunctions.size(); ++i) {
                SysFunctions sysFunction = (SysFunctions)sysFunctions.get(i);
                ShortCutConfig shortCutConfig = (ShortCutConfig)this.shortCutConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(ShortCutConfig::getFunctionId, (Object)sysFunction.getId()));
                if (!HussarUtils.isNotEmpty((Object)shortCutConfig)) continue;
                shortCutConfig.setShortCutUrl(sysResources.getPath());
                if (this.shortCutConfigService.updateById((Object)shortCutConfig)) continue;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
            }
        }
        this.handleResourceExpand(resourceDto);
        List resourceTypeCodes = DataRightFactory.getResourceTypeCodes();
        resourceTypeCodes.add("res_rights");
        resourceTypeCodes.add("res_form_rights");
        if (resourceTypeCodes.contains(sysResources.getResTypeId())) {
            LambdaQueryWrapper roleResourceLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.eq(SysRoleResource::getResourceId, (Object)sysResources.getId())).eq(SysRoleResource::getRelationSource, (Object)"1");
            List roleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper);
            List<Long> roleIdList = roleResourceList.stream().map(SysRoleResource::getRoleId).distinct().collect(Collectors.toList());
            this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIdList);
        }
        if (HussarUtils.isNotEmpty((Object)(newResource = (SysResources)this.sysResourcesService.getById((Serializable)sysResources.getId())).getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)newResource.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.UPDATE, new Object[]{newResource});
        }
        if (this.tenantProperties.isEnabled() && ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
            Executor hussarBaseAuthorizationExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
            hussarBaseAuthorizationExecutor.execute(() -> {
                String cacheName = "tenant_info";
                List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
                for (String cacheKey : cacheKeys) {
                    HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
                    if (!HussarUtils.isNotEmpty((Object)definition)) continue;
                    HussarContextHolder.setTenant((String)definition.getConnName(), (String)definition.getTenantCode());
                    this.changeResourceService.saveResource(definition.getConnName(), sysResources);
                    HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
                }
            });
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
    }

    private String processAddAuditIfNecessary(SysResources sysResources, ResourceDto resourceDto) {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isResourceAudit()) {
            SysResourcesAudit audit = new SysResourcesAudit();
            BeanUtils.copyProperties((Object)sysResources, (Object)audit, (String[])new String[]{"id", "createTime", "lastTime", "creator", "lastEditor"});
            audit.setResourceId(sysResources.getId());
            audit.setUserRights(sysResources.getUserRight());
            audit.setDeptRights(sysResources.getDeptRight());
            audit.setOperateType("1");
            audit.setAuditStatus("0");
            this.sysResourcesAuditMapper.insert(audit);
            Long resourceId = sysResources.getId();
            List resourceExpandDtos = resourceDto.getResourceExpandDtos();
            if (HussarUtils.isNotEmpty((Object)resourceExpandDtos)) {
                ArrayList<SysResourceExpandAudit> resourceExpands = new ArrayList<SysResourceExpandAudit>();
                for (ResourceExpandDto dto : resourceExpandDtos) {
                    SysResourceExpandAudit resourceExpand = new SysResourceExpandAudit();
                    BeanUtils.copyProperties((Object)dto, (Object)resourceExpand);
                    resourceExpand.setResourceId(resourceId);
                    resourceExpand.setOperateType("1");
                    resourceExpand.setAuditStatus("0");
                    resourceExpands.add(resourceExpand);
                }
                this.sysResourceExpandAuditService.saveBatch(resourceExpands);
            }
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage());
        }
        if (!this.sysResourcesService.save((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)sysResources.getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)sysResources.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysResources});
        }
        this.handleResourceExpand(resourceDto);
        if (this.tenantProperties.isEnabled() && ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
            Executor hussarBaseAuthorizationExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
            hussarBaseAuthorizationExecutor.execute(() -> {
                String cacheName = "tenant_info";
                List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
                for (String cacheKey : cacheKeys) {
                    HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
                    if (!HussarUtils.isNotEmpty((Object)definition)) continue;
                    HussarContextHolder.setTenant((String)definition.getConnName(), (String)definition.getTenantCode());
                    this.changeResourceService.saveResource(definition.getConnName(), sysResources);
                    HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
                }
            });
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage());
    }

    private void validParams(SysResources sysResources) {
        Long appId = sysResources.getApplicationId();
        appId = HussarUtils.isEmpty((Object)appId) ? 1L : appId;
        this.validPermissions(sysResources, appId);
        this.validPath(sysResources, appId);
        this.validResBtnUrl(sysResources, appId);
        this.validResOpenInterfaceUrl(sysResources, appId);
    }

    private void validResOpenInterfaceUrl(SysResources sysResources, Long appId) {
        if (HussarUtils.equals((Object)"res_open_interface", (Object)sysResources.getResTypeId())) {
            if (HussarUtils.isEmpty((Object)sysResources.getUrlNames())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_ADDRESS_EMPTY.getMessage()));
            }
            String serviceName = HussarUtils.isEmpty((Object)sysResources.getServiceName()) ? "" : sysResources.getServiceName();
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourcesAudit::getUrlNames, (Object)sysResources.getUrlNames())).eq(SysResourcesAudit::getApplicationId, (Object)appId)).eq(SysResourcesAudit::getResTypeId, (Object)"res_open_interface")).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysResourcesAudit::getServiceName, (Object)serviceName)).or(ToolUtil.isEmpty((Object)serviceName))).isNull(ToolUtil.isEmpty((Object)serviceName), SysResourcesAudit::getServiceName);
            })).ne(HussarUtils.isNotEmpty((Object)sysResources.getId()), SysResourcesAudit::getResourceId, (Object)sysResources.getId())).eq(SysResourcesAudit::getAuditStatus, (Object)"0");
            Long count = this.sysResourcesAuditMapper.selectCount((Wrapper)queryWrapper);
            if (count > 0L) {
                String str = HussarUtils.isEmpty((Object)sysResources.getId()) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage());
                throw new BaseException(str + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_INTERFACE_PATH_EXISTS_REVIEW.getMessage()));
            }
        }
    }

    private void validResBtnUrl(SysResources sysResources, Long appId) {
        if (HussarUtils.equals((Object)"res_btn", (Object)sysResources.getResTypeId())) {
            if (HussarUtils.isEmpty((Object)sysResources.getUrlNames())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_ADDRESS_EMPTY.getMessage()));
            }
            String serviceName = HussarUtils.isEmpty((Object)sysResources.getServiceName()) ? "" : sysResources.getServiceName();
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourcesAudit::getUrlNames, (Object)sysResources.getUrlNames())).eq(SysResourcesAudit::getApplicationId, (Object)appId)).ne(SysResourcesAudit::getResTypeId, (Object)"res_open_interface")).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysResourcesAudit::getServiceName, (Object)serviceName)).or(ToolUtil.isEmpty((Object)serviceName))).isNull(ToolUtil.isEmpty((Object)serviceName), SysResourcesAudit::getServiceName);
            })).ne(HussarUtils.isNotEmpty((Object)sysResources.getId()), SysResourcesAudit::getResourceId, (Object)sysResources.getId())).eq(SysResourcesAudit::getAuditStatus, (Object)"0");
            Long count = this.sysResourcesAuditMapper.selectCount((Wrapper)queryWrapper);
            if (count > 0L) {
                String str = HussarUtils.isEmpty((Object)sysResources.getId()) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage());
                throw new BaseException(str + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_INTERFACE_PATH_EXISTS_REVIEW.getMessage()));
            }
        }
    }

    private void validPath(SysResources sysResources, Long appId) {
        if (HussarUtils.equals((Object)RES_MENU, (Object)sysResources.getResTypeId())) {
            String serviceName;
            String path = sysResources.getPath();
            String string = serviceName = ToolUtil.isEmpty((Object)sysResources.getServiceName()) ? "" : sysResources.getServiceName();
            if (HussarUtils.isEmpty((Object)path)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_ROUTING_EMPTY.getMessage()));
            }
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("path", path.toUpperCase());
            queryParams.put("serviceName", serviceName);
            queryParams.put("appId", appId);
            queryParams.put("resourceId", sysResources.getId());
            queryParams.put("auditStatus", "0");
            Long count = this.sysResourcesAuditMapper.getCountSamePath(queryParams);
            if (count > 0L) {
                String str = HussarUtils.isEmpty((Object)sysResources.getId()) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage());
                throw new BaseException(str + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROUTE_EXISTS_REVIEW.getMessage()));
            }
        }
    }

    private void validPermissions(SysResources sysResources, Long appId) {
        if (StringUtils.isNotBlank((CharSequence)sysResources.getPermissions())) {
            LambdaQueryWrapper queryWrapperAudit;
            List allResAuditList;
            List allResources;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysResources::getPermissions, (Object)sysResources.getPermissions());
            queryWrapper.eq(SysResources::getApplicationId, (Object)appId);
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            });
            if (ToolUtil.isNotEmpty((Object)sysResources.getId())) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysResources::getId, (Object)sysResources.getId());
                });
            }
            if (HussarUtils.isNotEmpty((Object)(allResources = this.list((Wrapper)queryWrapper)))) {
                for (SysResources res : allResources) {
                    if (!(HussarUtils.equals((Object)"res_element", (Object)sysResources.getResTypeId()) ? HussarUtils.isNotEmpty((Object)res.getParentResourceId()) && HussarUtils.equals((Object)sysResources.getParentResourceId(), (Object)res.getParentResourceId()) : HussarUtils.isEmpty((Object)res.getParentResourceId()))) continue;
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_PERMISSION_EXIST.getMessage()));
                }
            }
            if (HussarUtils.isNotEmpty((Object)(allResAuditList = this.sysResourcesAuditMapper.selectList((Wrapper)(queryWrapperAudit = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourcesAudit::getPermissions, (Object)sysResources.getPermissions())).eq(SysResourcesAudit::getApplicationId, (Object)appId)).ne(HussarUtils.isNotEmpty((Object)sysResources.getId()), SysResourcesAudit::getResourceId, (Object)sysResources.getId())).eq(SysResourcesAudit::getAuditStatus, (Object)"0")))))) {
                String str = HussarUtils.isEmpty((Object)sysResources.getId()) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage());
                for (SysResourcesAudit res : allResAuditList) {
                    if (!(HussarUtils.equals((Object)"res_element", (Object)sysResources.getResTypeId()) ? HussarUtils.isNotEmpty((Object)res.getParentResourceId()) && HussarUtils.equals((Object)sysResources.getParentResourceId(), (Object)res.getParentResourceId()) : HussarUtils.isEmpty((Object)res.getParentResourceId()))) continue;
                    throw new BaseException(str + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERMISSION_EXISTS_REVIEW.getMessage()));
                }
            }
        }
    }

    public Long updateResource(SysResources sysResources) {
        if (ToolUtil.isEmpty((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
        }
        if (RES_MENU.equals(sysResources.getResTypeId())) {
            sysResources.setIsRepeatAuthenticate("0");
        }
        if (!this.sysResourcesService.updateById((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        SysResources newResource = (SysResources)this.sysResourcesService.getById((Serializable)sysResources.getId());
        if (HussarUtils.isNotEmpty((Object)newResource.getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)newResource.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.UPDATE, new Object[]{newResource});
        }
        return sysResources.getId();
    }

    public ResourceDetailVo getResourceInfoById(Long resourceId) {
        String resTypeCode;
        boolean flag;
        SysResources resources;
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
        }
        SysResources sysResources = this.sysResourcesMapper.getResourceInfoById(resourceId);
        if (HussarUtils.isEmpty((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_INFO_NO_FOUND.getMessage()));
        }
        TranslateUtil.translate((Object)sysResources, SysResources::getAliasLangKey, SysResources::setResourceAlias);
        TranslateUtil.translate((Object)sysResources, SysResources::getNameLangKey, SysResources::setResourceName);
        SysResourceModules resourceModules = sysResources.getResourceModules();
        TranslateUtil.translate((Object)resourceModules, SysResourceModules::getNameLangKey, SysResourceModules::setModuleName);
        sysResources.setResourceModules(resourceModules);
        ResourceDetailVo resourceDetailVo = new ResourceDetailVo();
        BeanUtils.copyProperties((Object)sysResources, (Object)resourceDetailVo);
        SysResourceViewVo sysResourceVo = new SysResourceViewVo();
        BeanUtils.copyProperties((Object)sysResources, (Object)sysResourceVo);
        sysResourceVo.setResourceTypeName(((SysResourceType)this.hussarBaseResourceTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getResourceTypeCode, (Object)sysResources.getResTypeId()))).getResourceTypeName());
        sysResourceVo.setResourceTypeNameLangKey(((SysResourceType)this.hussarBaseResourceTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceType::getResourceTypeCode, (Object)sysResources.getResTypeId()))).getNameLangKey());
        sysResourceVo.setModuleName(sysResources.getResourceModules().getModuleName());
        if (HussarUtils.isNotEmpty((Object)sysResources.getParentResourceId()) && HussarUtils.isNotEmpty((Object)(resources = (SysResources)this.sysResourcesService.getById((Serializable)sysResources.getParentResourceId())))) {
            TranslateUtil.translate((Object)resources, SysResources::getNameLangKey, SysResources::setResourceName);
            TranslateUtil.translate((Object)resources, SysResources::getAliasLangKey, SysResources::setResourceAlias);
            resourceDetailVo.setParentResourceName(resources.getResourceName());
            sysResourceVo.setParentResourceName(resources.getResourceName());
        }
        if (!(flag = this.hussarBaseResourceTypeService.getIsSysResType(resTypeCode = sysResources.getResTypeId()))) {
            List resTypeExpandVos = this.hussarBaseResTypeExpandService.getResTypeExpandListByCode(resTypeCode);
            ArrayList<ResourceExpandVo> resourceExpandVos = this.hussarBaseResourceExpandService.getResourceExpandListByResId(resourceId);
            List<Object> expandIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)resourceExpandVos)) {
                expandIds = resourceExpandVos.stream().map(ResourceExpandVo::getResourceTypeExpandId).collect(Collectors.toList());
            }
            ArrayList finalExpandIds = expandIds;
            List notRelateExpands = resTypeExpandVos.stream().filter(r -> !finalExpandIds.contains(Long.parseLong(r.getId()))).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(notRelateExpands)) {
                if (HussarUtils.isEmpty((Object)resourceExpandVos)) {
                    resourceExpandVos = new ArrayList<ResourceExpandVo>();
                }
                for (ResTypeExpandVo vo : notRelateExpands) {
                    ResourceExpandVo expandVo = new ResourceExpandVo();
                    expandVo.setResourceId(resourceId);
                    expandVo.setResourceTypeExpandCode(vo.getExpandCode());
                    expandVo.setResourceTypeExpandName(vo.getExpandName());
                    expandVo.setResourceTypeExpandId(Long.valueOf(Long.parseLong(vo.getId())));
                    resourceExpandVos.add(expandVo);
                }
            }
            ArrayList<ResourceExpandViewVo> resourceExpandViewVos = new ArrayList<ResourceExpandViewVo>();
            for (ResourceExpandVo resExps : resourceExpandVos) {
                ResourceExpandViewVo resExpViewVo = new ResourceExpandViewVo();
                resExpViewVo.setResourceTypeExpandName(resExps.getResourceTypeExpandName());
                resExpViewVo.setResourceTypeExpandValue(resExps.getResourceTypeExpandValue());
                resourceExpandViewVos.add(resExpViewVo);
            }
            sysResourceVo.setResourceExpands(resourceExpandViewVos);
            resourceDetailVo.setResourceTypeExpands(resTypeExpandVos);
            resourceDetailVo.setResourceExpands(resourceExpandVos);
        }
        resourceDetailVo.setSysResource(sysResourceVo);
        return resourceDetailVo;
    }

    public SysResources getResourceInfoById(String resourceId) {
        return this.sysResourcesMapper.getResourceInfoById(Long.parseLong(resourceId));
    }

    @HussarTransactional
    public void updateModuleTreeOrder(List<Long> idList) {
        this.checkParams(idList, "updateModuleTreeOrder");
        ArrayList<SysModules> sysModulesList = new ArrayList<SysModules>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysModules sysModules = new SysModules();
            sysModules.setId(id);
            sysModules.setSeq(Integer.valueOf(i + 1));
            sysModulesList.add(sysModules);
        }
        if (ToolUtil.isNotEmpty(sysModulesList)) {
            this.sysModulesService.updateBatchById(sysModulesList, sysModulesList.size());
        }
    }

    public List<JSTreeModel> getFunctionTreeByModuleId(QueryFuncOrderTreeDto queryFuncOrderTreeDto) {
        Long moduleId = queryFuncOrderTreeDto.getModuleId();
        String moduleName = queryFuncOrderTreeDto.getModuleName();
        Long appId = queryFuncOrderTreeDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = HussarUtils.isEmpty((Object)this.unifyPermissionProperties.getApplicationId()) ? 1L : this.unifyPermissionProperties.getApplicationId();
        }
        List<JSTreeModel> result = this.sysFunctionsMapper.functionTreeByModuleIdAndAppId(moduleId, appId);
        TranslateUtil.translate(result, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public void updateFunctionTreeOrder(List<Long> idList) {
        this.checkParams(idList, "updateModuleTreeOrder");
        ArrayList<SysFunctions> sysFunctionsList = new ArrayList<SysFunctions>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysFunctions sysFunctions = new SysFunctions();
            sysFunctions.setId(id);
            sysFunctions.setSeq(Integer.valueOf(i + 1));
            sysFunctionsList.add(sysFunctions);
        }
        if (ToolUtil.isNotEmpty(sysFunctionsList)) {
            this.sysFunctionsService.updateBatchById(sysFunctionsList, sysFunctionsList.size());
        }
    }

    public List<JSTreeModel> getResourceTreeByModuleId(ResourceTreeByIdDto resourceTreeByIdDto) {
        if (ToolUtil.isEmpty((Object)resourceTreeByIdDto.getModuleId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_FUNCTION_ID_NOT_NULL.getMessage()));
        }
        List<JSTreeModel> result = this.sysResourcesMapper.resourceTreeByModuleId(resourceTreeByIdDto.getModuleId());
        TranslateUtil.translate(result, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        JSTreeModel root = new JSTreeModel();
        root.setId(resourceTreeByIdDto.getModuleId());
        root.setText(resourceTreeByIdDto.getModuleName());
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public boolean updateResourceTreeOrder(List<Long> idList) {
        ArrayList<SysResources> sysResourcesList = new ArrayList<SysResources>();
        boolean flag = false;
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysResources sysResources = new SysResources();
            sysResources.setId(id);
            sysResources.setSeq(Integer.valueOf(i + 1));
            sysResourcesList.add(sysResources);
        }
        if (ToolUtil.isNotEmpty(sysResourcesList)) {
            flag = this.sysResourcesService.updateBatchById(sysResourcesList, sysResourcesList.size());
        }
        return flag;
    }

    public List<JSTreeModel> getModuleChangeById(String moduleId, String isLeaf) {
        List<JSTreeModel> jsTreeModelList = this.sysModulesMapper.moduleChangeTreeById(moduleId, isLeaf);
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        jsTreeModelList.add(root);
        return TreeModelUtils.merge(jsTreeModelList);
    }

    public void updateFunctionTreeChange(Long functionId, Long parentId) {
        if (ToolUtil.isEmpty((Object)functionId) || ToolUtil.isEmpty((Object)parentId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_AND_PARENT_ID_EMPTY.getMessage()));
        }
        Integer max = this.sysFunctionsService.getMaxOrderByParentId(parentId);
        Integer order = 1;
        if (ToolUtil.isNotEmpty((Object)max)) {
            order = max + 1;
        }
        this.sysFunctionsMapper.functionTreeChange(functionId, parentId, order);
        SysFunctions function = (SysFunctions)this.sysFunctionsService.getById((Serializable)functionId);
        if (HussarUtils.isNotEmpty((Object)function) && !HussarUtils.equals((Object)1L, (Object)function.getApplicationId())) {
            this.functionChangeNotify.notify(DataChangeType.UPDATE, new Object[]{function});
        }
    }

    public void updateFunctionModulesTreeChange(Long functionModuleId, Long parentId) {
        SysFunctionModules byId;
        List list = this.sysFunctionModulesService.list();
        List collect = list.stream().filter(o -> functionModuleId.longValue() == o.getId().longValue()).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(collect) && (byId = (SysFunctionModules)collect.get(0)).getParentModuleId().longValue() == parentId.longValue()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TRANS_FAILED_NOT_COMPLY_RULES.getMessage()));
        }
        Long parentModuleId = parentId;
        Long rootId = 1L;
        while (parentModuleId.longValue() != rootId.longValue()) {
            SysFunctionModules one = new SysFunctionModules();
            for (SysFunctionModules o2 : list) {
                if (parentModuleId.longValue() != o2.getId().longValue()) continue;
                one = o2;
            }
            parentModuleId = one.getParentModuleId();
            if (functionModuleId.longValue() != parentModuleId.longValue()) continue;
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TRANS_FAILED_NOT_COMPLY_RULES.getMessage()));
        }
        Integer max = this.sysFunctionModulesMapper.getMaxOrderByParentId(parentId);
        Integer order = 1;
        if (ToolUtil.isNotEmpty((Object)max)) {
            order = max + 1;
        }
        this.sysFunctionModulesMapper.functionModulesTreeChange(functionModuleId, parentId, order);
        SysFunctionModules module = (SysFunctionModules)this.sysFunctionModulesService.getById((Serializable)functionModuleId);
        if (HussarUtils.isNotEmpty((Object)module) && !HussarUtils.equals((Object)1L, (Object)module.getApplicationId())) {
            this.functionModuleChangeNotify.notify(DataChangeType.UPDATE, new Object[]{module});
        }
    }

    public List<JSTreeModel> getResourceTransferTree(QueryResTransferTreeDto queryResTransferTreeDto) {
        SysBaseConfig protectStatus;
        Long resourceId = queryResTransferTreeDto.getResourceId();
        Long appId = queryResTransferTreeDto.getApplicationId();
        Long bizAppId = queryResTransferTreeDto.getBizAppId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = HussarUtils.isEmpty((Object)this.unifyPermissionProperties.getApplicationId()) ? 1L : this.unifyPermissionProperties.getApplicationId();
        }
        boolean status = (protectStatus = this.baseConfigService.getSysBaseConfig("protection_status")) != null && "3".equals(protectStatus.getConfigValue());
        List<Object> result = this.sysResourceModulesMapper.getResTransferTree(resourceId, appId, bizAppId, status);
        String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY);
        if ("onsystem".equals(tenantType)) {
            List currentAppIds = this.sysApplicationService.getCurrentAppIds(BaseSecurityUtil.getUser().getUserId());
            result = result.stream().filter(jsTreeModel -> currentAppIds.contains(jsTreeModel.getAppId()) || Constants.DEFAULT_SYS_APP_ID.equals(jsTreeModel.getApplicationId()) && HussarUtils.isEmpty((Object)jsTreeModel.getAppId())).collect(Collectors.toList());
        }
        TranslateUtil.translate(result, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public void updateResourceTreeChange(ResourceTreeChangeDto resourceTreeChangeDto) {
        Long resourceId;
        SysResources resource;
        if (ToolUtil.isEmpty((Object)resourceTreeChangeDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_TRANS_EMPTY.getMessage()));
        }
        Integer max = this.sysResourcesService.getMaxOrderByParentId(BaseSecurityUtil.formatToLong((Object)resourceTreeChangeDto.getParentId()));
        Integer order = 1;
        if (ToolUtil.isNotEmpty((Object)max)) {
            order = max + 1;
        }
        if (HussarUtils.equals((Object)RES_MENU, (Object)(resource = (SysResources)this.sysResourcesService.getById((Serializable)(resourceId = resourceTreeChangeDto.getResourceId()))).getResTypeId())) {
            List sysResources = this.sysResourcesService.getPageAndElementResources(resource.getModuleId());
            HashSet<Long> resIds = new HashSet<Long>();
            this.getChildElementResources(resourceId, sysResources, resIds);
            if (HussarUtils.isNotEmpty(resIds)) {
                List elementResources = sysResources.stream().filter(r -> resIds.contains(r.getId())).collect(Collectors.toList());
                for (SysResources element : elementResources) {
                    element.setModuleId(resourceTreeChangeDto.getParentId());
                    element.setSeq(Integer.valueOf(element.getSeq() + order));
                }
                this.sysResourcesService.updateBatchById(elementResources);
            }
        }
        LambdaUpdateWrapper queryWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysResources::getId, (Object)resourceTreeChangeDto.getResourceId())).set(SysResources::getModuleId, (Object)resourceTreeChangeDto.getParentId())).set(SysResources::getSeq, (Object)order);
        this.sysResourcesService.update((Wrapper)queryWrapper);
        SysResources transferRes = (SysResources)this.sysResourcesService.getById((Serializable)resourceId);
        if (HussarUtils.isNotEmpty((Object)transferRes) && !HussarUtils.equals((Object)1L, (Object)transferRes.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.UPDATE, new Object[]{transferRes});
        }
    }

    @Deprecated
    public void updateModuleTreeChange(String moduleId, String parentId) {
        ModuleTreeChangeDto moduleTreeChangeDto = new ModuleTreeChangeDto();
        moduleTreeChangeDto.setModuleId(moduleId);
        moduleTreeChangeDto.setParentId(parentId);
        this.updateModuleTreeChange(moduleTreeChangeDto);
    }

    public void updateModuleTreeChange(ModuleTreeChangeDto moduleTreeChangeDto) {
        String moduleId = moduleTreeChangeDto.getModuleId();
        String parentId = moduleTreeChangeDto.getParentId();
        if (ToolUtil.isEmpty((Object)moduleId) || ToolUtil.isEmpty((Object)parentId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_AND_ID_EMPTY.getMessage()));
        }
        Integer max = this.sysResourceModulesMapper.getMaxOrderByParentId(BaseSecurityUtil.formatToLong((Object)parentId));
        Integer order = 1;
        if (ToolUtil.isNotEmpty((Object)max)) {
            order = max + 1;
        }
        this.sysResourceModulesMapper.moduleTreeChange(moduleId, parentId, order);
    }

    public List<JSTreeModel> getSelfResourceTree(String resourceIds) {
        this.checkParams(resourceIds, "getSelfResourceTree");
        String[] ids = resourceIds == null ? "".split(",") : resourceIds.split(",");
        List<JSTreeModel> result = this.sysResourcesMapper.selfResourceTree(ids);
        return TreeModelUtils.merge(this.doRecursive(result));
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, 0L);
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setCode("GROUP");
        model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_RESOURCE_TREE.getMessage()));
        model.setId(Constants.RES_NODE_ID);
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, Long parentId) {
        Long newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!"1".equals(map.getIsRes()) && !newParentId.equals(map.getId())) continue;
            newParentId = map.getParent();
            result.add(map);
            list.remove(map);
            --i;
            this.recursive(list, result, newParentId);
        }
    }

    public List<JSTreeModel> getMenuResTree(String resType) {
        return this.sysModulesMapper.getMenuModulesTree(resType);
    }

    public boolean isAllowEditModule(SysModules sysModules) {
        boolean flag = false;
        List<Map<String, Object>> modulesResult = this.sysModulesMapper.getModulesByParentId(sysModules.getId());
        List<Map<String, Object>> functionsResult = this.sysFunctionsMapper.getFunctionsByModuleId(sysModules.getId());
        SysModuleVO oldModule = this.sysModulesMapper.getModuleInfoById(sysModules.getId());
        if (oldModule.getIsLeaf().equals(sysModules.getIsLeaf())) {
            flag = true;
        } else if (ToolUtil.isEmpty(modulesResult) && ToolUtil.isEmpty(functionsResult)) {
            flag = true;
        }
        return flag;
    }

    public List<JSTreeModel> getMoudleAndFunctionTree(Long parentId) {
        return this.sysModulesMapper.getLazyLoadModulesTree(parentId);
    }

    public List<JSTreeModel> getFunctionAndResTree(String nodeId) {
        return this.sysModulesMapper.getFunctionAndResTree(nodeId);
    }

    public void exportRes(String ids, HttpServletResponse response) {
        List<String> idList = Arrays.asList(ids.split(","));
        List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List modules = this.sysResourceMosulesService.getResModulesByModuleIds(cdids);
        List resources = this.sysResourcesService.selectResourcesByResIds(cdids);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("modules", modules);
        data.put("resources", resources);
        data.put("export_type", "resource");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            LOGGER.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()));
        }
        String fileName = "resource_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @HussarTransactional
    public ImportVueResVo importVueRes(byte[] content) {
        Map data;
        HashMap map = new HashMap();
        ImportVueResVo importVueResVo = new ImportVueResVo();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            LOGGER.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DESERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        String exportType = (String)data.get("export_type");
        if (!"resource".equals(exportType)) {
            importVueResVo.setSuccess(FALSE);
            importVueResVo.setErrorImport(exportType);
            importVueResVo.setImportType("resource");
            return importVueResVo;
        }
        List modules = (List)data.get("modules");
        List resources = (List)data.get("resources");
        Map moduleCount = this.sysResourceMosulesService.insertOrUpdateList(modules);
        Map resourceCount = this.sysResourcesService.insertOrUpdateList(resources);
        importVueResVo.setSuccess("true");
        importVueResVo.setModuleInsert("" + moduleCount.get("insert"));
        importVueResVo.setModuleUpdate("" + moduleCount.get("update"));
        importVueResVo.setResourceInsert("" + resourceCount.get("insert"));
        importVueResVo.setResourceUpdate("" + resourceCount.get("update"));
        return importVueResVo;
    }

    public List<JSTreeModel> getFunResource(ResTreeDto resTreeDto) {
        Long gradeParentId;
        this.checkParams(resTreeDto, "getFunResource");
        Long newNodeId = resTreeDto.getNodeId();
        String type = resTreeDto.getType();
        String nodeType = resTreeDto.getNodeType();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        Long appId = resTreeDto.getApplicationId();
        Long bizAppId = resTreeDto.getBizAppId();
        boolean flag = this.existUnifyApp();
        List<Object> list1 = new ArrayList();
        if (flag) {
            root.setId(Constants.ROOT_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(false));
            if (HussarUtils.isEmpty((Object)appId)) {
                List applicationVos = this.sysApplicationService.getUserApplications(shiroUser.getId());
                List<Long> appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
                List<JSTreeModel> childrenList = this.getAppTree("res", appIds);
                root.setChildrenList(childrenList);
                if (HussarUtils.isEmpty(childrenList)) {
                    root.setIsLeaf("1");
                }
                result.add(root);
                return result;
            }
        } else {
            root.setId(Constants.RES_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(true));
            root.setId(Constants.RES_NODE_ID);
            appId = 1L;
        }
        Long struId = 0L;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List resourceIdList = new ArrayList();
        ArrayList moduleIdList = new ArrayList();
        ArrayList<Long> moduleIdList1 = new ArrayList<Long>();
        ArrayList<Long> list = new ArrayList<Long>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId).getId()))).size() > 0) {
            moduleIdList.addAll(this.sysResourceMosulesService.getGradeAdminResModuleId(resourceIdList));
            for (SysResourceModules modules : moduleIdList) {
                Long moduleId = modules.getId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(moduleIdList1);
        }
        if ("menuRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getMenuResourcesTree();
            result.add(root);
        } else if ("authorityRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getAuthorityModulesResTree(appId);
            result.add(root);
        } else {
            boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType) || ToolUtil.equals((Object)"app", (Object)nodeType);
            String isSys = "";
            if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                isSys = "0";
            }
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newNodeId)) {
                List sysUserRoleIds;
                Long roleId;
                newNodeId = Constants.RES_NODE_ID;
                if (HussarUtils.isNotEmpty((Object)root.getId())) {
                    result.add(root);
                }
                list1 = this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId, appId, isSys, bizAppId);
                String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY);
                if ("onsystem".equals(tenantType) && HussarUtils.isEmpty((Object)(roleId = (Long)(sysUserRoleIds = shiroUser.getRolesList()).stream().filter(l -> SysUserAndRole.TENANT_ADMIN_ROLE.getValue().equals(l) || SysUserAndRole.SUPERADMIN_ROLE.getValue().equals(l)).findAny().orElse(null)))) {
                    List currentAppIds = this.sysApplicationService.getCurrentAppIds(shiroUser.getId());
                    list1 = list1.stream().filter(jsTreeModel -> currentAppIds.contains(jsTreeModel.getAppId()) || Constants.DEFAULT_SYS_APP_ID.equals(jsTreeModel.getApplicationId()) && HussarUtils.isEmpty((Object)jsTreeModel.getAppId())).collect(Collectors.toList());
                }
            } else if (isModule) {
                if (HussarUtils.equals((Object)newNodeId, (Object)appId)) {
                    newNodeId = Constants.RES_NODE_ID;
                }
                list1 = this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId, appId, isSys, bizAppId);
            }
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                Long id = model.getId();
                if (!list.contains(id)) continue;
                model.getState().put("gradeDisabled", true);
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel model : result) {
            String isLeaf = model.getIsLeaf();
            String isModule = model.getType();
            if (!"isModule".equals(isModule) || !"0".equals(isLeaf)) continue;
            model.getState().put("notLeafModule", true);
        }
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getFunResourceForOrg(ResTreeDto resTreeDto) {
        List<JSTreeModel> list1;
        Long gradeParentId;
        this.checkParams(resTreeDto, "getFunResourceForOrg");
        Long newNodeId = resTreeDto.getNodeId();
        String type = resTreeDto.getType();
        String nodeType = resTreeDto.getNodeType();
        Long appId = resTreeDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = this.unifyPermissionProperties.getApplicationId();
        }
        appId = HussarUtils.isEmpty((Object)appId) ? 1L : appId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long struId = 0L;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List<Long> resourceIdList = new ArrayList();
        ArrayList<SysResourceModules> moduleIdList = new ArrayList<SysResourceModules>();
        ArrayList<Long> moduleIdList1 = new ArrayList<Long>();
        ArrayList<Long> list = new ArrayList<Long>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId).getId()))).size() > 0) {
            moduleIdList.addAll(this.sysResourceMosulesService.getGradeAdminResModuleId(resourceIdList));
            for (SysResourceModules modules : moduleIdList) {
                Long moduleId = modules.getId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(moduleIdList1);
        }
        if ("menuRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getMenuResourcesTree();
            result.add(root);
        } else if ("authorityRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getAuthorityModulesResTree(appId);
            result.add(root);
        } else {
            String isSys = "";
            if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                isSys = "0";
            }
            boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType);
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newNodeId)) {
                newNodeId = Constants.RES_NODE_ID;
                result.add(root);
                list1 = this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId, appId, isSys, null);
            } else {
                list1 = isModule ? this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId, appId, isSys, null) : new ArrayList<JSTreeModel>();
            }
        }
        if (isGradeAdmin) {
            list1 = this.getJsTreeModelListForModAndRes(moduleIdList, resourceIdList);
            list1.add(root);
            for (JSTreeModel model : list1) {
                Long id = model.getId();
                if (list.contains(id)) {
                    model.getState().put("gradeDisabled", true);
                }
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel model : result) {
            String isLeaf = model.getIsLeaf();
            String isModule = model.getType();
            if (!"isModule".equals(isModule) || !"0".equals(isLeaf)) continue;
            model.getState().put("notLeafModule", true);
        }
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getResFunTree(ResTreeDto resTreeDto) {
        Long struId;
        Long gradeParentId;
        List resourceIdList;
        this.checkParams(resTreeDto, "getResFunTree");
        String nodeType = resTreeDto.getNodeType();
        Long parentNodeId = resTreeDto.getNodeId();
        String isLeafModule = resTreeDto.getIsLeaf();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        JSTreeModel rootNode = new JSTreeModel();
        rootNode.setId(Constants.RES_NODE_ID);
        rootNode.setCode(String.valueOf(Constants.RES_NODE_ID));
        rootNode.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        rootNode.setParent(Constants.ROOT_NODE_PARENT);
        rootNode.setIsLeaf("0");
        rootNode.setIsModule("1");
        rootNode.setType("isRoot");
        rootNode.setConstant("0");
        if (isGradeAdmin) {
            rootNode.getState().put("gradeDisabled", true);
        }
        boolean leafModuleYes = ToolUtil.equals((Object)Constants.RES_NODE_ID, (Object)isLeafModule);
        boolean funModuleYes = ToolUtil.equals((Object)"isModule", (Object)nodeType);
        HashSet gradeRefFunModuleIds = Sets.newHashSet();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId = shiroUser.getEmployeeId()).getId()))).size() > 0) {
            List functionIdList = this.sysStruResourcesService.getFunId(resourceIdList);
            gradeRefFunModuleIds.addAll(functionIdList);
            if (!leafModuleYes) {
                List leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
                List moduleIdList = leafModules.stream().map(SysModules::getId).collect(Collectors.toList());
                gradeRefFunModuleIds.addAll(moduleIdList);
                ArrayList tmpModuleIds = Lists.newArrayList();
                tmpModuleIds.clear();
                for (SysModules sysModules : leafModules) {
                    Long parentId = sysModules.getParentModuleId();
                    if (!Objects.equals(1L, parentId)) continue;
                    tmpModuleIds.add(parentId);
                }
                List parentModules = this.sysModulesService.getParentModuleTree((List)tmpModuleIds);
                gradeRefFunModuleIds.addAll(parentModules.stream().map(SysModules::getId).collect(Collectors.toSet()));
            }
        }
        ArrayList<JSTreeModel> treeNodeResult = new ArrayList<JSTreeModel>();
        List<Object> lazyTreeNodeList = Lists.newArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentNodeId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentNodeId)) {
                parentNodeId = Constants.RES_NODE_ID;
                treeNodeResult.add(rootNode);
                lazyTreeNodeList = this.getMoudleAndFunctionTree(parentNodeId);
            } else {
                lazyTreeNodeList = funModuleYes && !leafModuleYes ? this.getMoudleAndFunctionTree(parentNodeId) : (funModuleYes && leafModuleYes ? this.sysFunctionsMapper.functionTreeByModuleId(parentNodeId) : new ArrayList());
            }
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : lazyTreeNodeList) {
                Long moduleOrFunId = model.getId();
                if (!gradeRefFunModuleIds.contains(moduleOrFunId)) continue;
                model.getState().put("gradeDisabled", true);
                treeNodeResult.add(model);
            }
        } else {
            treeNodeResult.addAll(lazyTreeNodeList);
        }
        for (JSTreeModel model : treeNodeResult) {
            String isLeaf = model.getIsLeaf();
            String isModule = model.getType();
            if ("isModule".equals(isModule) && "0".equals(isLeaf)) {
                model.getState().put("notLeafModule", true);
            }
            if (!"isFun".equals(isModule)) continue;
            model.setChildren(FALSE);
        }
        return TreeModelUtils.merge(treeNodeResult);
    }

    public List<JSTreeModel> getEditResTree() {
        Iterator gradeParentId;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        List<JSTreeModel> list1 = this.getResTree();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long struId = 0L;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        List resourceIdList = new ArrayList();
        ArrayList functionIdList = new ArrayList();
        ArrayList moduleIdList = new ArrayList();
        ArrayList<Long> moduleIdList1 = new ArrayList<Long>();
        ArrayList list = new ArrayList();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId).getId()))).size() > 0) {
            functionIdList.addAll(this.sysStruResourcesService.getFunId(resourceIdList));
            List leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
            moduleIdList.addAll(leafModules);
            ArrayList<Long> tmpModuleIds = new ArrayList<Long>();
            tmpModuleIds.clear();
            for (SysModules sysModules : leafModules) {
                Long parentId = sysModules.getParentModuleId();
                if (!Objects.equals(1L, parentId)) continue;
                tmpModuleIds.add(parentId);
            }
            List parentModules = this.sysModulesService.getParentModuleTree(tmpModuleIds);
            moduleIdList.addAll(parentModules);
            for (SysModules sysModules : moduleIdList) {
                Long moduleId = sysModules.getId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(resourceIdList);
            list.addAll(functionIdList);
            list.addAll(moduleIdList1);
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                Long id = model.getId();
                if (list.contains(id)) {
                    model.getState().put("gradeDisabled", true);
                }
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel js : result) {
            js.setState(false, false, false);
            if (!ToolUtil.equals((Object)js.getConstant(), (Object)"1")) continue;
            js.setState(false, false, true);
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public IPage getResNodeSubList(Page page, ResTreeQueryDto resTreeQueryDto) {
        List<Object> moduleResourcesVoList;
        String tenantType;
        this.checkParams(resTreeQueryDto, "getResNodeSubList");
        resTreeQueryDto.setResourceCode(resTreeQueryDto.getResourceCode().replace("%", "\\%").replace("_", "\\_"));
        resTreeQueryDto.setResourceName(resTreeQueryDto.getResourceName().replace("%", "\\%").replace("_", "\\_"));
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        Long appId = resTreeQueryDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = HussarUtils.isEmpty((Object)this.unifyPermissionProperties.getApplicationId()) ? 1L : this.unifyPermissionProperties.getApplicationId();
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        Long nodeId = resTreeQueryDto.getNodeId();
        String nodeType = resTreeQueryDto.getNodeType();
        String isLeafModule = resTreeQueryDto.getIsLeaf();
        HashMap resPageMap = new HashMap(4);
        if (ToolUtil.equals((Object)Constants.RES_NODE_ID, (Object)nodeId)) {
            nodeType = "isModule";
        }
        HashMap queryResParams = Maps.newHashMap();
        if (HussarUtils.equals((Object)appId, (Object)nodeId)) {
            nodeId = 1L;
        }
        if (ToolUtil.isNotEmpty((Object)nodeId)) {
            SysResourceModules resourceModule = (SysResourceModules)this.sysResourceModulesMapper.selectById(nodeId);
            if (ToolUtil.isNotEmpty((Object)resourceModule)) {
                queryResParams.put("parentModuleName", resourceModule.getModuleName());
                queryResParams.put("parentNameLangKey", resourceModule.getNameLangKey());
            } else {
                queryResParams.put("parentModuleName", "");
                queryResParams.put("parentNameLangKey", "");
            }
        }
        queryResParams.put("moduleId", nodeId);
        String resourceName = StringUtils.isBlank((CharSequence)resTreeQueryDto.getResourceName()) ? null : resTreeQueryDto.getResourceName().trim();
        String resourceCode = StringUtils.isBlank((CharSequence)resTreeQueryDto.getResourceCode()) ? null : resTreeQueryDto.getResourceCode().trim();
        Long bizAppId = resTreeQueryDto.getBizAppId();
        queryResParams.put("resourceName", resourceName);
        queryResParams.put("resourceCode", resourceCode);
        queryResParams.put("appId", appId);
        SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            queryResParams.put("protectStatus", protectStatus.getConfigValue());
        }
        if ("onsystem".equals(tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY))) {
            List sysUserRoleIds;
            Long roleId;
            if (HussarUtils.isNotEmpty((Object)bizAppId)) {
                if (nodeId.equals(Constants.RES_FUNC_PORTAL_ID)) {
                    queryResParams.put("bizAppId", bizAppId);
                }
                if (nodeId.equals(Constants.RES_NODE_ID)) {
                    queryResParams.put("isPortal", Constants.RES_FUNC_PORTAL_ID);
                }
            }
            if (HussarUtils.isEmpty((Object)(roleId = (Long)(sysUserRoleIds = shiroUser.getRolesList()).stream().filter(l -> SysUserAndRole.TENANT_ADMIN_ROLE.getValue().equals(l) || SysUserAndRole.SUPERADMIN_ROLE.getValue().equals(l)).findAny().orElse(null)))) {
                List currentAppIds = this.sysApplicationService.getCurrentAppIds(shiroUser.getId());
                queryResParams.put("currentAppIds", currentAppIds);
                queryResParams.put("needFilterSys", true);
            } else {
                queryResParams.put("needFilterSys", false);
            }
        }
        if (isGradeAdmin) {
            Long struId = shiroUser.getEmployeeId();
            Long gradeParentId = (long)this.orgMaintenanceService.getOneOrg(struId).getId();
            List resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId);
            if (resourceIdList.isEmpty()) {
                moduleResourcesVoList = Lists.newArrayList();
            } else {
                queryResParams.put("resourceIdList", resourceIdList);
                moduleResourcesVoList = this.getModuleResourcesVoList(queryResParams, page);
                for (SysModuleResourcesVo sysModuleResourcesVo : moduleResourcesVoList) {
                    sysModuleResourcesVo.setGradeDisabled(Boolean.TRUE);
                }
            }
        } else {
            moduleResourcesVoList = this.getModuleResourcesVoList(queryResParams, page);
        }
        page.setRecords(moduleResourcesVoList);
        return page;
    }

    private List<SysModuleResourcesVo> getModuleResourcesVoList(Map<String, Object> queryResParams, Page page) {
        List<SysModuleResourcesVo> moduleResourcesVoList;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (TranslateUtil.getIsEnable() && !HussarUtils.equals((Object)lang, (Object)LangEnum.ZH_CN.getLangValue())) {
            queryResParams.put("lang", lang);
            moduleResourcesVoList = this.sysResourcesMapper.selectResourceListByModuleIdForTrans(page, queryResParams);
        } else {
            moduleResourcesVoList = this.sysResourcesMapper.selectResourceListByModuleId(page, queryResParams);
        }
        TranslateUtil.translate(moduleResourcesVoList, SysModuleResourcesVo::getNameLangKey, SysModuleResourcesVo::setName);
        TranslateUtil.translate(moduleResourcesVoList, SysModuleResourcesVo::getParentNameLangKey, SysModuleResourcesVo::setParentModuleName);
        TranslateUtil.translate(moduleResourcesVoList, SysModuleResourcesVo::getNodeLangKey, SysModuleResourcesVo::setNodeTypeName);
        return moduleResourcesVoList;
    }

    @HussarTransactional
    public ApiResponse deleteModules(Long moduleId) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_ID_DEL_EMPTY.getMessage()));
        }
        boolean flag = this.delCascade(moduleId, null, null);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse deleteFunctions(String functionId) {
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_ID_DEL_EMPTY.getMessage()));
        }
        boolean flag = this.delCascade(null, functionId, null);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse<String> deleteResource(String resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_ID_DELETED_EMPTY.getMessage()));
        }
        boolean flag = this.delCascade(null, null, resourceId);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        return ApiResponse.success((Object)resourceId, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse<String> deleteDataByResourceId(Long resourceId) {
        boolean flag;
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_ID_DELETED_EMPTY.getMessage()));
        }
        SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)resourceId);
        if (HussarUtils.isEmpty((Object)resource)) {
            return ApiResponse.success((Object)String.valueOf(resourceId), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
        }
        boolean bl = flag = this.deleteFunctionByResource(resource) && this.deleteResourceModelByResource(resource);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.success((Object)String.valueOf(resourceId), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    private boolean deleteFunctionByResource(SysResources resource) {
        SysFunctions function = (SysFunctions)this.sysFunctionsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getDefaultResourceId, (Object)resource.getId()));
        if (HussarUtils.isNotEmpty((Object)function)) {
            this.sysRoleFunctionsService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)function.getId()));
            this.sysFunctionResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)function.getId()));
            return this.sysFunctionsService.removeById((Serializable)function.getId());
        }
        return true;
    }

    private boolean deleteResourceModelByResource(SysResources resource) {
        List resourcesList;
        SysResourceModules resourceModule = (SysResourceModules)this.sysResourceMosulesService.getById((Serializable)resource.getModuleId());
        if (HussarUtils.isNotEmpty((Object)resourceModule) && HussarUtils.isEmpty((Object)(resourcesList = this.sysResourcesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getModuleId, (Object)resourceModule.getId())).ne(SysResources::getId, (Object)resource.getId()))))) {
            return this.sysResourceMosulesService.removeById((Serializable)resourceModule.getId());
        }
        return true;
    }

    @Deprecated
    public List<SysResources> getSameUrl(String url) {
        if (ToolUtil.isEmpty((Object)url)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_ADDRESS_EMPTY.getMessage()));
        }
        return this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)url)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public List<SysResources> getSameUrl(ResourceUniqueDto resourceUniqueDto) {
        if (ToolUtil.isEmpty((Object)resourceUniqueDto.getUrl())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_ADDRESS_EMPTY.getMessage()));
        }
        String serviceName = ToolUtil.isEmpty((Object)resourceUniqueDto.getServiceName()) ? "" : resourceUniqueDto.getServiceName();
        Long appId = resourceUniqueDto.getAppId();
        appId = HussarUtils.isEmpty((Object)appId) ? 1L : appId;
        return this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)resourceUniqueDto.getUrl())).eq(SysResources::getApplicationId, (Object)appId)).ne(SysResources::getResTypeId, (Object)"res_open_interface")).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        })).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysResources::getServiceName, (Object)serviceName)).or(ToolUtil.isEmpty((Object)serviceName))).isNull(ToolUtil.isEmpty((Object)serviceName), SysResources::getServiceName);
        }));
    }

    public List<JSTreeModel> getRoleTreeByResourceId(String resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
        }
        List roleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)Long.parseLong(resourceId)));
        if (ToolUtil.isEmpty((Object)roleResourceList)) {
            ArrayList<JSTreeModel> emptyList = new ArrayList<JSTreeModel>();
            JSTreeModel model = new JSTreeModel();
            model.setId(Constants.RES_NODE_ID);
            model.setCode("GROUP");
            model.setParent(Constants.ROOT_NODE_PARENT);
            model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ASSOCIATED_ROLE.getMessage()));
            model.setType("isRoot");
            model.setState(false, false, true);
            emptyList.add(model);
            return TreeModelUtils.merge(emptyList);
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (Object roleResource : roleResourceList) {
            roleIds.add(roleResource.getRoleId());
        }
        ArrayList<String> roleIds2 = new ArrayList<String>();
        for (Long roleId : roleIds) {
            roleIds2.add(roleId.toString());
        }
        List result = this.orgMaintenanceService.selfRoleTree(roleIds2.toArray(new String[roleIds2.size()]));
        List<JSTreeModel> tree = this.getRoleTree(result);
        return TreeModelUtils.merge(tree);
    }

    @HussarTransactional
    @Deprecated
    public ApiResponse saveResourceRelationRole(Long resourceId, String roleIds) {
        ResourceRoleRelationDto resourceRoleRelationDto = new ResourceRoleRelationDto();
        resourceRoleRelationDto.setResourceId(resourceId);
        resourceRoleRelationDto.setRoleIds(roleIds);
        return this.saveResourceRelationRole(resourceRoleRelationDto);
    }

    @HussarTransactional
    public ApiResponse saveResourceRelationRole(ResourceRoleRelationDto resourceRoleRelationDto) {
        Long resourceId = resourceRoleRelationDto.getResourceId();
        String roleIds = resourceRoleRelationDto.getRoleIds();
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
        }
        SysResources resources = (SysResources)this.sysResourcesMapper.selectById(resourceId);
        if (HussarUtils.isEmpty((Object)resources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SAVE_FAILED_RESOURCE_NOT_EXIST.getMessage()));
        }
        Long count = this.sysResourcesAuditMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourcesAudit::getResourceId, (Object)resourceId)).eq(SysResourcesAudit::getAuditStatus, (Object)"0")).eq(SysResourcesAudit::getOperateType, (Object)"3"));
        if (count > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SAVE_FAILED_EXIST_REVIEW.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isResourceAudit()) {
            return this.doProcessAudit(roleIds, resourceId);
        }
        return this.doProcess(roleIds, resourceId);
    }

    private ApiResponse<String> doProcessAudit(String roleIds, Long resourceId) {
        String[] ids = roleIds == null ? "".split(",") : roleIds.split(",");
        ArrayList<SysRoleResourceAudit> sysRoleResourceAuditList = new ArrayList<SysRoleResourceAudit>();
        for (String roleId : ids) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            SysRoleResourceAudit audit = new SysRoleResourceAudit();
            audit.setRoleId(Long.valueOf(roleId));
            audit.setResourceId(resourceId);
            audit.setRelationSource("2");
            audit.setAuditStatus("0");
            audit.setOperateType("1");
            sysRoleResourceAuditList.add(audit);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceAuditList)) {
            this.sysRoleResourceAuditService.saveBatch(sysRoleResourceAuditList, sysRoleResourceAuditList.size());
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS_WAIT_REVIEW.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    private ApiResponse<String> doProcess(String roleIds, Long resourceId) {
        SysResources resource;
        List oldRolesIds = this.sysRoleResourceService.getResourceRoles(resourceId).stream().map(SysRoleResource::getRoleId).collect(Collectors.toList());
        String[] ids = roleIds == null ? "".split(",") : roleIds.split(",");
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String roleId : ids) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(Long.valueOf(roleId));
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setRelationSource("2");
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            this.sysRoleResourceService.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        if (HussarUtils.isNotEmpty((Object)(resource = (SysResources)this.sysResourcesService.getById((Serializable)resourceId)).getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)resource.getApplicationId())) {
            this.resourceRoleChangeNotify.notify(DataChangeType.RELATE, new Object[]{resourceId});
        }
        List newRolesIds = Arrays.stream(ids).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toList());
        oldRolesIds.addAll(newRolesIds);
        if (HussarUtils.isEmpty((Object)resource.getApplicationId()) || resource.getApplicationId() == 1L) {
            this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"role", oldRolesIds.stream().distinct().collect(Collectors.toList())});
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse updateResourceRelationRole(ResRoleDto resRoleDto) {
        Long resourceId = resRoleDto.getResourceId();
        List<Long> oldRolesIds = this.sysRoleResourceService.getResourceRoles(resourceId).stream().map(SysRoleResource::getRoleId).collect(Collectors.toList());
        String roleIds = resRoleDto.getRoleIds();
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
        }
        SysResources resources = (SysResources)this.sysResourcesMapper.selectById(resourceId);
        if (HussarUtils.isEmpty((Object)resources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SAVE_FAILED_RESOURCE_NOT_EXIST.getMessage()));
        }
        Long count = this.sysResourcesAuditMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourcesAudit::getResourceId, (Object)resourceId)).eq(SysResourcesAudit::getAuditStatus, (Object)"0")).eq(SysResourcesAudit::getOperateType, (Object)"3"));
        if (count > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SAVE_FAILED_EXIST_REVIEW.getMessage()));
        }
        long roleResCount = this.sysRoleResourceAuditService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResourceAudit::getResourceId, (Object)resourceId)).eq(SysRoleResourceAudit::getAuditStatus, (Object)"0"));
        if (roleResCount > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SAVE_FAILED_ROLE_RESOURCE_AUDIT.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isResourceAudit()) {
            return this.doProcessEditAudit(resourceId, roleIds);
        }
        return this.doProcessEdit(resourceId, roleIds, oldRolesIds);
    }

    private ApiResponse<String> doProcessEditAudit(Long resourceId, String roleIds) {
        List list = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId)).eq(SysRoleResource::getRelationSource, (Object)"2"));
        List oldRolesIds = list.stream().map(SysRoleResource::getRoleId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(oldRolesIds) && HussarUtils.isEmpty((Object)roleIds)) {
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
        }
        if (HussarUtils.isEmpty(oldRolesIds) && HussarUtils.isNotEmpty((Object)roleIds)) {
            return this.doProcessAudit(roleIds, resourceId);
        }
        if (HussarUtils.isNotEmpty(oldRolesIds) && HussarUtils.isEmpty((Object)roleIds)) {
            ArrayList<SysRoleResourceAudit> sysRoleResourceAuditList = new ArrayList<SysRoleResourceAudit>();
            for (Long roleId2 : oldRolesIds) {
                SysRoleResourceAudit audit = new SysRoleResourceAudit();
                audit.setRoleId(roleId2);
                audit.setResourceId(resourceId);
                audit.setRelationSource("2");
                audit.setAuditStatus("0");
                audit.setOperateType("3");
                sysRoleResourceAuditList.add(audit);
            }
            this.sysRoleResourceAuditService.saveBatch(sysRoleResourceAuditList, sysRoleResourceAuditList.size());
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS_WAIT_REVIEW.getMessage()));
        }
        if (HussarUtils.isNotEmpty(oldRolesIds) && HussarUtils.isNotEmpty((Object)roleIds)) {
            SysRoleResourceAudit audit;
            List newRolesIds = Arrays.stream(roleIds.split(",")).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toList());
            List delRolesIds = oldRolesIds.stream().filter(roleId -> !newRolesIds.contains(roleId)).collect(Collectors.toList());
            List addRolesIds = newRolesIds.stream().filter(roleId -> !oldRolesIds.contains(roleId)).collect(Collectors.toList());
            if (HussarUtils.isEmpty(delRolesIds) && HussarUtils.isEmpty(addRolesIds)) {
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
            }
            ArrayList<SysRoleResourceAudit> sysRoleResourceAuditList = new ArrayList<SysRoleResourceAudit>();
            if (HussarUtils.isNotEmpty(delRolesIds)) {
                for (Long roleId3 : delRolesIds) {
                    audit = new SysRoleResourceAudit();
                    audit.setRoleId(roleId3);
                    audit.setResourceId(resourceId);
                    audit.setRelationSource("2");
                    audit.setAuditStatus("0");
                    audit.setOperateType("3");
                    sysRoleResourceAuditList.add(audit);
                }
            }
            if (HussarUtils.isNotEmpty(addRolesIds)) {
                for (Long roleId3 : addRolesIds) {
                    audit = new SysRoleResourceAudit();
                    audit.setRoleId(roleId3);
                    audit.setResourceId(resourceId);
                    audit.setRelationSource("2");
                    audit.setAuditStatus("0");
                    audit.setOperateType("1");
                    sysRoleResourceAuditList.add(audit);
                }
            }
            if (HussarUtils.isNotEmpty(sysRoleResourceAuditList)) {
                this.sysRoleResourceAuditService.saveBatch(sysRoleResourceAuditList, sysRoleResourceAuditList.size());
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS_WAIT_REVIEW.getMessage()));
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    private ApiResponse<String> doProcessEdit(Long resourceId, String roleIds, List<Long> oldRolesIds) {
        String[] ids;
        this.sysRoleResourceService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId)).ne(SysRoleResource::getRelationSource, (Object)"1"));
        if (HussarUtils.isNotBlank((CharSequence)roleIds)) {
            ids = roleIds == null ? "".split(",") : roleIds.split(",");
            ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
            for (String roleId : ids) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(Long.valueOf(roleId));
                sysRoleResource.setResourceId(resourceId);
                sysRoleResource.setRelationSource("2");
                sysRoleResourceList.add(sysRoleResource);
            }
            this.sysRoleResourceService.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        this.resourceRoleChangeNotify.notify(DataChangeType.UPDATE, new Object[]{resourceId});
        ids = roleIds != null ? roleIds.split(",") : "".split(",");
        List newRolesIds = Arrays.stream(ids).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toList());
        oldRolesIds.addAll(newRolesIds);
        SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)resourceId);
        if (HussarUtils.isEmpty((Object)resource.getApplicationId()) || resource.getApplicationId() == 1L) {
            this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"role", oldRolesIds.stream().distinct().collect(Collectors.toList())});
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    public JSONObject queryIsCheckResource(String resourceUrl) {
        if (ToolUtil.isEmpty((Object)resourceUrl)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_URL_EMPTY.getMessage()));
        }
        JSONObject json = new JSONObject();
        json.put("flag", (Object)this.sysResourcesService.checkResource(resourceUrl));
        json.put("totp", (Object)this.hussarLoginConfigService.getTotpOpen());
        this.abstractOtpCredentialsMatcher.getClass();
        json.put("csrfToken", (Object)this.abstractOtpCredentialsMatcher.generate("FCUD3YLMJYG2F72L2NFDXYPL6UJBUUN24BGBK6JDEIKHUA4ZOD2A"));
        return json;
    }

    private List<JSTreeModel> getRoleTree(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        list.forEach(r -> {
            if ("ROLE".equals(r.getCode())) {
                roleIds.add(r.getId());
            }
        });
        this.recursiveRoleTree(list, result, roleIds);
        JSTreeModel model = new JSTreeModel();
        model.setId(Constants.RES_NODE_ID);
        model.setCode("GROUP");
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ASSOCIATED_ROLE.getMessage()));
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    private void recursiveRoleTree(List<JSTreeModel> list, List<JSTreeModel> result, List<Long> ids) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<JSTreeModel> tempList = new ArrayList<JSTreeModel>();
        for (JSTreeModel map : list) {
            if (ids.contains(map.getId())) {
                result.add(map);
                if (map.getParent() == null) continue;
                parentIds.add(map.getParent());
                continue;
            }
            tempList.add(map);
        }
        if (ToolUtil.isNotEmpty(parentIds)) {
            this.recursiveRoleTree(tempList, result, parentIds);
        }
    }

    private Boolean delCascade(Long moduleId, String functionId, String resId) {
        Long resourceId = Long.parseLong(resId);
        ArrayList<Long> functionIdList = new ArrayList<Long>();
        ArrayList resourceIdList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            List moduleList = this.sysModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysModules::getParentModuleId, (Object)moduleId));
            for (SysModules sysModules : moduleList) {
                this.delCascade(sysModules.getId(), null, null);
            }
            List functionList = this.sysFunctionsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctions::getFunctionModuleId, (Object)moduleId)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            }));
            for (SysFunctions sysFunctions : functionList) {
                functionIdList.add(sysFunctions.getId());
            }
        }
        if (ToolUtil.isNotEmpty((Object)resourceId)) {
            this.sysRoleResourceMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId));
            this.sysResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResources::getId, (Object)resourceId));
        }
        if (resourceIdList.size() != 0) {
            this.sysRoleResourceMapper.deleteBatchIds(resourceIdList);
            this.sysResourcesService.removeByIds(resourceIdList);
        }
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            this.sysFunctionsService.remove((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getId, (Object)functionId));
        }
        this.sysFunctionsService.removeByIds(functionIdList);
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            this.sysModulesService.removeById((Serializable)moduleId);
        }
        return true;
    }

    public SysModuleFunctionsVo functionsDetail(Long functionId, Long functionModuleId) {
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            return this.sysFunctionsService.getFunctionDetail(functionId);
        }
        return this.sysFunctionModulesService.getFunctionModuleDetail(functionModuleId);
    }

    public Integer functionSave(SysFunctions sysFunctions, String type) {
        int count = this.functionSaveByType(sysFunctions, type);
        return count;
    }

    public Integer functionSaveByType(SysFunctions sysFunctions, String type) {
        int count;
        Long userId = null;
        if (sysFunctions.getCreator() != null && "godaxe".equals(sysFunctions.getCreator())) {
            userId = sysFunctions.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        if (HussarUtils.equals((Object)"0", (Object)type)) {
            Integer max = this.sysFunctionsService.getMaxOrderByParentId(sysFunctions.getFunctionModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                sysFunctions.setSeq(Integer.valueOf(max + 1));
            } else {
                sysFunctions.setSeq(Integer.valueOf(1));
            }
            sysFunctions.setCreator(userId);
            count = this.sysFunctionsMapper.insert(sysFunctions);
            this.roleFunctionSaveByFunctions(sysFunctions);
        } else {
            sysFunctions.setLastEditor(userId);
            count = this.sysFunctionsMapper.updateById(sysFunctions);
        }
        return count;
    }

    public void roleFunctionSaveByFunctions(SysFunctions sysFunctions) {
        SysRoleFunctions roleFunction = new SysRoleFunctions();
        if (this.tenantProperties.isEnabled()) {
            if (!((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                    roleFunction.setRoleId(TenantConstant.TENANT_SYSTEM_ADMIN_ROLE);
                } else {
                    roleFunction.setRoleId(TenantConstant.ADMIN_ROLE);
                }
            } else if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                roleFunction.setRoleId(SysUserAndRole.SYSTEMADMIN_ROLE.getValue());
            } else {
                roleFunction.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
            }
        } else if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            roleFunction.setRoleId(SysUserAndRole.SYSTEMADMIN_ROLE.getValue());
        } else {
            roleFunction.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
        }
        roleFunction.setFunctionId(sysFunctions.getId());
        this.sysRoleFunctionsService.save((Object)roleFunction);
    }

    @HussarDs(value="#connName")
    public Integer functionSave(String connName, SysFunctions sysFunctions) {
        return this.functionSave(sysFunctions, "0");
    }

    public List<JSTreeModel> getFunctionModuleTreeByModuleId(QueryFuncOrderTreeDto queryFuncOrderTreeDto) {
        SysBaseConfig protectStatus;
        Long moduleId = queryFuncOrderTreeDto.getModuleId();
        String moduleName = queryFuncOrderTreeDto.getModuleName();
        Long appId = queryFuncOrderTreeDto.getApplicationId();
        Long bizAppId = queryFuncOrderTreeDto.getBizAppId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = HussarUtils.isEmpty((Object)this.unifyPermissionProperties.getApplicationId()) ? 1L : this.unifyPermissionProperties.getApplicationId();
        }
        boolean status = (protectStatus = this.baseConfigService.getSysBaseConfig("protection_status")) != null && "3".equals(protectStatus.getConfigValue());
        List result = this.sysFunctionModulesService.functionModuleTreeByModuleId(moduleId, appId, bizAppId, Boolean.valueOf(status));
        String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY);
        if ("onsystem".equals(tenantType)) {
            List currentAppIds = this.sysApplicationService.getCurrentAppIds(BaseSecurityUtil.getUser().getId());
            result = result.stream().filter(jsTreeModel -> currentAppIds.contains(jsTreeModel.getAppId()) || Constants.DEFAULT_SYS_APP_ID.equals(jsTreeModel.getApplicationId()) && HussarUtils.isEmpty((Object)jsTreeModel.getAppId())).collect(Collectors.toList());
        }
        TranslateUtil.translate((List)result, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public CheckResourceVo checkHasResources(Long resourceId, String type) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
        }
        List list = this.sysStruResourcesService.getResourceIdList(resourceId, type);
        CheckResourceVo result = new CheckResourceVo();
        List moduleList = this.sysResourceMosulesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getParentModuleId, (Object)resourceId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        if (list.size() > 0) {
            result.setResource(true);
        } else {
            result.setResource(false);
        }
        if (moduleList.size() > 0) {
            result.setModule(true);
        } else {
            result.setModule(false);
        }
        return result;
    }

    @HussarTransactional
    public ApiResponse delModuleResCascade(Long moduleId, Long resId) {
        List functionResourcesList;
        ArrayList<Long> moduleIdList = new ArrayList<Long>();
        ArrayList<Long> resourceIdList = new ArrayList<Long>();
        if (ToolUtil.isEmpty((Object)moduleId) && ToolUtil.isEmpty((Object)resId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_ID_OR_RESOURCE_ID_EMPTY.getMessage()));
        }
        List resources = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            SysApplication sysApplication;
            SysResourceModules sysResourceModules = (SysResourceModules)this.sysResourceMosulesService.getById((Serializable)moduleId);
            if (ToolUtil.isEmpty((Object)sysResourceModules)) {
                throw new BaseException("\u6a21\u5757\u4e0d\u5b58\u5728");
            }
            if (ToolUtil.isNotEmpty((Object)sysResourceModules.getAppId()) && sysResourceModules.getAppId() != 1L && ToolUtil.isNotEmpty((Object)(sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysResourceModules.getAppId()))) && sysResourceModules.getParentModuleId() == 1L) {
                throw new BaseException("\u5e94\u7528\u5b58\u5728,\u4e0d\u80fd\u5220\u9664\u6b64\u6a21\u5757");
            }
        }
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            this.getDelModule(moduleId, moduleIdList);
            List resourcesList = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().in(SysResources::getModuleId, moduleIdList));
            for (SysResources sysResources : resourcesList) {
                resourceIdList.add(sysResources.getId());
            }
            resources = resourcesList;
        }
        if (resourceIdList.size() > 0) {
            int count;
            ArrayList<Long> resourceIds = new ArrayList<Long>(resourceIdList);
            if (ToolUtil.isNotEmpty((Object)resId)) {
                resourceIds.add(resId);
            }
            if ((count = this.getAdminResourceCount(ADMIN_ROLE_IDS, resourceIds)) > 0) {
                throw new ResourceWithAdminException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_WITH_ADMIN.getMessage()));
            }
            functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFunctionResources::getResourceId, resourceIds));
            List functionsList = this.sysFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctions::getDefaultResourceId, resourceIds)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            }));
            if (functionResourcesList.size() > 0 || functionsList.size() > 0) {
                throw new ResourceWithFunctionException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_WITH_FUNCTION.getMessage()));
            }
            LambdaQueryWrapper roleResourceLambdaQueryWrapper = new LambdaQueryWrapper();
            roleResourceLambdaQueryWrapper.in(SysRoleResource::getResourceId, resourceIds);
            List roleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper);
            AssertUtil.isEmpty((Collection)roleResourceList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_WITH_ROLE_BATCH.getMessage()));
        }
        if (ToolUtil.isNotEmpty((Object)resId)) {
            int count = this.getAdminResourceCount(ADMIN_ROLE_IDS, Collections.singletonList(resId));
            if (count > 0) {
                throw new ResourceWithAdminException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_WITH_ADMIN.getMessage()));
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysFunctionResources::getResourceId, (Object)resId);
            functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)queryWrapper);
            AssertUtil.isEmpty((Collection)functionResourcesList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_RES_FUNCTION.getMessage()));
            int roleCounts = this.getAdminResourceCount(null, Arrays.asList(resId));
            if (roleCounts > 0) {
                throw new ResourceWithAdminException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_WITH_ROLE.getMessage()));
            }
            this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resId));
            SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)resId);
            if (HussarUtils.equals((Object)RES_MENU, (Object)resource.getResTypeId()) || HussarUtils.equals((Object)"res_element", (Object)resource.getResTypeId())) {
                List sysResources = this.sysResourcesService.getPageAndElementResources(resource.getModuleId());
                HashSet<Long> resIds = new HashSet<Long>();
                this.getChildElementResources(resId, sysResources, resIds);
                if (HussarUtils.isNotEmpty(resIds)) {
                    this.sysResourcesService.removeByIds(resIds);
                }
            }
            this.sysResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResources::getId, (Object)resId));
            this.hussarBaseResourceExpandService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceId, (Object)resId));
            if (HussarUtils.isNotEmpty((Object)resource.getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)resource.getApplicationId())) {
                this.resourceChangeNotify.notify(DataChangeType.DELETE, new Object[]{resource});
            }
        }
        if (resourceIdList.size() != 0) {
            this.sysRoleResourceService.removeByIds(resourceIdList);
            this.sysResourcesService.removeByIds(resourceIdList);
        }
        List resourceModules = null;
        SysResourceModules module = null;
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            module = (SysResourceModules)this.sysResourceMosulesService.getById((Serializable)moduleId);
            resourceModules = this.sysResourceMosulesService.listByIds(moduleIdList);
            this.sysResourceMosulesService.removeById((Serializable)moduleId);
        }
        if (ToolUtil.isNotEmpty(moduleIdList)) {
            this.sysResourceMosulesService.removeByIds(moduleIdList);
        }
        if (ToolUtil.isNotEmpty(module) && !HussarUtils.equals((Object)1L, (Object)module.getApplicationId())) {
            this.resourceModuleBatchDeleteChangeNotify.notify(DataChangeType.DELETE, new Object[]{resourceModules, resources});
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse<String> delResCascade(Long resId) {
        this.validResData(resId);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isResourceAudit()) {
            SysResourcesAudit audit = new SysResourcesAudit();
            SysResources resource = (SysResources)this.sysResourcesMapper.selectById(resId);
            BeanUtils.copyProperties((Object)resource, (Object)audit, (String[])new String[]{"id", "createTime", "lastTime", "creator", "lastEditor"});
            audit.setResourceId(resId);
            audit.setUserRights(resource.getUserRight());
            audit.setDeptRights(resource.getDeptRight());
            audit.setAuditStatus("0");
            audit.setOperateType("3");
            this.sysResourcesAuditMapper.insert(audit);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage()));
        }
        this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resId));
        SysResources resource = (SysResources)this.sysResourcesService.getById((Serializable)resId);
        if (HussarUtils.equals((Object)RES_MENU, (Object)resource.getResTypeId()) || HussarUtils.equals((Object)"res_element", (Object)resource.getResTypeId())) {
            List sysResources = this.sysResourcesService.getPageAndElementResources(resource.getModuleId());
            HashSet<Long> resIds = new HashSet<Long>();
            this.getChildElementResources(resId, sysResources, resIds);
            if (HussarUtils.isNotEmpty(resIds)) {
                this.sysResourcesService.removeByIds(resIds);
            }
        }
        this.sysResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResources::getId, (Object)resId));
        this.hussarBaseResourceExpandService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceId, (Object)resId));
        if (HussarUtils.isNotEmpty((Object)resource.getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)resource.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.DELETE, new Object[]{resource});
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    private void validResData(Long resId) {
        if (HussarUtils.isEmpty((Object)resId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_ID_OR_RESOURCE_ID_EMPTY.getMessage()));
        }
        Long auditResCount = this.sysResourcesAuditMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourcesAudit::getResourceId, (Object)resId)).eq(SysResourcesAudit::getAuditStatus, (Object)"0"));
        if (auditResCount > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage()));
        }
        int count = this.getAdminResourceCount(ADMIN_ROLE_IDS, Collections.singletonList(resId));
        if (count > 0) {
            throw new ResourceWithAdminException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_WITH_ADMIN.getMessage()));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFunctionResources::getResourceId, (Object)resId);
        List functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isEmpty((Collection)functionResourcesList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_RES_FUNCTION.getMessage()));
        List audits = this.sysFunctionResourcesAuditMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionResourcesAudit::getResourceId, (Object)resId)).eq(SysFunctionResourcesAudit::getAuditStatus, (Object)"0"));
        AssertUtil.isEmpty((Collection)audits, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAILED_FUNC_RESOURCE_AUDIT.getMessage()));
        List functionsAudits = this.sysFunctionsAuditMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionsAudit::getDefaultResourceId, (Object)resId)).eq(SysFunctionsAudit::getAuditStatus, (Object)"0"));
        AssertUtil.isEmpty((Collection)functionsAudits, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAILED_FUNC_RESOURCE_AUDIT.getMessage()));
        int roleCounts = this.getAdminResourceCount(null, Arrays.asList(resId));
        if (roleCounts > 0) {
            throw new ResourceWithAdminException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_WITH_ROLE.getMessage()));
        }
        long auditRoleCount = this.sysRoleResourceAuditService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResourceAudit::getResourceId, (Object)resId)).eq(SysRoleResourceAudit::getAuditStatus, (Object)"0"));
        if (auditRoleCount > 0L) {
            AssertUtil.isEmpty((Collection)functionsAudits, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAILED_ROLE_RESOURCE_AUDIT.getMessage()));
        }
    }

    private void getDelModule(Long moduleId, List<Long> moduleIds) {
        List moduleList = this.sysResourceMosulesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getParentModuleId, (Object)moduleId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        if (moduleList.size() > 0) {
            for (SysResourceModules modules : moduleList) {
                this.getDelModule(modules.getId(), moduleIds);
            }
        }
        moduleIds.add(moduleId);
    }

    public int getAdminResourceCount(List<Long> roleIds, List<Long> resourceIds) {
        return this.sysRoleResourceMapper.getAdminResourceCount(roleIds, resourceIds);
    }

    @Cacheable(value={"resource_info"}, key="'hussar_resource:'+#shiroUser.id + ':' +#type + ':' + #locale")
    public List<SysResources> getResources(SecurityUser shiroUser, String type, String locale) {
        List roleIdList = shiroUser.getRolesList();
        if (ToolUtil.isNotEmpty((Object)roleIdList)) {
            if (roleIdList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue()) || roleIdList.contains(SysUserAndRole.DEVELOP_ROLE.getValue()) || roleIdList.contains(TenantConstant.ADMIN_ROLE)) {
                List list = this.sysResourcesService.list();
                TranslateUtil.translate((List)list, SysResources::getNameLangKey, SysResources::setResourceName);
                TranslateUtil.translate((List)list, SysResources::getAliasLangKey, SysResources::setResourceAlias);
                return list;
            }
            List resourcesByIds = this.sysResourcesService.getResourcesByIds(roleIdList, type);
            TranslateUtil.translate((List)resourcesByIds, SysResources::getNameLangKey, SysResources::setResourceName);
            TranslateUtil.translate((List)resourcesByIds, SysResources::getAliasLangKey, SysResources::setResourceAlias);
            return resourcesByIds;
        }
        return Collections.emptyList();
    }

    private void updateComponentByType(List<SysResources> resources, String extra) {
        for (SysResources resource : resources) {
            String component = resource.getComponent();
            if (!ToolUtil.isNotEmpty((Object)component) || component.contains(extra)) continue;
            int index = component.indexOf("@");
            String pre = component.substring(0, index + 1);
            String suf = component.substring(index + 1);
            String newComponent = pre + extra + suf;
            resource.setComponent(newComponent);
        }
    }

    public List<SysResources> getResourcesListByApp(String type) {
        return new ArrayList<SysResources>();
    }

    public IPage getResourceList(ResListDto resListDto, Page<SysResources> pages) {
        HashMap result = new HashMap();
        String resourceAlias = resListDto.getResourceName();
        String permissions = resListDto.getPermissions();
        String urlNames = resListDto.getUrlNames();
        String path = resListDto.getPath();
        String component = resListDto.getComponent();
        if (ToolUtil.isNotEmpty((Object)resourceAlias)) {
            resourceAlias = resourceAlias.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setResourceName(resourceAlias);
        }
        if (ToolUtil.isNotEmpty((Object)permissions)) {
            permissions = permissions.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setPermissions(permissions);
        }
        if (ToolUtil.isNotEmpty((Object)urlNames)) {
            urlNames = urlNames.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setUrlNames(urlNames);
        }
        if (ToolUtil.isNotEmpty((Object)path)) {
            path = path.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setPath(path);
        }
        if (ToolUtil.isNotEmpty((Object)component)) {
            component = component.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setComponent(component);
        }
        List<SysResources> list = this.sysResourcesMapper.getResourceList(resListDto, pages);
        pages.setRecords(list);
        return pages;
    }

    public List<JSTreeModel> getJsTreeModelListForModAndRes(List<SysResourceModules> moduleIdList, List<Long> resourceIdList) {
        JSTreeModel jsTreeModel;
        ArrayList<JSTreeModel> jsTreeModelList = new ArrayList<JSTreeModel>();
        List sysResourcesList = new ArrayList();
        if (ToolUtil.isNotEmpty(resourceIdList)) {
            QueryWrapper sysResourcesQueryWrapper = new QueryWrapper();
            sysResourcesQueryWrapper.lambda().in(SysResources::getId, resourceIdList);
            sysResourcesList = this.sysResourcesService.list((Wrapper)sysResourcesQueryWrapper);
        }
        if (ToolUtil.isNotEmpty(sysResourcesList)) {
            for (SysResources sysResources : sysResourcesList) {
                jsTreeModel = new JSTreeModel();
                jsTreeModel.setId(sysResources.getId());
                jsTreeModel.setText(sysResources.getResourceName());
                jsTreeModel.setParent(Long.valueOf(sysResources.getModuleId()));
                jsTreeModel.setIsLeaf("1");
                jsTreeModel.setSeq(String.valueOf(sysResources.getSeq()));
                jsTreeModel.setIsFun("0");
                jsTreeModel.setIsRes("1");
                jsTreeModel.setType("isRes");
                jsTreeModel.setCode(sysResources.getResourceCode());
                jsTreeModel.setConstant("0");
                jsTreeModelList.add(jsTreeModel);
            }
        }
        if (ToolUtil.isNotEmpty(moduleIdList = moduleIdList.stream().distinct().collect(Collectors.toList()))) {
            for (SysResourceModules sysResourceModules : moduleIdList) {
                jsTreeModel = new JSTreeModel();
                jsTreeModel.setId(sysResourceModules.getId());
                jsTreeModel.setText(sysResourceModules.getModuleName());
                jsTreeModel.setParent(Long.valueOf(sysResourceModules.getParentModuleId()));
                jsTreeModel.setIsLeaf("0");
                jsTreeModel.setSeq(String.valueOf(sysResourceModules.getSeq()));
                jsTreeModel.setIsFun("0");
                jsTreeModel.setIsRes("0");
                jsTreeModel.setType("isModule");
                jsTreeModel.setCode(sysResourceModules.getModuleCode());
                jsTreeModel.setConstant("0");
                jsTreeModelList.add(jsTreeModel);
            }
        }
        return jsTreeModelList;
    }

    private void checkParams(Object params, String functions) {
        switch (functions) {
            case "getModuleInfoById": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MODUL_ID_NOT_NULL.getMessage()));
            }
            case "saveModules": {
                SysResourceModules sysResourceModules = (SysResourceModules)JSON.parseObject((String)JSON.toJSONString((Object)params), SysResourceModules.class);
                if (ToolUtil.isEmpty((Object)sysResourceModules.getModuleName())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_NAME_EMPTY.getMessage()));
                }
                int limit = 32;
                if (TranslateUtil.getIsEnable() && LocaleContextHolder.getLocale().toLanguageTag().equals(LangEnum.EN_US.getLangValue())) {
                    limit = 128;
                }
                if (sysResourceModules.getModuleName().trim().length() <= limit) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_NAME_LENGTH.getMessage()));
            }
            case "updateModules": {
                SysResourceModules updateSysModules = (SysResourceModules)JSON.parseObject((String)JSON.toJSONString((Object)params), SysResourceModules.class);
                if (ToolUtil.isEmpty((Object)updateSysModules.getId())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MODUL_ID_NOT_NULL.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)updateSysModules.getModuleName())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_NAME_EMPTY.getMessage()));
                }
                if (updateSysModules.getModuleName().trim().length() <= 32) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_NAME_LENGTH.getMessage()));
            }
            case "moduleTreeById": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MODUL_ID_NOT_NULL.getMessage()));
            }
            case "saveFunction": {
                SysFunctions sysFunctions = (SysFunctions)JSON.parseObject((String)JSON.toJSONString((Object)params), SysFunctions.class);
                if (ToolUtil.isEmpty((Object)sysFunctions.getFunctionName())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_NAME_EMPTY.getMessage()));
                }
                if (sysFunctions.getFunctionName().trim().length() > 32) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FEATURE_NAME_CHARACTERS.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysFunctions.getFunctionCode())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_CODE_EMPTY.getMessage()));
                }
                if (!ToolUtil.isEmpty((Object)sysFunctions.getDefaultResourceId())) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_ENTRY_EMPTY.getMessage()));
            }
            case "updateFunction": {
                SysFunctions editFunction = (SysFunctions)JSON.parseObject((String)JSON.toJSONString((Object)params), SysFunctions.class);
                if (ToolUtil.isEmpty((Object)editFunction.getId())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_FUNCTION_ID_NOT_NULL.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)editFunction.getFunctionName())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_NAME_EMPTY.getMessage()));
                }
                if (editFunction.getFunctionName().trim().length() > 32) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FEATURE_NAME_CHARACTERS.getMessage()));
                }
                if (!ToolUtil.isEmpty((Object)editFunction.getFunctionCode())) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_CODE_EMPTY.getMessage()));
            }
            case "getSelfResourceTree": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
            }
            case "getFunResourceForOrg": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
            }
            case "getFunResource": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
            }
            case "getResFunTree": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_FUNCTION_TREE_EMPTY.getMessage()));
            }
            case "getResNodeSubList": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_TREE_QUERY_EMPTY.getMessage()));
            }
            case "getFunctionInfoById": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_FUNCTION_ID_NOT_NULL.getMessage()));
            }
            case "updateModuleTreeOrder": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_SORTING_LIST_EMPTY.getMessage()));
            }
        }
    }

    public String getResourceCurrentCode(String moduleCode) {
        String currentCode = this.sysIdtableService.getCurrentCode("RESOURCE_CODE", "SYS_RESOURCES");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_CODE_OBTAINED.getMessage()));
        }
        return moduleCode + currentCode;
    }

    public List<SysResources> getSamePath(ResourcePathDto resourcePathDto) {
        String serviceName;
        String path = resourcePathDto.getPath();
        String string = serviceName = ToolUtil.isEmpty((Object)resourcePathDto.getServiceName()) ? "" : resourcePathDto.getServiceName();
        if (ToolUtil.isEmpty((Object)path)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_ROUTING_EMPTY.getMessage()));
        }
        Long appId = resourcePathDto.getAppId();
        appId = HussarUtils.isEmpty((Object)appId) ? 1L : appId;
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("path", resourcePathDto.getPath().toUpperCase());
        queryParams.put("serviceName", serviceName);
        queryParams.put("appId", appId);
        return this.sysResourcesMapper.getSamePath(queryParams);
    }

    public void insertOrUpdateResourcesList(List<SysResources> resourcesList) {
        if (CollectionUtils.isEmpty(resourcesList)) {
            LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_ADD_DATA.getMessage()), (Object)resourcesList.size());
            LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_EDIT_DATA.getMessage()), (Object)resourcesList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysResources::getId).collect(Collectors.toList());
        ArrayList<SysResources> insertData = new ArrayList<SysResources>();
        ArrayList<SysResources> updateData = new ArrayList<SysResources>();
        Integer maxOrder = this.sysResourcesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("RESOURCE_CODE", "SYS_RESOURCES");
        List modulesList = this.sysResourceMosulesService.list();
        HashMap<Long, String> resModuleIdAndCode = new HashMap<Long, String>();
        for (SysResourceModules module : modulesList) {
            resModuleIdAndCode.put(module.getId(), module.getModuleCode());
        }
        Integer maxCode = sysIdtable.getIdValue();
        for (SysResources item : resourcesList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            StringBuilder currentCode = new StringBuilder();
            int zerolength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zerolength < 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENCODING_EXCEEDS_LENGTH.getMessage()));
            }
            currentCode.append(item.getModuleId());
            for (int i = 0; i < zerolength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            item.setSeq(maxOrder);
            item.setResourceCode(currentCode.toString());
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_ADD_DATA.getMessage()), (Object)insertData.size());
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_EDIT_DATA.getMessage()), (Object)updateData.size());
    }

    public List<ResMapperSelectVo> getMapper(Long moduleId, String serverName) {
        ArrayList<ResMapperSelectVo> result = new ArrayList<ResMapperSelectVo>();
        LambdaQueryWrapper resourcesLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)resourcesLambdaQueryWrapper.eq(SysResources::getModuleId, (Object)moduleId)).eq(SysResources::getResTypeId, (Object)"res_btn");
        resourcesLambdaQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        List resourcesList = this.sysResourcesMapper.selectList((Wrapper)resourcesLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)resourcesList)) {
            List urlList = resourcesList.stream().map(SysResources::getUrlNames).collect(Collectors.toList());
            serverName = HussarUtils.isNotBlank((CharSequence)serverName) ? serverName : "default";
            HashMap map = new HashMap();
            for (SysResources item : resourcesList) {
                List mapperList = (List)map.get(item.getUrlNames());
                if (!HussarUtils.isNotEmpty((Object)mapperList)) continue;
                ArrayList<ResMapperVo> resMapperVoList = new ArrayList<ResMapperVo>();
                for (String mapper : mapperList) {
                    ResMapperVo resMapperVo = new ResMapperVo();
                    resMapperVo.setValue(Integer.valueOf(1));
                    resMapperVo.setLabel(mapper);
                    resMapperVoList.add(resMapperVo);
                }
                ResMapperSelectVo resMapperSelectVo = new ResMapperSelectVo();
                resMapperSelectVo.setLabel(item.getResourceName());
                resMapperSelectVo.setOptions(resMapperVoList);
                result.add(resMapperSelectVo);
            }
        }
        return result;
    }

    public List<String> getMapperKey() {
        return new ArrayList<String>(this.dataScopeProperties.getMapperKey());
    }

    private void handleResourceExpand(ResourceDto resourceDto) {
        Long resourceId = resourceDto.getId();
        List resourceExpandDtos = resourceDto.getResourceExpandDtos();
        if (HussarUtils.isEmpty((Object)resourceExpandDtos)) {
            return;
        }
        ArrayList<SysResourceExpand> resourceExpands = new ArrayList<SysResourceExpand>();
        for (ResourceExpandDto dto : resourceExpandDtos) {
            SysResourceExpand resourceExpand = new SysResourceExpand();
            BeanUtils.copyProperties((Object)dto, (Object)resourceExpand);
            resourceExpand.setResourceId(resourceId);
            resourceExpands.add(resourceExpand);
        }
        this.hussarBaseResourceExpandService.saveBatch(resourceExpands);
    }

    public List<JSTreeModel> getAppTree(String type, List<Long> appIdList) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        if (HussarUtils.isEmpty(appIdList)) {
            return Collections.emptyList();
        }
        List applications = this.sysApplicationService.list((Wrapper)new LambdaQueryWrapper().in(SysApplication::getId, appIdList));
        List<Object> relationAppIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)applications)) {
            if (HussarUtils.equals((Object)"res", (Object)type)) {
                List resourceModules = this.sysResourceMosulesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysResourceModules::getApplicationId, appIdList)).and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
                }));
                if (HussarUtils.isNotEmpty((Object)resourceModules)) {
                    relationAppIds = resourceModules.stream().map(SysResourceModules::getApplicationId).collect(Collectors.toList());
                }
            } else if (HussarUtils.equals((Object)"func", (Object)type)) {
                List functionModules = this.sysFunctionModulesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionModules::getApplicationId, appIdList)).and(wrapper1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
                }));
                if (HussarUtils.isNotEmpty((Object)functionModules)) {
                    relationAppIds = functionModules.stream().map(SysFunctionModules::getApplicationId).collect(Collectors.toList());
                }
            } else {
                List roleGroups = this.sysRoleGroupService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getFromAppId, (Object)1L)).in(SysRoleGroup::getAppId, appIdList));
                if (HussarUtils.isNotEmpty((Object)roleGroups)) {
                    relationAppIds = roleGroups.stream().map(SysRoleGroup::getAppId).collect(Collectors.toList());
                }
            }
            for (SysApplication application : applications) {
                JSTreeModel treeModel = new JSTreeModel();
                treeModel.setId(application.getId());
                treeModel.setText(application.getAppName());
                treeModel.setCode(application.getAppCode());
                treeModel.setApplicationId(application.getId());
                treeModel.setType("app");
                treeModel.setParent(Constants.ROOT_NODE_ID);
                treeModel.setIsLeaf(relationAppIds.contains(application.getId()) ? "0" : "1");
                treeModel.setChildren(relationAppIds.contains(application.getId()) ? "true" : FALSE);
                treeModel.setImgUrl("caidan_appManagement");
                result.add(treeModel);
            }
        }
        return result;
    }

    private boolean existUnifyApp() {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        return HussarUtils.isNotEmpty((Object)application);
    }

    public List<SysResources> checkOpenResUrl(ResourceUniqueDto resourceUniqueDto) {
        if (ToolUtil.isEmpty((Object)resourceUniqueDto.getUrl())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RES_ADDRESS_EMPTY.getMessage()));
        }
        Long appId = HussarUtils.isEmpty((Object)resourceUniqueDto.getAppId()) ? 1L : resourceUniqueDto.getAppId();
        String serviceName = ToolUtil.isEmpty((Object)resourceUniqueDto.getServiceName()) ? "" : resourceUniqueDto.getServiceName();
        return this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)resourceUniqueDto.getUrl())).eq(SysResources::getResTypeId, (Object)"res_open_interface")).eq(SysResources::getApplicationId, (Object)appId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        })).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysResources::getServiceName, (Object)serviceName)).or(ToolUtil.isEmpty((Object)serviceName))).isNull(ToolUtil.isEmpty((Object)serviceName), SysResources::getServiceName);
        }));
    }

    @Cacheable(value={"resource_info"}, key="'hussar_resource:'+#shiroUser.id + ':' +#type + ':' + #locale")
    public List<SysResourcesPartVo> getPartResources(SecurityUser shiroUser, String type, String locale) {
        List roleIdList = shiroUser.getRolesList();
        if (ToolUtil.isNotEmpty((Object)roleIdList)) {
            if (roleIdList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue()) || roleIdList.contains(SysUserAndRole.DEVELOP_ROLE.getValue()) || roleIdList.contains(SysUserAndRole.TENANT_ADMIN_ROLE.getValue())) {
                List list = this.sysResourcesService.getPartResourcesByType(type);
                if (TranslateUtil.getIsEnable() && !DEFAULT_LANGLE.equals(LocaleContextHolder.getLocale().toLanguageTag())) {
                    List needTrans = list.stream().filter(r -> RES_MENU.equals(r.getResTypeId())).collect(Collectors.toList());
                    list.removeAll(needTrans);
                    TranslateUtil.translate(needTrans, SysResourcesPartVo::getNameLangKey, SysResourcesPartVo::setResourceName);
                    list.addAll(needTrans);
                }
                return list;
            }
            List resourcesByIds = this.sysResourcesService.getPartResourcesByIds(roleIdList, type);
            if (TranslateUtil.getIsEnable() && !DEFAULT_LANGLE.equals(LocaleContextHolder.getLocale().toLanguageTag())) {
                List needTrans = resourcesByIds.stream().filter(r -> RES_MENU.equals(r.getResTypeId())).collect(Collectors.toList());
                resourcesByIds.removeAll(needTrans);
                TranslateUtil.translate(needTrans, SysResourcesPartVo::getNameLangKey, SysResourcesPartVo::setResourceName);
                resourcesByIds.addAll(needTrans);
            }
            return resourcesByIds;
        }
        return Collections.emptyList();
    }

    private void getChildElementResources(Long resourceId, List<SysResources> resources, Set<Long> resIds) {
        List childResources = resources.stream().filter(r -> HussarUtils.equals((Object)resourceId, (Object)r.getParentResourceId())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(childResources)) {
            for (SysResources child : childResources) {
                resIds.add(child.getId());
                this.getChildElementResources(child.getId(), resources, resIds);
            }
        }
    }

    public List<JSTreeModel> getModelAndResByModelId(ResourceModuleTreeDto resourceModuleTreeDto) {
        List<Object> result;
        boolean open = this.secureAssesmentProperties.isOpen();
        Long resModuleId = resourceModuleTreeDto.getResModuleId();
        boolean isSelectRes = ToolUtil.isNotEmpty((Object)resourceModuleTreeDto.getIsSelectRes()) && Boolean.parseBoolean(resourceModuleTreeDto.getIsSelectRes());
        Long appId = resourceModuleTreeDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        Long fromAppId = resourceModuleTreeDto.getAppId();
        if (HussarUtils.isEmpty((Object)resModuleId)) {
            result = this.sysFunctionsMapper.getModuleResTreeByModuleId(Constants.RES_NODE_ID, isSelectRes, appId, fromAppId);
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.RES_NODE_ID);
            root.setCode(String.valueOf(Constants.RES_NODE_ID));
            root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setIsLeaf("0");
            root.setType("isRoot");
            root.setIsModule("1");
            root.setIsRes("0");
            result.add(root);
        } else {
            List<JSTreeModel> moduleResourceList;
            result = new ArrayList();
            if (open) {
                moduleResourceList = this.sysFunctionsMapper.getResourcesAndChildModulesForSecureAssesment(resModuleId, isSelectRes, appId, fromAppId);
            } else {
                String isSys = "";
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                    isSys = "0";
                }
                moduleResourceList = this.sysFunctionsMapper.getResourcesAndChildModules(resModuleId, isSelectRes, appId, isSys, fromAppId);
            }
            if (isSelectRes) {
                this.initModuleResTree(resourceModuleTreeDto, moduleResourceList, result);
            } else {
                result.addAll(moduleResourceList);
            }
        }
        this.sysResourceMosulesService.initResState(resourceModuleTreeDto, result);
        TranslateUtil.translate(result, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return TreeModelUtils.merge(result);
    }

    private void initModuleResTree(ResourceModuleTreeDto resModuleTreeDto, List<JSTreeModel> moduleResourceList, List<JSTreeModel> jsTreeModelList) {
        ArrayList<Long> moduleIds = new ArrayList();
        ArrayList<JSTreeModel> moduleList = new ArrayList<JSTreeModel>();
        ArrayList<JSTreeModel> pageResList = new ArrayList<JSTreeModel>();
        String isShowDefaultRes = HussarUtils.isEmpty((Object)resModuleTreeDto.getIsShowDefaultRes()) ? "1" : resModuleTreeDto.getIsShowDefaultRes();
        List<Long> defaultResIds = this.sysFunctionsMapper.getAllDefaultResourceIds();
        List defaultResIdList = defaultResIds.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if ("1".equals(isShowDefaultRes)) {
            for (JSTreeModel model : moduleResourceList) {
                String type = model.getType();
                if (!"isModule".equals(type)) {
                    if (HussarUtils.isNotEmpty(defaultResIdList) && defaultResIdList.contains(model.getId())) {
                        model.setHidden("0");
                    } else {
                        model.setHidden("1");
                    }
                    pageResList.add(model);
                    moduleIds.add(model.getParent());
                    continue;
                }
                moduleList.add(model);
            }
        } else {
            for (JSTreeModel model : moduleResourceList) {
                String type = model.getType();
                if (!"isModule".equals(type)) {
                    if (HussarUtils.isEmpty(defaultResIdList)) {
                        model.setHidden("1");
                        pageResList.add(model);
                        moduleIds.add(model.getParent());
                    }
                    if (!HussarUtils.isNotEmpty(defaultResIdList) || defaultResIdList.contains(model.getId())) continue;
                    model.setHidden("1");
                    pageResList.add(model);
                    moduleIds.add(model.getParent());
                    continue;
                }
                moduleList.add(model);
            }
        }
        jsTreeModelList.addAll(pageResList);
        moduleIds = moduleIds.stream().distinct().collect(Collectors.toList());
        ArrayList<JSTreeModel> finalModuleList = new ArrayList<JSTreeModel>();
        this.getModuleList(moduleList, moduleIds, finalModuleList);
        jsTreeModelList.addAll(0, finalModuleList);
    }

    private void getModuleList(List<JSTreeModel> moduleList, List<Long> moduleIds, List<JSTreeModel> finalModuleList) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        List ids = finalModuleList.stream().map(JSTreeModel::getId).collect(Collectors.toList());
        for (int i = moduleList.size() - 1; i >= 0; --i) {
            JSTreeModel model = moduleList.get(i);
            Long id = model.getId();
            if (!moduleIds.contains(id)) continue;
            Long parentId = model.getParent();
            if (parentId != 1L) {
                parentIds.add(parentId);
            }
            if (ids.contains(id)) continue;
            finalModuleList.add(0, model);
        }
        if (HussarUtils.isNotEmpty(parentIds)) {
            this.getModuleList(moduleList, parentIds, finalModuleList);
        }
    }
}

