/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppVisitDto;
import com.jxdinfo.hussar.authorization.permit.dto.UpdateResourceDto;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteFunctionManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryFunctionManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.vo.AppMenuFuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppVisitVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysFunctionsBoServiceImpl
implements ISysFunctionsBoService {
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private QueryFunctionManager queryFunctionManager;
    @Resource
    private DeleteFunctionManager deleteFunctionManager;

    public Boolean saveOneFunctions(SysFunctions sysFunctions) {
        return this.sysFunctionsService.save((Object)sysFunctions);
    }

    public Boolean saveAllFunctions(List<SysFunctions> sysFunctionsList) {
        return this.sysFunctionsService.saveBatch(sysFunctionsList);
    }

    public SysFunctions getOneById(Long id) {
        return (SysFunctions)this.sysFunctionsService.getById((Serializable)id);
    }

    public SysFunctions getOneByCode(String code) {
        return (SysFunctions)this.sysFunctionsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctions::getFunctionCode, (Object)code)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public List<SysFunctions> listByModuleId(Long moduleId) {
        return this.sysFunctionsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctions::getFunctionModuleId, (Object)moduleId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    public Boolean updateNameByCode(UpdateResourceDto updateResourceDto) {
        String code = updateResourceDto.getCode();
        String name = updateResourceDto.getName();
        String langKey = updateResourceDto.getLangKey();
        LambdaUpdateWrapper funcUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysFunctions::getFunctionCode, (Object)code)).set(HussarUtils.isNotBlank((CharSequence)name), SysFunctions::getFunctionName, (Object)name)).set(SysFunctions::getNameLangKey, (Object)langKey);
        return this.sysFunctionsService.update((Wrapper)funcUpdateWrapper);
    }

    public Boolean updateNameById(UpdateResourceDto updateResourceDto) {
        Long id = updateResourceDto.getId();
        String name = updateResourceDto.getName();
        String langKey = updateResourceDto.getLangKey();
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarUtils.isNotBlank((CharSequence)name), SysFunctions::getFunctionName, (Object)name)).set(SysFunctions::getNameLangKey, (Object)langKey)).eq(SysFunctions::getId, (Object)id);
        return this.sysFunctionsService.update((Wrapper)wrapper);
    }

    public Boolean deleteOneById(Long id) {
        return this.sysFunctionsService.removeById((Serializable)id);
    }

    public Boolean deleteByid(List<Long> ids) {
        return this.sysFunctionsService.removeByIds(ids);
    }

    public Integer getMaxOrderByParentId(Long moduleId) {
        Integer order = this.sysFunctionsService.getMaxOrderByParentId(moduleId);
        if (HussarUtils.isEmpty((Object)order)) {
            return 0;
        }
        return order;
    }

    public List<SysFunctions> list(List<Long> formIds, Long appId, String functionCode) {
        LambdaQueryWrapper functionsWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(HussarUtils.isNotEmpty(formIds), SysFunctions::getFunctionModuleId, formIds)).eq(HussarUtils.isNotEmpty((Object)appId), SysFunctions::getAppId, (Object)appId)).like(HussarUtils.isNotEmpty((Object)functionCode), SysFunctions::getFunctionCode, (Object)functionCode)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return this.sysFunctionsService.list((Wrapper)functionsWrapper);
    }

    public AppMenuFuncResVo getAppMenuFuncResInfo(Long appId) {
        return this.queryFunctionManager.getAppMenuFuncResInfo(appId);
    }

    public List<AppVisitVo> getAppVisitInfoList(QueryAppVisitDto queryAppVisitDto) {
        return this.queryFunctionManager.getAppVisitInfoList(queryAppVisitDto);
    }

    public AppMenuFuncResVo getAppMenuFuncResByFormId(Long appId, Long formId) {
        return this.queryFunctionManager.getAppMenuFuncResByFormId(appId, formId);
    }

    public Boolean deleteAppMenuFuncResByFormId(Long formId) {
        return this.deleteFunctionManager.deleteAppMenuFuncResByFormId(formId);
    }

    public List<Long> getAuthorityFormList(List<Long> roleIds, Long appId) {
        return this.queryFunctionManager.getAuthorityFormList(roleIds, appId);
    }

    public Map<Long, List<SysFunctions>> getFunctionsByResTypeId(Long appId, Long roleId, String resTypeId) {
        return this.queryFunctionManager.getFunctionsByResTypeId(appId, roleId, resTypeId);
    }

    public List<SysFunctions> listByAppId(Long appId) {
        return this.sysFunctionsService.list((Wrapper)Wrappers.lambdaQuery().eq(SysFunctions::getAppId, (Object)appId));
    }

    public Boolean saveOrUpdateList(List<SysFunctions> sysFunctions) {
        return this.sysFunctionsService.saveOrUpdateBatch(sysFunctions);
    }
}

