/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.adapter.function.IHussarBaseFunctionAdapter;
import com.jxdinfo.hussar.authorization.audit.service.ISysFunctionResourcesAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryFuncDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResModuleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDtoByAppRole;
import com.jxdinfo.hussar.authorization.permit.model.SeqStatic;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.vo.ModuleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleBasicVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchModuleVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.ResourceWithFunctionException;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.common.properties.UnifyPermissionProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.functionmanager.FunctionModuleBatchDeleteChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.functionmanager.FunctionModuleChangeNotify;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysFunctionModulesServiceImpl
extends HussarBaseServiceImpl<SysFunctionModulesMapper, SysFunctionModules>
implements ISysFunctionModulesService {
    private static Logger logger = LoggerFactory.getLogger(SysFunctionModulesServiceImpl.class);
    private static final String TENANT_TYPE_PROPERTY = "hussar.core.tenant.type";
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Autowired
    private ISysStruFunctionsService iSysStruFunctionsService;
    @Autowired
    private ISysStruService iSysStruService;
    @Autowired
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Autowired
    private UnifyPermissionProperties unifyPermissionProperties;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private ISysRolesService sysRolesService;
    @Resource
    private IHussarBaseFunctionAdapter hussarBaseFunctionAdapter;
    @Resource
    private FunctionModuleChangeNotify functionModuleChangeNotify;
    @Resource
    private FunctionModuleBatchDeleteChangeNotify moduleBatchDeleteChangeNotify;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private HussarTenantProperties tenantProperties;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysFunctionResourcesAuditService sysFunctionResourcesAuditService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;

    public List<JSTreeModel> getFunModuleTree(String functionFlag) {
        boolean flag = ToolUtil.isEmpty((Object)functionFlag) ? false : Boolean.valueOf(functionFlag);
        Long appId = this.unifyPermissionProperties.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        String containSys = "";
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            containSys = "0";
        }
        List<JSTreeModel> jsTreeModelList = this.sysFunctionsMapper.getModuleFunctionTree(appId, containSys);
        if (flag) {
            jsTreeModelList.addAll(this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionData(appId, containSys));
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        jsTreeModelList.add(root);
        return jsTreeModelList;
    }

    public List<JSTreeModel> getFunModuleTreeForOrg(String functionFlag) {
        boolean flag = ToolUtil.isEmpty((Object)functionFlag) ? false : Boolean.valueOf(functionFlag);
        Long appId = this.unifyPermissionProperties.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        String containSys = "";
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            containSys = "0";
        }
        List<Object> jsTreeModelList = this.sysFunctionsMapper.getModuleFunctionTree(appId, containSys);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (shiroUser.getRolesList().contains(Constants.BUSSINESSADMIN_ROLE_ID)) {
            jsTreeModelList.addAll(this.sysFunctionsMapper.getBussinessModuleFunctionTreeWithFunctionData());
        } else {
            jsTreeModelList.addAll(this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionData(appId, containSys));
        }
        assert (shiroUser != null);
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        Long struId = 0L;
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
            Long gradeParentId = (long)this.orgMaintenanceService.getOneOrg(struId).getId();
            QueryWrapper sysStruFunctionsQueryWrapper = new QueryWrapper();
            sysStruFunctionsQueryWrapper.lambda().eq(SysStruFunctions::getStruId, (Object)gradeParentId);
            List sysStruFunctionsList = this.iSysStruFunctionsService.list((Wrapper)sysStruFunctionsQueryWrapper);
            List<Long> downFunctionIdList = sysStruFunctionsList.stream().map(SysStruFunctions::getFunctionId).collect(Collectors.toList());
            jsTreeModelList = this.getFunModuleTreeForOrgWithOutOtherNode(jsTreeModelList, downFunctionIdList);
        }
        if (!flag) {
            jsTreeModelList = jsTreeModelList.stream().filter(item -> "1".equals(item.getIsModule())).collect(Collectors.toList());
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        jsTreeModelList.add(root);
        if (isGradeAdmin) {
            jsTreeModelList.forEach(item -> item.getState().put("gradeDisabled", true));
        }
        return jsTreeModelList;
    }

    public List<JSTreeModel> getFunModuleMergeTreeForOrg(String functionFlag) {
        return this.hussarBaseFunctionAdapter.getFunModuleMergeTreeForOrg(functionFlag, Long.valueOf(1L), null, null);
    }

    private List<JSTreeModel> getFunModuleTreeForOrgWithOutOtherNode(List<JSTreeModel> jsTreeModelList, List<Long> downFunctionIdList) {
        List<Long> childrenList = new ArrayList<Long>();
        childrenList.addAll(downFunctionIdList);
        List<Long> parentJsTreeModelIdList = downFunctionIdList;
        boolean flag = true;
        if (ToolUtil.isNotEmpty(downFunctionIdList)) {
            while (flag) {
                ArrayList<Long> finalChildrenStruIdList = childrenList;
                List parentList = jsTreeModelList.stream().filter(o -> finalChildrenStruIdList.contains(o.getId())).collect(Collectors.toList());
                List parentIdList = parentList.stream().map(JSTreeModel::getParent).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(parentIdList)) {
                    if (ToolUtil.isEmpty(parentJsTreeModelIdList)) {
                        parentJsTreeModelIdList = parentIdList;
                    } else {
                        parentJsTreeModelIdList.addAll(parentIdList);
                    }
                    childrenList = parentIdList;
                    continue;
                }
                flag = false;
            }
        }
        parentJsTreeModelIdList = parentJsTreeModelIdList.stream().distinct().collect(Collectors.toList());
        List<Long> finalParentJsTreeModelIdList = parentJsTreeModelIdList;
        jsTreeModelList = jsTreeModelList.stream().filter(o -> finalParentJsTreeModelIdList.contains(o.getId())).collect(Collectors.toList());
        return jsTreeModelList;
    }

    public List<JSTreeModel> getResModuleTree(ResModuleTreeDto resModuleTreeDto) {
        boolean open = this.secureAssesmentProperties.isOpen();
        Long functionId = resModuleTreeDto.getFunctionId();
        boolean isSelectRes = ToolUtil.isNotEmpty((Object)resModuleTreeDto.getIsSelectRes()) && Boolean.parseBoolean(resModuleTreeDto.getIsSelectRes());
        Long appId = resModuleTreeDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        Long fromAppId = resModuleTreeDto.getAppId();
        List<Object> jsTreeModelList = new ArrayList<JSTreeModel>();
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            List functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)functionId));
            ArrayList resourceIds = new ArrayList();
            functionResourcesList.forEach(functionResource -> resourceIds.add(functionResource.getResourceId()));
            if (ToolUtil.isNotEmpty(resourceIds)) {
                List splitIds = LambdaQueryUtil.getSplitList(resourceIds);
                jsTreeModelList = open ? this.sysFunctionsMapper.getModuleResTreeForSecureAssesment(splitIds, isSelectRes, appId, fromAppId) : this.sysFunctionsMapper.getModuleResTree(splitIds, isSelectRes, appId, "", fromAppId);
            } else {
                jsTreeModelList = new ArrayList();
            }
        } else {
            List<JSTreeModel> moduleResourceList;
            if (open) {
                moduleResourceList = this.sysFunctionsMapper.getModuleResTreeForSecureAssesment(new ArrayList<List<Long>>(), isSelectRes, appId, fromAppId);
            } else {
                String isSys = "";
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                    isSys = "0";
                }
                moduleResourceList = this.sysFunctionsMapper.getModuleResTree(new ArrayList<List<Long>>(), isSelectRes, appId, isSys, fromAppId);
            }
            if (isSelectRes) {
                this.initModuleResTree(resModuleTreeDto, moduleResourceList, jsTreeModelList);
            } else {
                jsTreeModelList.addAll(moduleResourceList);
            }
        }
        String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY);
        if ("onsystem".equals(tenantType) && HussarUtils.isNotEmpty((Object)fromAppId)) {
            jsTreeModelList = jsTreeModelList.stream().filter(r -> fromAppId.equals(r.getAppId())).collect(Collectors.toList());
            JSTreeModel portal = new JSTreeModel();
            portal.setId(Constants.RES_FUNC_PORTAL_ID);
            portal.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.PORTAL_RESOURCE_TEXT.getMessage()));
            portal.setParent(Constants.RES_NODE_ID);
            portal.setIsLeaf("0");
            portal.setIsModule("1");
            portal.setType("isRoot");
            jsTreeModelList.add(portal);
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        jsTreeModelList.add(root);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isFunctionAudit()) {
            List notAuditSysResourceIds = this.sysFunctionResourcesAuditService.list().stream().filter(sysFunctionResourcesAudit -> "0".equals(sysFunctionResourcesAudit.getAuditStatus())).map(SysFunctionResourcesAudit::getResourceId).collect(Collectors.toList());
            for (JSTreeModel jSTreeModel : jsTreeModelList) {
                if (!notAuditSysResourceIds.contains(jSTreeModel.getId())) continue;
                jSTreeModel.setIsInAuditing("1");
            }
        }
        List resIds = jsTreeModelList.stream().filter(res -> "1".equals(res.getIsRes())).map(JSTreeModel::getId).collect(Collectors.toList());
        logger.info("\u89d2\u8272\u5173\u8054\u8d44\u6e90--\u8d44\u6e90\u6a21\u5757\u6811\u5c55\u793a\u7684\u529f\u80fdID\uff0c\u5171\u8ba1{}\u4e2a : {}", (Object)resIds.size(), resIds);
        TranslateUtil.translate(jsTreeModelList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return this.filterNoChildNode(TreeModelUtils.merge(jsTreeModelList));
    }

    private void initModuleResTree(ResModuleTreeDto resModuleTreeDto, List<JSTreeModel> moduleResourceList, List<JSTreeModel> jsTreeModelList) {
        ArrayList<Long> moduleIds = new ArrayList();
        ArrayList<JSTreeModel> moduleList = new ArrayList<JSTreeModel>();
        ArrayList<JSTreeModel> pageResList = new ArrayList<JSTreeModel>();
        String isShowDefaultRes = HussarUtils.isEmpty((Object)resModuleTreeDto.getIsShowDefaultRes()) ? "1" : resModuleTreeDto.getIsShowDefaultRes();
        List<Long> defaultResIds = this.sysFunctionsMapper.getAllDefaultResourceIds();
        List defaultResIdList = defaultResIds.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if ("1".equals(isShowDefaultRes)) {
            for (JSTreeModel model : moduleResourceList) {
                String type = model.getType();
                if (!"isModule".equals(type)) {
                    if (HussarUtils.isNotEmpty(defaultResIdList) && defaultResIdList.contains(model.getId())) {
                        model.setHidden("0");
                    } else {
                        model.setHidden("1");
                    }
                    pageResList.add(model);
                    moduleIds.add(model.getParent());
                    continue;
                }
                moduleList.add(model);
            }
        } else {
            for (JSTreeModel model : moduleResourceList) {
                String type = model.getType();
                if (!"isModule".equals(type)) {
                    if (HussarUtils.isEmpty(defaultResIdList)) {
                        model.setHidden("1");
                        pageResList.add(model);
                        moduleIds.add(model.getParent());
                    }
                    if (!HussarUtils.isNotEmpty(defaultResIdList) || defaultResIdList.contains(model.getId())) continue;
                    model.setHidden("1");
                    pageResList.add(model);
                    moduleIds.add(model.getParent());
                    continue;
                }
                moduleList.add(model);
            }
        }
        jsTreeModelList.addAll(pageResList);
        moduleIds = moduleIds.stream().distinct().collect(Collectors.toList());
        ArrayList<JSTreeModel> finalModuleList = new ArrayList<JSTreeModel>();
        this.getModuleList(moduleList, moduleIds, finalModuleList);
        jsTreeModelList.addAll(0, finalModuleList);
    }

    private void getModuleList(List<JSTreeModel> moduleList, List<Long> moduleIds, List<JSTreeModel> finalModuleList) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        List ids = finalModuleList.stream().map(JSTreeModel::getId).collect(Collectors.toList());
        for (int i = moduleList.size() - 1; i >= 0; --i) {
            JSTreeModel model = moduleList.get(i);
            Long id = model.getId();
            if (!moduleIds.contains(id)) continue;
            Long parentId = model.getParent();
            if (parentId != 1L) {
                parentIds.add(parentId);
            }
            if (ids.contains(id)) continue;
            finalModuleList.add(0, model);
        }
        if (HussarUtils.isNotEmpty(parentIds)) {
            this.getModuleList(moduleList, parentIds, finalModuleList);
        }
    }

    private List<JSTreeModel> filterNoChildNode(List<JSTreeModel> items) {
        ArrayList<JSTreeModel> newItems = new ArrayList<JSTreeModel>();
        for (JSTreeModel model : items) {
            List children = model.getChildrenList();
            if ("1".equals(model.getIsRes())) {
                newItems.add(model);
                continue;
            }
            if (ToolUtil.isNotEmpty((Object)children)) {
                List<JSTreeModel> newChildren = this.filterNoChildNode(children);
                if (ToolUtil.isNotEmpty(newChildren)) {
                    model.setChildrenList(newChildren);
                    newItems.add(model);
                } else if (Constants.RES_NODE_ID.equals(model.getId())) {
                    model.setChildrenList(newChildren);
                }
            }
            if (!Constants.RES_NODE_ID.equals(model.getId()) || newItems.contains(model)) continue;
            newItems.add(model);
        }
        return newItems;
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, 0L);
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, Long parentId) {
        Long newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel jsTreeModel = list.get(i);
            if (!"1".equals(jsTreeModel.getIsRes()) && !newParentId.equals(jsTreeModel.getId())) continue;
            newParentId = jsTreeModel.getParent();
            result.add(jsTreeModel);
            list.remove(jsTreeModel);
            if (--i == 0) {
                i = -1;
            }
            this.recursive(list, result, newParentId);
        }
    }

    public IPage getFunctionAndModuleList(Page page, FuncModuleTreeQueryDto funcModuleTreeQueryDto) {
        List<SysModuleFunctionsVo> list;
        String functionName = funcModuleTreeQueryDto.getFunctionName();
        String parentModuleId = String.valueOf(funcModuleTreeQueryDto.getParentModuleId());
        Long applicationId = funcModuleTreeQueryDto.getApplicationId();
        Long bizAppId = funcModuleTreeQueryDto.getBizAppId();
        Long nodeId = funcModuleTreeQueryDto.getParentModuleId();
        if (HussarUtils.isNotEmpty((Object)bizAppId)) {
            funcModuleTreeQueryDto.setBizAppId(null);
        }
        if (HussarUtils.isEmpty((Object)applicationId)) {
            applicationId = 1L;
        }
        if (HussarUtils.equals((Object)applicationId, (Object)Long.parseLong(parentModuleId))) {
            parentModuleId = "1";
            funcModuleTreeQueryDto.setParentModuleId(Long.valueOf(1L));
        }
        funcModuleTreeQueryDto.setApplicationId(applicationId);
        funcModuleTreeQueryDto.setParentModuleName("");
        if (ToolUtil.isNotEmpty((Object)functionName)) {
            functionName = functionName.replace("%", "\\\\%").replace("_", "\\\\_");
            funcModuleTreeQueryDto.setFunctionName(functionName);
        }
        if (ToolUtil.isNotEmpty((Object)parentModuleId)) {
            SysFunctionModules functionModules = (SysFunctionModules)this.sysFunctionModulesMapper.selectById(Long.valueOf(Long.parseLong(parentModuleId)));
            TranslateUtil.translate((Object)functionModules, SysFunctionModules::getNameLangKey, SysFunctionModules::setFunctionModuleName);
            if (ToolUtil.isNotEmpty((Object)functionModules)) {
                funcModuleTreeQueryDto.setParentModuleName(functionModules.getFunctionModuleName());
            }
        }
        SeqStatic functionSeq = this.sysFunctionsMapper.getSeqFunction(funcModuleTreeQueryDto);
        SeqStatic moduleSeq = this.sysFunctionsMapper.getSeqModule(funcModuleTreeQueryDto);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        assert (shiroUser != null);
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY);
        if ("onsystem".equals(tenantType)) {
            List sysUserRoleIds;
            Long roleId;
            if (HussarUtils.isNotEmpty((Object)bizAppId)) {
                if (nodeId.equals(Constants.RES_FUNC_PORTAL_ID)) {
                    funcModuleTreeQueryDto.setBizAppId(bizAppId);
                }
                if (nodeId.equals(Constants.RES_NODE_ID)) {
                    funcModuleTreeQueryDto.setIsPortal(Constants.RES_FUNC_PORTAL_ID);
                }
            }
            if (HussarUtils.isEmpty((Object)(roleId = (Long)(sysUserRoleIds = shiroUser.getRolesList()).stream().filter(l -> SysUserAndRole.TENANT_ADMIN_ROLE.getValue().equals(l) || SysUserAndRole.SUPERADMIN_ROLE.getValue().equals(l)).findAny().orElse(null)))) {
                List currentAppIds = this.sysApplicationService.getCurrentAppIds(shiroUser.getId());
                funcModuleTreeQueryDto.setCurrentAppIds(currentAppIds);
                funcModuleTreeQueryDto.setNeedFilterSys(Boolean.valueOf(true));
            } else {
                funcModuleTreeQueryDto.setNeedFilterSys(Boolean.valueOf(false));
            }
        }
        if (isGradeAdmin) {
            List treeNode = this.iSysFunctionModulesService.getFunModuleTreeForOrg("true");
            ArrayList ids = new ArrayList();
            treeNode.forEach(o -> ids.add(o.getId()));
            funcModuleTreeQueryDto.setFunctionModuleList(ids);
            list = this.getGradeModuleFuncVoList(funcModuleTreeQueryDto, page);
            list.forEach(o -> o.setGradeDisabled(true));
        } else {
            String isSys = "";
            if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
                isSys = "0";
            }
            funcModuleTreeQueryDto.setIsSys(isSys);
            list = this.getModuleFuncVoList(funcModuleTreeQueryDto, page);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (SysModuleFunctionsVo voTemp : list) {
                voTemp.setUp(true);
                voTemp.setDown(true);
                if (voTemp.getType() == 0 && ToolUtil.isNotEmpty((Object)functionSeq)) {
                    if (voTemp.getSeq().equals(functionSeq.getMinSeq())) {
                        voTemp.setUp(false);
                    }
                    if (!voTemp.getSeq().equals(functionSeq.getMaxSeq())) continue;
                    voTemp.setDown(false);
                    continue;
                }
                if (voTemp.getType() != 1 || !ToolUtil.isNotEmpty((Object)moduleSeq)) continue;
                if (voTemp.getSeq().equals(moduleSeq.getMinSeq())) {
                    voTemp.setUp(false);
                }
                if (!voTemp.getSeq().equals(moduleSeq.getMaxSeq())) continue;
                voTemp.setDown(false);
            }
        }
        page.setRecords(list);
        return page;
    }

    private List<SysModuleFunctionsVo> getGradeModuleFuncVoList(FuncModuleTreeQueryDto funcModuleTreeQueryDto, Page page) {
        List<SysModuleFunctionsVo> moduleFunVoList;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (TranslateUtil.getIsEnable() && !HussarUtils.equals((Object)lang, (Object)LangEnum.ZH_CN.getLangValue())) {
            funcModuleTreeQueryDto.setLang(lang);
            moduleFunVoList = this.sysFunctionsMapper.getGradeFunctionAndModuleListForTrans(page, funcModuleTreeQueryDto);
        } else {
            moduleFunVoList = this.sysFunctionsMapper.getGradeFunctionAndModuleList(funcModuleTreeQueryDto, page);
        }
        TranslateUtil.translate(moduleFunVoList, SysModuleFunctionsVo::getNameLangKey, SysModuleFunctionsVo::setName);
        return moduleFunVoList;
    }

    private List<SysModuleFunctionsVo> getModuleFuncVoList(FuncModuleTreeQueryDto funcModuleTreeQueryDto, Page page) {
        List<SysModuleFunctionsVo> moduleFunVoList;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (TranslateUtil.getIsEnable() && !HussarUtils.equals((Object)lang, (Object)LangEnum.ZH_CN.getLangValue())) {
            funcModuleTreeQueryDto.setLang(lang);
            moduleFunVoList = this.sysFunctionsMapper.getFunctionAndModuleListForTrans(page, funcModuleTreeQueryDto);
            TranslateUtil.translate(moduleFunVoList, SysModuleFunctionsVo::getNameLangKey, SysModuleFunctionsVo::setName);
        } else {
            moduleFunVoList = this.sysFunctionsMapper.getFunctionAndModuleList(funcModuleTreeQueryDto, page);
        }
        return moduleFunVoList;
    }

    public SysModuleFunctionsVo getFunctionModuleDetail(Long functionModuleId) {
        SysModuleFunctionsVo sysModuleFunctionsVo = this.sysFunctionModulesMapper.getFunctionModuleDetail(functionModuleId);
        TranslateUtil.translate((Object)sysModuleFunctionsVo, SysModuleFunctionsVo::getNameLangKey, SysModuleFunctionsVo::setName);
        TranslateUtil.translate((Object)sysModuleFunctionsVo, SysModuleFunctionsVo::getParentNameLangKey, SysModuleFunctionsVo::setParentModuleName);
        return sysModuleFunctionsVo;
    }

    public boolean saveOrUpdateFunctionModule(FuncModuleInfoDto funcModuleInfoDto) {
        boolean flag;
        Long functionModuleId = funcModuleInfoDto.getFunctionModuleId();
        String functionModuleName = funcModuleInfoDto.getFunctionModuleName();
        Long parentModuleId = funcModuleInfoDto.getParentModuleId();
        Long applicationId = funcModuleInfoDto.getApplicationId();
        Long appId = funcModuleInfoDto.getAppId();
        String nameLangKey = funcModuleInfoDto.getNameLangKey();
        if (ToolUtil.isEmpty((Object)functionModuleName)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_NAME_EMPTY.getMessage()));
        }
        if (functionModuleName.length() > 32) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LENGTH.getMessage()));
        }
        if (ToolUtil.isNotEmpty((Object)functionModuleId)) {
            SysFunctionModules functionModules = (SysFunctionModules)this.sysFunctionModulesMapper.selectById(functionModuleId);
            if (ToolUtil.isNotEmpty((Object)functionModules)) {
                boolean flag2;
                functionModules.setFunctionModuleName(functionModuleName);
                functionModules.setNameLangKey(nameLangKey);
                boolean bl = flag2 = this.sysFunctionModulesMapper.updateById(functionModules) > 0;
                if (flag2 && !HussarUtils.equals((Object)1L, (Object)functionModules.getApplicationId())) {
                    this.functionModuleChangeNotify.notify(DataChangeType.UPDATE, new Object[]{functionModules});
                }
                return flag2;
            }
            return false;
        }
        SysFunctionModules functionModules = new SysFunctionModules();
        functionModules.setFunctionModuleName(functionModuleName);
        functionModules.setParentModuleId(parentModuleId);
        functionModules.setApplicationId(applicationId);
        functionModules.setAppId(appId);
        functionModules.setNameLangKey(nameLangKey);
        Integer max = this.iSysFunctionModulesService.getMaxOrderByParentIdAndAppId(parentModuleId, applicationId);
        if (ToolUtil.isNotEmpty((Object)max)) {
            functionModules.setSeq(Integer.valueOf(max + 1));
        } else {
            functionModules.setSeq(Integer.valueOf(1));
        }
        boolean bl = flag = this.sysFunctionModulesMapper.insert(functionModules) > 0;
        if (flag && !HussarUtils.equals((Object)1L, (Object)functionModules.getApplicationId())) {
            this.functionModuleChangeNotify.notify(DataChangeType.INSERT, new Object[]{functionModules});
        }
        return flag;
    }

    @HussarTransactional
    public boolean deleteFunctionModules(Long functionModuleId) {
        SysApplication sysApplication;
        if (ToolUtil.isEmpty((Object)functionModuleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_ID_EMPTY.getMessage()));
        }
        SysFunctionModules functionModule = (SysFunctionModules)this.iSysFunctionModulesService.getById((Serializable)functionModuleId);
        SysFunctionModules sysFunctionModules = (SysFunctionModules)this.iSysFunctionModulesService.getById((Serializable)functionModuleId);
        if (ToolUtil.isEmpty((Object)sysFunctionModules)) {
            throw new BaseException("\u6a21\u5757\u4e0d\u5b58\u5728");
        }
        if (ToolUtil.isNotEmpty((Object)sysFunctionModules.getAppId()) && sysFunctionModules.getAppId() != 1L && ToolUtil.isNotEmpty((Object)(sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)sysFunctionModules.getAppId()))) && sysFunctionModules.getParentModuleId() == 1L) {
            throw new BaseException("\u5e94\u7528\u5b58\u5728,\u4e0d\u80fd\u5220\u9664\u6b64\u6a21\u5757");
        }
        ArrayList<Long> functionIdList = new ArrayList<Long>();
        ArrayList<Long> functionModuleIdList = new ArrayList<Long>();
        ArrayList<Long> parentModuleIds = new ArrayList<Long>();
        functionModuleIdList.add(functionModuleId);
        parentModuleIds.add(functionModuleId);
        this.getFuncAndFuncModuleIds(functionIdList, functionModuleIdList, parentModuleIds);
        List functionModules = null;
        if (functionModuleIdList.size() > 0) {
            functionModules = this.iSysFunctionModulesService.listByIds(functionModuleIdList);
        }
        boolean flag = true;
        List functions = null;
        if (functionIdList.size() > 0) {
            List menuList = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionId, functionIdList));
            if (menuList.size() > 0) {
                throw new ResourceWithFunctionException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FUNCTION_FAIL_WITH_MENU.getMessage()));
            }
            ArrayList<Long> ingoreRoleIds = new ArrayList<Long>();
            Long adminRoleId = SysUserAndRole.SUPERADMIN_ROLE.getValue();
            if (this.tenantProperties.isEnabled() && !((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
                adminRoleId = TenantConstant.ADMIN_ROLE;
            }
            ingoreRoleIds.add(adminRoleId);
            ingoreRoleIds.add(SysUserAndRole.DEVELOP_ROLE.getValue());
            List roleFunctionList = this.sysRoleFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getFunctionId, functionIdList)).notIn(SysRoleFunctions::getRoleId, ingoreRoleIds));
            if (roleFunctionList.size() > 0) {
                throw new ResourceWithFunctionException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FUNCTION_FAIL_WITH_ROLE.getMessage()));
            }
            functions = this.sysFunctionsMapper.selectBatchIds(functionIdList);
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("roleIds", ingoreRoleIds);
            queryParams.put("functionIds", functionIdList);
            queryParams.put("relationSource", "1");
            boolean bl = flag = this.sysRoleFunctionsMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getFunctionId, functionIdList)) >= 0 && this.sysRoleResourceMapper.deleteRelationForFuncId(queryParams) >= 0 && this.sysFunctionsMapper.delete((Wrapper)new LambdaUpdateWrapper().in(SysFunctions::getId, functionIdList)) >= 0 && this.sysFunctionResourcesMapper.delete((Wrapper)new LambdaUpdateWrapper().in(SysFunctionResources::getFunctionId, functionIdList)) >= 0;
        }
        if (functionModuleIdList.size() > 0) {
            this.sysFunctionModulesMapper.delete((Wrapper)new LambdaUpdateWrapper().in(SysFunctionModules::getId, functionModuleIdList));
        }
        if (!HussarUtils.equals((Object)1L, (Object)functionModule.getApplicationId())) {
            this.moduleBatchDeleteChangeNotify.notify(DataChangeType.DELETE, new Object[]{functionModules, functions});
        }
        return flag;
    }

    private void getFuncAndFuncModuleIds(List<Long> functionIdList, List<Long> functionModuleIdList, List<Long> parentModuleIds) {
        List childModuleList;
        List functionsList = this.sysFunctionsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctions::getFunctionModuleId, parentModuleIds)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        if (ToolUtil.isNotEmpty((Object)functionsList)) {
            functionsList.forEach(function -> functionIdList.add(function.getId()));
        }
        if (ToolUtil.isNotEmpty((Object)(childModuleList = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionModules::getParentModuleId, parentModuleIds)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }))))) {
            parentModuleIds.clear();
            childModuleList.forEach(functionModule -> {
                functionModuleIdList.add(functionModule.getId());
                parentModuleIds.add(functionModule.getId());
            });
            this.getFuncAndFuncModuleIds(functionIdList, functionModuleIdList, parentModuleIds);
        }
    }

    public void saveFunctionModuleTreeOrder(List<Long> idList) {
        ArrayList<SysFunctionModules> sysFunctionModulesList = new ArrayList<SysFunctionModules>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysFunctionModules sysFunctionModules = new SysFunctionModules();
            sysFunctionModules.setId(id);
            sysFunctionModules.setSeq(Integer.valueOf(i + 1));
            sysFunctionModulesList.add(sysFunctionModules);
        }
        if (ToolUtil.isNotEmpty(sysFunctionModulesList)) {
            this.updateBatchById(sysFunctionModulesList, sysFunctionModulesList.size());
        }
    }

    public List<JSTreeModel> functionModuleTreeByModuleId(Long moduleId, Long appId, Long bizAppId, Boolean protectStatus) {
        return this.sysFunctionModulesMapper.functionModuleTreeByModuleIdAndAppId(moduleId, appId, bizAppId, protectStatus);
    }

    public ApiResponse updateMoveNode(FuncModuleOrderDto funcModuleOrderDto) {
        SysFunctionModules thatFunctionModule;
        Long functionModuleId = funcModuleOrderDto.getFunctionModuleId();
        Boolean isUp = funcModuleOrderDto.getIsUp();
        if (ToolUtil.isEmpty((Object)functionModuleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_ID_EMPTY.getMessage()));
        }
        SysFunctionModules thisFunctionModule = (SysFunctionModules)this.sysFunctionModulesMapper.selectById(functionModuleId);
        Long appId = thisFunctionModule.getApplicationId();
        appId = HussarUtils.isEmpty((Object)appId) ? 1L : appId;
        List<SysFunctionModules> thatFunctionModules = isUp != false ? this.sysFunctionModulesMapper.seletListLt(thisFunctionModule.getParentModuleId(), thisFunctionModule.getSeq(), appId) : this.sysFunctionModulesMapper.seletListGt(thisFunctionModule.getParentModuleId(), thisFunctionModule.getSeq(), appId);
        if (thatFunctionModules.size() > 0 && (thatFunctionModule = thatFunctionModules.get(0)) != null) {
            Integer temp = thisFunctionModule.getSeq();
            thisFunctionModule.setSeq(thatFunctionModule.getSeq());
            thatFunctionModule.setSeq(temp);
            this.sysFunctionModulesMapper.updateById(thisFunctionModule);
            this.sysFunctionModulesMapper.updateById(thatFunctionModule);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_OPERATE_SUCCESS.getMessage()));
    }

    public void insertOrUpdateFunctionModuleList(List<SysFunctionModules> sysFunctionModulesList) {
        if (CollectionUtils.isEmpty(sysFunctionModulesList)) {
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_ADD_DATA.getMessage()), (Object)sysFunctionModulesList.size());
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_EDIT_DATA.getMessage()), (Object)sysFunctionModulesList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysFunctionModules::getId).collect(Collectors.toList());
        ArrayList<SysFunctionModules> insertData = new ArrayList<SysFunctionModules>();
        ArrayList<SysFunctionModules> updateData = new ArrayList<SysFunctionModules>();
        Integer maxOrder = this.sysFunctionModulesMapper.getMaxOrder();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("FUNCTION_MODULE_CODE", "SYS_FUNCTION_MODULES");
        Integer maxCode = sysIdtable.getIdValue();
        for (SysFunctionModules item : sysFunctionModulesList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            n = maxCode;
            n2 = maxCode = Integer.valueOf(maxCode + 1);
            StringBuilder currentCode = new StringBuilder();
            int zeroLength = sysIdtable.getIdLength() - maxCode.toString().length();
            if (zeroLength < 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENCODING_EXCEEDS_LENGTH.getMessage()));
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(maxCode);
            item.setSeq(maxOrder);
            item.setFunctionModuleCode(currentCode.toString());
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
            sysIdtable.setIdValue(maxCode);
            this.sysIdtableService.updateIdtable(sysIdtable);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_ADD_DATA.getMessage()), (Object)insertData.size());
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_EDIT_DATA.getMessage()), (Object)updateData.size());
    }

    public Collection<SysFunctionModules> recursiveGetFuncModule(List<Long> funcModuleList, Collection<SysFunctionModules> allFuncModuleList, Collection<SysFunctionModules> result) {
        if (HussarUtils.isEmpty(funcModuleList) || funcModuleList.size() == 1 && PermitConstants.ROOT_ID.equals(funcModuleList.get(0))) {
            return result;
        }
        HashSet<Long> parentModuleList = new HashSet<Long>();
        for (SysFunctionModules item : allFuncModuleList) {
            if (!funcModuleList.contains(item.getId())) continue;
            result.add(item);
            parentModuleList.add(item.getParentModuleId());
        }
        return this.recursiveGetFuncModule(new ArrayList<Long>(parentModuleList), allFuncModuleList, result);
    }

    public List<JSTreeModel> loadFuncModuleTree(String functionFlag, Long applicationId, String showFlag, Long bizAppId) {
        return this.hussarBaseFunctionAdapter.getFunModuleMergeTreeForOrg(functionFlag, applicationId, showFlag, bizAppId);
    }

    public List<JSTreeModel> loadFuncModuleTree(String functionFlag, Long applicationId, String showFlag) {
        return this.loadFuncModuleTree(functionFlag, applicationId, showFlag, null);
    }

    public List<JSTreeModel> loadFuncModuleTreeByAppRole(ResTreeDtoByAppRole resTreeDto) {
        return this.hussarBaseFunctionAdapter.getFunModuleMergeTreeForOrgByAppRole(resTreeDto);
    }

    public List<RoleBasicVo> getFuncRelateRoles(Long functionId) {
        if (HussarUtils.isEmpty((Object)functionId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_ID_NO_PASSED.getMessage()));
        }
        List roleFunctions = this.sysRoleFunctionsMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)functionId));
        if (HussarUtils.isEmpty((Object)roleFunctions)) {
            return Collections.emptyList();
        }
        List roleIds = roleFunctions.stream().map(SysRoleFunctions::getRoleId).collect(Collectors.toList());
        List sysRoles = this.sysRolesService.listByIds(roleIds);
        ArrayList<RoleBasicVo> result = new ArrayList<RoleBasicVo>();
        if (HussarUtils.isNotEmpty((Object)sysRoles)) {
            for (SysRoles roles : sysRoles) {
                RoleBasicVo vo = new RoleBasicVo();
                vo.setId(roles.getId());
                vo.setRoleName(roles.getRoleName());
                result.add(vo);
            }
        }
        return result;
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        return this.hussarBaseFunctionAdapter.getMaxOrderByParentIdAndAppId(moduleId, appId);
    }

    public List<SysFunctionModules> listByNameAndParentId(String moduleName, Long parentId, Long iamAppId, Long businessAppId) {
        return this.hussarBaseFunctionAdapter.moduleList(moduleName, parentId, iamAppId, businessAppId);
    }

    public List<SysFunctionModules> listByNameAndAppId(String moduleName, Long parentId, Long appId) {
        return this.hussarBaseFunctionAdapter.moduleListByAppId(moduleName, parentId, appId);
    }

    public boolean save(SysFunctionModules entity) {
        return this.hussarBaseFunctionAdapter.saveModule(entity);
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long iamAppId, Long businessAppId) {
        return this.hussarBaseFunctionAdapter.getFullModuleNameMapByName(moduleName, iamAppId, businessAppId);
    }

    public Map<Long, String> getFullModuleNameMapByAppId(String moduleName, Long appId) {
        return this.hussarBaseFunctionAdapter.getFullModuleNameMapByAppId(moduleName, appId);
    }

    public String getFullModuleNameById(Long moduleId, Long iamAppId, Long businessAppId) {
        return this.hussarBaseFunctionAdapter.getFullModuleNameById(moduleId, iamAppId, businessAppId);
    }

    public String getFullModuleNameByAppId(Long moduleId, Long appId) {
        return this.hussarBaseFunctionAdapter.getFullModuleNameByAppId(moduleId, appId);
    }

    public boolean updateById(SysFunctionModules entity) {
        return this.hussarBaseFunctionAdapter.updateModule(entity);
    }

    public SysFunctionModules getById(Serializable id) {
        return this.hussarBaseFunctionAdapter.getModuleByModuleId((Long)id);
    }

    public List<ModuleTreeVo> lazyLoadFuncModuleTree(ResTreeDto resTreeDto) {
        Long newNodeId = resTreeDto.getNodeId();
        String nodeType = resTreeDto.getNodeType();
        Long appId = resTreeDto.getApplicationId();
        Long bizAppId = resTreeDto.getBizAppId();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List<Object> result = new ArrayList();
        List<Object> list1 = new ArrayList();
        if (HussarUtils.isEmpty((Object)newNodeId)) {
            ModuleTreeVo root = new ModuleTreeVo();
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
            root.setParentId((Serializable)Constants.ROOT_NODE_PARENT);
            root.setIsModule("1");
            root.setType("isRoot");
            root.setConstant("0");
            root.setIsLeaf("0");
            root.setIcon("tree-com");
            boolean bl = this.existUnifyApp();
            if (bl) {
                root.setId((Serializable)Constants.ROOT_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(false));
                if (HussarUtils.isEmpty((Object)appId)) {
                    List applicationVos = this.sysApplicationService.getUserApplications(shiroUser.getId());
                    List<Long> appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
                    List<ModuleTreeVo> childrenList = this.getAppTree(appIds);
                    root.setChildren(childrenList);
                    if (HussarUtils.isNotEmpty(childrenList)) {
                        root.setHasChildren(Boolean.valueOf(true));
                    } else {
                        root.setIsLeaf("1");
                    }
                    result.add(root);
                    return result;
                }
            } else {
                root.setId((Serializable)Constants.RES_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(false));
                root.setCode(String.valueOf(Constants.RES_NODE_ID));
                appId = 1L;
                newNodeId = Constants.RES_NODE_ID;
                if (HussarUtils.isNotEmpty((Object)root.getId())) {
                    result.add(root);
                }
                list1 = this.sysFunctionModulesMapper.lazyLoadModulesFuncTree(newNodeId, appId, null);
                root.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(list1)));
                String tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY);
                if ("onsystem".equals(tenantType) && HussarUtils.isNotEmpty((Object)bizAppId)) {
                    list1 = list1.stream().filter(moduleTreeVo -> Constants.RES_FUNC_PORTAL_ID.equals(moduleTreeVo.getId())).collect(Collectors.toList());
                }
                result.addAll(list1);
            }
        } else {
            boolean isModule;
            boolean bl = isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType) || ToolUtil.equals((Object)"app", (Object)nodeType);
            if (isModule) {
                List sysUserRoleIds;
                Long roleId;
                list1 = this.sysFunctionModulesMapper.lazyLoadModulesFuncTree(newNodeId, appId, bizAppId);
                String string = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(TENANT_TYPE_PROPERTY);
                if ("onsystem".equals(string) && HussarUtils.isEmpty((Object)(roleId = (Long)(sysUserRoleIds = shiroUser.getRolesList()).stream().filter(l -> SysUserAndRole.TENANT_ADMIN_ROLE.getValue().equals(l) || SysUserAndRole.SUPERADMIN_ROLE.getValue().equals(l)).findAny().orElse(null)))) {
                    List currentAppIds = this.sysApplicationService.getCurrentAppIds(shiroUser.getId());
                    List strFinalAppIds = currentAppIds.stream().map(Object::toString).collect(Collectors.toList());
                    list1 = list1.stream().filter(jsTreeModel -> strFinalAppIds.contains(jsTreeModel.getAppId()) || Constants.DEFAULT_SYS_APP_ID.equals(jsTreeModel.getApplicationId()) && HussarUtils.isEmpty((Object)jsTreeModel.getAppId())).collect(Collectors.toList());
                }
            }
            result.addAll(list1);
        }
        for (ModuleTreeVo moduleTreeVo2 : result) {
            String isModule = moduleTreeVo2.getType();
            if ("isModule".equals(isModule)) {
                moduleTreeVo2.getState().put("notLeafModule", true);
            }
            if ((Long)moduleTreeVo2.getId() != 4L && (moduleTreeVo2.getAppId() == null || !"noCode".equals(moduleTreeVo2.getModSource()))) continue;
            moduleTreeVo2.setCanAddModule(Boolean.valueOf(false));
            moduleTreeVo2.setIsNoCode("1");
        }
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            result = result.stream().filter(r -> "0".equals(r.getIsSys()) || (Long)r.getId() == 1L).collect(Collectors.toList());
        }
        TranslateUtil.translate(result, AbstractNoIconHussarLazyTreeDefinition::getLabelLangKey, AbstractNoIconHussarLazyTreeDefinition::setLabel);
        return HussarTreeParser.getTreeList(result);
    }

    public Page<SearchModuleVo> searchFuncModule(PageInfo pageInfo, String name) {
        List<SearchModuleVo> result;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("name", SqlQueryUtil.transferSpecialChar((String)name));
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (TranslateUtil.getIsEnable() && !HussarUtils.equals((Object)lang, (Object)LangEnum.ZH_CN.getLangValue())) {
            queryParams.put("lang", lang);
            result = this.sysFunctionModulesMapper.searchFuncModuleForTrans((Page<SearchModuleVo>)page, queryParams);
            TranslateUtil.translate(result, SearchModuleVo::getNameLangKey, SearchModuleVo::setName);
            TranslateUtil.translate(result, SearchModuleVo::getParentNameLangKey, SearchModuleVo::setParentName);
        } else {
            result = this.sysFunctionModulesMapper.searchFuncModule(page, queryParams);
        }
        page.setRecords(result);
        return page;
    }

    public List<ModuleTreeVo> backFuncModuleTree(Long id) {
        ArrayList<ModuleTreeVo> result = new ArrayList<ModuleTreeVo>();
        ModuleTreeVo root = new ModuleTreeVo();
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setParentId((Serializable)Constants.ROOT_NODE_PARENT);
        root.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODULE_RESOURCE_LIST.getMessage()));
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        root.setIsLeaf("0");
        root.setIcon("tree-com");
        boolean flag = this.existUnifyApp();
        if (flag) {
            root.setId((Serializable)Constants.ROOT_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(false));
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            List applicationVos = this.sysApplicationService.getUserApplications(shiroUser.getId());
            List<Long> appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
            List<ModuleTreeVo> childrenList = this.getAppTree(appIds);
            if (HussarUtils.isNotEmpty(childrenList)) {
                root.setHasChildren(Boolean.valueOf(true));
            } else {
                root.setIsLeaf("1");
            }
            result.add(root);
            result.addAll((Collection<ModuleTreeVo>)childrenList);
        } else {
            root.setId((Serializable)Constants.RES_NODE_ID);
            root.setCanAddModule(Boolean.valueOf(true));
            root.setId((Serializable)Constants.RES_NODE_ID);
            result.add(root);
        }
        List<ModuleTreeVo> list = this.sysFunctionModulesMapper.getAllFuncModule();
        if (HussarUtils.isEmpty(list)) {
            return result;
        }
        HashMap childMap = new HashMap();
        ModuleTreeVo module = null;
        for (ModuleTreeVo moduleTreeVo : list) {
            List<ModuleTreeVo> vos;
            if (flag && (Long)moduleTreeVo.getParentId() == 1L && moduleTreeVo.getApplicationId() != 1L) {
                moduleTreeVo.setParentId((Serializable)moduleTreeVo.getApplicationId());
            }
            if (id.equals(moduleTreeVo.getId())) {
                module = moduleTreeVo;
            }
            if (HussarUtils.isEmpty(childMap.get(moduleTreeVo.getParentId()))) {
                vos = new ArrayList<ModuleTreeVo>();
                vos.add(moduleTreeVo);
                childMap.put(moduleTreeVo.getParentId(), vos);
                continue;
            }
            vos = (List)childMap.get(moduleTreeVo.getParentId());
            vos.add(moduleTreeVo);
        }
        if (HussarUtils.isEmpty(module)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_MODULE_NO_FOUND.getMessage()));
        }
        ArrayList<ModuleTreeVo> parentModuleList = new ArrayList<ModuleTreeVo>();
        this.getParentModules(parentModuleList, module, list);
        parentModuleList.add(module);
        for (ModuleTreeVo treeVo : parentModuleList) {
            Long parentId = (Long)treeVo.getParentId();
            List child = (List)childMap.get(parentId);
            if (!HussarUtils.isNotEmpty((Object)child)) continue;
            for (ModuleTreeVo vo : child) {
                vo.setHasChildren(Boolean.valueOf(childMap.containsKey(vo.getId())));
            }
            result.addAll(child);
        }
        for (ModuleTreeVo treeVo : result) {
            String isModule = treeVo.getType();
            if (!"isModule".equals(isModule)) continue;
            treeVo.getState().put("notLeafModule", true);
        }
        return HussarTreeParser.getTreeList(result);
    }

    public List<JSTreeModel> loadMenuFuncModuleTree(QueryFuncDto queryFuncDto) {
        return this.hussarBaseFunctionAdapter.loadMenuFuncModuleTree(queryFuncDto);
    }

    public void updateFunctionModulesStatusByAppId(Long appId, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.set(HussarDelflagEntity::getDelFlag, (Object)status)).eq(SysFunctionModules::getAppId, (Object)appId);
        this.update((Wrapper)wrapper);
    }

    public void deleteFunctionModulesByAppId(Long appId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysFunctionModules::getAppId, (Object)appId);
        this.remove((Wrapper)wrapper);
    }

    private void getParentModules(List<ModuleTreeVo> result, ModuleTreeVo module, List<ModuleTreeVo> list) {
        if (HussarUtils.isNotEmpty((Object)module)) {
            Long parentId = (Long)module.getParentId();
            ModuleTreeVo parentModules = null;
            for (ModuleTreeVo treeVo : list) {
                if (!parentId.equals(treeVo.getId())) continue;
                parentModules = treeVo;
            }
            if (HussarUtils.isNotEmpty(parentModules)) {
                result.add(parentModules);
                this.getParentModules(result, parentModules, list);
            }
        }
    }

    private boolean existUnifyApp() {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        return HussarUtils.isNotEmpty((Object)application);
    }

    private List<ModuleTreeVo> getAppTree(List<Long> appIdList) {
        ArrayList<ModuleTreeVo> result = new ArrayList<ModuleTreeVo>();
        if (HussarUtils.isEmpty(appIdList)) {
            return Collections.emptyList();
        }
        List applications = this.sysApplicationService.list((Wrapper)new LambdaQueryWrapper().in(SysApplication::getId, appIdList));
        List<Object> relationAppIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)applications)) {
            List functionModules = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionModules::getApplicationId, appIdList)).and(wrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            }));
            if (HussarUtils.isNotEmpty((Object)functionModules)) {
                relationAppIds = functionModules.stream().map(SysFunctionModules::getApplicationId).collect(Collectors.toList());
            }
            for (SysApplication application : applications) {
                ModuleTreeVo treeModel = new ModuleTreeVo();
                treeModel.setId((Serializable)application.getId());
                treeModel.setLabel(application.getAppName());
                treeModel.setCode(application.getAppCode());
                treeModel.setApplicationId(application.getId());
                treeModel.setType("app");
                treeModel.setParentId((Serializable)Constants.ROOT_NODE_ID);
                treeModel.setConstant("0");
                treeModel.setHasChildren(Boolean.valueOf(relationAppIds.contains(application.getId())));
                treeModel.setIsLeaf(relationAppIds.contains(application.getId()) ? "0" : "1");
                treeModel.setIcon("caidan_appManagement");
                result.add(treeModel);
            }
        }
        return result;
    }
}

