/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.adapter.role.IHussarBaseRoleAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleUserChangeNotify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.properties.HussarReloadUserAuthorizationProperties;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.sysUserRoleServiceImpl")
public class SysUserRoleServiceImpl
extends HussarBaseServiceImpl<SysUserRoleMapper, SysUserRole>
implements ISysUserRoleService {
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysConfRolesService isConfRolesService;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private ISysRolesService sysRolesService;
    private static final String DISABLED = "0";
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private IHussarBaseRoleAdapter hussarBaseRoleAdapter;
    @Autowired
    private RoleUserChangeNotify roleUserChangeNotify;
    @Resource
    @Lazy
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;
    @Resource
    private HussarReloadUserAuthorizationProperties properties;

    public void deleteNotPublicRole(String userId) {
        this.sysUserRoleMapper.deleteNotPublicRole(userId);
    }

    public void addRecord(SysUserRole sysUserRole) {
        this.sysUserRoleMapper.insert(sysUserRole);
    }

    public List<Long> getRolesByUserId(Long userId) {
        return this.hussarBaseRoleAdapter.getRolesByUserId(userId);
    }

    public List<Long> getRolesByUserIdAndAppId(Long userId, Long appId) {
        return this.sysUserRoleMapper.getRolesByUserIdAndAppId(userId, appId);
    }

    public List<String> selectUserIdByRoleId(String roleId) {
        return this.sysUserRoleMapper.selectUserIdByRoleId(roleId);
    }

    @HussarTransactional
    public ApiResponse saveOrDelUserRole(RoleUserDto roleUserDto) {
        Long roleId = roleUserDto.getRoleId();
        List adds = roleUserDto.getAdds();
        List dels = roleUserDto.getDels();
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        ArrayList<Long> hasDel = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)dels)) {
            for (RoleOrgUserVo roleOrgUserVo : dels) {
                hasDel.add(roleOrgUserVo.getId());
            }
        }
        ArrayList<Long> addIds = new ArrayList<Long>();
        ArrayList<Long> addIdsTemp = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)adds)) {
            for (RoleOrgUserVo roleOrgUserVo : adds) {
                addIds.add(roleOrgUserVo.getId());
                addIdsTemp.add(roleOrgUserVo.getId());
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)ADD);
        List se = this.sysUserRoleMapper.selectList((Wrapper)wrapper);
        for (Object sysUserRole : se) {
            for (int i = 0; i < addIdsTemp.size(); ++i) {
                if (!((Long)addIdsTemp.get(i)).equals(sysUserRole.getUserId()) || !ADD.equals(sysUserRole.getAdminOption())) continue;
                addIds.remove(addIdsTemp.get(i));
            }
        }
        ArrayList<Long> delNew = new ArrayList<Long>();
        for (SysUserRole sysUserRole : se) {
            for (Long del : hasDel) {
                if (!del.equals(sysUserRole.getUserId()) || DELETE.equals(sysUserRole.getAdminOption())) continue;
                delNew.add(del);
            }
        }
        Long count = this.sysConfRolesMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getRoleId, (Object)roleId));
        if (count > 0L && addIds.size() > 0) {
            LambdaQueryWrapper userRoleWrapper = new LambdaQueryWrapper();
            for (Long userId : addIds) {
                ((LambdaQueryWrapper)userRoleWrapper.or()).eq(SysUserRole::getUserId, (Object)userId);
            }
            List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)userRoleWrapper);
            Iterator map = new HashMap();
            for (SysUserRole userRole : userRoleList) {
                Long userId = userRole.getUserId();
                StringBuilder sb = (StringBuilder)map.get(userId);
                if (ToolUtil.isNotEmpty((Object)sb)) {
                    sb.append(",");
                    sb.append(userRole.getGrantedRole());
                    continue;
                }
                sb = new StringBuilder(String.valueOf(userRole.getGrantedRole()));
                map.put(userId, sb);
            }
            Long userId = this.isConfRolesService.isIncludeConfRole(map, roleId);
            if (userId != null) {
                SysUsers user = (SysUsers)this.sysUsersMapper.selectById(userId);
                throw new BaseException(String.format(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFICATION_FAILED.getMessage()), user.getUserName()));
            }
        }
        List auditList = this.sysUserroleAuditMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)roleId));
        List userroleAudits = this.sysUserroleAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)roleId)).eq(SysUserroleAudit::getStatus, (Object)DISABLED));
        AssertUtil.isEmpty((Collection)userroleAudits, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SAVE_FAILE_EXIST_UNAPPROVED_ASSOCIATED_USER.getMessage()));
        if (this.sysAuditConfig.isRoleAudit() && this.sysAuditConfig.isCriticalOperationsAudit()) {
            SysUserroleAudit sysUserroleAudit;
            if (ToolUtil.isNotEmpty(addIds)) {
                for (Long userId : addIds) {
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(userId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(ADD);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delNew)) {
                for (Long userId : delNew) {
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(userId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(DELETE);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (addIds.size() > 0 || delNew.size() > 0) {
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS_WAIT_REVIEW.getMessage()));
            }
        } else {
            SysRoles role;
            if (ToolUtil.isNotEmpty(delNew)) {
                this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, delNew));
                this.bpmAbstractPushMsgMatcher.deleteUserRole(delNew, null, null, roleId);
            }
            ArrayList<SysUserRole> userRoleList2 = new ArrayList<SysUserRole>();
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            for (Long userId : addIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreator(securityUser.getId());
                sysUserRole.setLastEditor(securityUser.getId());
                sysUserRole.setLastTime(now);
                sysUserRole.setCreateTime(now);
                userRoleList2.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(userId);
            }
            if (ToolUtil.isNotEmpty(userRoleList2)) {
                this.saveBatch(userRoleList2, userRoleList2.size());
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList2, "add");
            }
            if (HussarUtils.isNotEmpty((Object)(role = (SysRoles)this.sysRolesService.getById((Serializable)roleId)).getAppId()) && role.getAppId() != 1L) {
                this.roleUserChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
            }
            if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
                List<Long> ids = new ArrayList<Long>();
                ids.addAll(addIds);
                ids.addAll(delNew);
                ids = ids.stream().distinct().collect(Collectors.toList());
                this.userAuthorizationChangeReporter.report(new Object[]{"user", ids});
            }
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
    }

    public List<SysUserRole> getUserRolesByUserIds(List<Long> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        return this.sysUserRoleMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUserRole::getUserId, userIds));
    }

    public Map<String, Integer> saveOrUpdateBatchUserRoles(List<SysUserRole> userRoles) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<SysUserRole> existedUserRoles = this.getUserRolesByUserRoles(userRoles);
        int repeatCount = 0;
        ArrayList<SysUserRole> newUserRoles = new ArrayList<SysUserRole>();
        if (HussarUtils.isEmpty(existedUserRoles)) {
            this.saveBatch(userRoles);
            map.put("insert", userRoles.size());
            map.put("update", 0);
            return map;
        }
        for (SysUserRole userRole : userRoles) {
            boolean flag = false;
            for (SysUserRole existedUserRole : existedUserRoles) {
                if (!this.userRoleIsEqual(existedUserRole, userRole)) continue;
                ++repeatCount;
                flag = true;
                break;
            }
            if (flag) continue;
            newUserRoles.add(userRole);
        }
        map.put("insert", newUserRoles.size());
        map.put("update", repeatCount);
        this.saveBatch(newUserRoles);
        return map;
    }

    public List<SysUserRole> getUserRolesByUserRoles(List<SysUserRole> userRoles) {
        if (HussarUtils.isEmpty(userRoles)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        int size = userRoles.size();
        ArrayList<SysUserRole> returnList = new ArrayList<SysUserRole>();
        for (int i = 0; i < size; i += 9999) {
            List<SysUserRole> tempList = i + 9999 < size ? userRoles.subList(i, i + 9999) : userRoles.subList(i, size);
            lambdaQueryWrapper.clear();
            for (SysUserRole sysUserRole : tempList) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysUserRole::getGrantedRole, (Object)sysUserRole.getGrantedRole())).eq(SysUserRole::getUserId, (Object)sysUserRole.getUserId());
            }
            returnList.addAll(this.sysUserRoleMapper.selectList((Wrapper)lambdaQueryWrapper));
        }
        return returnList;
    }

    @HussarTransactional
    public ApiResponse<Boolean> addOrDelAppDevRoleUser(RoleUserDto roleUserDto) {
        SysRoles role;
        Long roleId = roleUserDto.getRoleId();
        List adds = roleUserDto.getAdds();
        List removes = roleUserDto.getDels();
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        if (ToolUtil.isNotEmpty((Object)removes)) {
            List delUserIds = removes.stream().map(RoleOrgUserVo::getId).collect(Collectors.toList());
            this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, delUserIds));
        }
        boolean addFlag = true;
        if (ToolUtil.isNotEmpty((Object)adds)) {
            List addUserIds = adds.stream().map(RoleOrgUserVo::getId).collect(Collectors.toList());
            this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, addUserIds));
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            LocalDateTime now = LocalDateTime.now();
            for (Long userId : addUserIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setLastTime(now);
                sysUserRole.setCreateTime(now);
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                addFlag = this.saveBatch(userRoleList, userRoleList.size());
            }
        }
        if (HussarUtils.isEmpty((Object)(role = (SysRoles)this.sysRolesService.getById((Serializable)roleId)).getAppId()) || role.getAppId() == 1L) {
            List<Object> ids = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)removes)) {
                List delUserIds = removes.stream().map(RoleOrgUserVo::getId).collect(Collectors.toList());
                ids.addAll(delUserIds);
            }
            if (HussarUtils.isNotEmpty((Object)adds)) {
                List addUserIds = adds.stream().map(RoleOrgUserVo::getId).collect(Collectors.toList());
                ids.addAll(addUserIds);
            }
            ids = ids.stream().distinct().collect(Collectors.toList());
            this.userAuthorizationChangeReporter.report(new Object[]{"user", ids});
        }
        return ApiResponse.success((Object)addFlag);
    }

    @HussarTransactional
    public Boolean addAppRoleUser(RoleUserDto roleUserDto) {
        Long roleId = roleUserDto.getRoleId();
        List adds = roleUserDto.getAdds();
        if (HussarUtils.isEmpty((Object)roleId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        boolean addFlag = true;
        if (HussarUtils.isNotEmpty((Object)adds)) {
            Long addUserId = ((RoleOrgUserVo)adds.get(0)).getId();
            if (HussarUtils.isNotEmpty((Object)addUserId)) {
                this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getUserId, (Object)addUserId));
                LocalDateTime now = LocalDateTime.now();
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(addUserId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setLastTime(now);
                sysUserRole.setCreateTime(now);
                addFlag = this.save((BaseEntity)sysUserRole);
            }
            HussarCacheUtil.evictKeysLike((String)"hussar_user_cache", (String)"user_id_");
            HussarCacheUtil.put((String)"hussar_user_authorization_change", (Object)addUserId, (Object)this.properties.getAffectedUserValidTime());
        }
        return addFlag;
    }

    private boolean userRoleIsEqual(SysUserRole userRole, SysUserRole sysUserRole) {
        return HussarUtils.equals((Object)userRole.getUserId(), (Object)sysUserRole.getUserId()) && HussarUtils.equals((Object)userRole.getGrantedRole(), (Object)sysUserRole.getGrantedRole());
    }

    @HussarDs(value="#connName")
    public void saveUserRole(String connName, Long userId) {
        SysUserRole entity = new SysUserRole();
        entity.setAdminOption(UserRoleStatus.OK.getCode());
        entity.setUserId(userId);
        entity.setGrantedRole(TenantConstant.ADMIN_ROLE);
        this.save(connName, (BaseEntity)entity);
    }

    @HussarTransactional
    public void saveAppRoleUser(Long roleId, List<Long> userIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)ADD);
        List oldRelations = this.sysUserRoleMapper.selectList((Wrapper)wrapper);
        List<Object> oldUserIds = new ArrayList();
        List<Object> addUserIds = new ArrayList<Long>();
        List<Object> delUserIds = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty((Object)oldRelations)) {
            oldUserIds = oldRelations.stream().map(SysUserRole::getUserId).distinct().collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(oldUserIds) && HussarUtils.isNotEmpty(userIds)) {
            ArrayList finalOldUserIds = oldUserIds;
            addUserIds = userIds.stream().filter(item -> !finalOldUserIds.contains(item)).collect(Collectors.toList());
            delUserIds = oldUserIds.stream().filter(item -> !userIds.contains(item)).collect(Collectors.toList());
        } else if (HussarUtils.isNotEmpty(oldUserIds) && HussarUtils.isEmpty(userIds)) {
            delUserIds.addAll(oldUserIds);
        } else if (HussarUtils.isEmpty(oldUserIds) && HussarUtils.isNotEmpty(userIds)) {
            addUserIds.addAll(userIds);
        } else {
            return;
        }
        Long count = this.sysConfRolesMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getRoleId, (Object)roleId));
        if (count > 0L && HussarUtils.isNotEmpty(addUserIds)) {
            LambdaQueryWrapper userRoleWrapper = new LambdaQueryWrapper();
            for (Long l : addUserIds) {
                ((LambdaQueryWrapper)userRoleWrapper.or()).eq(SysUserRole::getUserId, (Object)l);
            }
            List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)userRoleWrapper);
            HashMap<Long, StringBuilder> hashMap = new HashMap<Long, StringBuilder>();
            for (SysUserRole sysUserRole : userRoleList) {
                Long userId = sysUserRole.getUserId();
                StringBuilder sb = (StringBuilder)hashMap.get(userId);
                if (ToolUtil.isNotEmpty((Object)sb)) {
                    sb.append(",");
                    sb.append(sysUserRole.getGrantedRole());
                    continue;
                }
                sb = new StringBuilder(String.valueOf(sysUserRole.getGrantedRole()));
                hashMap.put(userId, sb);
            }
            Long userId = this.isConfRolesService.isIncludeConfRole(hashMap, roleId);
            if (userId != null) {
                SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(userId);
                throw new BaseException(String.format(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFICATION_FAILED.getMessage()), sysUsers.getUserName()));
            }
        }
        ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LocalDateTime localDateTime = LocalDateTime.now();
        for (Long l : addUserIds) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(l);
            sysUserRole.setGrantedRole(roleId);
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            sysUserRole.setLastTime(localDateTime);
            sysUserRole.setLastEditor(securityUser.getId());
            sysUserRole.setCreateTime(localDateTime);
            sysUserRole.setCreator(securityUser.getId());
            userRoleList.add(sysUserRole);
        }
        if (ToolUtil.isNotEmpty(userRoleList)) {
            this.saveBatch(userRoleList, userRoleList.size());
            this.userAuthorizationChangeReporter.report(new Object[]{"user", addUserIds});
        }
    }

    public boolean savePublicBatch(String connName, List<Long> userIds) {
        ArrayList sysUserRoleList = Lists.newArrayList();
        userIds.forEach(userId -> {
            SysUserRole record = (SysUserRole)this.getOne(connName, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRole::getUserId, userId)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
            if (record == null) {
                SysUserRole userRole = new SysUserRole();
                userRole.setUserId(userId);
                userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                userRole.setAdminOption(ADD);
                sysUserRoleList.add(userRole);
            }
        });
        return this.saveOrUpdateBatch(connName, sysUserRoleList);
    }

    public boolean removePublicBatch(String connName, List<Long> userIds) {
        return this.remove(connName, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysUserRole::getUserId, userIds)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
    }

    public List<Long> delOrganRoleIdByUserId(Long userId) {
        return this.sysUserRoleMapper.delOrganRoleIdByUserId(userId);
    }

    public void delUserRoleByRoleId(Long userId, List<List<Long>> roleList) {
        this.sysUserRoleMapper.delUserRoleByRoleId(userId, roleList);
    }

    public void delSysRolesByUserId(Long userId, List<List<Long>> roleList) {
        this.sysUserRoleMapper.delSysRolesByUserId(userId, roleList);
    }
}

