/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.StruRoleAuditDto;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.vo.SysStruRoleVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysStruRoleAuditServiceImpl
extends HussarServiceImpl<SysStruRoleAuditMapper, SysStruRoleAudit>
implements ISysStruRoleAuditService {
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    public IPage<SysStruRoleVo> getStruRoleReviewList(Page<SysStruRoleVo> page, StruRoleAuditDto struRoleAuditDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        String organName = struRoleAuditDto == null ? null : struRoleAuditDto.getOrganName();
        String status = struRoleAuditDto == null ? null : struRoleAuditDto.getStatus();
        return page.setRecords(this.sysStruRoleAuditMapper.getStruRoleReviewList(page, organName, status));
    }

    @HussarTransactional
    public void reviewSubmit(StruRoleAuditDto struRoleAudit) {
        if (ToolUtil.isEmpty((Object)struRoleAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_ROLE_EMPTY.getMessage()));
        }
        String struId = struRoleAudit.getStruId() == null ? "" : struRoleAudit.getStruId().toString();
        String roleId = struRoleAudit.getRoleId() == null ? "" : struRoleAudit.getRoleId().toString();
        String opsType = struRoleAudit.getOperationType() == null ? "" : struRoleAudit.getOperationType();
        String[] sids = struId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        SysStruRoleAudit sysStruRoleAudit = new SysStruRoleAudit();
        sysStruRoleAudit.setStatus(StruRoleStatus.OK.getCode());
        if (sids.length == oids.length && rids.length == oids.length) {
            ArrayList<SysStruRole> addBpmList = new ArrayList<SysStruRole>();
            ArrayList<SysStruRole> deleteBpmList = new ArrayList<SysStruRole>();
            for (int i = 0; i < sids.length; ++i) {
                SysStruRole sysStruRole;
                List list = this.sysStruRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)sids[i])).eq(SysStruRole::getGrantedRole, (Object)rids[i]));
                if (ToolUtil.isEmpty((Object)list)) {
                    sysStruRole = new SysStruRole();
                    sysStruRole.setStruId(Long.valueOf(sids[i]));
                    sysStruRole.setGrantedRole(Long.valueOf(rids[i]));
                    if (ADD.equals(oids[i])) {
                        this.sysStruRoleMapper.insert(sysStruRole);
                        addBpmList.add(sysStruRole);
                    }
                    if (DELETE.equals(oids[i])) {
                        deleteBpmList.add(sysStruRole);
                    }
                } else {
                    sysStruRole = new SysStruRole();
                    sysStruRole.setStruId(Long.valueOf(sids[i]));
                    sysStruRole.setGrantedRole(Long.valueOf(rids[i]));
                    if (ADD.equals(oids[i])) {
                        this.sysStruRoleMapper.update(sysStruRole, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysStruRole::getStruId, (Object)sids[i])).eq(SysStruRole::getGrantedRole, (Object)rids[i]));
                        addBpmList.add(sysStruRole);
                    }
                    if (DELETE.equals(oids[i])) {
                        this.sysStruRoleMapper.delete((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysStruRole::getStruId, (Object)sids[i])).eq(SysStruRole::getGrantedRole, (Object)rids[i]));
                        deleteBpmList.add(sysStruRole);
                    }
                }
                this.sysStruRoleAuditMapper.update(sysStruRoleAudit, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysStruRoleAudit::getStruId, (Object)sids[i])).eq(SysStruRoleAudit::getRoleId, (Object)rids[i])).eq(SysStruRoleAudit::getOperationType, (Object)oids[i]));
            }
            this.abstractPushMsgMatcher.insertOperation("struRole", "add", addBpmList, Constants.NONE_ID);
            this.abstractPushMsgMatcher.insertOperation("struRole", "delete", deleteBpmList, Constants.NONE_ID);
        }
    }

    @HussarTransactional
    public void refuseSubmit(StruRoleAuditDto struRoleAudit) {
        if (ToolUtil.isEmpty((Object)struRoleAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_ROLE_EMPTY.getMessage()));
        }
        String struId = struRoleAudit.getStruId() == null ? "" : struRoleAudit.getStruId().toString();
        String roleId = struRoleAudit.getRoleId() == null ? "" : struRoleAudit.getRoleId().toString();
        String opsType = struRoleAudit.getOperationType() == null ? "" : struRoleAudit.getOperationType();
        SysStruRoleAudit sysStruRoleAudit = new SysStruRoleAudit();
        sysStruRoleAudit.setStatus(StruRoleStatus.REFUSE.getCode());
        this.sysStruRoleAuditMapper.update(sysStruRoleAudit, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysStruRoleAudit::getStruId, (Object)struId)).eq(SysStruRoleAudit::getRoleId, (Object)roleId)).eq(SysStruRoleAudit::getOperationType, (Object)opsType));
    }

    public int isDelete(Long id) {
        return this.sysStruRoleAuditMapper.isDelete(id);
    }
}

