/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ILocalHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.localHussarBaseUserBoServiceImpl")
public class LocalHussarBaseUserBoServiceImpl
implements ILocalHussarBaseUserBoService {
    @Autowired
    private ISysUsersService sysUsersService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Resource
    protected SysStruUserMapper sysStruUserMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Lazy
    @Resource
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    public Map<Long, SysUsers> getUserInfo(List<Long> userIds) {
        List usersList = new ArrayList();
        if (HussarUtils.isNotEmpty(userIds)) {
            usersList = this.sysUsersService.listByIds(userIds);
        }
        HashMap<Long, SysUsers> map = new HashMap<Long, SysUsers>();
        if (HussarUtils.isNotEmpty(usersList)) {
            for (SysUsers item : usersList) {
                map.put(item.getId(), item);
            }
        }
        return map;
    }

    public List<UserVo> getUserInfoByRoleId(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_NO_PASSED.getMessage()));
        }
        List userVos = this.sysUsersMapper.getUserInfoByRoleId(roleIds);
        if (HussarUtils.isEmpty(userVos)) {
            return Collections.emptyList();
        }
        userVos = userVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserVo>(Comparator.comparing(UserVo::getId))), ArrayList::new));
        return userVos;
    }

    public List<UserVo> getUsersByPostIds(List<Long> postIds) {
        AssertUtil.isNotEmpty(postIds, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysUserPost::getPostId, postIds);
        wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List list = this.sysUserPostService.list((Wrapper)wrapper);
        List userIds = list.stream().map(SysUserPost::getUserId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        List users = this.sysUsersService.listByIds(userIds);
        if (HussarUtils.isEmpty((Object)users)) {
            return Collections.emptyList();
        }
        ArrayList<UserVo> result = new ArrayList<UserVo>();
        for (SysUsers user : users) {
            UserVo vo = new UserVo();
            vo.setId(user.getId());
            vo.setUserName(user.getUserName());
            result.add(vo);
        }
        return result;
    }

    public List<SysStruUser> getStruUserByStruIds(List<Long> struIds) {
        if (CollectionUtils.isEmpty(struIds)) {
            return Lists.newArrayList();
        }
        return this.sysStruUserMapper.getStruUserByStruIds(struIds);
    }

    public List<String> getUserIdsByUserIdsAndRolePermission(List<Long> userIds, String rolePermission) {
        if (CollectionUtils.isEmpty(userIds) || StringUtils.isBlank((CharSequence)rolePermission)) {
            return Lists.newArrayList();
        }
        List userList = LambdaQueryUtil.getSplitList(userIds);
        List<String> userIdList = this.sysUserRoleMapper.getUserIdsByUserIdsAndRolePermission(userList, rolePermission);
        userIdList = userIdList.stream().distinct().collect(Collectors.toList());
        return userIdList;
    }

    public List<OrganUserTreeVo> organUserSearch(String name) {
        ArrayList<OrganUserTreeVo> organUserTreeVoList = new ArrayList<OrganUserTreeVo>();
        List sysUsers = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(SysUsers::getUserName, (Object)name)).ne(SysUsers::getAccountStatus, (Object)"2")).ne(SysUsers::getIsSys, (Object)"1"));
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            Map<Long, SysUsers> userMaps = sysUsers.stream().collect(Collectors.toMap(SysUsers::getId, Function.identity()));
            List<Long> userIds = this.wrapUserInfo(userMaps, organUserTreeVoList);
            this.wrapOrganUserInfo(userIds, organUserTreeVoList);
        }
        List organUserTreeVos = HussarTreeParser.getTreeList(organUserTreeVoList);
        for (OrganUserTreeVo organUserTreeVo : organUserTreeVos) {
            this.sysRolesService.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)organUserTreeVo);
        }
        return organUserTreeVos;
    }

    public List<SysUsers> list() {
        return this.sysUsersService.list();
    }

    private List<Long> wrapUserInfo(Map<Long, SysUsers> userMaps, List<OrganUserTreeVo> organUserTreeVoList) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (Map.Entry<Long, SysUsers> userMap : userMaps.entrySet()) {
            List struIds = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userMap.getKey())).stream().map(SysStruUser::getStruId).collect(Collectors.toList());
            String userName = userMap.getValue().getUserName();
            String accountStatus = userMap.getValue().getAccountStatus();
            for (Long struId : struIds) {
                OrganUserTreeVo organUserTreeVo = new OrganUserTreeVo();
                organUserTreeVo.setId((Serializable)userMap.getKey());
                organUserTreeVo.setLabel(userName);
                organUserTreeVo.setParentId((Serializable)struId);
                organUserTreeVo.setTypes("user");
                organUserTreeVo.setHasChildren(Boolean.valueOf(false));
                organUserTreeVo.setAccountStatus(accountStatus);
                organUserTreeVoList.add(organUserTreeVo);
            }
            userIds.add(userMap.getKey());
        }
        return userIds;
    }

    private void wrapOrganUserInfo(List<Long> userIds, List<OrganUserTreeVo> organUserTreeVoList) {
        List<Long> struIds = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds)).stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        List<Long> finalStruIds = this.queryOrganizationManager.getParentStruByIds(struIds);
        List<OrganUserTreeVo> organUserTreeOnlyOrgan = this.sysStruMapper.getOrganTreeOnlyOrgan(finalStruIds, null);
        ArrayList rootIds = Lists.newArrayListWithCapacity((int)2);
        if (organUserTreeOnlyOrgan.stream().anyMatch(o -> HussarUtils.equals((Object)o.getParentId(), (Object)Constants.ROOT_NODE_ID))) {
            rootIds.add(Constants.ROOT_NODE_ID);
        }
        if (organUserTreeOnlyOrgan.stream().anyMatch(o -> HussarUtils.equals((Object)o.getParentId(), (Object)Constants.OUT_STRU_NODE_ID))) {
            rootIds.add(Constants.OUT_STRU_NODE_ID);
        }
        if (HussarUtils.isNotEmpty((Object)rootIds)) {
            List<OrganUserTreeVo> rootOrganUsers = this.sysStruMapper.getOrganTreeOnlyOrgan(rootIds, null);
            organUserTreeVoList.addAll(rootOrganUsers);
        }
        organUserTreeVoList.addAll(organUserTreeOnlyOrgan);
    }
}

