/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.jxdinfo.hussar.authorization.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.dao.SysPostRoleMapper;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonUserManager {
    @Autowired
    protected ISysConfRolesService sysConfRolesService;
    @Autowired
    protected IHussarValidateService validateService;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysStruAuditMapper sysStruAuditMapper;
    @Resource
    protected AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Autowired
    protected ICreateUserConfigService createUserConfigService;
    @Autowired
    protected IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    protected AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Autowired
    protected ISysUsersAuditService sysUsersAuditService;
    @Autowired
    protected ISysStruAuditService sysStruAuditService;
    @Autowired
    protected ISysUserIpAuditService sysUserIpAuditService;
    @Autowired
    protected ISysUserIpService sysUserIpService;
    @Autowired
    protected ISysUserRoleService sysUserRoleService;
    @Autowired
    protected ISysUserroleAuditService sysUserroleAuditService;
    @Autowired
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    protected HussarBaseProperties hussarBaseProperties;
    @Autowired
    protected ISysStaffService sysStaffService;
    @Resource
    protected SysStruRoleMapper sysStruRoleMapper;
    @Resource
    protected SysPostRoleMapper sysPostRoleMapper;
    @Autowired
    protected ISysUserPostService sysUserPostService;
    @Autowired
    protected ISysUserPostAuditService sysUserPostAuditService;
    @Autowired
    protected ISysStruUserService sysStruUserService;
    @Autowired
    protected ISysStruUserAuditService sysStruUserAuditService;
    @Autowired
    protected ISysStaffAuditService sysStaffAuditService;
    @Resource
    protected UserChangeNotify userChangeNotify;
    @Resource
    protected IHussarBasePostService hussarBasePostService;
    @Resource
    protected ISysDicRefService sysDicRefService;
    protected static final String ADD = "1";
    protected static final String DELETE = "2";

    protected void checkIncludeConfRole(Long[] idLs, String type) {
        if (HussarUtils.isNotEmpty((Object[])idLs)) {
            boolean flag = this.sysConfRolesService.isIncludeConfRole(idLs);
            if (HussarUtils.equals((Object)"add", (Object)type)) {
                AssertUtil.isFalse((boolean)flag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THE_ROLE_NO_ALLOW_EXCEED_ROLE_SETS.getMessage()));
            }
            if (HussarUtils.equals((Object)"edit", (Object)type)) {
                AssertUtil.isFalse((boolean)flag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THE_ROLE_NO_ALLOW_EXCEED_ROLE_SETS.getMessage()));
            }
        }
    }

    protected boolean saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotBlank((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String string : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(string);
                sysUserIps.add(sysUserIp);
            }
        }
        if (sysUserIps.size() > 0) {
            ArrayList<String> newsysUserIps = new ArrayList<String>();
            for (SysUserIp sysUserIp : sysUserIps) {
                AssertUtil.isFalse((boolean)newsysUserIps.contains(sysUserIp.getUserIp()), (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXIST_DUPLICATE_IP.getMessage()) + sysUserIp.getUserIp()));
                newsysUserIps.add(sysUserIp.getUserIp());
            }
            flag = this.sysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }

    protected boolean saveUserAuditIP(Long userId, String accessLoginIp, String currentStatus) {
        boolean flag = false;
        ArrayList<SysUserIpAudit> listAudit = new ArrayList<SysUserIpAudit>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
                sysUserIpAudit.setUserId(userId);
                sysUserIpAudit.setUserIp(ip);
                sysUserIpAudit.setIsAudit("0");
                sysUserIpAudit.setCurrentStatus(currentStatus);
                listAudit.add(sysUserIpAudit);
            }
        }
        if (HussarUtils.isNotEmpty(listAudit)) {
            flag = this.sysUserIpAuditService.saveBatch(listAudit);
        }
        return flag;
    }

    protected void fillCommonFields(List<SysUserRole> sysUserRoles) {
        if (HussarUtils.isEmpty(sysUserRoles)) {
            return;
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        for (SysUserRole userRole : sysUserRoles) {
            userRole.setCreateTime(now);
            userRole.setLastTime(now);
            userRole.setCreator(securityUser.getId());
            userRole.setLastEditor(securityUser.getId());
        }
    }
}

