/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganTypeBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTypeBo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseOrganTypeBoServiceImpl")
public class HussarBaseOrganTypeBoServiceImpl
implements IHussarBaseOrganTypeBoService {
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Autowired
    private ISysStruRuleService sysStruRuleService;

    public OrganizationTypeBo findOrganizationTypeByOrganType(String organType) {
        AssertUtil.isNotEmpty((String)organType, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        OrganizationTypeBo typeBo = this.sysOrganTypeMapper.getOrganizationTypeByOrganType(organType);
        return typeBo;
    }

    public OrganizationTypeBo findOrganizationTypeByTypeName(String typeName) {
        AssertUtil.isNotEmpty((String)typeName, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        OrganizationTypeBo typeBo = this.sysOrganTypeMapper.getOrganizationTypeByTypeName(typeName);
        return typeBo;
    }

    public List<OrganizationTypeBo> getAllOrganType() {
        List<OrganizationTypeBo> allOrganType = this.sysOrganTypeMapper.getAllOrganType();
        allOrganType.sort(Comparator.comparingLong(type -> Long.parseLong(type.getOrganType())));
        return allOrganType;
    }

    public Long countStruRuleStaff(String parentType) {
        return this.sysStruRuleService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRule::getSysOrganType, (Object)parentType)).eq(SysStruRule::getOrganType, (Object)"9"));
    }

    public SysOrganType getById(Long id) {
        return (SysOrganType)this.sysOrganTypeMapper.selectById(id);
    }
}

