/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeIamDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ILocalRolesExternalAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.WorkTempRoleSearchVo;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalRolesExternalAdapterServiceImpl
implements ILocalRolesExternalAdapterService {
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;

    public ApiResponse<Long> addAppDevRole(String appName, Long appId) {
        return this.sysRolesService.addAppDevRole(appName, appId);
    }

    public ApiResponse<Boolean> addOrDelAppDevRoleUser(RoleUserDto roleUserDto) {
        return this.sysUserRoleService.addOrDelAppDevRoleUser(roleUserDto);
    }

    public Boolean addAppRoleUser(RoleUserDto roleUserDto) {
        return this.sysUserRoleService.addAppRoleUser(roleUserDto);
    }

    public List<RoleVo> getRoleInfoByIds(List<Long> roleIds) {
        List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
        ArrayList<RoleVo> roleVoList = new ArrayList<RoleVo>();
        if (HussarUtils.isNotEmpty((Object)roles)) {
            for (SysRoles role : roles) {
                RoleVo roleVo = new RoleVo();
                roleVo.setId(role.getId());
                roleVo.setRoleName(role.getRoleName());
                roleVoList.add(roleVo);
            }
        }
        return roleVoList;
    }

    public List<JSTreeModel> loadRoleGruopTree(Long appId, Long bizAppId) {
        return this.sysRolesService.getRoleGroupTree(appId, bizAppId);
    }

    public List<JSTreeModel> loadRoleGruopTree(Long appId) {
        return this.sysRolesService.getRoleGroupTree(appId, null);
    }

    public List<SysRoles> searchRoleToGroup(Long id, String roleName) {
        return this.sysRolesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getGroupId, (Object)id)).like(HussarUtils.isNotBlank((CharSequence)roleName), SysRoles::getRoleName, (Object)roleName)).orderByAsc(SysRoles::getRoleOrder));
    }

    public List<ReadOnlyRoleTreeVo> getRoleTree(Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List groups = this.sysRoleGroupMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId)).eq(SysRoleGroup::getFromAppId, (Object)1L));
        List<SysRoleGroup> orderGroups = groups.stream().sorted(Comparator.comparing(SysRoleGroup::getGroupOrder)).collect(Collectors.toList());
        List sysRoles = this.sysRolesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId)).eq(SysRoles::getFromAppId, (Object)1L));
        List<SysRoles> orderSysRoles = sysRoles.stream().sorted(Comparator.comparing(SysRoles::getRoleOrder)).collect(Collectors.toList());
        return LocalRolesExternalAdapterServiceImpl.getReadOnlyRoleTreeVos(orderSysRoles, orderGroups);
    }

    private static List<ReadOnlyRoleTreeVo> getReadOnlyRoleTreeVos(List<SysRoles> orderSysRoles, List<SysRoleGroup> orderGroups) {
        ArrayList<ReadOnlyRoleTreeVo> result = new ArrayList<ReadOnlyRoleTreeVo>();
        HashMap<Long, ArrayList<SysRoles>> map = new HashMap<Long, ArrayList<SysRoles>>();
        if (HussarUtils.isNotEmpty(orderSysRoles)) {
            for (SysRoles role : orderSysRoles) {
                ArrayList<SysRoles> children = (ArrayList<SysRoles>)map.get(role.getGroupId());
                if (HussarUtils.isEmpty((Object)children)) {
                    children = new ArrayList<SysRoles>();
                    map.put(role.getGroupId(), children);
                }
                children.add(role);
            }
        }
        ReadOnlyRoleTreeVo root = new ReadOnlyRoleTreeVo();
        root.setId((Serializable)Long.valueOf(Long.parseLong("1")));
        root.setParentId((Serializable)OrganConstants.ROOT_ORGAN_ID);
        root.setIcon("tree-com");
        root.setLabel("\u89d2\u8272\u6811");
        root.setType("root");
        ArrayList<ReadOnlyRoleTreeVo> groupChildren = new ArrayList<ReadOnlyRoleTreeVo>();
        if (HussarUtils.isEmpty(orderGroups)) {
            root.setChildren(groupChildren);
            root.setHasChildren(Boolean.valueOf(false));
            result.add(root);
            return result;
        }
        for (SysRoleGroup group : orderGroups) {
            ReadOnlyRoleTreeVo treeVo = new ReadOnlyRoleTreeVo();
            treeVo.setId((Serializable)group.getId());
            treeVo.setIcon("role-group-unify");
            treeVo.setLabel(group.getGroupName());
            treeVo.setParentId((Serializable)Long.valueOf(Long.parseLong("1")));
            treeVo.setType("group");
            treeVo.setDescription(group.getGroupAlias());
            List childrenRoles = (List)map.get(group.getId());
            ArrayList<ReadOnlyRoleTreeVo> children = new ArrayList<ReadOnlyRoleTreeVo>();
            ReadOnlyRoleTreeVo roleTreeVo = null;
            if (HussarUtils.isNotEmpty((Object)childrenRoles)) {
                treeVo.setHasChildren(Boolean.valueOf(true));
                for (SysRoles role : childrenRoles) {
                    roleTreeVo = new ReadOnlyRoleTreeVo();
                    roleTreeVo.setId((Serializable)role.getId());
                    roleTreeVo.setParentId((Serializable)group.getId());
                    roleTreeVo.setLabel(role.getRoleName());
                    roleTreeVo.setHasChildren(Boolean.valueOf(false));
                    roleTreeVo.setIcon("role-unify");
                    roleTreeVo.setType("role");
                    roleTreeVo.setDescription(role.getRoleAlias());
                    children.add(roleTreeVo);
                }
            }
            treeVo.setChildren(children);
            groupChildren.add(treeVo);
        }
        root.setChildren(groupChildren);
        if (HussarUtils.isNotEmpty(groupChildren)) {
            root.setHasChildren(Boolean.valueOf(true));
        }
        result.add(root);
        return result;
    }

    public Boolean delRole(Long id) {
        this.sysRolesService.deleteRole(id);
        return Boolean.TRUE;
    }

    public List<WorkTempRoleSearchVo> roleSearch(String name, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        ArrayList<WorkTempRoleSearchVo> roleSearchVoList = new ArrayList<WorkTempRoleSearchVo>();
        List sysRoles = this.sysRolesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(SysRoles::getRoleName, (Object)name)).eq(SysRoles::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysRoles)) {
            Set<Long> roleGroupIds = this.wrapRoleInfo(sysRoles, roleSearchVoList);
            this.wrapRoleGroup(roleGroupIds, roleSearchVoList);
        }
        List roleSearchVos = HussarTreeParser.getTreeList(roleSearchVoList);
        for (WorkTempRoleSearchVo roleSearchVo : roleSearchVos) {
            this.sysRolesService.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)roleSearchVo);
        }
        return roleSearchVos;
    }

    private Set<Long> wrapRoleInfo(List<SysRoles> sysRoles, List<WorkTempRoleSearchVo> roleSearchVoList) {
        HashSet<Long> roleGroupIds = new HashSet<Long>();
        for (SysRoles sysRole : sysRoles) {
            WorkTempRoleSearchVo roleSearchVo = new WorkTempRoleSearchVo();
            roleSearchVo.setId((Serializable)sysRole.getId());
            roleSearchVo.setParentId((Serializable)sysRole.getGroupId());
            roleSearchVo.setLabel(sysRole.getRoleName());
            roleSearchVo.setHasChildren(Boolean.FALSE);
            roleSearchVoList.add(roleSearchVo);
            roleGroupIds.add(sysRole.getGroupId());
        }
        return roleGroupIds;
    }

    private void wrapRoleGroup(Set<Long> roleGroupIds, List<WorkTempRoleSearchVo> roleSearchVoList) {
        List sysRoleGroups = this.sysRoleGroupService.list((Wrapper)new LambdaQueryWrapper().in(SysRoleGroup::getId, roleGroupIds));
        for (SysRoleGroup sysRoleGroup : sysRoleGroups) {
            WorkTempRoleSearchVo roleGroupSearchVo = new WorkTempRoleSearchVo();
            roleGroupSearchVo.setId((Serializable)sysRoleGroup.getId());
            roleGroupSearchVo.setLabel(sysRoleGroup.getGroupName());
            roleGroupSearchVo.setHasChildren(Boolean.TRUE);
            roleSearchVoList.add(roleGroupSearchVo);
        }
    }

    public RoleInfoVO getRoleViewMap(Long id) {
        return this.sysRolesService.getRoleViewMap(id);
    }

    public Boolean updateRole(SysRoles sysRoles) {
        this.sysRolesService.updateRole(sysRoles);
        return Boolean.TRUE;
    }

    public List<SysRoles> getRolesByIds(List<Long> roleIds) {
        return this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
    }

    public List<SysRoles> getAllRoles() {
        return this.sysRolesService.list();
    }

    public Boolean saveRoleBatch(List<SysRoles> roleList) {
        return this.sysRolesService.saveBatch(roleList);
    }

    public List<SysRoleGroup> selectRoleGroupByIds(List<Long> roleGroupIds) {
        return this.sysRoleGroupService.selectRoleGroupByIds(roleGroupIds);
    }

    public List<SysRoleGroup> getAllRoleGroup() {
        return this.sysRoleGroupService.list();
    }

    public Boolean saveRoleGroupBatch(List<SysRoleGroup> roleGroupList) {
        return this.sysRoleGroupService.saveBatch(roleGroupList);
    }

    public List<ReadOnlyRoleTreeVo> getRoleTreeForSys(RoleTreeIamDto roleTreeIamDto) {
        Long appId = roleTreeIamDto.getAppId();
        Boolean showSysRoleFlag = roleTreeIamDto.getShowSysRole();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List groups = this.sysRoleGroupMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId)).eq(SysRoleGroup::getFromAppId, (Object)1L));
        List<SysRoleGroup> orderGroups = groups.stream().sorted(Comparator.comparing(SysRoleGroup::getGroupOrder)).collect(Collectors.toList());
        List sysRoles = this.sysRolesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId)).eq(SysRoles::getFromAppId, (Object)1L)).ne(showSysRoleFlag == false, SysRoles::getIsSys, (Object)"1"));
        List<SysRoles> orderSysRoles = sysRoles.stream().sorted(Comparator.comparing(SysRoles::getRoleOrder)).collect(Collectors.toList());
        return LocalRolesExternalAdapterServiceImpl.getReadOnlyRoleTreeVos(orderSysRoles, orderGroups);
    }
}

