/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.enums.AccountTypeEnum;
import com.jxdinfo.hussar.authorization.permit.enums.GenderEnum;
import com.jxdinfo.hussar.authorization.permit.enums.UserExcelEnum;
import com.jxdinfo.hussar.authorization.permit.manager.ExportUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonUserManager;
import com.jxdinfo.hussar.authorization.permit.model.ExcelExportDesc;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.UserExcel;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.excel.builder.ConcreteExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.handler.CustomSheetWriteHandler;
import com.jxdinfo.hussar.excel.handler.DataValidationSheetWriteHandler;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ExportUserManagerImpl
extends CommonUserManager
implements ExportUserManager {
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysExcelTaskService sysExcelTaskServiceImpl;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    protected IProtectionStatusConfigBoService protectionStatusConfigBoService;
    private static String USER_SECURITY_LEVEL = "user_security_level";
    protected static final String SECURITY_LEVEL = "security_level";
    private static int SPLIT_LT = 999;
    private static int SPLIT_LT_OR = 499;
    private static final Logger logger = LoggerFactory.getLogger(ExportUserManagerImpl.class);

    @Override
    public void exportUserExcel(String ids, Long taskId, boolean exportKey) {
        AssertUtil.isNotEmpty((String)StringUtil.trimToEmpty((CharSequence)ids), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        AssertUtil.isNotNull((Object)securityUser, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_CURRENT_LOGIN_USER.getMessage()));
        Long[] struIds = (Long[])ConvertUtils.convert((String[])ids.split(","), Long.class);
        List<Long> struIdList = Arrays.asList(struIds);
        List struUserList = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList));
        ArrayList userExcels = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)struUserList)) {
            List<Long> userIdList = struUserList.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
            Map<Long, String> userOrganMap = this.getOrganInfos(userIdList);
            LambdaQueryWrapper multiQueryWrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, userIdList).orderByAsc(SysUsers::getUserOrder);
            List users = this.sysUsersMapper.selectList((Wrapper)multiQueryWrapper);
            List staffIds = users.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
            LambdaQueryWrapper multiStaffQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getId, staffIds);
            List staffs = this.sysStaffService.list((Wrapper)multiStaffQueryWrapper);
            Map<Long, SysStaff> staffMap = staffs.stream().collect(Collectors.toMap(SysStaff::getId, s -> s));
            List dicVos = this.sysDicRefService.getDicListByType("staff_position");
            Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
            List securityLevels = this.sysDicRefService.getDicListByType(USER_SECURITY_LEVEL);
            Map<String, String> securityLevelMaps = securityLevels.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            users.forEach(u -> {
                SysStaff staff;
                UserExcel userExcel = new UserExcel();
                userExcel.setDepartment((String)userOrganMap.get(u.getId()));
                BeanUtils.copyProperties((Object)u, (Object)userExcel);
                userExcel.setMail(u.geteMail());
                userExcel.setUserOrder(String.valueOf(u.getUserOrder()));
                userExcel.setMaxSessions(String.valueOf(u.getMaxSessions()));
                if (HussarUtils.equals((Object)"0", (Object)u.getTypeProperty())) {
                    userExcel.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getStartTime()));
                    userExcel.setExpiredTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getExpiredTime()));
                }
                if (HussarUtils.isNotEmpty((Object)keyList) && keyList.contains(String.valueOf(u.getId()))) {
                    userExcel.setAccountStatus(UserStatus.LOCKED.getCode());
                }
                if (HussarUtils.isNotEmpty((Object)(staff = (SysStaff)staffMap.get(u.getEmployeeId())).getStaffPosition())) {
                    staff.setStaffPosition((String)dicMap.get(staff.getStaffPosition()));
                }
                if (HussarUtils.isNotEmpty((Object)u.getSecurityLevel())) {
                    userExcel.setSecurityLevelName((String)securityLevelMaps.get(String.valueOf(u.getSecurityLevel())));
                }
                BeanUtils.copyProperties((Object)staff, (Object)userExcel);
                if (exportKey) {
                    userExcel.setUserId(String.valueOf(u.getId()));
                }
                userExcels.add(userExcel);
            });
        }
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            ClassSheetMsg classSheetMsg = new ClassSheetMsg(UserExcel.class, userExcels, "\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f", 0);
            if (!exportKey) {
                classSheetMsg.setExcludeColumnIndexes(Collections.singletonList(25));
            }
            classSheetMsg.addHandler((WriteHandler)new DataValidationSheetWriteHandler(this.getUserExcelOptions()));
            classSheetMsg.addHandler((WriteHandler)new CustomSheetWriteHandler(this.getUserExcelStyle()));
            ExcelExportDesc exportDesc = new ExcelExportDesc();
            exportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateTimeStr();
            exportDesc.setExportTime(exportTime);
            ArrayList<ExcelExportDesc> exportDescs = new ArrayList<ExcelExportDesc>();
            exportDescs.add(exportDesc);
            ClassSheetMsg classSheetDescMsg = new ClassSheetMsg(ExcelExportDesc.class, exportDescs, "\u5bfc\u51fa\u63cf\u8ff0", 1);
            try {
                ExcelProduct excelProduct = new ConcreteExcelBuilder("\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f" + Java8DateUtils.getCurrentDateDTimeStr() + ".xlsx", taskId, this.hussarBaseExcelServiceImpl).makeClassSheet(classSheetMsg).makeClassSheet(classSheetDescMsg).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void exportUserExcelWithSecurity(String ids, Long taskId, boolean exportKey, String securityLevel) {
        AssertUtil.isNotEmpty((String)StringUtil.trimToEmpty((CharSequence)ids), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        AssertUtil.isNotNull((Object)securityUser, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_CURRENT_LOGIN_USER.getMessage()));
        Long[] struIds = (Long[])ConvertUtils.convert((String[])ids.split(","), Long.class);
        List<Long> struIdList = Arrays.asList(struIds);
        List struUserList = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList));
        ArrayList userExcels = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)struUserList)) {
            List<Long> userIdList = struUserList.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
            Map<Long, String> userOrganMap = this.getOrganInfos(userIdList);
            LambdaQueryWrapper multiQueryWrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, userIdList).orderByAsc(SysUsers::getUserOrder);
            List users = this.sysUsersMapper.selectList((Wrapper)multiQueryWrapper);
            List staffIds = users.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
            LambdaQueryWrapper multiStaffQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getId, staffIds);
            List staffs = this.sysStaffService.list((Wrapper)multiStaffQueryWrapper);
            Map<Long, SysStaff> staffMap = staffs.stream().collect(Collectors.toMap(SysStaff::getId, s -> s));
            List dicVos = this.sysDicRefService.getDicListByType("staff_position");
            Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
            List securityLevels = this.sysDicRefService.getDicListByType(USER_SECURITY_LEVEL);
            Map<String, String> securityLevelMaps = securityLevels.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            users.forEach(u -> {
                SysStaff staff;
                UserExcel userExcel = new UserExcel();
                userExcel.setDepartment((String)userOrganMap.get(u.getId()));
                BeanUtil.copyProperties((Object)u, (Object)userExcel);
                userExcel.setMail(u.geteMail());
                userExcel.setUserOrder(String.valueOf(u.getUserOrder()));
                userExcel.setMaxSessions(String.valueOf(u.getMaxSessions()));
                if (HussarUtils.equals((Object)"0", (Object)u.getTypeProperty())) {
                    userExcel.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getStartTime()));
                    userExcel.setExpiredTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getExpiredTime()));
                }
                if (HussarUtils.isNotEmpty((Object)keyList) && keyList.contains(String.valueOf(u.getId()))) {
                    userExcel.setAccountStatus(UserStatus.LOCKED.getCode());
                }
                if (HussarUtils.isNotEmpty((Object)(staff = (SysStaff)staffMap.get(u.getEmployeeId())).getStaffPosition())) {
                    staff.setStaffPosition((String)dicMap.get(staff.getStaffPosition()));
                }
                if (HussarUtils.isNotEmpty((Object)u.getSecurityLevel())) {
                    userExcel.setSecurityLevelName((String)securityLevelMaps.get(String.valueOf(u.getSecurityLevel())));
                }
                BeanUtil.copyProperties((Object)staff, (Object)userExcel);
                if (exportKey) {
                    userExcel.setUserId(String.valueOf(u.getId()));
                }
                userExcels.add(userExcel);
            });
        }
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            ClassSheetMsg classSheetMsg = new ClassSheetMsg(UserExcel.class, userExcels, "\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f", 0);
            if (!exportKey) {
                classSheetMsg.setExcludeColumnIndexes(Collections.singletonList(25));
            }
            classSheetMsg.addHandler((WriteHandler)new DataValidationSheetWriteHandler(this.getUserExcelOptions()));
            classSheetMsg.addHandler((WriteHandler)new CustomSheetWriteHandler(this.getUserExcelStyle()));
            ExcelExportDesc exportDesc = new ExcelExportDesc();
            exportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateTimeStr();
            exportDesc.setExportTime(exportTime);
            ArrayList<ExcelExportDesc> exportDescs = new ArrayList<ExcelExportDesc>();
            exportDescs.add(exportDesc);
            ClassSheetMsg classSheetDescMsg = new ClassSheetMsg(ExcelExportDesc.class, exportDescs, "\u5bfc\u51fa\u63cf\u8ff0", 1);
            try {
                String excelFileName = "\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f" + Java8DateUtils.getCurrentDateDTimeStr() + ".xlsx";
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue() && HussarUtils.isNotEmpty((Object)securityLevel)) {
                    String securityLabel = this.sysDicRefService.getDictLabel(SECURITY_LEVEL, securityLevel);
                    if (HussarUtils.isEmpty((Object)securityLabel)) {
                        securityLabel = "\u672a\u786e\u5b9a\u5bc6\u7ea7";
                    }
                    excelFileName = "\uff08" + securityLabel + "\uff09-" + excelFileName;
                }
                ExcelProduct excelProduct = new ConcreteExcelBuilder(excelFileName, taskId, this.hussarBaseExcelServiceImpl).makeClassSheet(classSheetMsg).makeClassSheet(classSheetDescMsg).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void exportUserExcelWithSecurityForBigDate(List<String> idList, Long taskId, Boolean exportKey, String securityLevel, Boolean isAssociateSub) {
        AssertUtil.isNotEmpty(idList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        AssertUtil.isNotNull((Object)securityUser, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_CURRENT_LOGIN_USER.getMessage()));
        List idListL = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            List<Object> realIdList = new ArrayList();
            realIdList = Boolean.TRUE.equals(isAssociateSub) ? this.getAllSubOrgIdList(idListL) : idListL;
            List struUserList = this.sysStruUserMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, realIdList));
            ArrayList userExcels = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)struUserList)) {
                List<Long> userIdList = struUserList.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
                Map<Long, String> userOrganMap = this.getOrganInfos(userIdList);
                List userIdListSplit = LambdaQueryUtil.getSplitListLt(userIdList, (int)SPLIT_LT);
                ArrayList users = new ArrayList();
                for (int i = 0; i < userIdListSplit.size(); ++i) {
                    List longs = (List)userIdListSplit.get(i);
                    LambdaQueryWrapper sysUsersQu = new LambdaQueryWrapper();
                    sysUsersQu.in(SysUsers::getId, (Collection)longs);
                    List sysUsers = this.sysUsersMapper.selectList((Wrapper)sysUsersQu);
                    if (HussarUtils.isNotEmpty((Object)sysUsers)) {
                        users.addAll(sysUsers);
                    }
                    logger.info("\u5206\u5272\u67e5\u8be2\u7528\u6237\u4fe1\u606f\uff0c\u5f53\u524d\u67e5\u8be2\u6b21\u6570\uff1a{}", (Object)i);
                }
                List staffIds = users.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                ArrayList staffs = new ArrayList();
                List staffIdsSplit = LambdaQueryUtil.getSplitListLt(staffIds, (int)SPLIT_LT);
                for (int i = 0; i < staffIdsSplit.size(); ++i) {
                    List longs = (List)staffIdsSplit.get(i);
                    LambdaQueryWrapper sysStaffQu = new LambdaQueryWrapper();
                    sysStaffQu.in(SysStaff::getId, (Collection)longs);
                    List list = this.sysStaffService.list((Wrapper)sysStaffQu);
                    if (HussarUtils.isNotEmpty((Object)list)) {
                        staffs.addAll(list);
                    }
                    logger.info("\u5206\u5272\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\uff0c\u5f53\u524d\u67e5\u8be2\u6b21\u6570\uff1a{}", (Object)i);
                }
                Map<Long, SysStaff> staffMap = staffs.stream().collect(Collectors.toMap(SysStaff::getId, s -> s));
                List dicVos = this.sysDicRefService.getDicListByType("staff_position");
                Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
                List securityLevels = this.sysDicRefService.getDicListByType(USER_SECURITY_LEVEL);
                Map<String, String> securityLevelMaps = securityLevels.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
                List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
                users.forEach(u -> {
                    SysStaff staff;
                    UserExcel userExcel = new UserExcel();
                    userExcel.setDepartment((String)userOrganMap.get(u.getId()));
                    BeanUtil.copyProperties((Object)u, (Object)userExcel);
                    userExcel.setMail(u.geteMail());
                    userExcel.setUserOrder(String.valueOf(u.getUserOrder()));
                    userExcel.setMaxSessions(String.valueOf(u.getMaxSessions()));
                    if (HussarUtils.equals((Object)"0", (Object)u.getTypeProperty())) {
                        userExcel.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getStartTime()));
                        userExcel.setExpiredTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)u.getExpiredTime()));
                    }
                    if (HussarUtils.isNotEmpty((Object)keyList) && keyList.contains(String.valueOf(u.getId()))) {
                        userExcel.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                    if (HussarUtils.isNotEmpty((Object)(staff = (SysStaff)staffMap.get(u.getEmployeeId())).getStaffPosition())) {
                        staff.setStaffPosition((String)dicMap.get(staff.getStaffPosition()));
                    }
                    if (HussarUtils.isNotEmpty((Object)u.getSecurityLevel())) {
                        userExcel.setSecurityLevelName((String)securityLevelMaps.get(String.valueOf(u.getSecurityLevel())));
                    }
                    BeanUtil.copyProperties((Object)staff, (Object)userExcel);
                    if (exportKey.booleanValue()) {
                        userExcel.setUserId(String.valueOf(u.getId()));
                    }
                    userExcels.add(userExcel);
                });
            }
            ClassSheetMsg classSheetMsg = new ClassSheetMsg(UserExcel.class, userExcels, "\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f", 0);
            if (!exportKey.booleanValue()) {
                classSheetMsg.setExcludeColumnIndexes(Collections.singletonList(25));
            }
            classSheetMsg.addHandler((WriteHandler)new DataValidationSheetWriteHandler(this.getUserExcelOptions()));
            classSheetMsg.addHandler((WriteHandler)new CustomSheetWriteHandler(this.getUserExcelStyle()));
            ExcelExportDesc exportDesc = new ExcelExportDesc();
            exportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateTimeStr();
            exportDesc.setExportTime(exportTime);
            ArrayList<ExcelExportDesc> exportDescs = new ArrayList<ExcelExportDesc>();
            exportDescs.add(exportDesc);
            ClassSheetMsg classSheetDescMsg = new ClassSheetMsg(ExcelExportDesc.class, exportDescs, "\u5bfc\u51fa\u63cf\u8ff0", 1);
            try {
                String excelFileName = "\u7528\u6237\u4eba\u5458\u5bfc\u51fa\u4fe1\u606f" + Java8DateUtils.getCurrentDateDTimeStr() + ".xlsx";
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue() && HussarUtils.isNotEmpty((Object)securityLevel)) {
                    String securityLabel = this.sysDicRefService.getDictLabel(SECURITY_LEVEL, securityLevel);
                    if (HussarUtils.isEmpty((Object)securityLabel)) {
                        securityLabel = "\u672a\u786e\u5b9a\u5bc6\u7ea7";
                    }
                    excelFileName = "\uff08" + securityLabel + "\uff09-" + excelFileName;
                }
                ExcelProduct excelProduct = new ConcreteExcelBuilder(excelFileName, taskId, this.hussarBaseExcelServiceImpl).makeClassSheet(classSheetMsg).makeClassSheet(classSheetDescMsg).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void exportUserExcelWithSub(String ids, Long taskId, boolean exportKey) throws Exception {
        AssertUtil.isNotEmpty((String)StringUtil.trimToEmpty((CharSequence)ids), (String)"\u53c2\u6570\u4e3a\u7a7a");
        Long[] struIds = (Long[])ConvertUtils.convert((String[])ids.split(","), Long.class);
        HashSet<Long> allIdList = new HashSet<Long>();
        List<Long> struIdList = Arrays.asList(struIds);
        List<Long> subOrganIdList = this.getAllSubOrgIdList(struIdList);
        allIdList.addAll(struIdList);
        allIdList.addAll(subOrganIdList);
        String idsWithSub = StringUtil.join(allIdList, (String)",");
        this.exportUserExcel(idsWithSub, taskId, exportKey);
    }

    private List<Long> getAllSubOrgIdList(List<Long> struIdList) {
        logger.info("\u5f00\u59cb\u6267\u884cgetAllSubOrgIdList()\u65b9\u6cd5");
        LambdaQueryWrapper eq = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStru::getId, struIdList).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0'));
        List list = this.sysStruMapper.selectList((Wrapper)eq);
        List fidList = list.stream().map(SysStru::getStruFid).distinct().collect(Collectors.toList());
        List splitListLt = LambdaQueryUtil.getSplitListLt(fidList, (int)SPLIT_LT_OR);
        ArrayList sysStrus = new ArrayList();
        for (int i = 0; i < splitListLt.size(); ++i) {
            List strings = (List)splitListLt.get(i);
            if (!HussarUtils.isNotEmpty((Object)strings)) continue;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String fid : strings) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
            }
            List splitQuList = this.sysStruMapper.selectList((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
            if (HussarUtils.isNotEmpty((Object)splitQuList)) {
                sysStrus.addAll(splitQuList);
            }
            logger.info("\u6267\u884cgetAllSubOrgIdList()\u65b9\u6cd5\uff0c\u5f53\u524d\u4e3a\u7b2c{}\u6b21\u5faa\u73af\uff0c\u67e5\u8be2\u7ed3\u679c\u4e2a\u6570\uff1a{}", (Object)i, (Object)splitQuList.size());
        }
        return sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
    }

    private Map<Integer, Short> getUserExcelStyle() {
        HashMap<Integer, Short> styleMap = new HashMap<Integer, Short>();
        styleMap.put(UserExcelEnum.USER_ACCOUNT.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.USER_NAME.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.WORK_ID.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.WECHAT.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.START_TIME.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.EXPIRED_TIME.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.STAFF_CODE.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.ID_CARD.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.BIRTHDAY.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.ADDRESS.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.WORK_DATE.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.GRADUATE_DATE.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.GRADUATE_SCHOOL.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.REMARK.getIndex(), (short)49);
        styleMap.put(UserExcelEnum.USER_ID.getIndex(), (short)49);
        return styleMap;
    }

    private Map<Long, String> getOrganInfos(List<Long> userIdList) {
        if (HussarUtils.isEmpty(userIdList)) {
            return new HashMap<Long, String>();
        }
        List splitListLt = LambdaQueryUtil.getSplitListLt(userIdList, (int)SPLIT_LT);
        ArrayList<UserOrganPostVo> organByUserIds = new ArrayList<UserOrganPostVo>();
        for (int i = 0; i < splitListLt.size(); ++i) {
            List longs = (List)splitListLt.get(i);
            logger.info("\u5f00\u59cb\u6267\u884c\u67e5\u8be2getOrganInfos\u65b9\u6cd5");
            List<UserOrganPostVo> users = this.sysStruUserMapper.getOrganByUserIdsForBigDate(longs, null);
            logger.info("getOrganInfos\u65b9\u6cd5\uff0c\u6267\u884cgetOrganByUserIdsForBigDate\u67e5\u8be2\uff0c\u5f53\u524d\u4e3a\u7b2c{}\u6b21\u5faa\u73af\uff0c\u8fd4\u56de\u4e2a\u6570\uff1a{}", (Object)i, (Object)(HussarUtils.isEmpty(users) ? 0 : users.size()));
            if (!HussarUtils.isNotEmpty(users)) continue;
            organByUserIds.addAll(users);
        }
        return organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId, Collectors.mapping(UserOrganPostVo::getOrganFname, Collectors.joining(","))));
    }

    @Override
    public Map<Integer, List<String>> getUserExcelOptions() {
        HashMap<Integer, List<String>> selectParamMap = new HashMap<Integer, List<String>>();
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        selectParamMap.put(UserExcelEnum.STAFF_POSITION.getIndex(), dicVos.stream().map(DicVo::getLabel).collect(Collectors.toList()));
        selectParamMap.put(UserExcelEnum.SEX.getIndex(), Arrays.stream(GenderEnum.values()).map(GenderEnum::getDescription).collect(Collectors.toList()));
        List<String> status = Arrays.asList(UserStatus.OK.getMessage(), UserStatus.DORMANCY.getMessage());
        selectParamMap.put(UserExcelEnum.ACCOUNT_STATUS.getIndex(), status);
        selectParamMap.put(UserExcelEnum.TYPE_PROPERTY.getIndex(), Arrays.stream(AccountTypeEnum.values()).map(AccountTypeEnum::getDescription).collect(Collectors.toList()));
        List securityLevels = this.sysDicRefService.getDicListByType(USER_SECURITY_LEVEL);
        selectParamMap.put(UserExcelEnum.SECURITY_LEVEL.getIndex(), securityLevels.stream().map(DicVo::getLabel).collect(Collectors.toList()));
        return selectParamMap;
    }
}

