/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruStaffMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonOutsideOrganizationManager {
    @Autowired
    protected ISysOrganService organService;
    @Autowired
    protected ISysOrganTypeService organTypeService;
    @Autowired
    protected ISysOfficeService sysOfficeService;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysOrganMapper sysOrganMapper;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Resource
    protected SysUserRoleMapper sysUserRoleMapper;
    @Resource
    protected SysStaffMapper sysStaffMapper;
    @Autowired
    protected ISysStruService struService;
    @Autowired
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    protected AddOrganizationManager addOrganizationManager;
    @Resource
    protected SysStruRuleMapper sysStruRuleMapper;
    @Resource
    protected SysStruUserMapper sysStruUserMapper;
    @Resource
    protected SysStruPostMapper sysStruPostMapper;
    @Resource
    protected SysStruRoleMapper sysStruRoleMapper;
    @Resource
    protected SysStruStaffMapper sysStruStaffMapper;
    @Resource
    protected SysUserPostMapper sysUserPostMapper;

    protected Long getOrganId(String organCode) {
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            return Constants.ROOT_NODE_ID;
        }
        if (organCode.equals(String.valueOf(Constants.ROOT_NODE_ID))) {
            return Constants.ROOT_NODE_ID;
        }
        if (organCode.equals(String.valueOf(Constants.OUT_STRU_NODE_ID))) {
            return Constants.OUT_STRU_NODE_ID;
        }
        SysOrgan sysOrganTemp = (SysOrgan)this.organService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode)));
        AssertUtil.isNotNull((Object)sysOrganTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORGAN_NOT_FOUND.getMessage()));
        SysStru sysStruTemp = (SysStru)this.struService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrganTemp.getId()));
        AssertUtil.isNotNull((Object)sysStruTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PARENT_ORGAN_NOT_FOUND.getMessage()));
        return sysStruTemp.getId();
    }

    protected Long getUserId(String userAccount) {
        if (HussarUtils.isBlank((CharSequence)userAccount)) {
            return null;
        }
        String userAccountTemp = userAccount;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            userAccountTemp = userAccountTemp.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccountTemp)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()));
        AssertUtil.isNotNull((Object)sysUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        return sysUsers.getId();
    }

    protected String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.sysStruMapper.getMaxStruSeq(pFid, level);
        if (HussarUtils.isBlank((CharSequence)maxStruSeq)) {
            return pSeq + "/0001";
        }
        return this.getStruSeqByMaxStruSeq(maxStruSeq, pSeq, level);
    }

    protected String getStruSeqByMaxStruSeq(String maxStruSeq, String pSeq, int level) {
        String struSeq = "";
        String[] arr = maxStruSeq.split("/");
        if (StringUtils.isNotBlank((CharSequence)pSeq)) {
            int len = arr.length - 1;
            if (len < level) {
                StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                for (int i = 0; i < level - len; ++i) {
                    stringBuilder.append("/0001");
                }
                struSeq = stringBuilder.toString();
            } else {
                struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf("/")) + "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        } else {
            struSeq = "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
        }
        return struSeq;
    }

    protected Map<Long, String> getSubStruIdsByStruFids(List<String> struFids) {
        if (HussarUtils.isEmpty(struFids)) {
            return new HashMap<Long, String>();
        }
        List<SysStru> strus = this.sysStruMapper.getSubStruIdsByStruFids(struFids);
        return strus.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getStruFid));
    }

    protected Map<Long, List<Long>> getChildByStruFids(List<String> struFids, Map<Long, String> struMap) {
        if (HussarUtils.isEmpty(struFids)) {
            return new HashMap<Long, List<Long>>();
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        for (String struFid : struFids) {
            ArrayList<Long> list = new ArrayList<Long>();
            Long id = null;
            for (Map.Entry<Long, String> entry : struMap.entrySet()) {
                Long struId = entry.getKey();
                String fid = entry.getValue();
                if (fid.startsWith(struFid)) {
                    list.add(struId);
                }
                if (!fid.equals(struFid)) continue;
                id = struId;
            }
            if (!HussarUtils.isNotEmpty(id)) continue;
            result.put(id, list);
        }
        return result;
    }

    protected Map<Long, List<Long>> getUserStruMap(List<SysStruUser> struUsers) {
        HashMap<Long, List<Long>> userStruMap = new HashMap<Long, List<Long>>();
        if (HussarUtils.isNotEmpty(struUsers)) {
            for (SysStruUser struUser : struUsers) {
                List<Long> ids;
                Long struId = struUser.getStruId();
                Long userId = struUser.getUserId();
                if (HussarUtils.isEmpty(userStruMap.get(userId))) {
                    ids = new ArrayList<Long>();
                    ids.add(struId);
                    userStruMap.put(userId, ids);
                    continue;
                }
                ids = (List)userStruMap.get(userId);
                ids.add(struId);
            }
        }
        return userStruMap;
    }

    protected Map<Long, List<Long>> getStaffStruMap(List<SysStruStaff> struStaffs) {
        HashMap<Long, List<Long>> staffStruMap = new HashMap<Long, List<Long>>();
        if (HussarUtils.isNotEmpty(struStaffs)) {
            for (SysStruStaff struStaff : struStaffs) {
                List<Long> ids;
                Long struId = struStaff.getStruId();
                Long staffId = struStaff.getStaffId();
                if (HussarUtils.isEmpty(staffStruMap.get(staffId))) {
                    ids = new ArrayList<Long>();
                    ids.add(struId);
                    staffStruMap.put(staffId, ids);
                    continue;
                }
                ids = (List)staffStruMap.get(staffId);
                ids.add(struId);
            }
        }
        return staffStruMap;
    }

    protected void refreshStruSeq() {
        List strus = this.sysStruMapper.selectList(null);
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)organsEntity.getParentId()) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)organsEntity.getParentId())).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
        this.struService.updateBatchById((Collection)strus);
    }

    private void setInfo(SysStru root, List<SysStru> strus) {
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(stru -> HussarUtils.equals((Object)stru.getParentId(), (Object)root.getId())).sorted(Comparator.comparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            this.setInfo((SysStru)stru, strus);
            return stru;
        }).collect(Collectors.toList());
    }
}

