/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.adapter.role.IHussarBaseRoleAdapter;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.publish.constant.PublishConstant;
import com.jxdinfo.hussar.authorization.publishrecord.model.SysPublishRecord;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.model.ApiResourceDTO;
import com.jxdinfo.hussar.formdesign.publish.model.ModuleNode;
import com.jxdinfo.hussar.formdesign.publish.model.PageResourceDTO;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.formdesign.publish.model.ResultDTO;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class ResourcePublishServiceImpl
implements ResourcePublishService {
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysPublishRecordService sysPublishRecordService;
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Resource
    private IHussarBaseRoleAdapter hussarBaseRoleAdapter;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Value(value="${hussar-formdesign.menu-role:\u8d85\u7ea7\u7ba1\u7406\u5458}")
    private String menuRole;
    @Value(value="${hussar-formdesign.menu-role-group:}")
    private String menuRoleGroup;

    @CacheEvict(value={"menu_info"}, allEntries=true)
    public boolean deleteMenu(String sourceId) {
        SysPublishRecord publishRecord = (SysPublishRecord)this.sysPublishRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPublishRecord::getSourceId, (Object)sourceId));
        if (ToolUtil.isEmpty((Object)publishRecord)) {
            return true;
        }
        Long menuId = publishRecord.getMenuId();
        if (ToolUtil.isNotEmpty((Object)menuId)) {
            return this.sysMenuManageService.removeById((Serializable)menuId);
        }
        return true;
    }

    @CacheEvict(value={"resource_info"}, allEntries=true)
    @HussarTransactional
    public boolean publishResource(PublishDTO publishDTO) {
        PageResourceDTO pageResourceDTO = publishDTO.getPage();
        List resourceDTOList = publishDTO.getApis();
        String extensionId = publishDTO.getExtensionId();
        if (ToolUtil.isNotEmpty((Object)pageResourceDTO)) {
            this.savePageResource(pageResourceDTO, extensionId);
        }
        if (ToolUtil.isNotEmpty((Object)resourceDTOList)) {
            this.saveApiResource(resourceDTOList, extensionId);
        }
        return true;
    }

    private void savePageResource(PageResourceDTO pageResourceDTO, String extensionId) {
        List allModules = this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getApplicationId, (Object)1L)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        Map<Long, SysResourceModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, Function.identity()));
        String sourceId = pageResourceDTO.getPageId();
        if (ToolUtil.isEmpty((Object)sourceId)) {
            return;
        }
        SysPublishRecord publishRecord = (SysPublishRecord)this.sysPublishRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPublishRecord::getSourceId, (Object)sourceId));
        SysResources sysResources = this.getResourceByRecord(publishRecord);
        if (ToolUtil.isNotEmpty((Object)sysResources)) {
            ModuleNode moduleNode = pageResourceDTO.getModuleNode();
            this.updateResourceAndModule(pageResourceDTO, extensionId, sysResources, moduleNode, allModules, moduleMap);
        } else {
            ModuleNode moduleNode = pageResourceDTO.getModuleNode();
            sysResources = this.createPageResourceAndModule(moduleNode, null, pageResourceDTO, extensionId, allModules);
        }
        if (ToolUtil.isNotEmpty((Object)sysResources)) {
            if (ToolUtil.isEmpty((Object)publishRecord)) {
                publishRecord = new SysPublishRecord();
                publishRecord.setSourceId(sourceId);
                publishRecord.setSourceType("0");
                publishRecord.setResourceId(sysResources.getId());
            } else {
                publishRecord.setResourceId(sysResources.getId());
            }
            this.sysPublishRecordService.saveOrUpdate((Object)publishRecord);
            this.saveResourceRelations(publishRecord, sysResources.getId());
        }
    }

    private <T> void updateResourceAndModule(T resourceDTO, String extensionId, SysResources sysResources, ModuleNode moduleNode, List<SysResourceModules> allModules, Map<Long, SysResourceModules> moduleMap) {
        Long moduleId = sysResources.getModuleId();
        String fullName = this.getFullModuleNameById(moduleMap, moduleId);
        HashMap<String, String> map = new HashMap<String, String>();
        this.getModuleChNameMap(moduleNode, map);
        String fullModuleChName = (String)map.get("fullModuleChName");
        if (HussarUtils.equals((Object)fullModuleChName, (Object)fullName)) {
            this.updateResource(resourceDTO, sysResources, extensionId);
        } else {
            String moduleChName = (String)map.get("moduleChName");
            Map<Object, Object> fullNameMap = new HashMap();
            if (ToolUtil.isNotEmpty((Object)moduleChName)) {
                fullNameMap = this.getFullModuleNameMapByName(allModules, moduleMap, moduleChName);
            }
            ArrayList moduleIds = new ArrayList();
            fullNameMap.entrySet().stream().filter(entry -> HussarUtils.equals((Object)fullModuleChName, entry.getValue())).forEach(entry -> moduleIds.add(entry.getKey()));
            if (HussarUtils.isNotEmpty(moduleIds)) {
                sysResources.setModuleId((Long)moduleIds.get(0));
                this.updateResource(resourceDTO, sysResources, extensionId);
            } else {
                this.createModuleAndUpdateResource(moduleNode, null, resourceDTO, extensionId, sysResources, allModules);
            }
        }
    }

    private <T> void updateResource(T resourceDTO, SysResources sysResources, String extensionId) {
        if (resourceDTO instanceof PageResourceDTO) {
            this.updatePageResource((PageResourceDTO)resourceDTO, sysResources, extensionId);
        }
        if (resourceDTO instanceof ApiResourceDTO) {
            this.updateApiResource((ApiResourceDTO)resourceDTO, sysResources, extensionId);
        }
    }

    public String getFullModuleNameById(Map<Long, SysResourceModules> moduleMap, Long moduleId) {
        SysResourceModules module = moduleMap.get(moduleId);
        StringBuilder fullName = new StringBuilder();
        this.getFullName(moduleMap, module, fullName);
        CharSequence[] parts = fullName.toString().split("/");
        Collections.reverse(Arrays.asList(parts));
        return String.join((CharSequence)"/", parts);
    }

    public Map<Long, String> getFullModuleNameMapByName(List<SysResourceModules> allModules, Map<Long, SysResourceModules> moduleMap, String moduleName) {
        List modules = allModules.stream().filter(item -> item.getModuleName().equals(moduleName)).collect(Collectors.toList());
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (SysResourceModules module : modules) {
            StringBuilder fullName = new StringBuilder();
            this.getFullName(moduleMap, module, fullName);
            CharSequence[] parts = fullName.toString().split("/");
            Collections.reverse(Arrays.asList(parts));
            String finalFullName = String.join((CharSequence)"/", parts);
            result.put(module.getId(), finalFullName);
        }
        return result;
    }

    private void getFullName(Map<Long, SysResourceModules> moduleMap, SysResourceModules module, StringBuilder fullName) {
        fullName.append(module.getModuleName()).append("/");
        Long parentModuleId = module.getParentModuleId();
        if (!HussarUtils.equals((Object)parentModuleId, (Object)1L)) {
            SysResourceModules parentModule = moduleMap.get(parentModuleId);
            this.getFullName(moduleMap, parentModule, fullName);
        }
    }

    private void getModuleChNameMap(ModuleNode moduleNode, Map<String, String> map) {
        String fullModuleChName = HussarUtils.isBlank((CharSequence)map.get("fullModuleChName")) ? "" : map.get("fullModuleChName");
        String moduleChName = moduleNode.getModuleChName();
        fullModuleChName = fullModuleChName + "/" + moduleChName;
        if (HussarUtils.isEmpty((Object)moduleNode.getChild())) {
            map.put("moduleChName", moduleChName);
            map.put("fullModuleChName", fullModuleChName);
        } else {
            map.put("fullModuleChName", fullModuleChName);
            this.getModuleChNameMap(moduleNode.getChild(), map);
        }
    }

    private void getModuleChNameMapForFunction(ModuleNode moduleNode, Map<String, String> map) {
        String fullModuleChName = HussarUtils.isBlank((CharSequence)map.get("fullModuleChName")) ? "" : map.get("fullModuleChName");
        String moduleChName = moduleNode.getModuleChName();
        fullModuleChName = fullModuleChName + "/" + moduleChName;
        if (HussarUtils.isNotEmpty((Object)moduleNode.getChild())) {
            map.put("moduleChName", moduleChName);
            map.put("fullModuleChName", fullModuleChName);
            this.getModuleChNameMapForFunction(moduleNode.getChild(), map);
        }
    }

    private void updatePageResource(PageResourceDTO pageResourceDTO, SysResources sysResources, String extensionId) {
        this.copyPropertyToPageResource(pageResourceDTO, sysResources);
        sysResources.setServiceName(extensionId);
        this.sysResourcesService.updateById((Object)sysResources);
    }

    private SysResources createPageResourceAndModule(ModuleNode moduleNode, Long parentId, PageResourceDTO pageResourceDTO, String extensionId, List<SysResourceModules> allModules) {
        ModuleNode child;
        String chName = moduleNode.getModuleChName();
        parentId = ToolUtil.isNotEmpty((Object)parentId) ? parentId : PublishConstant.DEFAULT_PARENT_ID;
        SysResourceModules resourceModules = null;
        for (SysResourceModules module : allModules) {
            String moduleName = module.getModuleName();
            Long parentModuleId = module.getParentModuleId();
            if (HussarUtils.isNotBlank((CharSequence)moduleNode.getModuleChName())) {
                if (!HussarUtils.equals((Object)moduleName, (Object)chName) || !HussarUtils.equals((Object)parentModuleId, (Object)parentId)) continue;
                resourceModules = module;
                break;
            }
            if (!HussarUtils.equals((Object)parentModuleId, (Object)parentId)) continue;
            resourceModules = module;
            break;
        }
        if (!ModuleNode.isEmpty((ModuleNode)(child = moduleNode.getChild()))) {
            if (HussarUtils.isEmpty(resourceModules)) {
                resourceModules = this.createResourceModule(chName, parentId);
            }
            if (ToolUtil.isNotEmpty(resourceModules)) {
                return this.createPageResourceAndModule(child, resourceModules.getId(), pageResourceDTO, extensionId, allModules);
            }
        } else {
            if (HussarUtils.isEmpty(resourceModules)) {
                resourceModules = this.createResourceModule(chName, parentId);
            }
            if (ToolUtil.isNotEmpty(resourceModules)) {
                return this.createPageResource(pageResourceDTO, resourceModules, extensionId);
            }
        }
        return null;
    }

    private <T> void createModuleAndUpdateResource(ModuleNode moduleNode, Long parentId, T resourceDTO, String extensionId, SysResources sysResources, List<SysResourceModules> allModules) {
        ModuleNode child;
        String chName = moduleNode.getModuleChName();
        parentId = ToolUtil.isNotEmpty((Object)parentId) ? parentId : PublishConstant.DEFAULT_PARENT_ID;
        SysResourceModules resourceModules = null;
        for (SysResourceModules module : allModules) {
            String moduleName = module.getModuleName();
            Long parentModuleId = module.getParentModuleId();
            if (HussarUtils.isNotBlank((CharSequence)moduleNode.getModuleChName())) {
                if (!HussarUtils.equals((Object)moduleName, (Object)chName) || !HussarUtils.equals((Object)parentModuleId, (Object)parentId)) continue;
                resourceModules = module;
                break;
            }
            if (!HussarUtils.equals((Object)parentModuleId, (Object)parentId)) continue;
            resourceModules = module;
            break;
        }
        if (!ModuleNode.isEmpty((ModuleNode)(child = moduleNode.getChild()))) {
            if (HussarUtils.isEmpty(resourceModules)) {
                resourceModules = this.createResourceModule(chName, parentId);
            }
            if (ToolUtil.isNotEmpty(resourceModules)) {
                this.createModuleAndUpdateResource(child, resourceModules.getId(), resourceDTO, extensionId, sysResources, allModules);
            }
        } else {
            if (HussarUtils.isEmpty(resourceModules)) {
                resourceModules = this.createResourceModule(chName, parentId);
            }
            if (ToolUtil.isNotEmpty(resourceModules)) {
                sysResources.setModuleId(resourceModules.getId());
                this.updateResource(resourceDTO, sysResources, extensionId);
            }
        }
    }

    private void copyPropertyToPageResource(PageResourceDTO pageResourceDTO, SysResources sysResources) {
        sysResources.setResourceName(pageResourceDTO.getPageLabel());
        sysResources.setResourceAlias(pageResourceDTO.getPageLabel());
        sysResources.setStrategy(String.valueOf(pageResourceDTO.getStrategy()));
        sysResources.setKeepAlive(pageResourceDTO.getKeepAlive() != false ? "1" : "0");
        sysResources.setPath(pageResourceDTO.getPath());
        sysResources.setResTypeId("res_menu");
        sysResources.setComponent(pageResourceDTO.getComponent());
    }

    private SysResources createPageResource(PageResourceDTO pageResourceDTO, SysResourceModules sysResourceModules, String extensionId) {
        SysResources sysResources = new SysResources();
        this.copyPropertyToPageResource(pageResourceDTO, sysResources);
        this.commonResourceProperties(sysResourceModules, sysResources, extensionId);
        if (HussarUtils.isEmpty((Object)sysResources.getId())) {
            sysResources.setId(Long.valueOf(IdWorker.getId((Object)new SysResources())));
        }
        if (this.sysResourcesService.save((Object)sysResources)) {
            return sysResources;
        }
        return null;
    }

    private void saveApiResource(List<ApiResourceDTO> resourceDTOList, String extensionId) {
        for (ApiResourceDTO resourceDTO : resourceDTOList) {
            List allModules = this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getApplicationId, (Object)1L)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
            }));
            Map<Long, SysResourceModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysResourceModules::getId, Function.identity()));
            this.saveEachApiResource(resourceDTO, extensionId, allModules, moduleMap);
        }
    }

    private void saveEachApiResource(ApiResourceDTO resourceDTO, String extensionId, List<SysResourceModules> allModules, Map<Long, SysResourceModules> moduleMap) {
        String sourceId = resourceDTO.getApiId();
        if (ToolUtil.isEmpty((Object)sourceId)) {
            return;
        }
        SysPublishRecord publishRecord = (SysPublishRecord)this.sysPublishRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPublishRecord::getSourceId, (Object)sourceId));
        SysResources sysResources = this.getResourceByRecord(publishRecord);
        if (ToolUtil.isNotEmpty((Object)sysResources)) {
            ModuleNode moduleNode = resourceDTO.getModuleNode();
            this.updateResourceAndModule(resourceDTO, extensionId, sysResources, moduleNode, allModules, moduleMap);
        } else {
            ModuleNode moduleNode = resourceDTO.getModuleNode();
            sysResources = this.createApiResourceAndModule(moduleNode, null, resourceDTO, extensionId, allModules);
        }
        if (ToolUtil.isNotEmpty((Object)sysResources)) {
            if (ToolUtil.isEmpty((Object)publishRecord)) {
                publishRecord = new SysPublishRecord();
                publishRecord.setSourceId(sourceId);
                publishRecord.setSourceType("1");
                publishRecord.setResourceId(sysResources.getId());
            } else {
                publishRecord.setResourceId(sysResources.getId());
            }
            this.sysPublishRecordService.saveOrUpdate((Object)publishRecord);
            this.saveResourceRelations(publishRecord, sysResources.getId());
        }
    }

    private void updateApiResource(ApiResourceDTO resourceDTO, SysResources sysResources, String extensionId) {
        this.copyPropertyToApiResource(resourceDTO, sysResources);
        sysResources.setServiceName(extensionId);
        this.sysResourcesService.updateById((Object)sysResources);
    }

    private SysResources createApiResourceAndModule(ModuleNode moduleNode, Long parentId, ApiResourceDTO resourceDTO, String extensionId, List<SysResourceModules> allModules) {
        ModuleNode child;
        String chName = moduleNode.getModuleChName();
        parentId = ToolUtil.isNotEmpty((Object)parentId) ? parentId : PublishConstant.DEFAULT_PARENT_ID;
        SysResourceModules resourceModules = null;
        for (SysResourceModules module : allModules) {
            String moduleName = module.getModuleName();
            Long parentModuleId = module.getParentModuleId();
            if (HussarUtils.isNotBlank((CharSequence)moduleNode.getModuleChName())) {
                if (!HussarUtils.equals((Object)moduleName, (Object)chName) || !HussarUtils.equals((Object)parentModuleId, (Object)parentId)) continue;
                resourceModules = module;
                break;
            }
            if (!HussarUtils.equals((Object)parentModuleId, (Object)parentId)) continue;
            resourceModules = module;
            break;
        }
        if (!ModuleNode.isEmpty((ModuleNode)(child = moduleNode.getChild()))) {
            if (HussarUtils.isEmpty(resourceModules)) {
                resourceModules = this.createResourceModule(chName, parentId);
            }
            if (ToolUtil.isNotEmpty(resourceModules)) {
                return this.createApiResourceAndModule(child, resourceModules.getId(), resourceDTO, extensionId, allModules);
            }
        } else {
            if (HussarUtils.isEmpty(resourceModules)) {
                resourceModules = this.createResourceModule(chName, parentId);
            }
            if (ToolUtil.isNotEmpty(resourceModules)) {
                return this.createApiResource(resourceDTO, resourceModules, extensionId);
            }
        }
        return null;
    }

    private SysResources createApiResource(ApiResourceDTO resourceDTO, SysResourceModules sysResourceModules, String extensionId) {
        SysResources sysResources = new SysResources();
        this.copyPropertyToApiResource(resourceDTO, sysResources);
        this.commonResourceProperties(sysResourceModules, sysResources, extensionId);
        if (this.sysResourcesService.save((Object)sysResources)) {
            return sysResources;
        }
        return null;
    }

    private void copyPropertyToApiResource(ApiResourceDTO resourceDTO, SysResources sysResources) {
        sysResources.setResourceName(resourceDTO.getApiLabel());
        sysResources.setResourceAlias(resourceDTO.getApiLabel());
        sysResources.setUrlNames(resourceDTO.getUrl());
        sysResources.setPermissions(resourceDTO.getPermissions());
        sysResources.setResTypeId("res_btn");
    }

    private SysResources getResourceByRecord(SysPublishRecord publishRecord) {
        SysResources sysResources = null;
        if (ToolUtil.isNotEmpty((Object)publishRecord) && ToolUtil.isNotEmpty((Object)publishRecord.getResourceId())) {
            sysResources = (SysResources)this.sysResourcesService.getById((Serializable)publishRecord.getResourceId());
        }
        return sysResources;
    }

    private SysResourceModules createResourceModule(String name, Long parentId) {
        SysResourceModules resourceModules = new SysResourceModules();
        resourceModules.setId(Long.valueOf(IdWorker.getId((Object)new SysResourceModules())));
        resourceModules.setModuleCode(this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_RESOURCE_MODULES"));
        resourceModules.setModuleName(name);
        resourceModules.setParentModuleId(parentId);
        resourceModules.setSeq(this.getMaxOrder(resourceModules));
        if (this.sysResourceMosulesService.save((Object)resourceModules)) {
            return resourceModules;
        }
        return null;
    }

    private void commonResourceProperties(SysResourceModules sysResourceModules, SysResources sysResources, String extensionId) {
        String currentCode = this.sysIdtableService.getCurrentCode("RESOURCE_CODE", "SYS_RESOURCES");
        sysResources.setResourceCode(sysResourceModules.getModuleCode() + currentCode);
        sysResources.setIsAudit("0");
        sysResources.setModuleId(sysResourceModules.getId());
        sysResources.setIsRepeatAuthenticate("0");
        sysResources.setSeq(this.getMaxOrder(sysResources));
        sysResources.setServiceName(extensionId);
    }

    private void saveResourceRelations(SysPublishRecord publishRecord, Long resourceId) {
        Long functionId = publishRecord.getFunctionId();
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            this.saveFunctionResource(functionId, resourceId, "0".equals(publishRecord.getSourceType()));
            this.associationRoleResource(resourceId);
        }
    }

    private void saveFunctionResource(Long functionId, Long resourceId, boolean isPage) {
        List functionResourcesList;
        SysFunctions sysFunctions;
        if (isPage && ToolUtil.isNotEmpty((Object)(sysFunctions = (SysFunctions)this.sysFunctionsService.getById((Serializable)functionId)))) {
            sysFunctions.setDefaultResourceId(resourceId);
            this.sysFunctionsService.updateById((Object)sysFunctions);
        }
        if (ToolUtil.isEmpty((Object)(functionResourcesList = this.sysFunctionResourcesService.listByFuncIdAndResId(functionId, resourceId)))) {
            SysFunctionResources functionResources = new SysFunctionResources();
            functionResources.setFunctionId(functionId);
            functionResources.setResourceId(resourceId);
            this.sysFunctionResourcesService.save((Object)functionResources);
        }
    }

    private void associationRoleResource(Long resourceId) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        List currentRoleResourceList = this.sysRoleResourceService.listByResIdAndRelationSource(resourceId, "1");
        List<Long> roleList = this.getRoleList();
        for (Long roleId : roleList) {
            boolean isExist = false;
            for (SysRoleResource roleResource : currentRoleResourceList) {
                if (!ToolUtil.isNotEmpty((Object)roleId) || !ToolUtil.isNotEmpty((Object)roleResource.getRoleId()) || roleId.longValue() != roleResource.getRoleId().longValue()) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setRelationSource("1");
            roleResourceList.add(sysRoleResource);
        }
        if (roleResourceList.size() > 0) {
            this.sysRoleResourceService.saveBatch(roleResourceList);
        }
    }

    private void associationRoleResourceBatch(List<Long> resourceIdList) {
        if (ToolUtil.isEmpty(resourceIdList)) {
            return;
        }
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        List currentRoleResourceList = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleResource::getResourceId, resourceIdList)).eq(SysRoleResource::getRelationSource, (Object)"1"));
        List<Long> roleList = this.getRoleList();
        for (Long roleId : roleList) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            for (Long resourceId : resourceIdList) {
                if (ToolUtil.isEmpty((Object)resourceId)) continue;
                boolean isExist = false;
                for (SysRoleResource rr : currentRoleResourceList) {
                    if (!ToolUtil.isNotEmpty((Object)rr.getRoleId()) || !ToolUtil.isNotEmpty((Object)rr.getResourceId()) || roleId.longValue() != rr.getRoleId().longValue() || resourceId.longValue() != rr.getResourceId().longValue()) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(roleId);
                sysRoleResource.setResourceId(resourceId);
                sysRoleResource.setRelationSource("1");
                roleResourceList.add(sysRoleResource);
            }
        }
        if (roleResourceList.size() > 0) {
            this.sysRoleResourceService.saveBatch(roleResourceList);
        }
    }

    private List<Long> getRoleList() {
        String[] roleName = ToolUtil.isNotEmpty((Object)this.menuRole) ? this.menuRole.split(",") : new String[]{};
        String[] groupId = ToolUtil.isNotEmpty((Object)this.menuRoleGroup) ? this.menuRoleGroup.split(",") : new String[]{};
        List roleList = this.hussarBaseRoleAdapter.getRoleIdByRoleName(Arrays.asList(roleName));
        if (ToolUtil.isNotEmpty((Object)groupId)) {
            List groupList = this.hussarBaseRoleAdapter.getRoleIdByGroupId(Arrays.asList(groupId));
            for (Long g : groupList) {
                boolean flag = false;
                for (Long r : roleList) {
                    if (!Objects.equals(g, r)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                roleList.add(g);
            }
        }
        if (!roleList.contains(SysUserAndRole.DEVELOP_ROLE.getValue())) {
            roleList.add(SysUserAndRole.DEVELOP_ROLE.getValue());
        }
        return roleList;
    }

    @CacheEvict(value={"menu_info"}, allEntries=true)
    public ResultDTO saveMenu(PublishDTO publishDTO) {
        PageResourceDTO pageResourceDTO = publishDTO.getPage();
        List resourceDTOList = publishDTO.getApis();
        ResultDTO resultDTO = new ResultDTO(true, "");
        String sourceId = pageResourceDTO.getPageId();
        if (ToolUtil.isEmpty((Object)sourceId)) {
            return resultDTO;
        }
        SysPublishRecord publishRecord = (SysPublishRecord)this.sysPublishRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPublishRecord::getSourceId, (Object)sourceId));
        SysFunctions sysFunctions = this.saveFunctionByRecord(pageResourceDTO, publishRecord);
        String msg = "";
        if (ToolUtil.isNotEmpty((Object)sysFunctions)) {
            publishRecord = this.saveFunctionRecord(pageResourceDTO, publishRecord, sysFunctions.getId());
            msg = this.saveFunctionRelations(publishRecord, resourceDTOList, sysFunctions.getId());
            resultDTO.setMsg(msg);
        }
        SysMenu sysMenu = this.saveMenuByRecord(pageResourceDTO, publishRecord);
        this.saveMenuRelation(sysMenu, sysFunctions, pageResourceDTO);
        return resultDTO;
    }

    private SysFunctions saveFunctionByRecord(PageResourceDTO pageResourceDTO, SysPublishRecord publishRecord) {
        SysFunctions sysFunctions = this.getFunctionByRecord(publishRecord);
        if (ToolUtil.isNotEmpty((Object)sysFunctions)) {
            String fullName = this.sysFunctionModulesService.getFullModuleNameById(sysFunctions.getFunctionModuleId(), null);
            HashMap<String, String> map = new HashMap<String, String>();
            this.getModuleChNameMapForFunction(pageResourceDTO.getModuleNode(), map);
            String fullModuleChName = (String)map.get("fullModuleChName");
            if (HussarUtils.equals((Object)fullModuleChName, (Object)fullName)) {
                this.updateFunction(pageResourceDTO, sysFunctions);
            } else {
                String moduleChName = (String)map.get("moduleChName");
                Map fullNameMap = this.sysFunctionModulesService.getFullModuleNameMapByName(moduleChName, null);
                ModuleNode moduleNode = pageResourceDTO.getModuleNode();
                ArrayList moduleIds = new ArrayList();
                fullNameMap.entrySet().stream().filter(entry -> HussarUtils.equals((Object)fullModuleChName, entry.getValue())).forEach(entry -> moduleIds.add(entry.getKey()));
                if (HussarUtils.isNotEmpty(moduleIds)) {
                    sysFunctions.setFunctionModuleId((Long)moduleIds.get(0));
                    this.updateFunction(pageResourceDTO, sysFunctions);
                } else {
                    this.createModuleAndUpdateFunction(moduleNode, null, pageResourceDTO, sysFunctions);
                }
            }
        } else {
            ModuleNode moduleNode = pageResourceDTO.getModuleNode();
            sysFunctions = this.createFunctionAndModule(moduleNode, null, pageResourceDTO);
        }
        return sysFunctions;
    }

    private SysPublishRecord saveFunctionRecord(PageResourceDTO pageResourceDTO, SysPublishRecord publishRecord, Long functionId) {
        if (ToolUtil.isEmpty((Object)publishRecord)) {
            publishRecord = new SysPublishRecord();
            publishRecord.setSourceId(pageResourceDTO.getPageId());
            publishRecord.setSourceType("0");
            publishRecord.setFunctionId(functionId);
        } else {
            publishRecord.setFunctionId(functionId);
        }
        this.sysPublishRecordService.saveOrUpdate((Object)publishRecord);
        return publishRecord;
    }

    private SysFunctions getFunctionByRecord(SysPublishRecord publishRecord) {
        SysFunctions sysFunctions = null;
        if (ToolUtil.isNotEmpty((Object)publishRecord) && ToolUtil.isNotEmpty((Object)publishRecord.getFunctionId())) {
            sysFunctions = (SysFunctions)this.sysFunctionsService.getById((Serializable)publishRecord.getFunctionId());
        }
        return sysFunctions;
    }

    private void updateFunction(PageResourceDTO pageResourceDTO, SysFunctions sysFunctions) {
        sysFunctions.setFunctionName(pageResourceDTO.getPageLabel());
        this.sysFunctionsService.updateById((Object)sysFunctions);
    }

    private SysFunctions createFunctionAndModule(ModuleNode moduleNode, Long parentId, PageResourceDTO pageResourceDTO) {
        String chName = moduleNode.getModuleChName();
        parentId = ToolUtil.isNotEmpty((Object)parentId) ? parentId : PublishConstant.DEFAULT_PARENT_ID;
        ModuleNode child = moduleNode.getChild();
        if (!ModuleNode.isEmpty((ModuleNode)child)) {
            SysFunctionModules functionModules = this.createFunctionModule(chName, parentId);
            if (ToolUtil.isNotEmpty((Object)functionModules)) {
                return this.createFunctionAndModule(child, functionModules.getId(), pageResourceDTO);
            }
        } else {
            return this.createFunction(pageResourceDTO, parentId);
        }
        return null;
    }

    private void createModuleAndUpdateFunction(ModuleNode moduleNode, Long parentId, PageResourceDTO pageResourceDTO, SysFunctions sysFunctions) {
        String chName = moduleNode.getModuleChName();
        parentId = ToolUtil.isNotEmpty((Object)parentId) ? parentId : PublishConstant.DEFAULT_PARENT_ID;
        ModuleNode child = moduleNode.getChild();
        if (!ModuleNode.isEmpty((ModuleNode)child)) {
            SysFunctionModules functionModules = this.createFunctionModule(chName, parentId);
            if (ToolUtil.isNotEmpty((Object)functionModules)) {
                this.createModuleAndUpdateFunction(child, functionModules.getId(), pageResourceDTO, sysFunctions);
            }
        } else {
            sysFunctions.setFunctionModuleId(parentId);
            this.updateFunction(pageResourceDTO, sysFunctions);
        }
    }

    private SysFunctionModules createFunctionModule(String name, Long parentId) {
        List functionModulesList = this.sysFunctionModulesService.listByNameAndParentId(name, parentId, null);
        if (ToolUtil.isNotEmpty((Object)functionModulesList)) {
            return (SysFunctionModules)functionModulesList.get(0);
        }
        SysFunctionModules functionModules = new SysFunctionModules();
        functionModules.setId(Long.valueOf(IdWorker.getId((Object)new SysFunctionModules())));
        functionModules.setFunctionModuleCode(this.sysIdtableService.getCurrentCode("FUNCTION_MODULE_CODE", "SYS_FUNCTION_MODULES"));
        functionModules.setFunctionModuleName(name);
        functionModules.setParentModuleId(parentId);
        functionModules.setSeq(this.getMaxOrder(functionModules));
        if (this.sysFunctionModulesService.save((Object)functionModules)) {
            return functionModules;
        }
        return null;
    }

    private SysFunctions createFunction(PageResourceDTO pageResourceDTO, Long parentId) {
        SysFunctions sysFunctions = new SysFunctions();
        sysFunctions.setFunctionName(pageResourceDTO.getPageLabel());
        String functionCode = this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
        sysFunctions.setFunctionModuleId(parentId);
        sysFunctions.setFunctionCode(functionCode);
        sysFunctions.setSeq(this.getMaxOrder(sysFunctions));
        if (HussarUtils.isEmpty((Object)sysFunctions.getId())) {
            sysFunctions.setId(Long.valueOf(IdWorker.getId((Object)new SysFunctions())));
        }
        if (this.sysFunctionsService.save((Object)sysFunctions)) {
            return sysFunctions;
        }
        return null;
    }

    private String saveFunctionRelations(SysPublishRecord publishRecord, List<ApiResourceDTO> resourceDTOList, Long functionId) {
        String msg = "";
        SysResources sysResources = null;
        if (ToolUtil.isNotEmpty((Object)publishRecord.getResourceId())) {
            sysResources = (SysResources)this.sysResourcesService.getById((Serializable)publishRecord.getResourceId());
        }
        if (ToolUtil.isNotEmpty(sysResources)) {
            this.saveFunctionResource(functionId, publishRecord.getResourceId(), "0".equals(publishRecord.getSourceType()));
            this.associationRoleResource(publishRecord.getResourceId());
        } else {
            msg = "\u672a\u53d1\u5e03\u8d44\u6e90";
        }
        this.saveFunctionApiResources(functionId, resourceDTOList);
        this.associationRoleFunction(functionId);
        return msg;
    }

    private void saveFunctionApiResources(Long functionId, List<ApiResourceDTO> resourceDTOList) {
        ArrayList sourceIdList = new ArrayList();
        resourceDTOList.forEach(r -> sourceIdList.add(r.getApiId()));
        List publishRecordList = new ArrayList();
        if (ToolUtil.isNotEmpty(sourceIdList)) {
            publishRecordList = this.sysPublishRecordService.list((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPublishRecord::getSourceId, sourceIdList));
        }
        ArrayList<Long> resourceIdList = new ArrayList<Long>();
        publishRecordList.forEach(pr -> {
            if (ToolUtil.isNotEmpty((Object)pr.getResourceId())) {
                resourceIdList.add(pr.getResourceId());
            }
        });
        if (ToolUtil.isEmpty(resourceIdList)) {
            return;
        }
        List functionResourcesList = this.sysFunctionResourcesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)functionId)).in(SysFunctionResources::getResourceId, resourceIdList));
        ArrayList<SysFunctionResources> addFunctionResourcesList = new ArrayList<SysFunctionResources>();
        for (Long resourceId : resourceIdList) {
            boolean isExist = false;
            for (SysFunctionResources functionResources : functionResourcesList) {
                if (resourceId.longValue() != functionResources.getResourceId().longValue()) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            SysFunctionResources functionResources = new SysFunctionResources();
            functionResources.setFunctionId(functionId);
            functionResources.setResourceId(resourceId);
            addFunctionResourcesList.add(functionResources);
        }
        this.associationRoleResourceBatch(resourceIdList);
        if (ToolUtil.isNotEmpty(addFunctionResourcesList)) {
            this.sysFunctionResourcesService.saveBatch(addFunctionResourcesList);
        }
    }

    private void associationRoleFunction(Long functionId) {
        ArrayList<SysRoleFunctions> roleFunctionsList = new ArrayList<SysRoleFunctions>();
        List currentRoleFunctionList = this.sysRoleFunctionsService.listByFunctionId(functionId);
        List<Long> roleList = this.getRoleList();
        for (Long roleId : roleList) {
            boolean isExist = false;
            for (SysRoleFunctions roleFunctions : currentRoleFunctionList) {
                if (roleId.longValue() != roleFunctions.getRoleId().longValue()) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
            sysRoleFunctions.setRoleId(roleId);
            sysRoleFunctions.setFunctionId(functionId);
            roleFunctionsList.add(sysRoleFunctions);
        }
        if (roleFunctionsList.size() > 0) {
            this.sysRoleFunctionsService.saveBatch(roleFunctionsList);
        }
    }

    private SysMenu saveMenuByRecord(PageResourceDTO pageResourceDTO, SysPublishRecord publishRecord) {
        SysMenu sysMenu = this.getMenuByRecord(publishRecord);
        if (ToolUtil.isNotEmpty((Object)sysMenu)) {
            this.updateMenu(pageResourceDTO, sysMenu);
        } else {
            ModuleNode moduleNode = pageResourceDTO.getModuleNode();
            sysMenu = this.createMenu(moduleNode, null, 0);
        }
        if (ToolUtil.isNotEmpty((Object)sysMenu)) {
            if (ToolUtil.isEmpty((Object)publishRecord)) {
                publishRecord = new SysPublishRecord();
                publishRecord.setSourceId(pageResourceDTO.getPageId());
                publishRecord.setSourceType("0");
                publishRecord.setMenuId(sysMenu.getId());
            } else {
                publishRecord.setMenuId(sysMenu.getId());
            }
            this.sysPublishRecordService.saveOrUpdate((Object)publishRecord);
        }
        return sysMenu;
    }

    private SysMenu getMenuByRecord(SysPublishRecord publishRecord) {
        SysMenu sysMenu = null;
        if (ToolUtil.isNotEmpty((Object)publishRecord) && ToolUtil.isNotEmpty((Object)publishRecord.getFunctionId())) {
            sysMenu = (SysMenu)this.sysMenuManageService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysMenu::getId, (Object)publishRecord.getMenuId()));
        }
        return sysMenu;
    }

    private void updateMenu(PageResourceDTO pageResourceDTO, SysMenu sysMenu) {
        sysMenu.setText(pageResourceDTO.getPageLabel());
        sysMenu.setMenuAlias(pageResourceDTO.getPageLabel());
        sysMenu.setPath(pageResourceDTO.getPath());
        sysMenu.setComponent(pageResourceDTO.getComponent());
        this.sysMenuManageService.updateById((Object)sysMenu);
    }

    private SysMenu createMenu(ModuleNode moduleNode, Long parentId, int level) {
        ++level;
        String chName = moduleNode.getModuleChName();
        parentId = ToolUtil.isNotEmpty((Object)parentId) ? parentId : PublishConstant.DEFAULT_PARENT_ID;
        ModuleNode child = moduleNode.getChild();
        if (!ModuleNode.isEmpty((ModuleNode)child)) {
            SysMenu parentMenu = this.createOneMenu(chName, parentId, false, level);
            if (ToolUtil.isNotEmpty((Object)parentMenu)) {
                return this.createMenu(child, parentMenu.getId(), level);
            }
        } else {
            return this.createOneMenu(chName, parentId, true, level);
        }
        return null;
    }

    private SysMenu createOneMenu(String name, Long parentId, boolean isLeaf, int level) {
        List menuList = this.sysMenuManageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getText, (Object)name)).eq(SysMenu::getParentId, (Object)parentId));
        if (ToolUtil.isNotEmpty((Object)menuList)) {
            return (SysMenu)menuList.get(0);
        }
        SysMenu sysMenu = new SysMenu();
        sysMenu.setOpenMode("0");
        sysMenu.setText(name);
        sysMenu.setMenuAlias(name);
        sysMenu.setMenuType("2");
        sysMenu.setParentId(parentId);
        sysMenu.setIsLeaf(isLeaf ? "1" : "0");
        sysMenu.setIcons("");
        sysMenu.setOpenType(isLeaf ? "inside" : "");
        sysMenu.setParentId(parentId);
        sysMenu.setSeq(this.getMaxOrder(sysMenu));
        switch (level) {
            case 1: {
                sysMenu.setIcons("caidan-1Jmoren");
                break;
            }
            case 2: {
                sysMenu.setIcons("caidan-2Jmoren");
                break;
            }
            case 3: {
                sysMenu.setIcons("caidan-3Jmoren");
                break;
            }
            default: {
                sysMenu.setIcons("caidan-3Jmoren");
            }
        }
        if (this.sysMenuManageService.save((Object)sysMenu)) {
            return sysMenu;
        }
        return null;
    }

    private void saveMenuRelation(SysMenu sysMenu, SysFunctions sysFunctions, PageResourceDTO pageResourceDTO) {
        if (ToolUtil.isNotEmpty((Object)sysFunctions) && ToolUtil.isNotEmpty((Object)sysMenu)) {
            sysMenu.setFunctionId(sysFunctions.getId());
            sysMenu.setPath(pageResourceDTO.getPath());
            sysMenu.setComponent(pageResourceDTO.getComponent());
            this.sysMenuManageService.updateById((Object)sysMenu);
        }
    }

    private <T> Integer getMaxOrder(T entity) {
        Integer max = null;
        if (entity instanceof SysResourceModules) {
            max = this.sysResourceMosulesService.getMaxOrderByParentIdAndAppId(((SysResourceModules)entity).getParentModuleId(), Long.valueOf(1L));
        } else if (entity instanceof SysResources) {
            max = this.sysResourcesService.getMaxOrderByParentId(((SysResources)entity).getModuleId());
        } else if (entity instanceof SysFunctionModules) {
            max = this.sysFunctionModulesService.getMaxOrderByParentIdAndAppId(((SysFunctionModules)entity).getParentModuleId(), Long.valueOf(1L));
        } else if (entity instanceof SysFunctions) {
            max = this.sysFunctionsService.getMaxOrderByParentId(((SysFunctions)entity).getFunctionModuleId());
        } else if (entity instanceof SysMenu) {
            max = this.sysMenuMapper.getMaxOrderByParentId(((SysMenu)entity).getParentId());
        }
        if (ToolUtil.isNotEmpty((Object)max)) {
            return max + 1;
        }
        return 1;
    }
}

