/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.manager.impl.PostUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.post.service.ISysPostAuditService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPostAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.postmanager.PostChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonPostManagerImpl {
    @Resource
    protected SysPostMapper sysPostMapper;
    @Autowired
    protected ISysStruPostService sysStruPostService;
    @Autowired
    protected ISysStruPostAuditService sysStruPostAuditService;
    @Autowired
    protected ISysUserPostService sysUserPostService;
    @Autowired
    protected ISysUserPostAuditService sysUserPostAuditService;
    @Autowired
    protected ISysPostRoleService sysPostRoleService;
    @Autowired
    protected ISysPostRoleAuditService sysPostRoleAuditService;
    @Autowired
    protected ISysUserRoleService sysUserRoleService;
    @Autowired
    protected ISysPostAuditService sysPostAuditService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    protected PostChangeNotify postChangeNotify;
    @Resource
    protected ISysStruUserService sysStruUserService;
    @Autowired
    protected PostUserAuthorizationChangeReporter postUserAuthorizationChangeReporter;

    protected void saveStruPost(Long postId, List<Long> organIds, Boolean auditFlag) {
        ArrayList<SysStruPost> organPostList = new ArrayList<SysStruPost>();
        ArrayList<SysStruPostAudit> auditList = new ArrayList<SysStruPostAudit>();
        for (Long organId : organIds) {
            if (auditFlag.booleanValue()) {
                SysStruPostAudit audit = new SysStruPostAudit();
                audit.setPostId(postId);
                audit.setStruId(organId);
                audit.setOperateType("1");
                audit.setAuditStatus("0");
                auditList.add(audit);
                continue;
            }
            SysStruPost sysStruPost = new SysStruPost();
            sysStruPost.setPostId(postId);
            sysStruPost.setStruId(organId);
            organPostList.add(sysStruPost);
        }
        if (auditFlag.booleanValue()) {
            if (ToolUtil.isNotEmpty(auditList)) {
                this.sysStruPostAuditService.saveBatch(auditList, auditList.size());
            }
        } else if (ToolUtil.isNotEmpty(organPostList)) {
            this.sysStruPostService.saveBatch(organPostList, organPostList.size());
        }
    }

    protected void savePostRole(Long postId, List<Long> roleIds, Boolean auditFlag) {
        ArrayList<SysPostRole> postRoleList = new ArrayList<SysPostRole>();
        ArrayList<SysPostRoleAudit> auditList = new ArrayList<SysPostRoleAudit>();
        for (Long roleId : roleIds) {
            if (auditFlag.booleanValue()) {
                SysPostRoleAudit audit = new SysPostRoleAudit();
                audit.setPostId(postId);
                audit.setRoleId(roleId);
                audit.setOperateType("1");
                audit.setAuditStatus("0");
                auditList.add(audit);
                continue;
            }
            SysPostRole sysPostRole = new SysPostRole();
            sysPostRole.setPostId(postId);
            sysPostRole.setRoleId(roleId);
            postRoleList.add(sysPostRole);
        }
        if (auditFlag.booleanValue()) {
            if (ToolUtil.isNotEmpty(auditList)) {
                this.sysPostRoleAuditService.saveBatch(auditList, auditList.size());
            }
        } else if (ToolUtil.isNotEmpty(postRoleList)) {
            this.sysPostRoleService.saveBatch(postRoleList, postRoleList.size());
        }
    }

    protected void saveUserPost(Long postId, List<Long> userIds, Boolean auditFlag) {
        ArrayList<SysUserPost> userPostList = new ArrayList<SysUserPost>();
        ArrayList<SysUserPostAudit> auditList = new ArrayList<SysUserPostAudit>();
        for (Long userId : userIds) {
            if (auditFlag.booleanValue()) {
                SysUserPostAudit audit = new SysUserPostAudit();
                audit.setPostId(postId);
                audit.setUserId(userId);
                audit.setRelateType("1");
                audit.setOperateType("1");
                audit.setAuditStatus("0");
                auditList.add(audit);
                continue;
            }
            SysUserPost sysUserPost = new SysUserPost();
            sysUserPost.setPostId(postId);
            sysUserPost.setUserId(userId);
            sysUserPost.setRelateType("1");
            userPostList.add(sysUserPost);
        }
        if (auditFlag.booleanValue()) {
            if (ToolUtil.isNotEmpty(auditList)) {
                this.sysUserPostAuditService.saveBatch(auditList, auditList.size());
            }
        } else if (ToolUtil.isNotEmpty(userPostList)) {
            this.sysUserPostService.saveBatch(userPostList, userPostList.size());
        }
    }

    protected void delUserPost(Long postId, List<Long> userIds, Boolean auditFlag) {
        if (HussarUtils.isNotEmpty(userIds)) {
            if (auditFlag.booleanValue()) {
                List userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId)).in(SysUserPost::getUserId, userIds));
                ArrayList<SysUserPostAudit> auditList = new ArrayList<SysUserPostAudit>();
                for (SysUserPost userPost : userPosts) {
                    SysUserPostAudit audit = new SysUserPostAudit();
                    audit.setPostId(postId);
                    audit.setUserId(userPost.getUserId());
                    audit.setRelateType(userPost.getRelateType());
                    audit.setOperateType("2");
                    audit.setAuditStatus("0");
                    auditList.add(audit);
                }
                if (HussarUtils.isNotEmpty(auditList)) {
                    this.sysUserPostAuditService.saveBatch(auditList, auditList.size());
                }
            } else {
                this.sysUserPostService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId)).in(SysUserPost::getUserId, userIds));
            }
        }
    }

    protected void delPostRole(Long postId, List<Long> roleIds, Boolean auditFlag) {
        if (HussarUtils.isNotEmpty(roleIds)) {
            if (auditFlag.booleanValue()) {
                List postRoles = this.sysPostRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId)).in(SysPostRole::getRoleId, roleIds));
                ArrayList<SysPostRoleAudit> auditList = new ArrayList<SysPostRoleAudit>();
                for (SysPostRole postRole : postRoles) {
                    SysPostRoleAudit audit = new SysPostRoleAudit();
                    audit.setPostId(postId);
                    audit.setRoleId(postRole.getRoleId());
                    audit.setOperateType("2");
                    audit.setAuditStatus("0");
                    auditList.add(audit);
                }
                if (HussarUtils.isNotEmpty(auditList)) {
                    this.sysPostRoleAuditService.saveBatch(auditList, auditList.size());
                }
            } else {
                this.sysPostRoleService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId)).in(SysPostRole::getRoleId, roleIds));
            }
        }
    }
}

