/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.post.dto.PostDto;
import com.jxdinfo.hussar.authorization.post.manager.AddPostManager;
import com.jxdinfo.hussar.authorization.post.manager.impl.CommonPostManagerImpl;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.addPostManagerImpl")
public class AddPostManagerImpl
extends CommonPostManagerImpl
implements AddPostManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddPostManagerImpl.class);

    @Override
    public ApiResponse<Long> addPost(PostDto postDto) {
        List organIds = postDto.getOrganIds();
        List userIds = postDto.getUserIds();
        List roleIds = postDto.getRoleIds();
        SysPost post = this.initialization(postDto);
        String result = this.processAuditIfNecessary(post, organIds, userIds, roleIds);
        return ApiResponse.success((Object)post.getId(), (String)result);
    }

    private String processAuditIfNecessary(SysPost post, List<Long> organIds, List<Long> userIds, List<Long> roleIds) {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isPostAudit()) {
            return this.doProcessPostAudit(post, organIds, userIds, roleIds);
        }
        String msg = this.doProcessPost(post, organIds, userIds, roleIds);
        this.postUserAuthorizationChangeReporter.report(new Object[]{userIds});
        this.postChangeNotify.notify(DataChangeType.INSERT, new Object[]{post});
        return msg;
    }

    private String doProcessPostAudit(SysPost post, List<Long> organIds, List<Long> userIds, List<Long> roleIds) {
        Long postId = post.getId();
        List list = this.sysPostAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostAudit::getPostCode, (Object)post.getPostCode())).eq(SysPostAudit::getAuditStatus, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_POST_CODE_REVIEW.getMessage()));
        }
        SysPostAudit sysPostAudit = new SysPostAudit();
        BeanUtils.copyProperties((Object)post, (Object)sysPostAudit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
        sysPostAudit.setPostId(postId);
        sysPostAudit.setOperateType("1");
        sysPostAudit.setAuditStatus("0");
        this.sysPostAuditService.save((Object)sysPostAudit);
        if (HussarUtils.isNotEmpty(organIds)) {
            this.saveStruPost(postId, organIds, true);
        }
        if (HussarUtils.isNotEmpty(userIds)) {
            this.saveUserPost(postId, userIds, true);
        }
        if (HussarUtils.isNotEmpty(roleIds)) {
            this.savePostRole(postId, roleIds, true);
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage());
    }

    private String doProcessPost(SysPost post, List<Long> organIds, List<Long> userIds, List<Long> roleIds) {
        this.sysPostMapper.insert(post);
        if (HussarUtils.isNotEmpty(organIds)) {
            this.saveStruPost(post.getId(), organIds, false);
        }
        if (HussarUtils.isNotEmpty(userIds)) {
            this.saveUserPost(post.getId(), userIds, false);
        }
        if (HussarUtils.isNotEmpty(roleIds)) {
            this.savePostRole(post.getId(), roleIds, false);
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage());
    }

    private SysPost initialization(PostDto postDto) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_POST_DTO_INITIALIZE_PARAM.getMessage()), (Object)JSON.toJSONString((Object)postDto));
        SysPost post = new SysPost();
        long id = IdWorker.getId((Object)post);
        post.setId(Long.valueOf(id));
        post.setPostName(StringUtils.trimToEmpty((String)postDto.getPostName()));
        post.setOrganTypeCode(postDto.getOrganTypeCode());
        post.setPostDesc(postDto.getPostDesc());
        String code = this.getCode(postDto.getPostCode());
        post.setPostCode(code);
        Integer postOrder = this.sysPostMapper.getMaxOrder();
        postOrder = HussarUtils.isEmpty((Object)postOrder) ? Integer.valueOf(1) : Integer.valueOf(postOrder + 1);
        post.setPostOrder(postOrder);
        return post;
    }

    private String getCode(String code) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode("POST_CODE", "SYS_POST");
                lambdaQueryWrapper.eq(SysPost::getPostCode, (Object)code);
                currentCount = this.sysPostMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysPost::getPostCode, (Object)code);
            currentCount = this.sysPostMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_POST_CODE_REVIEW.getMessage()));
            }
        }
        return code;
    }
}

