/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.adapter.role.IHussarBaseRoleAdapter;
import com.jxdinfo.hussar.authorization.adapter.user.ISysUsersAdapter;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.InstitutionVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysGetBackPasswordMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysPasswordHistMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserProxyMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RepeatPwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetPwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.SelfInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.UpdatePwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserQueryReqDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.ValidateUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUserProxy;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.PrincipalVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysUsersVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrgVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
@DependsOn(value={"springContextHolder"})
public class SysUsersServiceImpl
extends HussarBaseServiceImpl<SysUsersMapper, SysUsers>
implements ISysUsersService {
    private Logger logger = LoggerFactory.getLogger(SysUsersServiceImpl.class);
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysGetBackPasswordMapper sysGetBackPasswordMapper;
    @Resource
    private SysPasswordHistMapper sysPasswordHistMapper;
    @Resource
    private SysUserProxyMapper sysUserProxyMapper;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private IGlobalService globalService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysUserIpAuditService iSysUserIpAuditService;
    @Resource
    private ISysConfRolesService iSysConfRolesService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private SysStruAuditMapper sysStruAuditMapper;
    @Resource
    @Lazy
    private ISysUsersAuditService iSysUsersAuditService;
    @Resource
    private ISysStruAuditService iSysStruAuditService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    private HussarEncryptProperties hussarEncryptProperties;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    @Lazy
    @Resource
    private QueryUserManager queryUserManager;
    @Resource
    private ISysStruService sysStruService;
    @Autowired
    private ValidateUserManager validateUserManager;
    @Resource
    private ISysUsersAdapter sysUsersAdapter;
    @Resource
    private IHussarBaseRoleAdapter hussarBaseRoleAdapter;
    @Resource
    private QueryOrganizationManager queryOrganizationManager;
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L, 679338378499727360L};

    public SysUsers getById(Long userId) {
        return this.sysUsersAdapter.getById(userId);
    }

    public SysUsers getOne(String connName, String userAccount, List<String> accountStatus) {
        return this.sysUsersAdapter.getOne(connName, userAccount, accountStatus);
    }

    public List<SysUsers> listByIds(Collection<? extends Serializable> userIds) {
        return this.sysUsersAdapter.listByIds(userIds);
    }

    public List<SysUsers> getExpiredTemporary(LocalDateTime endTime) {
        return this.sysUsersAdapter.getExpiredTemporary(endTime);
    }

    public boolean updateBatchById(Collection<SysUsers> users) {
        return this.sysUsersAdapter.updateBatchById(users);
    }

    private void insertAndUpdateUserRoleAudit(List<Long> roleIds, List<SysUserroleAudit> auditList, Long userId, String operationType) {
        ArrayList<SysUserroleAudit> updateAuditList = new ArrayList<SysUserroleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        boolean isExist = false;
        ArrayList<SysUserroleAudit> addAuditList = new ArrayList<SysUserroleAudit>();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Long account = ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser()) ? BaseSecurityUtil.getUser().getId() : null;
        for (Long roleId : roleIds) {
            for (SysUserroleAudit sysUserroleAudit : auditList) {
                if (!roleId.equals(sysUserroleAudit.getRoleId())) continue;
                isExist = true;
                updateAuditList.add(sysUserroleAudit);
                break;
            }
            if (isExist) continue;
            SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
            sysUserroleAudit.setUserId(userId);
            sysUserroleAudit.setRoleId(roleId);
            sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
            sysUserroleAudit.setOperationType(operationType);
            addAuditList.add(sysUserroleAudit);
        }
        if (updateAuditList.size() > 0) {
            updateMap.put("userId", userId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("lastTime", currentDate);
            updateMap.put("lastEditor", account);
            updateMap.put("updateAuditList", updateAuditList);
            this.sysUserroleAuditMapper.updateAuditBatch(updateMap);
        }
        if (addAuditList.size() > 0) {
            this.sysUserroleAuditService.saveBatch(addAuditList);
        }
    }

    public ApiResponse changeOrg(Map<String, Object> map) {
        String userId = map.get("userId").toString();
        Long corporationId = Long.valueOf(map.get("corporationId").toString());
        String permitId = map.get("permitId").toString();
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById((Serializable)((Object)userId));
        sysUsers.setCorporationId(corporationId);
        sysUsers.setDepartmentId(corporationId);
        sysUsers.setPermissionStruId(Long.valueOf(permitId));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsers);
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("3");
            if (this.sysUsersAuditMapper.insert(sysUsersAudit) == 1) {
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS_WAIT_REVIEW.getMessage()));
            }
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_FAIL.getMessage()));
        }
        if (this.sysUsersMapper.updateById(sysUsers) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage()));
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_FAIL.getMessage()));
    }

    public boolean isExistAccount(String userAccount) {
        boolean flag = false;
        List<Map<String, Object>> result = this.sysUsersMapper.isExistAccount(userAccount);
        if (result.size() > 0) {
            flag = true;
        }
        return flag;
    }

    @HussarTransactional
    public ArrayList<Object> getUserInfo(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_EMPTY.getMessage()));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        SysUsers user = this.sysUsersAdapter.getById(userId);
        List userRole = this.hussarBaseRoleAdapter.getByUserId(userId);
        List userProxy = this.sysUserProxyMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserProxy::getUserId, (Object)userId));
        List byProxy = this.sysUserProxyMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserProxy::getProxyUserId, (Object)userId));
        List userIps = this.iSysUserIpService.selectUserIp(userId);
        StringBuilder ips = new StringBuilder();
        String ipsStr = "";
        if (userIps != null && userIps.size() > 0) {
            for (String sysUserIp : userIps) {
                ips.append(sysUserIp);
                ips.append(",");
            }
            ipsStr = ips.toString();
            ipsStr = ipsStr.substring(0, ipsStr.length() - 1);
        }
        if (user != null) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            String cacheKey = null;
            for (String s : keyList) {
                cacheKey = s;
                UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
                if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
                user.setAccountStatus(UserStatus.LOCKED.getCode());
            }
            user.setPassword("");
        }
        result.add(user);
        result.add(userRole);
        result.add(userProxy);
        result.add(byProxy);
        result.add(userIps);
        result.add(ipsStr);
        return result;
    }

    public IPage<UserOrgVo> getUserInfoList(Page<UserOrgVo> page, UserQueryReqDto userQueryReqDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        if (currentUser.isGradeadmin()) {
            SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)userQueryReqDto.getDepStruId()));
            SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
            if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                userQueryReqDto.setDepStruId(currentUser.getDeptId());
            }
        }
        if (ToolUtil.isNotEmpty((Object)userQueryReqDto.getDepStruId())) {
            struFid = ((SysStru)this.sysStruMapper.selectById(userQueryReqDto.getDepStruId())).getStruFid();
        }
        userQueryReqDto.setStruFid(struFid);
        if ("0".equals(userQueryReqDto.getUserStatus()) || ADD.equals(userQueryReqDto.getUserStatus())) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            userQueryReqDto.setLockUserIds(lockUserIds);
            Object[] arr = new String[]{"0", ADD};
            if (userQueryReqDto.getUserStatus() != null && ArrayUtils.contains((Object[])arr, (Object)userQueryReqDto.getUserStatus()) && CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if ("0".equals(userQueryReqDto.getUserStatus()) && ToolUtil.isEmpty(lockUserIds)) {
                return page;
            }
        }
        List<UserOrgVo> userInfoList = this.sysUsersMapper.findAccountUserList(page, userQueryReqDto);
        if (currentUser.isGradeadmin()) {
            userInfoList.forEach(o -> {
                if (currentUser.getId().equals(o.getId())) {
                    o.setIsLanding(ADD);
                }
            });
        }
        this.updateAccountStatus(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    private void updateAccountStatus(List<UserOrgVo> userInfoList) {
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        UserLockModel model = null;
        if (CollectionUtils.isNotEmpty((Collection)keyList) && CollectionUtils.isNotEmpty(userInfoList)) {
            for (UserOrgVo vo : userInfoList) {
                Optional<String> optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                if (!optional.isPresent()) continue;
                try {
                    String tmpkey = optional.get();
                    model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                    if (null == model || model.getLockTime() == null) continue;
                    vo.setAccountStatus(UserStatus.LOCKED.getCode());
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isFirstLogin(Long userId) {
        boolean flag = false;
        Long count = this.sysGetBackPasswordMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysGetBackPassword::getId, (Object)userId));
        if (count == 0L) {
            flag = true;
        }
        return flag;
    }

    public boolean isPwdOverdue(Long userId) {
        boolean flag = false;
        List list = this.sysUsersAdapter.getPwdHist(userId);
        if (ToolUtil.isNotEmpty((Object)list)) {
            SysPasswordHist sysPasswordHist = (SysPasswordHist)list.get(0);
            Duration duration = Duration.between(sysPasswordHist.getCreateTime(), LocalDateTime.now());
            if (duration.toDays() >= this.hussarPwdConfigService.getPasswordHist()) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    public SysUsers getUser(Long userId) {
        return (SysUsers)this.sysUsersMapper.selectById(userId);
    }

    public List<SysPasswordHist> getPwdHist(Long userId) {
        return this.sysPasswordHistMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPasswordHist::getUserId, (Object)userId)).orderByDesc(HussarBaseEntity::getCreateTime));
    }

    @HussarTransactional
    public void updatePwd(SysUsers sysUsers) {
        this.sysUsersAdapter.updatePwd(sysUsers);
    }

    public ApiResponse saveGetBackPwd(SysGetBackPassword sysGetBackPassword) {
        if (ToolUtil.isEmpty((Object)sysGetBackPassword)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SECURITY_INFO_EMPTY.getMessage()));
        }
        sysGetBackPassword.setId(BaseSecurityUtil.getUser().getId());
        if (!this.iSysGetBackPasswordService.saveOrUpdate((Object)sysGetBackPassword)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SETUP_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SETUP_SUCCESS.getMessage()));
    }

    public long resetAllPwd(Map<String, Object> map) {
        String newPwd = map.get("newPwd").toString();
        String[] userIds = (String[])map.get("userIds");
        long count = 0L;
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        for (String userId : userIds) {
            if (!ToolUtil.isNotEmpty((Object)userId)) continue;
            SysUsers sysUsers = new SysUsers();
            sysUsers.setPassword(newPwd);
            count += (long)this.sysUsersMapper.update(sysUsers, (Wrapper)new LambdaUpdateWrapper().eq(SysUsers::getId, (Object)userId));
            loginLock.removeUserCache(userId);
        }
        return count;
    }

    @HussarTransactional
    public void resetVueAllPwd(Map<String, Object> map) {
    }

    @HussarTransactional
    public ApiResponse saveUserOrder(List<Long> idList) {
        if (ToolUtil.isEmpty(idList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_USER_NEED_SAVE_SORTING.getMessage()));
        }
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysUsers sysUsers = new SysUsers();
            sysUsers.setId(id);
            sysUsers.setUserOrder(Integer.valueOf(i + 1));
            sysUsersList.add(sysUsers);
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
        }
        if (ToolUtil.isNotEmpty(sysUsersList) && super.updateBatchById(sysUsersList, sysUsersList.size())) {
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_FAIL.getMessage()));
    }

    public Integer getMaxOrder(Long departmentId) {
        return this.sysUsersMapper.getMaxOrder(departmentId);
    }

    @HussarTransactional
    public boolean copyRole(Long copyFrom, Long copyTo) {
        if (HussarUtils.isEmpty((Object)copyTo)) {
            return true;
        }
        List rolesFrom = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)copyFrom)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        List rolesTo = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)copyTo)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        ArrayList<Long> adds = new ArrayList<Long>();
        for (SysUserRole from : rolesFrom) {
            if (ToolUtil.isEmpty((Object)from.getGrantedRole())) continue;
            boolean isSame = false;
            for (SysUserRole to : rolesTo) {
                if (!from.getGrantedRole().equals(to.getGrantedRole())) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            adds.add(from.getGrantedRole());
        }
        int size = adds.size();
        Long[] toRolesArray = new Long[rolesTo.size()];
        Long[] addArray = adds.toArray(new Long[size]);
        for (int i = 0; i < rolesTo.size(); ++i) {
            toRolesArray[i] = ((SysUserRole)rolesTo.get(i)).getGrantedRole();
        }
        int arryLen1 = addArray.length;
        int arryLen2 = toRolesArray.length;
        if ((addArray = Arrays.copyOf(addArray, arryLen1 + arryLen2)).length == 0) {
            return true;
        }
        System.arraycopy(toRolesArray, 0, addArray, arryLen1, arryLen2);
        if (this.iSysConfRolesService.isIncludeConfRole(addArray)) {
            return false;
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(copyTo);
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, copyTo, ADD);
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (Long roleId : adds) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(copyTo);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, Constants.NONE_ID);
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList, "add");
            }
        }
        return true;
    }

    public Page<SysUsers> getUserList(Page<SysUsers> page, SysUsers sysUsers) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        String userAccount = sysUsers.getUserAccount();
        String userName = sysUsers.getUserName();
        if (ToolUtil.isNotEmpty((Object)userAccount)) {
            userAccount = userAccount.replace("%", "\\%").replace("_", "\\_");
        }
        if (ToolUtil.isNotEmpty((Object)userName)) {
            userName = userName.replace("%", "\\%").replace("_", "\\_");
        }
        page.setRecords(this.sysUsersMapper.getUserList(page, userAccount, userName));
        return page;
    }

    public List<JSTreeModel> getUserTreeByRole(Long roleId) {
        List<JSTreeModel> userTreeList = this.sysUsersMapper.getUserTreeStruByRole(roleId);
        userTreeList.addAll(this.sysUsersMapper.getUserTreeByRole(roleId));
        return userTreeList;
    }

    public List<JSTreeModel> getUserTreeByRole(String roleId) {
        return this.getUserTreeByRole(Long.parseLong(roleId));
    }

    public List<JSTreeModel> getLazyUserTreeByRole(Long roleId) {
        return this.sysUsersMapper.getLazyUserTreeByRole(roleId);
    }

    public void updateUserStatus() {
        SysBaseConfig noLogin = this.iSysBaseConfigService.getSysBaseConfig("nologin_day");
        String days = noLogin.getConfigValue();
        String status = UserStatus.DORMANCY.getCode();
        Instant now = Instant.now();
        Instant before = now.minus(Duration.ofDays(Integer.valueOf(days).intValue()));
        Date dateBefore = Date.from(before);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp previous = Timestamp.valueOf(df.format(dateBefore));
        this.sysUsersMapper.updateUserStatus(previous, status);
    }

    public boolean reChecking(RepeatPwdDto repeatPwdDto) {
        String userName = BaseSecurityUtil.getUser().getAccount();
        String pass = repeatPwdDto.getCipher();
        if (this.hussarLoginConfigService.getTotpOpen().booleanValue()) {
            SysUsers sysUsers = (SysUsers)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userName));
            String totpKey = sysUsers.getTotpKey();
            return this.abstractOTPCredentialsMatcher.verify(totpKey, pass, this.hussarLoginConfigService.getTotpOffsetMin());
        }
        String password = pass;
        SysUsers sysUsers = (SysUsers)super.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userName)).eq(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode()));
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(password).getBytes());
        return sysUsers.getPassword().equalsIgnoreCase(pwd);
    }

    @HussarTransactional
    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public ApiResponse cancelUser(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_EMPTY.getMessage()));
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = this.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_FAIL_ADMIN.getMessage()));
        }
        if (shiroUser.getId().equals(userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_FAIL_ACTIVE_USER.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_CANCEL.getMessage()));
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("4");
            if (this.sysUsersAuditMapper.insert(sysUsersAudit) == 1) {
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_SUCCESS_WAIT_REVIEW.getMessage()));
            }
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_FAIL.getMessage()));
        }
        Long employeeId = sysUser.getEmployeeId();
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUser.getId()));
        sysUser.setAccountStatus(UserStatus.CANCEL.getCode());
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        if (this.sysUsersMapper.updateById(sysUser) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUser, Constants.NONE_ID);
            sysUser.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUser.getId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUser.getId(), "deleteByUserId");
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_FAIL.getMessage()));
    }

    @HussarTransactional
    private boolean saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String string : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(string);
                sysUserIps.add(sysUserIp);
            }
        }
        if (sysUserIps.size() > 0) {
            ArrayList<String> newsysUserIps = new ArrayList<String>();
            for (SysUserIp sysUserIp : sysUserIps) {
                if (newsysUserIps.contains(sysUserIp.getUserIp())) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXIST_DUPLICATE_IP.getMessage()) + sysUserIp.getUserIp());
                }
                newsysUserIps.add(sysUserIp.getUserIp());
            }
            flag = this.iSysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }

    @HussarTransactional
    private boolean saveUserAuditIP(Long userId, String accessLoginIp, String currentStatus) {
        boolean flag = false;
        ArrayList<SysUserIpAudit> listAudit = new ArrayList<SysUserIpAudit>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
                sysUserIpAudit.setUserId(userId);
                sysUserIpAudit.setUserIp(ip);
                sysUserIpAudit.setIsAudit("0");
                sysUserIpAudit.setCurrentStatus(currentStatus);
                listAudit.add(sysUserIpAudit);
            }
        }
        if (listAudit.size() > 0) {
            flag = this.iSysUserIpAuditService.saveBatch(listAudit);
        }
        return flag;
    }

    public void exportData(List<String> idList, HttpServletResponse response) {
        ArrayList<Long> ids = new ArrayList<Long>();
        idList.forEach(id -> ids.add(Long.valueOf(id)));
        List<SysUsers> users = this.queryUserManager.selectUsersByIds(ids);
        List userIp = this.iSysUserIpService.selectUserIpByUserIds(ids);
        ArrayList<Long> employeeIds = new ArrayList<Long>();
        for (SysUsers sysUsers : users) {
            Long employeeId = sysUsers.getEmployeeId();
            if (employeeId == null) continue;
            employeeIds.add(employeeId);
        }
        List strus = new ArrayList();
        if (employeeIds.size() > 0) {
            strus = this.sysStruService.getStruByStruIds(employeeIds);
        }
        List userRoles = this.sysUserRoleService.getUserRolesByUserIds(ids);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("users", users);
        data.put("user_ip", userIp);
        data.put("userRole", userRoles);
        data.put("strus", strus);
        data.put("export_type", "user");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()));
        }
        String fileName = "user_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @HussarTransactional
    public Map<String, String> importVueData(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DESERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        String export_type = (String)data.get("export_type");
        if (!"user".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "employee");
            return map;
        }
        List users = (List)data.get("users");
        List userIps = (List)data.get("user_ip");
        List userRoles = (List)data.get("userRole");
        List strus = (List)data.get("strus");
        Map<String, Integer> userCount = this.saveOrUpdateBatchUsers(users);
        this.insertOrUpdateList(userIps);
        Map userRoleCount = this.sysUserRoleService.saveOrUpdateBatchUserRoles(userRoles);
        this.sysStruService.saveOrUpdateStruList(strus);
        map.put("success", "true");
        map.put("userInsert", "" + userCount.get("insert"));
        map.put("userUpdate", "" + userCount.get("update"));
        map.put("userRoleInsert", "" + userRoleCount.get("insert"));
        map.put("userRoleUpdate", "" + userRoleCount.get("update"));
        return map;
    }

    public List<JSTreeModel> getUserTreeVue(String isExport, Long parentId) {
        Long newParentId = parentId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long empolyeeId = shiroUser.getEmployeeId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            level = this.sysStruMapper.selectStruLevel(empolyeeId);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SYSTEM_USER.getMessage()));
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List list = new ArrayList();
        List list1 = new ArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.getUserTree(newParentId);
        } else {
            result.add(jsTreeModel);
            list1 = this.sysOrgManageService.getUserTree();
        }
        list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel jSTreeModel : result) {
                String type = jSTreeModel.getType();
                if (type != null && "USER".equals(type)) {
                    jSTreeModel.setState(false, false, false);
                    continue;
                }
                jSTreeModel.setState(false, false, true);
            }
        }
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getUserTreeVueForCopy(String isExport, Long parentId) {
        Long newParentId = parentId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long empolyeeId = shiroUser.getEmployeeId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            level = this.sysStruMapper.selectStruLevel(empolyeeId);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SYSTEM_USER.getMessage()));
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List list1 = new ArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.getUserTree(newParentId);
        } else {
            result.add(jsTreeModel);
            list1 = this.sysOrgManageService.getUserTree();
        }
        List list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTreeForCopy(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel jSTreeModel : result) {
                String type = jSTreeModel.getType();
                if (type != null && "USER".equals(type)) {
                    jSTreeModel.setState(false, false, false);
                    continue;
                }
                jSTreeModel.setState(false, false, true);
            }
        }
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getUserDepTreeVue(Long struParentId, String reqModule) {
        List<JSTreeModel> list;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long empolyeeId = shiroUser.getEmployeeId();
        Long currentUserId = shiroUser.getUserId();
        Long currentStruId = shiroUser.getEmployeeId();
        Long deptId = shiroUser.getDeptId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            level = this.sysStruMapper.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setId(Constants.ROOT_NODE_ID);
        root.setParent(Constants.ROOT_NODE_PARENT);
        String rootText = "role".equals(reqModule) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SYSTEM_USER.getMessage());
        rootText = Objects.requireNonNull(BaseSecurityUtil.getUser()).isGradeadmin() ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN.getMessage()) : rootText;
        root.setText(rootText);
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (ToolUtil.isNotEmpty((Object)struParentId) && ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)struParentId)) {
            struParentId = Constants.ROOT_NODE_ID;
            result.add(root);
        }
        if (isGradeAdmin) {
            SysStru sysStruT;
            root.getState().put("gradeDisabled", true);
            level = this.sysStruMapper.selectStruLevel(empolyeeId);
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            String userParentFid = sysStru.getStruFid();
            String paramStruFid = "";
            int paramStruLevel = 1;
            paramStruFid = struParentId.equals(Constants.ROOT_NODE_ID) ? OrganUtil.getStruFidByLevel((String)userParentFid, (int)1) : ((paramStruLevel = (sysStruT = (SysStru)this.sysStruMapper.selectById(struParentId)).getStruLevel() + 1) >= level ? sysStruT.getStruFid() : OrganUtil.getStruFidByLevel((String)userParentFid, (int)paramStruLevel));
            list = this.sysStruMapper.getGradeOrgTree(paramStruLevel, paramStruFid);
            for (JSTreeModel jsTreeModel : list) {
                String type;
                Long modelId = jsTreeModel.getId();
                String struLevelStr = jsTreeModel.getStruLevel();
                int struLevelT = 0;
                if (struLevelStr != null) {
                    struLevelT = Integer.parseInt(struLevelStr);
                }
                if (struLevelT == level - 1) {
                    jsTreeModel.getState().put("changeDisabled", true);
                }
                if (struLevelT < level) {
                    if (struLevelT >= level - 1) continue;
                    jsTreeModel.getState().put("gradeDisabled", true);
                    continue;
                }
                if (struLevelT == level) {
                    if (jsTreeModel.getPrime() != null && "0".equals(jsTreeModel.getPrime())) {
                        jsTreeModel.getState().put("isOrganRoleNode", true);
                        continue;
                    }
                    Long parent = jsTreeModel.getParent();
                    if (!deptId.equals(parent)) continue;
                    type = jsTreeModel.getType();
                    if ("ORGANROLE".equals(type)) {
                        jsTreeModel.getState().put("isOrganRoleNode", true);
                        continue;
                    }
                    if ("USER".equals(type)) {
                        if (!modelId.equals(currentUserId)) continue;
                        jsTreeModel.getState().put("currentUser", true);
                        continue;
                    }
                    if (!modelId.equals(currentStruId)) continue;
                    jsTreeModel.getState().put("currentEmployee", true);
                    continue;
                }
                Long id = jsTreeModel.getId();
                type = jsTreeModel.getType();
                if ("ORGANROLE".equals(type)) {
                    id = jsTreeModel.getParent();
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                }
                if (!"USER".equals(type)) continue;
                id = jsTreeModel.getEmployeeId();
            }
        } else {
            list = this.sysStruMapper.getLazyLoadingOrgTree(null, struParentId);
        }
        this.toSetContainsRules(list);
        result.addAll(list);
        List listOrganType = this.organTypeService.list();
        Map mapOrganType = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
        if (CollectionUtils.isNotEmpty(result)) {
            for (JSTreeModel jsTreeModel : result) {
                if (!HussarUtils.isNotBlank((CharSequence)jsTreeModel.getStruType())) continue;
                jsTreeModel.setImgUrl(((SysOrganType)mapOrganType.get(jsTreeModel.getStruType())).getImgUrl());
            }
        }
        return TreeModelUtils.merge(result);
    }

    private List<JSTreeModel> rootNode(JSTreeModel root) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        result.add(root);
        return result;
    }

    public void toSetContainsRules(List<JSTreeModel> list) {
        List<String> stringList = this.sysStruRuleMapper.getAllSysOrganType();
        for (JSTreeModel jsTreeModel : list) {
            boolean contains = stringList.contains(jsTreeModel.getStruType());
            if (contains) {
                jsTreeModel.setContainsRules(ADD);
                continue;
            }
            jsTreeModel.setContainsRules("0");
        }
    }

    @HussarTransactional
    public ApiResponse saveUser(SysUsersVo sysUsersVo) {
        if (ToolUtil.isEmpty((Object)sysUsersVo)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USERINFO_CANNOT_BE_EMPTY.getMessage()));
        }
        try {
            this.validateParam(sysUsersVo, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        SysUsers sysUsers = new SysUsers();
        BeanUtils.copyProperties((Object)sysUsersVo, (Object)sysUsers);
        String roleIds = sysUsersVo.getRoleIds() == null ? "" : sysUsersVo.getRoleIds();
        String[] ids = roleIds.split(",");
        Long[] idLs = new Long[ids.length];
        int i = 0;
        for (String id : ids) {
            Long idL = ToolUtil.isNotEmpty((Object)id) ? Long.valueOf(id) : 0L;
            idLs[i++] = idL;
        }
        if (this.iSysConfRolesService.isIncludeConfRole(idLs)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THE_ROLE_NO_ALLOW_EXCEED_ROLE_SETS.getMessage()));
        }
        Boolean userAccountInAudit = this.userAccountInAudit(sysUsers.getUserAccount());
        if (userAccountInAudit.booleanValue()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST_AUDIT.getMessage()));
        }
        sysUsers.setCorporationId(sysUsers.getDepartmentId());
        Integer order = this.getMaxOrder(sysUsers.getDepartmentId());
        order = ToolUtil.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
        sysUsers.setUserOrder(order);
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("sysUser", sysUsers);
        map.put("roleId", roleIds);
        String pass = "";
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && !this.createUserConfigService.getCreateUserUseDefaultPass().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)sysUsers.geteMail())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EMAIL_MUST_BE_FILLED.getMessage()));
            }
            pass = GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule());
        } else {
            pass = this.hussarPwdConfigService.getDefaultPassword();
        }
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        sysUsers.setPassword(pwd);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            boolean canOperate1 = this.iSysStruAuditService.checkCanOperate(sysUsers.getDepartmentId());
            if (!canOperate1) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_USER_ORGAN_EXIST_UNAPPROVED_DATA.getMessage()));
            }
            long userId = IdWorker.getId((Object)sysUsers);
            sysUsers.setId(Long.valueOf(userId));
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(Long.valueOf(userId));
            sysUsersAudit.setPassword(pass);
            sysUsersAudit.setCurrentStatus("0");
            sysUsersAudit.setIsAudit("0");
            this.iSysUsersAuditService.save((Object)sysUsersAudit);
            this.saveUserAuditIP(userId, sysUsersVo.getAccessLoginIp(), "0");
            stringBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ADD_SUCCESS_WAIT_REVIEW.getMessage()));
            if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
                ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
                if (ids.length > 0) {
                    for (String roleId : ids) {
                        if (ToolUtil.isEmpty((Object)roleId)) continue;
                        SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                        sysUserroleAudit.setUserId(sysUsers.getId());
                        sysUserroleAudit.setRoleId(Long.valueOf(roleId));
                        sysUserroleAudit.setStatus(UserRoleStatus.UserAuditButRoleNotAudit.getCode());
                        sysUserroleAudit.setOperationType(ADD);
                        sysUserroleAuditList.add(sysUserroleAudit);
                    }
                }
                if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                    this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
                    if (sysUserroleAuditList.size() != 1 || !((SysUserroleAudit)sysUserroleAuditList.get(0)).getRoleId().equals(SysUserAndRole.PUBLIC_ROLE.getValue())) {
                        stringBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ROLE_ADD_SUCCESS.getMessage()));
                    }
                }
            }
        } else {
            this.save((BaseEntity)sysUsers);
            this.saveUserIP(sysUsers.getId(), sysUsersVo.getAccessLoginIp());
            stringBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ADD_SUCCESS.getMessage()));
            if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
                this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId()));
                ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
                for (String roleId : ids) {
                    if (ToolUtil.isEmpty((Object)roleId)) continue;
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(sysUsers.getId());
                    sysUserRole.setGrantedRole(Long.valueOf(roleId));
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    userRoleList.add(sysUserRole);
                }
                if (ToolUtil.isNotEmpty(userRoleList)) {
                    this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                    if (userRoleList.size() != 1 || !((SysUserRole)userRoleList.get(0)).getGrantedRole().equals(SysUserAndRole.PUBLIC_ROLE.getValue())) {
                        stringBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ROLE_ADD_SUCCESS.getMessage()));
                    }
                }
            }
            if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) {
                CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)pass);
            }
        }
        Long sysUsersId = sysUsers.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(sysUsersId);
            sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            this.sysUserRoleMapper.insert(sysUserRole);
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            if (ids.length > 0) {
                for (String roleId : ids) {
                    if (ToolUtil.isEmpty((Object)roleId) || SysUserAndRole.PUBLIC_ROLE.getValue().equals(Long.valueOf(roleId))) continue;
                    if (SysUserAndRole.GRADEADMIN_ROLE.getValue().equals(Long.valueOf(roleId))) {
                        SysUserRole sysUserGradeRole = new SysUserRole();
                        sysUserGradeRole.setUserId(sysUsersId);
                        sysUserGradeRole.setGrantedRole(SysUserAndRole.GRADEADMIN_ROLE.getValue());
                        sysUserGradeRole.setAdminOption(UserRoleStatus.OK.getCode());
                        this.sysUserRoleMapper.insert(sysUserGradeRole);
                        continue;
                    }
                    SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(sysUsersId);
                    sysUserroleAudit.setRoleId(Long.valueOf(roleId));
                    sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(ADD);
                    sysUserroleAuditList.add(sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
                stringBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ROLE_ADD_SUCCESS_WAIT_REVIEW.getMessage()));
            }
        }
        return ApiResponse.success((String)stringBuffer.toString());
    }

    public IPage<UserOrgVo> getAccountList(UserQueryReqDto userQueryReqDto, Page<UserOrgVo> pages) {
        if (ToolUtil.isEmpty(pages)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        String userName = userQueryReqDto.getUserName();
        String userAccount = userQueryReqDto.getUserAccount();
        String userStatus = userQueryReqDto.getUserStatus();
        String userProperty = userQueryReqDto.getUserProperty();
        Long orgId = userQueryReqDto.getDepStruId();
        return pages.setRecords(this.sysUsersMapper.getAccountList(userName, userAccount, userStatus, userProperty, orgId, pages));
    }

    public List<SysUsers> updateUserStatusToDormancy(String status) {
        int nologinDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("nologin_day").getConfigValue());
        if (nologinDay == -1) {
            return new ArrayList<SysUsers>();
        }
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date previous = DateUtil.addDay((Date)date, (int)(-nologinDay));
        List<SysUsers> noLoginList = this.sysUsersMapper.getNoLoginList(previous, UserStatus.OK.getCode());
        noLoginList.removeIf(sysUsers -> ArrayUtils.contains((Object[])ADMINS, (Object)sysUsers.getId()));
        if (ToolUtil.isNotEmpty(noLoginList)) {
            this.sysUsersMapper.updateToDormancy(date, status, noLoginList);
        } else {
            noLoginList = new ArrayList<SysUsers>();
        }
        return noLoginList;
    }

    @HussarDs(value="#connName")
    public List<SysUsers> updateUserStatusToDormancy(String connName, String status) {
        return this.updateUserStatusToDormancy(status);
    }

    public List<SysUsers> getWillCancel() {
        return this.getWillCancel("master");
    }

    @HussarDs(value="#connName")
    public List<SysUsers> getWillCancel(String connName) {
        int logoutDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig(connName, "logout_day").getConfigValue());
        int warnDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig(connName, "email_before_logout_day").getConfigValue());
        int days = logoutDay - warnDay;
        Date previous = DateUtil.addDay((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)(-days));
        return ((SysUsersMapper)this.baseMapper).getWillCancel(previous, UserStatus.DORMANCY.getCode());
    }

    @HussarDs(value="#connName")
    public void unLock(String connName) {
        String casCacheName;
        List casLockKeys;
        String cacheName = "Login_Lock";
        List lockKeys = HussarCacheUtil.getKeysLike((String)cacheName, (String)"?");
        if (CollectionUtils.isNotEmpty((Collection)lockKeys)) {
            String cacheKey = null;
            for (String lockKey : lockKeys) {
                cacheKey = lockKey;
                UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)cacheName, (Object)cacheKey);
                if (HussarUtils.isNotEmpty((Object)model) && model.getLockTime() != null && model.getExpireTime().before(new Date())) {
                    HussarCacheUtil.evictKeysLike((String)cacheName, (String)cacheKey);
                }
                if (model != null) continue;
                HussarCacheUtil.evictKeysLike((String)cacheName, (String)cacheKey);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(casLockKeys = (List)HussarCacheUtil.get((String)(casCacheName = "hussar_cas_login_lock"), (Object)"?")))) {
            String cacheKey = null;
            for (String lockKey : casLockKeys) {
                cacheKey = lockKey;
                UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)cacheName, (Object)cacheKey)), UserLockModel.class);
                if (HussarUtils.isNotEmpty((Object)model) && model.getLockTime() != null && model.getExpireTime().before(new Date())) {
                    HussarCacheUtil.evictKeysLike((String)casCacheName, (String)cacheKey);
                }
                if (model != null) continue;
                HussarCacheUtil.evictKeysLike((String)cacheName, (String)cacheKey);
            }
        }
    }

    public boolean updateUserStatusToCancel() {
        return this.updateUserStatusToCancel("master");
    }

    @HussarDs(value="#connName")
    public boolean updateUserStatusToCancel(String connName) {
        int logoutDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig(connName, "logout_day").getConfigValue());
        Date previous = DateUtil.addDay((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)(-logoutDay));
        return ((SysUsersMapper)this.baseMapper).updateToCancel(previous, UserStatus.CANCEL.getCode());
    }

    public List<SysUsers> getExpireTemporaty(LocalDateTime end) {
        return this.getExpireTemporaty("master", end);
    }

    @HussarDs(value="#connName")
    public List<SysUsers> getExpireTemporaty(String connName, LocalDateTime end) {
        return ((SysUsersMapper)this.baseMapper).getExpireTemporaty(end);
    }

    public IPage<UserOrgVo> getSysUserInfo(Page<UserOrgVo> page, UserQueryReqDto userQueryReqDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        if (!BaseSecurityUtil.getUser().isGradeadmin()) {
            userQueryReqDto.setIsSys(ADD);
            if ("0".equals(userQueryReqDto.getUserStatus()) || ADD.equals(userQueryReqDto.getUserStatus())) {
                List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
                ArrayList<Long> lockUserIds = new ArrayList<Long>();
                userQueryReqDto.setLockUserIds(lockUserIds);
                Object[] arr = new String[]{"0", ADD};
                if (userQueryReqDto.getUserStatus() != null && ArrayUtils.contains((Object[])arr, (Object)userQueryReqDto.getUserStatus()) && CollectionUtils.isNotEmpty((Collection)keyList)) {
                    String tmpKey = null;
                    Iterator iterator = keyList.iterator();
                    while (iterator.hasNext()) {
                        String cacheKey;
                        tmpKey = cacheKey = (String)iterator.next();
                        lockUserIds.add(Long.parseLong(tmpKey));
                    }
                }
                if ("0".equals(userQueryReqDto.getUserStatus()) && ToolUtil.isEmpty(lockUserIds)) {
                    return page;
                }
            }
            List<UserOrgVo> userInfoList = this.sysUsersMapper.findAccountUserList(page, userQueryReqDto);
            this.updateAccountStatus(userInfoList);
            page.setRecords(userInfoList);
        }
        return page;
    }

    @HussarTransactional
    public ApiResponse updateUser(SysUsersVo sysUsersVo) {
        String roleIds;
        if (ToolUtil.isEmpty((Object)sysUsersVo)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USERINFO_CANNOT_BE_EMPTY.getMessage()));
        }
        try {
            this.validateParam(sysUsersVo, "edit");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        sysUsersVo.setAccountStatus(((SysUsers)this.sysUsersMapper.selectById(sysUsersVo.getId())).getAccountStatus());
        SysUsers sysUsers = new SysUsers();
        BeanUtils.copyProperties((Object)sysUsersVo, (Object)sysUsers);
        this.checkTypeProperty(sysUsers);
        Long userId = sysUsers.getId();
        String string = roleIds = sysUsersVo.getRoleIds() == null ? "" : sysUsersVo.getRoleIds().trim();
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        String[] ids = roleIds.split(",");
        Long[] idList = new Long[ids.length];
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        for (String id : ids) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            Long[] idL = Long.valueOf(id);
            idList[i++] = idL;
            if (list.contains(id)) continue;
            list.add(id);
        }
        if (this.iSysConfRolesService.isIncludeConfRole(idList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THE_ROLE_NO_ALLOW_EXCEED_ROLE_SETS.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.iSysUsersAuditService.adjustEdit(sysUsers.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_UPDATE.getMessage()));
        }
        sysUsers.setCorporationId(sysUsers.getDepartmentId());
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(userId);
            List connList = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
            ArrayList<Long> adds = new ArrayList<Long>();
            ArrayList<Long> dels = new ArrayList<Long>();
            for (SysUserRole sysUserRole : connList) {
                boolean isSame = false;
                for (Long roleId : idList) {
                    if (ToolUtil.isEmpty((Object)roleId) || !roleId.equals(sysUserRole.getGrantedRole())) continue;
                    isSame = true;
                    break;
                }
                if (isSame) continue;
                dels.add(sysUserRole.getGrantedRole());
            }
            for (Long roleId : idList) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                boolean isSame = false;
                for (SysUserRole sysUserRole : connList) {
                    if (!roleId.equals(sysUserRole.getGrantedRole())) continue;
                    isSame = true;
                    break;
                }
                if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                adds.add(roleId);
            }
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, userId, ADD);
            }
            if (ToolUtil.isNotEmpty(dels)) {
                this.insertAndUpdateUserRoleAudit(dels, auditList, userId, DELETE);
            }
        } else {
            List<Object> roleList;
            this.sysRolesService.delAuthCacheInfo(userId);
            if (BaseSecurityUtil.getUser().isGradeadmin()) {
                roleList = this.sysUserRoleMapper.delOrganRoleIdByUserId(userId);
                if (roleList.size() > 0) {
                    List roleIdList = LambdaQueryUtil.getSplitList(roleList);
                    this.sysUserRoleMapper.delUserRoleByRoleId(userId, roleIdList);
                }
                this.abstractPushMsgMatcher.insertOperation("userRole", DELETE, (Object)userId, Constants.NONE_ID);
            } else {
                roleList = this.sysUserRoleMapper.getSysRolesByUserId(userId);
                if (CollectionUtils.isNotEmpty(roleList)) {
                    List cdids = roleList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    List cdidList = LambdaQueryUtil.getSplitList(cdids);
                    this.sysUserRoleMapper.delSysRolesByUserId(userId, cdidList);
                }
                this.abstractPushMsgMatcher.insertOperation("userRole", DELETE, (Object)userId, Constants.NONE_ID);
            }
            this.bpmAbstractPushMsgMatcher.delete("userRole", userId, "deleteByUserId");
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (String roleId : ids) {
                if (ToolUtil.isEmpty((Object)roleId) || SysUserAndRole.PUBLIC_ROLE.getValue().toString().equals(roleId) && BaseSecurityUtil.getUser().isGradeadmin()) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(Long.valueOf(roleId));
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
            }
            String isSys = sysUsers.getIsSys();
            this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.GRADEADMIN_ROLE.getValue()));
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, Constants.NONE_ID);
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList, "add");
            }
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsers user = this.getUser(sysUsers.getId());
            String oldEmployeeId = user.getEmployeeId().toString();
            String newEmployeeId = sysUsers.getEmployeeId().toString();
            if (!this.iSysStruAuditService.checkCanOperate(user.getEmployeeId())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_FORBBDIN.getMessage()));
            }
            if (!oldEmployeeId.equals(newEmployeeId) && !this.iSysStruAuditService.checkCanOperate(sysUsers.getEmployeeId())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_FORBBDIN_NEW.getMessage()));
            }
            BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit, (String[])new String[]{"id"});
            sysUsersAudit.setUserId(sysUsers.getId());
            sysUsersAudit.setCurrentStatus(ADD);
            sysUsersAudit.setIsAudit("0");
            this.sysUsersAuditMapper.insert(sysUsersAudit);
            this.saveUserAuditIP(userId, sysUsersVo.getAccessLoginIp(), ADD);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage()));
        }
        SysUsers old = (SysUsers)this.sysUsersMapper.selectById(sysUsers.getId());
        if (!ADD.equals(old.getAccountStatus()) && ADD.equals(sysUsers.getAccountStatus())) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
            LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
            loginLock.removeUserCache(String.valueOf(sysUsers.getId()));
        }
        this.sysUsersMapper.updateById(sysUsers);
        this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, Constants.NONE_ID);
        this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
        this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userId));
        this.saveUserIP(userId, sysUsersVo.getAccessLoginIp());
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public ApiResponse dormancyUser(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_EMPTY.getMessage()));
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(userId);
        sysUsers.setAccountStatus(UserStatus.DORMANCY.getCode());
        this.sysUsersMapper.updateById(sysUsers);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.DORMANCY_SUCCESS.getMessage()));
    }

    @HussarTransactional
    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public ApiResponse deleteUser(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_EMPTY.getMessage()));
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = this.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ADMIN.getMessage()));
        }
        if (shiroUser.getId().equals(userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL_ACTIVE_USER.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_DELETE.getMessage()));
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus(DELETE);
            if (this.sysUsersAuditMapper.insert(sysUsersAudit) == 1) {
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage()));
            }
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        Long employeeId = sysUser.getEmployeeId();
        sysUser.setAccountStatus(UserStatus.DELETE.getCode());
        this.sysStruMapper.updatePrincipal(sysUser.getId());
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUser.getId()));
        this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUser.getId()));
        if (this.sysUsersMapper.updateById(sysUser) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", DELETE, (Object)sysUser, Constants.NONE_ID);
            sysUser.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUser.getId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUser.getId(), "deleteByUserId");
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
    }

    public ApiResponse updateLockAccountStatus(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_EMPTY.getMessage()));
        }
        SysUsers sysUsers = this.getUser(userId);
        this.dealLock(sysUsers);
        boolean flag = true;
        if ("0".equals(sysUsers.getTypeProperty())) {
            LocalDateTime nowDay = LocalDateTime.now();
            LocalDateTime expiredDay = sysUsers.getExpiredTime();
            LocalDateTime startDay = sysUsers.getStartTime();
            flag = nowDay.isAfter(startDay);
            if (flag) {
                flag = expiredDay.isAfter(nowDay);
            }
        }
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.TMP_ACCOUNT_CANNOT_ACTIVE.getMessage()));
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).set(SysUsers::getLastLoginTime, (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()))).eq(SysUsers::getId, (Object)userId));
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    private void dealLock(SysUsers sysUsers) {
        if (sysUsers != null) {
            HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsers.getId()));
        }
    }

    public ApiResponse<UpdateInfoVo> updatePassword(UpdatePwdDto updatePwdDto) {
        String cPwd;
        String oldPwd = updatePwdDto.getOldPwd() == null ? "" : updatePwdDto.getOldPwd();
        String newPwd = updatePwdDto.getNewPwd() == null ? "" : updatePwdDto.getNewPwd();
        String string = cPwd = updatePwdDto.getConfirmPwd() == null ? "" : updatePwdDto.getConfirmPwd();
        if (this.hussarEncryptProperties.isEnablePwEncryption()) {
            oldPwd = this.passwordEncryptService.decrypt(oldPwd);
            newPwd = this.passwordEncryptService.decrypt(newPwd);
            cPwd = this.passwordEncryptService.decrypt(cPwd);
        }
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replace("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String unmatchedHint = this.hussarPwdConfigService.getUnmatchedHint();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        UpdateInfoVo updateInfoVo = new UpdateInfoVo();
        if (!newPwd.matches(regular)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("unmatchedHintMark");
            updateInfoVo.setPwdRule(pwdRule);
            updateInfoVo.setHintMark(hint);
            updateInfoVo.setMsg(unmatchedHint);
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (!newPwd.equals(cPwd)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError(TranslateUtil.getTranslateName((String)TipConstantsEnum.RESET_FAIL_SECRET_NOT_SAME_MARK.getMessage()));
            return ApiResponse.success((Object)updateInfoVo);
        }
        String oPwd = this.credentialsMatcher.passwordEncode(oldPwd.getBytes());
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        Long userId = BaseSecurityUtil.getUser().getId();
        SysUsers user = this.getById(userId);
        String userAccount = user.getUserAccount();
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_CONCLUDE_USERNAME_MARK.getMessage()));
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (!oPwd.equalsIgnoreCase(user.getPassword())) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_ORIGINAL_SECRET_ERROR_MARK.getMessage()));
            return ApiResponse.success((Object)updateInfoVo);
        }
        List<SysPasswordHist> list = this.getPwdHist(userId);
        if (ToolUtil.isEmpty(list) && this.hussarPwdConfigService.getDefaultPassword().equals(newPwd)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_DEFULT_SECRET_SAME_MARK.getMessage()));
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (this.hussarPwdConfigService.getPwdRepeatTime() != 0) {
            for (int i = 0; i < list.size() && i < this.hussarPwdConfigService.getPwdRepeatTime(); ++i) {
                SysPasswordHist sysPasswordHist = list.get(i);
                if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
                updateInfoVo.setSuccess(false);
                updateInfoVo.setRepeatTime(this.hussarPwdConfigService.getPwdRepeatTime());
                updateInfoVo.setError("updateFail");
                return ApiResponse.success((Object)updateInfoVo);
            }
        }
        user.setPassword(nPwd);
        this.updatePwd(user);
        updateInfoVo.setSuccess(true);
        result.put("success", true);
        return ApiResponse.success((Object)updateInfoVo);
    }

    public ApiResponse<UpdateInfoVo> updatePasswordToReset(ResetPwdDto resetPwdDto) {
        String cPwd;
        String[] userIds = resetPwdDto.getUserIds() == null ? "".split(",") : resetPwdDto.getUserIds().split(",");
        String adminPwd = resetPwdDto.getSuperPws() == null ? "" : resetPwdDto.getSuperPws();
        String newPwd = resetPwdDto.getPassword() == null ? "" : resetPwdDto.getPassword();
        String string = cPwd = resetPwdDto.getPasswordRepeat() == null ? "" : resetPwdDto.getPasswordRepeat();
        if (this.hussarEncryptProperties.isEnablePwEncryption()) {
            adminPwd = this.passwordEncryptService.decrypt(adminPwd);
            newPwd = this.passwordEncryptService.decrypt(newPwd);
            cPwd = this.passwordEncryptService.decrypt(cPwd);
        }
        String aPwd = this.credentialsMatcher.passwordEncode(adminPwd.getBytes());
        Long userId = BaseSecurityUtil.getUser().getId();
        SysUsers user = this.getUser(userId);
        UpdateInfoVo updateInfoVo = new UpdateInfoVo();
        if (!aPwd.equalsIgnoreCase(user.getPassword())) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError(TranslateUtil.getTranslateName((String)TipConstantsEnum.RESET_FAIL_SECRET_ERROR_MARK.getMessage()));
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (!newPwd.equals(cPwd)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError(TranslateUtil.getTranslateName((String)TipConstantsEnum.RESET_FAIL_SECRET_NOT_SAME_MARK.getMessage()));
            return ApiResponse.success((Object)updateInfoVo);
        }
        String str = this.hussarPwdConfigService.getPwdComplexityRegular();
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replace("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String unmatchedHint = this.hussarPwdConfigService.getUnmatchedHint();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        if (!newPwd.matches(regular)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("unmatchedHintMark");
            updateInfoVo.setPwdRule(pwdRule);
            updateInfoVo.setHintMark(hint);
            updateInfoVo.setMsg(unmatchedHint);
            return ApiResponse.success((Object)updateInfoVo);
        }
        Object[] userIdL = (Long[])ConvertUtils.convert((String[])userIds, Long.class);
        List sysUsers = this.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, userIdL));
        for (SysUsers users : sysUsers) {
            if (!newPwd.toLowerCase().contains(users.getUserAccount().toLowerCase())) continue;
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("pwdContainUsernameMark");
            updateInfoVo.setUserName(users.getUserName());
            return ApiResponse.success((Object)updateInfoVo);
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        this.sysUsersMapper.resetAllPwd((Long[])userIdL, nPwd);
        for (String id : userIds) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            loginLock.removeUserCache(id);
        }
        updateInfoVo.setSuccess(true);
        return ApiResponse.success((Object)updateInfoVo);
    }

    public ApiResponse saveCopyRole(Long copyFrom, String copyTos) {
        String[] tos;
        Long from = copyFrom == null ? 0L : copyFrom;
        if (StringUtils.isBlank((CharSequence)copyTos)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_COPY_ROLE_CANNOT_BE_EMPTY.getMessage()));
        }
        for (String copyTo : tos = copyTos.split(",")) {
            boolean result = this.copyRole(from, Long.valueOf(copyTo));
            if (result) continue;
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.COPY_ROLE_FAIL_CONFLICT.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.COPY_ROLE_SUCCESS.getMessage()));
    }

    public ApiResponse updateSelfInfo(SelfInfoDto selfInfoDto) {
        Long shiroUserId = BaseSecurityUtil.getUser().getId();
        Long userId = selfInfoDto.getUserId() == null ? 0L : selfInfoDto.getUserId();
        String shiroUserIdStr = shiroUserId + "";
        if (shiroUserId != null && shiroUserIdStr.equals(String.valueOf(userId))) {
            String eMail = selfInfoDto.geteMail() == null ? "" : selfInfoDto.geteMail().trim();
            String weChat = selfInfoDto.getWeChat() == null ? "" : selfInfoDto.getWeChat().trim();
            String mobile = selfInfoDto.getMobile() == null ? "" : selfInfoDto.getMobile().trim();
            String telephone = selfInfoDto.getTelephone() == null ? "" : selfInfoDto.getTelephone().trim();
            SysUsers user = this.getById(userId);
            user.seteMail(eMail);
            user.setWeChat(weChat);
            user.setMobile(mobile);
            user.setTelephone(telephone);
            this.updateById((BaseEntity)user);
            this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ILLEGAL_REQUEST.getMessage()));
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                SysUserIp userIp;
                Integer n;
                Integer n2;
                Object obj = objects.get(i);
                if (obj instanceof SysUsers) {
                    SysUsers user = (SysUsers)obj;
                    if (this.updateById((BaseEntity)user)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((BaseEntity)user);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysUserIp && !this.iSysUserIpService.update((Object)(userIp = (SysUserIp)obj), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userIp.getUserId())).eq(SysUserIp::getUserIp, (Object)userIp.getUserIp()))) {
                    this.saveUserIP(userIp.getUserId(), userIp.getUserIp());
                }
                if (obj instanceof SysUserRole) {
                    SysUserRole userRole = (SysUserRole)obj;
                    if (this.sysUserRoleService.update((Object)userRole, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userRole.getUserId())).eq(SysUserRole::getGrantedRole, (Object)userRole.getGrantedRole()))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysUserRoleService.save((Object)userRole);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysStru) {
                    SysStru sysStru = (SysStru)obj;
                    if (SqlHelper.retBool((Integer)this.sysStruMapper.updateById(sysStru))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStruMapper.insert(sysStru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public boolean isCanAdd(SysUsers sysUsers) {
        this.checkTypeProperty(sysUsers);
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        if (this.isExistAccount(sysUsers.getUserAccount())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysStruAudit::getRealStruId, (Object)sysUsers.getEmployeeId())).eq(SysStruAudit::getState, (Object)"0");
        Long count = this.sysStruAuditMapper.selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THIS_PERSON_PROHIBIT_UPDATE.getMessage()));
        }
        return true;
    }

    private Boolean userAccountInAudit(String userAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUsersAudit::getUserAccount, (Object)userAccount)).eq(SysUsersAudit::getIsAudit, (Object)"0");
        List list = this.iSysUsersAuditService.list((Wrapper)wrapper);
        return HussarUtils.isNotEmpty((Object)list);
    }

    private void checkTypeProperty(SysUsers sysUsers) {
        if (UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty())) {
            LocalDateTime begin = sysUsers.getStartTime();
            LocalDateTime end = sysUsers.getExpiredTime();
            LocalDateTime now = LocalDateTime.now();
            if (!now.isAfter(begin) || !end.isAfter(now)) {
                sysUsers.setAccountStatus(UserStatus.DORMANCY.getCode());
            }
        }
    }

    private void validateParam(Object o, String mdType) {
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysUsers) {
            SysUsers reqBO = (SysUsers)o;
            if ("edit".equals(mdType) && null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getUserAccount())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getUserAccount()) && 255 < reqBO.getUserAccount().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_MAX_LENGTH.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getIsSys())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_IS_SYS_NOT_NULL.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getUserName())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_USER_NAME_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getUserName()) && 32 < reqBO.getUserName().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_USER_NAME_MAX_LENGTH.getMessage()));
            }
            if (null == reqBO.getMaxSessions()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_MAX_SESSIONS_NOT_NULL.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAccountStatus())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_STATUS_NOT_NULL.getMessage()));
            }
            if (null == reqBO.getSecurityLevel()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_SECURITY_LEVEL_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getMobile()) && 11 != reqBO.getMobile().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_VALID_MOBILE.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTelephone())) {
                String regTel = "^\\d{3,4}-\\d{8}$";
                if (!reqBO.getTelephone().matches(regTel)) {
                    sBuffer.append(",");
                    sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_VALID_TELEPHONE.getMessage()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.geteMail())) {
                String regEx1 = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
                if (!reqBO.geteMail().matches(regEx1)) {
                    sBuffer.append(",");
                    sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_VALID_EMAIL.getMessage()));
                }
            }
        }
        if (0 < sBuffer.length()) {
            String rspStr = sBuffer.substring(1);
            throw new BaseException(rspStr);
        }
    }

    private void validateImportData(List<SysUsers> users) {
        StringBuffer sBuffer = new StringBuffer();
        if (CollectionUtils.isEmpty(users)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOUSER_DATA_FOUND_IN_IMPORT_DATA.getMessage()));
        }
        for (int i = 0; i < users.size(); ++i) {
            int rowNum = i + 1;
            try {
                this.validateParam(users.get(i), "add");
                continue;
            }
            catch (BaseException e) {
                sBuffer.append(";");
                sBuffer.append(String.format(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROW_LINE.getMessage()), rowNum, e.getMessage()));
            }
        }
        if (0 < sBuffer.length()) {
            throw new BaseException(sBuffer.substring(1));
        }
    }

    public List<JSTreeModel> getUserByRole(Long roleId) {
        List<JSTreeModel> list = this.getUserTreeByRole(roleId);
        return list;
    }

    public List<JSTreeModel> getUserByRole(String roleId) {
        return this.getUserByRole(Long.parseLong(roleId));
    }

    public List<JSTreeModel> getLazyUserByRole(Long roleId, Long nodeId) {
        Long newNodeId = nodeId;
        ArrayList<JSTreeModel> jsTreeModels = new ArrayList<JSTreeModel>();
        if (newNodeId.equals(Constants.ROOT_NODE_PARENT)) {
            newNodeId = Constants.ROOT_NODE_ID;
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.ROOT_NODE_ID);
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ASSOCIATE_USER.getMessage()));
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setType("isRoot");
            jsTreeModels.add(root);
        }
        List<JSTreeModel> list = this.getLazyUserTreeByRole(roleId);
        ArrayList<JSTreeModel> retList = new ArrayList<JSTreeModel>(this.computUserByRole(list));
        for (JSTreeModel jsTreeModel : retList) {
            if (!jsTreeModel.getParent().equals(newNodeId)) continue;
            jsTreeModels.add(jsTreeModel);
        }
        this.listOrder(jsTreeModels);
        for (JSTreeModel model : jsTreeModels) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return TreeModelUtils.merge(jsTreeModels);
    }

    private List<JSTreeModel> computUserByRole(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> resultList = new ArrayList<JSTreeModel>();
        ArrayList<Long> ids = new ArrayList<Long>();
        list.forEach(u -> {
            if ("USER".equals(u.getType())) {
                ids.add(u.getId());
            }
        });
        this.computeUserRecursion(list, resultList, ids);
        return resultList;
    }

    private void computeUserRecursion(List<JSTreeModel> listData, List<JSTreeModel> resultList, List<Long> ids) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<JSTreeModel> tempList = new ArrayList<JSTreeModel>();
        for (JSTreeModel tmp : listData) {
            if (ids.contains(tmp.getId())) {
                resultList.add(tmp);
                if (tmp.getParent() == null) continue;
                parentIds.add(tmp.getParent());
                continue;
            }
            tempList.add(tmp);
        }
        if (ToolUtil.isNotEmpty(parentIds)) {
            this.computeUserRecursion(tempList, resultList, parentIds);
        }
    }

    private void listOrder(List<JSTreeModel> list) {
        Collections.sort(list, new Comparator<JSTreeModel>(){

            @Override
            public int compare(JSTreeModel o1, JSTreeModel o2) {
                if (SysUsersServiceImpl.this.formateObj(o1.getFirstOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getFirstOrder())) == 0) {
                    if (SysUsersServiceImpl.this.formateObj(o1.getStruLevel()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruLevel())) == 0) {
                        if (SysUsersServiceImpl.this.formateObj(o1.getStruOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruOrder())) == 0) {
                            return SysUsersServiceImpl.this.formateObj(o1.getText()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getText()));
                        }
                        return SysUsersServiceImpl.this.formateObj(o1.getStruOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruOrder()));
                    }
                    return SysUsersServiceImpl.this.formateObj(o1.getStruLevel()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruLevel()));
                }
                return SysUsersServiceImpl.this.formateObj(o1.getFirstOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getFirstOrder()));
            }
        });
    }

    private String formateObj(Object object) {
        return object == null ? "" : object.toString();
    }

    public ApiResponse<Page<PrincipalVo>> searchPrincipal(Long current, Long size, String name) {
        Page page = new Page();
        page.setCurrent(HussarUtils.isEmpty((Object)current) ? 1L : current);
        page.setSize(HussarUtils.isEmpty((Object)size) ? 0x7FFFFFFFFFFFFFFEL : size);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            String struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
            queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        }
        page.setRecords(this.sysUsersMapper.searchPrincipal((Page<PrincipalVo>)page, queryOrgParams));
        return ApiResponse.success((Object)page);
    }

    public List<JSTreeModel> getUserTreeByPrincipal(Long userId) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        final boolean isGradeAdmin = currentUser.isGradeadmin();
        final ArrayList<Object> result = new ArrayList<Object>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SYSTEM_USER.getMessage()));
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        result.add(jsTreeModel);
        Long deptId = currentUser.getDeptId();
        String currentStruFidT = "";
        final ArrayList<String> list = new ArrayList<String>();
        if (isGradeAdmin) {
            String[] split;
            currentStruFidT = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
            for (String s : split = currentStruFidT.split("/")) {
                if (!HussarUtils.isNotBlank((CharSequence)s)) continue;
                list.add(s);
            }
        }
        final String currentStruFid = currentStruFidT;
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(userId);
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(SysUsers::getDepartmentId, (Object)sysUsers.getDepartmentId());
        userWrapper.ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode());
        userWrapper.orderByAsc(SysUsers::getUserOrder);
        List userList = this.sysUsersMapper.selectList((Wrapper)userWrapper);
        ArrayList<JSTreeModel> usersJSTreeModel = new ArrayList<JSTreeModel>();
        JSTreeModel temp = null;
        for (SysUsers u : userList) {
            temp = new JSTreeModel();
            temp.setId(u.getId());
            temp.setText(u.getUserName());
            temp.setCode("USER");
            temp.setIsEmployee(ADD);
            temp.setParent(u.getDepartmentId());
            temp.setChildren("false");
            temp.setType("USER");
            temp.setStruType("9");
            usersJSTreeModel.add(temp);
        }
        result.addAll(usersJSTreeModel);
        String paramStruFid = "/%";
        int parentLevel = 1;
        final HashMap<Integer, String> mapStruFid = new HashMap<Integer, String>();
        if (!Constants.ROOT_NODE_ID.equals(sysUsers.getDepartmentId())) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(sysUsers.getDepartmentId());
            parentLevel = sysStru.getStruLevel();
            String struFid = sysStru.getStruFid();
            for (int i = 1; i <= parentLevel; ++i) {
                mapStruFid.put(i, OrganUtil.getStruFidByLevel((String)struFid, (int)i));
            }
            paramStruFid = (String)mapStruFid.get(1) + "%";
        }
        this.sysStruMapper.findInstitutionAndStaff(paramStruFid, parentLevel, new ResultHandler<InstitutionVo>(){

            public void handleResult(ResultContext<? extends InstitutionVo> resultContext) {
                String reduceStruFidByLevel;
                InstitutionVo t = (InstitutionVo)resultContext.getResultObject();
                int level = t.getStruLevel();
                Long id = t.getId();
                String fid = t.getStruFid();
                String text = t.getLabel();
                Long parent = t.getParentId();
                String organType = t.getStruType();
                boolean flag = false;
                if (isGradeAdmin) {
                    if (list.contains(id + "")) {
                        flag = true;
                    } else if (fid.startsWith(currentStruFid) && fid.startsWith((reduceStruFidByLevel = (String)mapStruFid.get(level - 1)) + "/")) {
                        flag = true;
                    }
                } else if (level == OrganConstants.ORGAN_LEVEL) {
                    flag = true;
                } else {
                    reduceStruFidByLevel = (String)mapStruFid.get(level - 1);
                    if (fid.startsWith(reduceStruFidByLevel + "/")) {
                        flag = true;
                    }
                }
                if (flag) {
                    JSTreeModel jsTreeModelT = new JSTreeModel();
                    if (isGradeAdmin) {
                        jsTreeModelT.getState().put("gradeDisabled", true);
                    }
                    jsTreeModelT.setId(id);
                    jsTreeModelT.setText(text);
                    jsTreeModelT.setParent(parent);
                    jsTreeModelT.setChildrenList(new ArrayList());
                    jsTreeModelT.setChildren("true");
                    jsTreeModelT.setStruType(organType);
                    jsTreeModelT.setStruLevel(level + "");
                    jsTreeModelT.setType(organType);
                    result.add(jsTreeModelT);
                }
            }
        });
        return TreeModelUtils.merge(result);
    }

    public IPage<UserOrgVo> searchUsers(Page<UserOrgVo> page, UserQueryReqDto userQueryReqDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        if (currentUser.isGradeadmin()) {
            if (HussarUtils.isEmpty((Object)userQueryReqDto.getDepStruId())) {
                userQueryReqDto.setDepStruId(currentUser.getDeptId());
            } else {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)userQueryReqDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    userQueryReqDto.setDepStruId(currentUser.getDeptId());
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)userQueryReqDto.getDepStruId()) && !Objects.equals(Constants.ROOT_NODE_ID, userQueryReqDto.getDepStruId())) {
            struFid = ((SysStru)this.sysStruMapper.selectById(userQueryReqDto.getDepStruId())).getStruFid();
        }
        if (HussarUtils.isNotEmpty((Object)userQueryReqDto.getDepStruId()) && !Objects.equals(Constants.ROOT_NODE_ID, userQueryReqDto.getDepStruId())) {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(userQueryReqDto.getDepStruId());
            if (HussarUtils.isEmpty((Object)struTemp)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
            }
            struFid = struTemp.getStruFid();
        } else {
            queryParams.put("containSys", ADD);
        }
        userQueryReqDto.setStruFid(struFid);
        if ("0".equals(userQueryReqDto.getUserStatus()) || ADD.equals(userQueryReqDto.getUserStatus())) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            userQueryReqDto.setLockUserIds(lockUserIds);
            Object[] arr = new String[]{"0", ADD};
            if (userQueryReqDto.getUserStatus() != null && ArrayUtils.contains((Object[])arr, (Object)userQueryReqDto.getUserStatus()) && CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if ("0".equals(userQueryReqDto.getUserStatus()) && ToolUtil.isEmpty(lockUserIds)) {
                return page;
            }
        }
        queryParams.put("depStruId", userQueryReqDto.getDepStruId());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)userQueryReqDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToNull((String)userQueryReqDto.getUserStatus()));
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)userQueryReqDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToNull((String)userQueryReqDto.getUserProperty()));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<UserOrgVo> userInfoList = this.sysUsersMapper.findAccountUserListNew(page, queryParams);
        if (currentUser.isGradeadmin()) {
            userInfoList.forEach(o -> {
                if (currentUser.getId().equals(o.getId())) {
                    o.setIsLanding(ADD);
                }
            });
        }
        this.updateAccountStatus(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    public Map<String, Integer> saveOrUpdateBatchUsers(List<SysUsers> users) {
        Long insertCount;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<Long> userIds = users.stream().map(SysUsers::getId).collect(Collectors.toList());
        List<SysUsers> existedUsers = this.queryUserManager.selectUsersByIds(userIds);
        ArrayList<SysUsers> repeatUsers = new ArrayList<SysUsers>();
        List<Object> newUsers = new ArrayList();
        if (HussarUtils.isNotEmpty(existedUsers)) {
            List repeatIds = existedUsers.stream().map(SysUsers::getId).collect(Collectors.toList());
            for (SysUsers sysUsers : users) {
                if (repeatIds.contains(sysUsers.getId())) {
                    repeatUsers.add(sysUsers);
                    continue;
                }
                newUsers.add(sysUsers);
            }
            map.put("insert", newUsers.size());
            map.put("update", repeatUsers.size());
            insertCount = Long.parseLong(newUsers.size() + "");
        } else {
            newUsers = users;
            insertCount = Long.parseLong(newUsers.size() + "");
            map.put("insert", newUsers.size());
            map.put("update", 0);
        }
        this.validateUserManager.validateBatchLimit(insertCount);
        if (HussarUtils.isNotEmpty(newUsers)) {
            this.saveBatch(newUsers);
        }
        if (HussarUtils.isNotEmpty(repeatUsers)) {
            this.updateBatchById(repeatUsers);
        }
        return map;
    }

    @HussarDs(value="#connName")
    public void resetTenantPwd(String connName, String tenantCode, Long userId, String newPwd) {
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        Long[] userIds = new Long[]{userId};
        this.sysUsersMapper.resetAllPwd(userIds, newPwd);
        try {
            String cacheKey = tenantCode + ":" + "Login_Lock" + "::" + userId;
            ((RedisTemplate)SpringContextHolder.getBean(RedisTemplate.class)).delete((Object)cacheKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SysUsers getUserByAccountAndStatus(String connName, String userAccount, List<String> accountStatus) {
        return this.sysUsersAdapter.getUserByAccountAndStatus(connName, userAccount, accountStatus);
    }

    public Page<RoleUserVo> getUsersByNameList(PageInfo pageInfo, List<String> userNameList, List<String> userAccountList, QueryUserDto queryUserDto) {
        String struPath;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)queryUserDto.getDepStruId())) {
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) ? "0" : ADD;
            Long parentId = this.queryOrganizationManager.getGradeOrganType(queryUserDto.getDepStruId(), BaseSecurityUtil.getUser());
            if (HussarUtils.isEmpty((Object)parentId)) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(parentId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            queryUserDto.setDepStruId(parentId);
        }
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        queryParams.put("containSys", StringUtils.trimToEmpty((String)queryUserDto.getContainSys()));
        if (Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            struPath = "0";
        } else if (Objects.equals(Constants.OUT_STRU_NODE_ID, depStruId.get())) {
            struPath = ADD;
            queryParams.put("containSys", "0");
        } else {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            if (HussarUtils.isNotEmpty((Object)struTemp)) {
                struPath = struTemp.getStruFid();
                queryParams.put("containSys", "0");
            } else {
                struPath = "";
            }
        }
        if (HussarUtils.isNotEmpty(userNameList)) {
            queryParams.put("userNameList", userNameList);
        } else {
            queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName()));
        }
        if (HussarUtils.isNotEmpty(userAccountList)) {
            queryParams.put("userAccountList", userAccountList);
        } else {
            queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserAccount()));
        }
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("struPath", struPath);
        List<RoleUserVo> userInfoList = this.sysUsersMapper.getUsersByNameAndAccountList((Page<RoleUserVo>)page, queryParams);
        page.setRecords(userInfoList);
        return page;
    }

    public Page<RoleUserVo> getUsersByNameSingle(PageInfo pageInfo, QueryUserDto queryUserDto) {
        String struPath;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)queryUserDto.getDepStruId())) {
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) ? "0" : ADD;
            Long parentId = this.queryOrganizationManager.getGradeOrganType(queryUserDto.getDepStruId(), BaseSecurityUtil.getUser());
            if (HussarUtils.isEmpty((Object)parentId)) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(parentId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            queryUserDto.setDepStruId(parentId);
        }
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        queryParams.put("containSys", StringUtils.trimToEmpty((String)queryUserDto.getContainSys()));
        if (Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            struPath = "0";
        } else if (Objects.equals(Constants.OUT_STRU_NODE_ID, depStruId.get())) {
            struPath = ADD;
            queryParams.put("containSys", "0");
        } else {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            if (HussarUtils.isNotEmpty((Object)struTemp)) {
                struPath = struTemp.getStruFid();
                queryParams.put("containSys", "0");
            } else {
                struPath = "";
            }
        }
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserAccount()));
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName()));
        queryParams.put("struPath", struPath);
        List<RoleUserVo> userInfoList = this.sysUsersMapper.getUsersByUserNameSingle((Page<RoleUserVo>)page, queryParams);
        page.setRecords(userInfoList);
        return page;
    }

    public Integer getUserMaxOrder() {
        return this.sysUsersMapper.getUserMaxOrder();
    }

    @HussarDs(value="#connName")
    public List<ResetSecureUserVo> searchResetSecureUserVo(Page<ResetSecureUserVo> page, String connName, Map<String, Object> queryParams) {
        return this.sysUsersMapper.searchResetSecureUserVo(page, queryParams);
    }

    public UserStaffVo getUserAndStaffInfo(Long userId) {
        UserStaffVo vo = (UserStaffVo)HussarCacheUtil.get((String)"low_code_user_info", (Object)userId);
        if (HussarUtils.isEmpty((Object)vo) && HussarUtils.isNotEmpty((Object)(vo = this.sysUsersMapper.getUserAndStaffInfo(userId)))) {
            HussarCacheUtil.put((String)"low_code_user_info", (Object)userId, (Object)vo, (long)180L);
        }
        return vo;
    }

    public Page<SysUsers> getList(Page<SysUsers> page, QueryWrapper<SysUsers> queryWrapper) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        Page sysUsersPage = (Page)this.sysUsersMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = sysUsersPage.getRecords();
        if (records != null && records.size() > 0) {
            for (int i = 0; i < records.size(); ++i) {
                ((SysUsers)records.get(i)).setPassword("");
            }
        }
        return sysUsersPage;
    }
}

