/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.vo.OrganRightVo;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleOrganVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCustomInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserRightVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleDataRightBoServiceImpl
implements ISysRoleDataRightBoService {
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;
    @Resource
    private SysRoleDataRightMapper sysRoleDataRightMapper;

    public List<SysRoleDataRight> list(List<Long> roleIds, List<Long> funIds) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(HussarUtils.isNotEmpty(roleIds), SysRoleDataRight::getRoleId, roleIds)).in(HussarUtils.isNotEmpty(funIds), SysRoleDataRight::getFunctionId, funIds);
        return this.sysRoleDataRightService.list((Wrapper)wrapper);
    }

    public boolean removeByIds(List<Long> roleRightIds) {
        return this.sysRoleDataRightService.removeByIds(roleRightIds);
    }

    public boolean saveBatch(List<SysRoleDataRight> roleDataRightList) {
        return this.sysRoleDataRightService.saveBatch(roleDataRightList);
    }

    public List<UserVo> getUserRightsData(Long roleRightId) {
        return this.sysRoleDataRightMapper.getUserRightsData(roleRightId);
    }

    public List<SimpleOrganVo> getOrganRightsData(Long roleRightId) {
        return this.sysRoleDataRightMapper.getOrganRightsData(roleRightId);
    }

    public Boolean deleteRoleDataRightByRoleIds(List<Long> roleIds) {
        this.sysRoleDataRightMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysRoleDataRight::getRoleId, roleIds));
        return Boolean.TRUE;
    }

    public List<DataRightCustomInfoVo> selectDataRightCustomInfo(List<Long> roleRightIds) {
        ArrayList<DataRightCustomInfoVo> result = new ArrayList<DataRightCustomInfoVo>();
        List<UserRightVo> userRightVos = this.sysRoleDataRightMapper.getUserRightsDataByRightIds(roleRightIds);
        Map<Long, List<UserRightVo>> userMap = userRightVos.stream().collect(Collectors.groupingBy(UserRightVo::getDataRightId));
        List<OrganRightVo> organRightVos = this.sysRoleDataRightMapper.getOrganRightsDataByRightIds(roleRightIds);
        Map<Long, List<OrganRightVo>> organMap = organRightVos.stream().collect(Collectors.groupingBy(OrganRightVo::getDataRightId));
        for (Long roleRightId : roleRightIds) {
            List<OrganRightVo> organRightVoList;
            DataRightCustomInfoVo vo = new DataRightCustomInfoVo();
            vo.setDataRightId(roleRightId);
            List<UserRightVo> userRightVoList = userMap.get(roleRightId);
            if (HussarUtils.isNotEmpty(userRightVoList)) {
                ArrayList<UserVo> userVos = new ArrayList<UserVo>();
                for (UserRightVo userRightVo : userRightVoList) {
                    UserVo userVo = new UserVo();
                    BeanUtil.copy((Object)userRightVo, (Object)userVo);
                    userVos.add(userVo);
                }
                vo.setUserVos(userVos);
            }
            if (HussarUtils.isNotEmpty(organRightVoList = organMap.get(roleRightId))) {
                ArrayList<SimpleOrganVo> organVos = new ArrayList<SimpleOrganVo>();
                for (OrganRightVo organRightVo : organRightVoList) {
                    SimpleOrganVo organVo = new SimpleOrganVo();
                    BeanUtil.copy((Object)organRightVo, (Object)organVo);
                    organVos.add(organVo);
                }
                vo.setSimpleOrganVos(organVos);
            }
            result.add(vo);
        }
        return result;
    }
}

