/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ILocalDataScopeAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCacheVo;
import com.jxdinfo.hussar.authorization.permit.vo.OptionVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datascope.core.enums.DataScopeEnum;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeInfo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalDataScopeAdapterServiceImpl
implements ILocalDataScopeAdapterService {
    @Resource
    @Lazy
    private SysStruMapper sysStruMapper;
    @Resource
    @Lazy
    private ISysStruAssistOrganService assistOrganService;
    @Resource
    @Lazy
    private ISysUsersService usersService;
    @Resource
    @Lazy
    private SysOrgManageService sysOrgManageService;
    @Resource
    @Lazy
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;

    public List<DataScopeInfo> getDataScope(Long userId, String mapper, String serverName) {
        SecurityUser shirouser = BaseSecurityUtil.getUser();
        assert (shirouser != null);
        List roleIdList = shirouser.getRolesList();
        List<Object> dataRightCacheVoList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)roleIdList)) {
            for (Long roleId : roleIdList) {
                List cacheList = (List)HussarCacheUtil.get((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
                if (!HussarUtils.isNotEmpty((Object)cacheList)) continue;
                dataRightCacheVoList.addAll(cacheList);
            }
            if (HussarUtils.isNotBlank((CharSequence)serverName)) {
                dataRightCacheVoList = dataRightCacheVoList.stream().filter(item -> HussarUtils.equals((Object)serverName, (Object)item.getServerName()) || HussarUtils.equals((Object)"hussar-web", (Object)serverName) && HussarUtils.isEmpty((Object)item.getServerName())).collect(Collectors.toList());
            }
        }
        if (HussarUtils.isEmpty(dataRightCacheVoList)) {
            return null;
        }
        DataScopeInfo dataRightScopeVo = new DataScopeInfo();
        ArrayList<DataScopeInfo> customDataRights = new ArrayList<DataScopeInfo>();
        List<Object> deptIdList = new ArrayList<Long>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        ArrayList customdeptIdList = new ArrayList();
        ArrayList<String> organTypes = new ArrayList<String>();
        for (DataRightCacheVo dataRightCacheVo : dataRightCacheVoList) {
            if (!mapper.equals(dataRightCacheVo.getMapper())) continue;
            if (HussarUtils.equals((Object)"res_rights", (Object)dataRightCacheVo.getResTypeCode()) || HussarUtils.equals((Object)"res_form_rights", (Object)dataRightCacheVo.getResTypeCode())) {
                dataRightScopeVo.setUserScopeField(dataRightCacheVo.getUserRight());
                dataRightScopeVo.setDeptScopeField(dataRightCacheVo.getDeptRight());
                dataRightScopeVo.setResTypeCode(dataRightCacheVo.getResTypeCode());
                typeList.add(dataRightCacheVo.getType());
                if (ToolUtil.isNotEmpty((Object)dataRightCacheVo.getDeptId())) {
                    customdeptIdList.addAll(dataRightCacheVo.getDeptId());
                }
                if (!HussarUtils.equals((Object)"6", (Object)String.valueOf(dataRightCacheVo.getType()))) continue;
                Map dynamicParameterValue = (Map)JSONObject.parseObject((String)dataRightCacheVo.getCustomDataCondition(), (TypeReference)new TypeReference<Map<String, List<OptionVo>>>(){}, (Feature[])new Feature[0]);
                organTypes.add(((OptionVo)((List)dynamicParameterValue.get("gradeOrganType")).get(0)).getValue());
                continue;
            }
            DataScopeInfo customVo = new DataScopeInfo();
            customVo.setResTypeCode(dataRightCacheVo.getResTypeCode());
            customVo.setScopeLabel(dataRightCacheVo.getDataScopeLabel());
            Map dynamicParameterValue = (Map)JSONObject.parseObject((String)dataRightCacheVo.getCustomDataCondition(), (TypeReference)new TypeReference<Map<String, List<OptionVo>>>(){}, (Feature[])new Feature[0]);
            HashMap customDataCondition = new HashMap();
            if (HussarUtils.isNotEmpty((Object)dynamicParameterValue)) {
                for (Map.Entry entry : dynamicParameterValue.entrySet()) {
                    List values = ((List)entry.getValue()).stream().map(OptionVo::getValue).collect(Collectors.toList());
                    customDataCondition.put(entry.getKey(), values);
                }
            }
            customVo.setCustomDataConditionValueMap(customDataCondition);
            customDataRights.add(customVo);
        }
        ArrayList<DataScopeInfo> dataScopeInfos = new ArrayList<DataScopeInfo>();
        if (HussarUtils.isNotEmpty(typeList)) {
            SysUsers sysUsers = this.usersService.getUser(shirouser.getId());
            int min = (Integer)Collections.min(typeList);
            if (min == DataScopeEnum.OWN_DEPT_CHILD.getType()) {
                deptIdList.addAll(this.getDeptIds(sysUsers, true));
            } else if (min == DataScopeEnum.OWN_DEPT.getType()) {
                deptIdList.addAll(this.getDeptIds(sysUsers, false));
            } else if (min == DataScopeEnum.CUSTOM.getType()) {
                deptIdList.addAll(customdeptIdList);
            } else if (min == DataScopeEnum.ORGAN_GRADE.getType()) {
                SysStru stru = (SysStru)this.sysStruMapper.selectById(shirouser.getDeptId());
                if (HussarUtils.isNotEmpty((Object)stru)) {
                    String type = this.sysOrgManageService.getTopTypeByTypeInList(stru.getStruType(), organTypes);
                    Long parentId = this.sysOrgManageService.getParentOrganByType(shirouser.getDeptId(), type);
                    if (HussarUtils.isNotEmpty((Object)parentId)) {
                        List allSubOrgan = this.hussarBaseOrganizationBoService.getAllSubOrgan(parentId);
                        deptIdList.addAll(allSubOrgan.stream().map(o -> Long.parseLong(o.getId())).collect(Collectors.toList()));
                    }
                }
                deptIdList.add(-1L);
            }
            deptIdList = deptIdList.stream().distinct().collect(Collectors.toList());
            dataRightScopeVo.setScopeTypes(typeList);
            dataRightScopeVo.setScopeDeptIds(deptIdList);
            dataScopeInfos.add(dataRightScopeVo);
        }
        dataScopeInfos.addAll(customDataRights);
        return dataScopeInfos;
    }

    public List<Long> getDeptIds(Integer type, Long userid) {
        SysUsers user = this.usersService.getUser(userid);
        if (type == Integer.parseInt("2")) {
            return this.getDeptIds(user, true);
        }
        if (type == Integer.parseInt("3")) {
            return this.getDeptIds(user, false);
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PASS_CORRECT_VISIBLE_RANGE.getMessage()));
    }

    private List<Long> getDeptIds(SysUsers sysUsers, boolean hasChildren) {
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        SecurityUser user = BaseSecurityUtil.getUser();
        deptIdList.add(HussarUtils.isEmpty((Object)user.getDeptId()) ? 11L : user.getDeptId());
        deptIdList.addAll(this.getAssitStru(sysUsers.getEmployeeId()));
        if (hasChildren) {
            deptIdList.addAll(this.getChildren(deptIdList));
        }
        return deptIdList;
    }

    private List<Long> getAssitStru(Long struId) {
        List list = this.assistOrganService.list((Wrapper)new LambdaQueryWrapper(SysStruAssistOrgan.class).eq(SysStruAssistOrgan::getStruId, (Object)struId));
        return list.stream().map(SysStruAssistOrgan::getAssistParentId).collect(Collectors.toList());
    }

    private List<Long> getChildren(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(SysStru.class);
        List sysStrus = this.sysStruMapper.selectList((Wrapper)wrapper.in(SysStru::getId, struIds));
        wrapper.clear();
        sysStrus.forEach(stru -> ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)stru.getStruFid()));
        List children = this.sysStruMapper.selectList((Wrapper)wrapper);
        return children.stream().map(SysStru::getId).collect(Collectors.toList());
    }
}

