/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.manager.AddResourceManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditResourceManager;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppFuncResDto;
import com.jxdinfo.hussar.authorization.permit.dto.UpdateResourceDto;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseResourceServiceImpl")
public class HussarBaseResourceServiceImpl
implements IHussarBaseResourceService {
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private AddResourceManager addResourceManager;
    @Resource
    private EditResourceManager editResourceManager;
    @Resource
    private SysResourcesMapper sysResourcesMapper;

    public ApiResponse<Boolean> saveResource(SysResources sysResources) {
        if (ToolUtil.isEmpty((Object)sysResources)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_RESOURCE_INFO_NOT_NULL.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysResources.getId())) {
            this.addResourceManager.addResource(sysResources);
        } else {
            this.editResourceManager.editResource(sysResources);
        }
        return ApiResponse.success((Object)true);
    }

    public Boolean saveBatchResource(List<SysResources> resourcesList) {
        return this.sysResourcesService.saveBatch(resourcesList);
    }

    public SysResources getResourcesByCode(String code) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getResourceCode, (Object)code);
        queryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return (SysResources)this.sysResourcesService.getOne((Wrapper)queryWrapper);
    }

    public List<SysResources> getResListLikeCode(String code) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().like(SysResources::getResourceCode, (Object)code);
        queryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return this.sysResourcesService.list((Wrapper)queryWrapper);
    }

    public List<SysResources> getResourcesByModuleId(Long moduleId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getModuleId, (Object)moduleId);
        queryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return this.sysResourcesService.list((Wrapper)queryWrapper);
    }

    public Boolean updateNameAliasByCode(UpdateResourceDto updateResourceDto) {
        String code = updateResourceDto.getCode();
        String name = updateResourceDto.getName();
        String aliasName = updateResourceDto.getAlias();
        String langKey = updateResourceDto.getLangKey();
        LambdaUpdateWrapper resUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)resUpdateWrapper.eq(SysResources::getResourceCode, (Object)code)).set(HussarUtils.isNotBlank((CharSequence)name), SysResources::getResourceName, (Object)name)).set(HussarUtils.isNotBlank((CharSequence)aliasName), SysResources::getResourceAlias, (Object)aliasName)).set(SysResources::getAliasLangKey, (Object)langKey)).set(SysResources::getNameLangKey, (Object)langKey);
        return this.sysResourcesService.update((Wrapper)resUpdateWrapper);
    }

    public Boolean updateNameAliasById(UpdateResourceDto updateResourceDto) {
        Long id = updateResourceDto.getId();
        String name = updateResourceDto.getName();
        String aliasName = updateResourceDto.getAlias();
        String langKey = updateResourceDto.getLangKey();
        LambdaUpdateWrapper resUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarUtils.isNotBlank((CharSequence)name), SysResources::getResourceName, (Object)name)).set(HussarUtils.isNotBlank((CharSequence)aliasName), SysResources::getResourceAlias, (Object)aliasName)).set(SysResources::getAliasLangKey, (Object)langKey)).set(SysResources::getNameLangKey, (Object)langKey)).eq(SysResources::getId, (Object)id);
        return this.sysResourcesService.update((Wrapper)resUpdateWrapper);
    }

    public Boolean deleteOneResourcesById(Long id) {
        return this.sysResourcesService.removeById((Serializable)id);
    }

    public Boolean deleteResourcesByIds(List<Long> ids) {
        return this.sysResourcesService.removeByIds(ids);
    }

    public Boolean saveOneResource(SysResources sysResources) {
        return this.sysResourcesService.save((Object)sysResources);
    }

    public List<SysResources> list(List<Long> formIds, List<String> resTypeIds) {
        LambdaQueryWrapper resourcesLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(HussarUtils.isNotEmpty(formIds), SysResources::getModuleId, formIds)).in(HussarUtils.isNotEmpty(resTypeIds), SysResources::getResTypeId, resTypeIds)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        return this.sysResourcesService.list((Wrapper)resourcesLambdaQueryWrapper);
    }

    public Integer getMaxOrderByParentId(Long parentId) {
        Integer order = this.sysResourcesService.getMaxOrderByParentId(parentId);
        if (HussarUtils.isEmpty((Object)order)) {
            return 0;
        }
        return order;
    }

    public List<SysResources> getResourceList(QueryAppFuncResDto queryAppFuncResDto) {
        Long roleId = queryAppFuncResDto.getRoleId();
        Long appId = queryAppFuncResDto.getAppId();
        Long formId = queryAppFuncResDto.getFormId();
        List roleIds = queryAppFuncResDto.getRoleIds();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("roleId", roleId);
        queryParams.put("roleIds", roleIds);
        queryParams.put("appId", appId);
        queryParams.put("formId", formId);
        return this.sysResourcesMapper.getAppResourceList(queryParams);
    }
}

