/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.manager.SortOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.sortOrganizationManagerImpl")
public class SortOrganizationManagerImpl
implements SortOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortOrganizationManagerImpl.class);
    @Resource
    private ISysStruService sysStruService;

    @Override
    public String sortOrganization(List<Long> idList) {
        int i;
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_SORTING.getMessage()));
        AssertUtil.isNotEmpty(idList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        LambdaQueryWrapper queryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStru::getId, idList);
        ((LambdaQueryWrapper)queryWrapper.ne(SysStru::getStruType, (Object)"9")).orderByAsc(SysStru::getStruSeq);
        List list = this.sysStruService.list((Wrapper)queryWrapper);
        AssertUtil.isTrue((idList.size() == list.size() ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CONTAINS_NON_ORG.getMessage()));
        ArrayList<Long> ids = new ArrayList<Long>();
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_COMPARE_ID_ORDER.getMessage()));
        for (int i2 = 0; i2 < idList.size(); ++i2) {
            if (Objects.equals(((SysStru)list.get(i2)).getId(), idList.get(i2))) continue;
            ids.add(idList.get(i2));
        }
        ArrayList<SysStru> update = new ArrayList<SysStru>();
        if (HussarUtils.isNotEmpty(ids)) {
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_SORT_CHANGED.getMessage()));
            List listTemp = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysStru::getStruType, (Object)"9")).in(SysStru::getId, ids)).orderByAsc(SysStru::getStruSeq));
            Map map = listTemp.stream().collect(Collectors.toMap(SysStru::getId, Function.identity()));
            for (i = 0; i < ids.size(); ++i) {
                SysStru sysStruT = (SysStru)map.get(ids.get(i));
                String oldStruSeq = sysStruT.getStruSeq();
                String newStruSeq = ((SysStru)listTemp.get(i)).getStruSeq();
                List searchResult = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStruT.getStruFid()));
                if (!HussarUtils.isNotEmpty((Object)searchResult)) continue;
                for (SysStru temp : searchResult) {
                    temp.setStruSeq(temp.getStruSeq().replaceFirst(oldStruSeq, newStruSeq));
                    update.add(temp);
                }
            }
        }
        if (HussarUtils.isNotEmpty(update)) {
            this.sysStruService.updateBatchById(update);
        }
        Map mapSysStru = this.sysStruService.list((Wrapper)queryWrapper).stream().collect(Collectors.toMap(SysStru::getId, Function.identity()));
        ArrayList<SysStru> sysStruList = new ArrayList<SysStru>();
        for (i = 0; i < idList.size(); ++i) {
            Long struId = idList.get(i);
            SysStru sysStru = (SysStru)mapSysStru.get(struId);
            if (!HussarUtils.isNotEmpty((Object)sysStru)) continue;
            sysStru.setStruOrder(Integer.valueOf(i + 1));
            sysStruList.add(sysStru);
        }
        if (HussarUtils.isNotEmpty(sysStruList)) {
            this.sysStruService.updateBatchById(sysStruList);
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage());
    }
}

