/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.adapter.function.IHussarBaseFunctionAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncResDelDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysFunctionResourcesServiceImpl
extends HussarBaseServiceImpl<SysFunctionResourcesMapper, SysFunctionResources>
implements ISysFunctionResourcesService {
    private static Logger logger = LoggerFactory.getLogger(SysFunctionResourcesServiceImpl.class);
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    @Lazy
    private ISysRoleFunctionsService iSysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private QueryDataRightManager queryDataRightManager;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private IHussarBaseFunctionAdapter hussarBaseFunctionAdapter;

    public boolean save(SysFunctionResources entity) {
        return this.hussarBaseFunctionAdapter.saveFuncRes(entity);
    }

    public boolean saveBatch(Collection<SysFunctionResources> entityList) {
        return this.hussarBaseFunctionAdapter.saveBatchFuncRes((List)entityList);
    }

    public List<SysFunctionResources> listByResIds(List<Long> resIds) {
        return this.hussarBaseFunctionAdapter.listByResIds(resIds);
    }

    public Map<String, Object> getFunctionResourceList(String functionId, String page, String limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
        List<Map<String, String>> list = this.sysFunctionResourcesMapper.getFunctionResourceList(pages, functionId);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    public int deleteFunRes(FuncResDelDto funcResDelDto) {
        String functionId = ToolUtil.isNotEmpty((Object)funcResDelDto.getFunctionId()) ? funcResDelDto.getFunctionId() : "";
        List resourceIds = ToolUtil.isNotEmpty((Object)funcResDelDto.getResourceIds()) ? funcResDelDto.getResourceIds() : new ArrayList();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleFunctions::getFunctionId, (Object)functionId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list((Wrapper)queryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctionsList)) {
            for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
                roleIds.add(sysRoleFunctions.getRoleId());
            }
        }
        if (ToolUtil.isNotEmpty(roleIds)) {
            LambdaQueryWrapper queryWrapperRr = new LambdaQueryWrapper();
            queryWrapperRr.in(SysRoleResource::getRoleId, roleIds);
            queryWrapperRr.in(SysRoleResource::getResourceId, (Collection)resourceIds);
            this.iSysRoleResourceService.remove((Wrapper)queryWrapperRr);
        }
        return this.sysFunctionResourcesMapper.deleteFunRes(functionId, resourceIds);
    }

    public boolean saveFunctionRes(Long functionId, List<Map<String, String>> resources) {
        QueryWrapper queryWrapperFr = new QueryWrapper();
        queryWrapperFr.eq((Object)"FUNCTION_ID", (Object)functionId);
        List<FuncResVo> sysFunctionResourcesMap = this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
        ArrayList resourceIds = new ArrayList();
        ArrayList<Long> delResourceIds = new ArrayList<Long>();
        sysFunctionResourcesMap.parallelStream().forEach(sysFunctionResources -> {
            Long resourceId = sysFunctionResources.getResourceId();
            resourceIds.add(resourceId);
            delResourceIds.add(resourceId);
        });
        if (ToolUtil.isNotEmpty(resourceIds)) {
            this.remove((Wrapper)queryWrapperFr);
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"FUNCTION_ID", (Object)functionId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list((Wrapper)queryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctionsList)) {
            for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
                roleIds.add(sysRoleFunctions.getRoleId());
            }
        }
        for (Map map : resources) {
            delResourceIds.add(Long.valueOf((String)map.get("id")));
        }
        if (ToolUtil.isNotEmpty(roleIds) && ToolUtil.isNotEmpty(delResourceIds)) {
            LambdaQueryWrapper queryWrapperRr = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getRoleId, roleIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)queryWrapperRr, SysRoleResource::getResourceId, delResourceIds);
            queryWrapperRr.eq(SysRoleResource::getRelationSource, (Object)"1");
            this.iSysRoleResourceService.remove((Wrapper)queryWrapperRr);
        }
        ArrayList<SysFunctionResources> sysFunctionResourcesSaveList = new ArrayList<SysFunctionResources>();
        ArrayList<SysRoleResource> arrayList = new ArrayList<SysRoleResource>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        ArrayList newResIdList = new ArrayList();
        for (Map<String, String> resource : resources) {
            SysFunctionResources sysFunctionResources2 = new SysFunctionResources();
            sysFunctionResources2.setResourceId(Long.valueOf(resource.get("id")));
            sysFunctionResources2.setFunctionId(functionId);
            sysFunctionResources2.setCreator(securityUser.getId());
            sysFunctionResources2.setLastEditor(securityUser.getId());
            sysFunctionResources2.setLastTime(now);
            sysFunctionResources2.setCreateTime(now);
            sysFunctionResourcesSaveList.add(sysFunctionResources2);
            if (!ToolUtil.isNotEmpty(roleIds)) continue;
            for (Long roleId : roleIds) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setResourceId(Long.valueOf(resource.get("id")));
                sysRoleResource.setRoleId(roleId);
                sysRoleResource.setRelationSource("1");
                sysRoleResource.setCreator(securityUser.getId());
                sysRoleResource.setLastEditor(securityUser.getId());
                sysRoleResource.setLastTime(now);
                sysRoleResource.setCreateTime(now);
                arrayList.add(sysRoleResource);
            }
        }
        if (ToolUtil.isNotEmpty(arrayList)) {
            this.iSysRoleResourceService.saveBatch(arrayList);
        }
        boolean saveFlag = this.saveBatch(sysFunctionResourcesSaveList);
        this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIds);
        return saveFlag;
    }

    @HussarDs(value="#connName")
    public void saveFunctionRes(String connName, Long functionId, List<Map<String, String>> resources) {
        QueryWrapper queryWrapperFr = new QueryWrapper();
        queryWrapperFr.eq((Object)"FUNCTION_ID", (Object)functionId);
        List<FuncResVo> sysFunctionResourcesMap = this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
        if (HussarUtils.isEmpty(sysFunctionResourcesMap)) {
            return;
        }
        ArrayList resourceIds = new ArrayList();
        ArrayList<Long> delResourceIds = new ArrayList<Long>();
        sysFunctionResourcesMap.parallelStream().forEach(sysFunctionResources -> {
            Long resourceId = sysFunctionResources.getResourceId();
            resourceIds.add(resourceId);
            delResourceIds.add(resourceId);
        });
        if (ToolUtil.isNotEmpty(resourceIds)) {
            this.remove(connName, (Wrapper)queryWrapperFr);
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"FUNCTION_ID", (Object)functionId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list(connName, (Wrapper)queryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctionsList)) {
            for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
                roleIds.add(sysRoleFunctions.getRoleId());
            }
        }
        for (Map map : resources) {
            delResourceIds.add(Long.valueOf((String)map.get("id")));
        }
        if (ToolUtil.isNotEmpty(roleIds) && ToolUtil.isNotEmpty(delResourceIds)) {
            LambdaQueryWrapper queryWrapperRr = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getRoleId, roleIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)queryWrapperRr, SysRoleResource::getResourceId, delResourceIds);
            queryWrapperRr.eq(SysRoleResource::getRelationSource, (Object)"1");
            this.iSysRoleResourceService.remove(connName, (Wrapper)queryWrapperRr);
        }
        ArrayList<SysFunctionResources> sysFunctionResourcesSaveList = new ArrayList<SysFunctionResources>();
        ArrayList<SysRoleResource> arrayList = new ArrayList<SysRoleResource>();
        LocalDateTime now = LocalDateTime.now();
        ArrayList<Long> newResIdList = new ArrayList<Long>();
        for (Map<String, String> resource : resources) {
            List sysRoles;
            Set tenantRoles;
            if (!"res_menu".equals(resource.get("type")) && !"res_btn".equals(resource.get("type")) && !"res_rights".equals(resource.get("type")) && !"res_form_rights".equals(resource.get("type"))) continue;
            SysFunctionResources sysFunctionResources2 = new SysFunctionResources();
            Long resId = Long.valueOf(resource.get("id"));
            sysFunctionResources2.setResourceId(resId);
            newResIdList.add(resId);
            sysFunctionResources2.setFunctionId(functionId);
            sysFunctionResources2.setLastTime(now);
            sysFunctionResources2.setCreateTime(now);
            sysFunctionResourcesSaveList.add(sysFunctionResources2);
            if (!ToolUtil.isNotEmpty(roleIds) || !HussarUtils.isNotEmpty((Object)(tenantRoles = EntityUtils.toSet((Collection)(sysRoles = this.sysRolesMapper.selectBatchIds(roleIds)), SysRoles::getId)))) continue;
            for (Long roleId : roleIds) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setResourceId(Long.valueOf(resource.get("id")));
                sysRoleResource.setRoleId(roleId);
                sysRoleResource.setRelationSource("1");
                sysRoleResource.setLastTime(now);
                sysRoleResource.setCreateTime(now);
                arrayList.add(sysRoleResource);
            }
        }
        if (ToolUtil.isNotEmpty(arrayList)) {
            this.iSysRoleResourceService.saveBatch(connName, arrayList);
        }
        boolean saveFlag = this.saveBatch(connName, sysFunctionResourcesSaveList);
        this.queryDataRightManager.saveDataRightCacheByRoleIds(connName, roleIds);
    }

    public List<FuncResVo> getFunctionResourceList(Long functionId) {
        return this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
    }

    public void insertOrUpdateFunctionResource(List<SysFunctionResources> functionResourcesList) {
        if (CollectionUtils.isEmpty(functionResourcesList)) {
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_ADD_DATA.getMessage()), (Object)functionResourcesList.size());
            return;
        }
        List<SysFunctionResources> existList = this.selectExistList(functionResourcesList);
        List<SysFunctionResources> addList = functionResourcesList;
        if (ToolUtil.isNotEmpty(existList)) {
            addList = this.getAddList(functionResourcesList, existList);
        }
        if (ToolUtil.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_ADD_DATA.getMessage()), (Object)addList.size());
    }

    public void dataSyncByfuncRes(List<SysFunctionResources> functionResourcesList) {
        List functionIdList = functionResourcesList.stream().map(SysFunctionResources::getFunctionId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryRoleFunc = new LambdaQueryWrapper();
        queryRoleFunc.in(SysRoleFunctions::getFunctionId, functionIdList);
        List sysRoleFuncList = this.sysRoleFunctionsMapper.selectList((Wrapper)queryRoleFunc);
        if (ToolUtil.isNotEmpty((Object)sysRoleFuncList)) {
            ArrayList<Long> repeatIds = new ArrayList<Long>();
            HashMap funcIdAndResIdListMap = new HashMap();
            for (SysFunctionResources funcRes : functionResourcesList) {
                if (repeatIds.contains(funcRes.getFunctionId())) {
                    ((List)funcIdAndResIdListMap.get(funcRes.getFunctionId())).add(funcRes.getResourceId());
                    continue;
                }
                repeatIds.add(funcRes.getFunctionId());
                ArrayList<Long> resIdList = new ArrayList<Long>();
                resIdList.add(funcRes.getResourceId());
                funcIdAndResIdListMap.put(funcRes.getFunctionId(), resIdList);
            }
            ArrayList newroleResourceList = new ArrayList();
            HashMap<String, SysRoleResource> distinctRoleRes = new HashMap<String, SysRoleResource>();
            for (SysRoleFunctions roleFunction : sysRoleFuncList) {
                List resIdList = (List)funcIdAndResIdListMap.get(roleFunction.getFunctionId());
                for (Long resId : resIdList) {
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource.setRoleId(roleFunction.getRoleId());
                    sysRoleResource.setResourceId(resId);
                    sysRoleResource.setRelationSource("1");
                    distinctRoleRes.put(roleFunction.getRoleId().toString() + resId.toString() + "1", sysRoleResource);
                }
            }
            distinctRoleRes.forEach((key, value) -> newroleResourceList.add(value));
            if (ToolUtil.isNotEmpty(newroleResourceList)) {
                this.iSysRoleResourceService.delRoleResByDoubleId(newroleResourceList);
                this.iSysRoleResourceService.saveBatch(newroleResourceList);
            }
        }
    }

    public List<SysFunctionResources> selectListByDoubleIds(List<SysFunctionResources> sysFunctionResources) {
        ArrayList<SysFunctionResources> retunList = new ArrayList<SysFunctionResources>();
        LambdaQueryWrapper funcResQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysFunctionResources.size(); i += 999) {
            List<SysFunctionResources> temp;
            if (i + 999 >= sysFunctionResources.size()) {
                temp = sysFunctionResources.subList(i, sysFunctionResources.size());
                funcResQueryWrapper.clear();
                for (SysFunctionResources funcRes : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
                }
                retunList.addAll(this.sysFunctionResourcesMapper.selectList((Wrapper)funcResQueryWrapper));
                continue;
            }
            temp = sysFunctionResources.subList(i, i + 999);
            funcResQueryWrapper.clear();
            for (SysFunctionResources funcRes : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
            }
            retunList.addAll(this.sysFunctionResourcesMapper.selectList((Wrapper)funcResQueryWrapper));
        }
        return retunList;
    }

    public void deleteListByDoubleIds(List<SysFunctionResources> sysFunctionResourcesList) {
        LambdaQueryWrapper funcResQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysFunctionResourcesList.size(); i += 999) {
            List<SysFunctionResources> temp;
            if (i + 999 >= sysFunctionResourcesList.size()) {
                temp = sysFunctionResourcesList.subList(i, sysFunctionResourcesList.size());
                funcResQueryWrapper.clear();
                for (SysFunctionResources funcRes : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
                }
                this.sysFunctionResourcesMapper.delete((Wrapper)funcResQueryWrapper);
                continue;
            }
            temp = sysFunctionResourcesList.subList(i, i + 999);
            funcResQueryWrapper.clear();
            for (SysFunctionResources funcRes : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)funcResQueryWrapper.or()).eq(SysFunctionResources::getFunctionId, (Object)funcRes.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)funcRes.getResourceId());
            }
            this.sysFunctionResourcesMapper.delete((Wrapper)funcResQueryWrapper);
        }
    }

    public List<SysFunctionResources> selectFunctionResByFuncIds(List<Long> functionIds) {
        if (HussarUtils.isEmpty(functionIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)lambdaQueryWrapper, SysFunctionResources::getFunctionId, functionIds);
        return this.sysFunctionResourcesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    private List<SysFunctionResources> selectExistList(List<SysFunctionResources> sysFunctionResources) {
        List<Object> returnList = new ArrayList<SysFunctionResources>();
        ArrayList functionIds = new ArrayList();
        ArrayList resourceIds = new ArrayList();
        sysFunctionResources.forEach(fr -> {
            functionIds.add(fr.getFunctionId());
            resourceIds.add(fr.getResourceId());
        });
        if (ToolUtil.isNotEmpty(functionIds) && ToolUtil.isNotEmpty(resourceIds)) {
            List distFuncIds = functionIds.stream().distinct().collect(Collectors.toList());
            List distResIds = resourceIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper funcResQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysFunctionResources::getFunctionId, distFuncIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)funcResQueryWrapper, SysFunctionResources::getResourceId, distResIds);
            returnList = this.sysFunctionResourcesMapper.selectList((Wrapper)funcResQueryWrapper);
        }
        return returnList;
    }

    private List<SysFunctionResources> getAddList(List<SysFunctionResources> functionResourcesList, List<SysFunctionResources> existList) {
        ArrayList<SysFunctionResources> addList = new ArrayList<SysFunctionResources>();
        HashMap existMap = new HashMap();
        existList.forEach(fr -> existMap.put(fr.getFunctionId() + "-" + fr.getResourceId(), "1"));
        for (SysFunctionResources functionResources : functionResourcesList) {
            String idStr = functionResources.getFunctionId() + "-" + functionResources.getResourceId();
            if (!ToolUtil.isEmpty(existMap.get(idStr))) continue;
            addList.add(functionResources);
        }
        return addList;
    }

    public List<JSTreeModel> getShortCutMenuTree(List<JSTreeModel> shortCutMenuTree) {
        return this.hussarBaseFunctionAdapter.getShortCutMenuTree(shortCutMenuTree);
    }

    public List<SysFunctionResources> listByFuncIdAndResId(Long functionId, Long resourceId) {
        return this.hussarBaseFunctionAdapter.listByFuncIdAndResId(functionId, resourceId);
    }

    public List<JSTreeModel> selfResFunctionTree(Long resourceId) {
        List<Object> functionTreeData = new ArrayList<JSTreeModel>();
        if (ToolUtil.isNotEmpty((Object)resourceId)) {
            List<Long> funIds = this.sysFunctionResourcesMapper.getFunctionIdByResId(resourceId);
            if (HussarUtils.isNotEmpty(funIds)) {
                String functionIds = funIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                functionTreeData = this.iSysRoleFunctionsService.selfFunctionTree(functionIds);
            } else {
                JSTreeModel model = new JSTreeModel();
                model.setParent(Constants.ROOT_NODE_PARENT);
                model.setCode("GROUP");
                model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
                model.setId(Constants.RES_NODE_ID);
                model.setType("isRoot");
                model.setState(true, true, true);
                functionTreeData.add(model);
            }
        }
        return functionTreeData;
    }
}

