/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.SysConfRolesetDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesetService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.vo.SysConfRolesVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysConfRolesetVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysConfRolesetServiceImpl
extends HussarServiceImpl<SysConfRolesetMapper, SysConfRoleset>
implements ISysConfRolesetService {
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private RoleUserAuthorizationChangeReporter roleUserAuthorizationChangeReporter;

    public ApiResponse<Long> saveRoleSet(SysConfRoleset sysConfRoleset) {
        if (ToolUtil.isEmpty((Object)sysConfRoleset)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_INCOMPATIBLE_CHARACTER_EMPTY.getMessage()));
        }
        try {
            this.validateParam(sysConfRoleset, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        String comefrom = "add";
        this.sameRoleName(sysConfRoleset, comefrom);
        boolean flag = this.saveOrUpdate((BaseEntity)sysConfRoleset);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL.getMessage()));
        }
        return ApiResponse.success((Object)sysConfRoleset.getId(), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
    }

    public ApiResponse updateRoleSet(SysConfRoleset sysConfRoleset) {
        if (ToolUtil.isEmpty((Object)sysConfRoleset)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_INCOMPATIBLE_CHARACTER_EMPTY.getMessage()));
        }
        try {
            this.validateParam(sysConfRoleset, "edit");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        String comefrom = "edit";
        this.sameRoleName(sysConfRoleset, comefrom);
        boolean flag = this.updateById((BaseEntity)sysConfRoleset);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    private void validateParam(Object o, String mdType) {
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysConfRoleset) {
            SysConfRoleset reqBO = (SysConfRoleset)o;
            if ("edit".equals(mdType) && null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getSetName())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MUTEX_ROLE_SET_NAME_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSetName()) && 16 < reqBO.getSetName().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MUTEX_ROLE_SET_NAME_MAX_LENGTH.getMessage()));
            }
            if (null == reqBO.getCardinality()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MUTEX_ROLE_SET_CARDINALITY_NOT_NULL.getMessage()));
            }
            if (0 < sBuffer.length()) {
                String rspStr = sBuffer.substring(1);
                throw new BaseException(rspStr);
            }
        }
    }

    @HussarTransactional
    public ApiResponse deleteRoleSet(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_INCOMPATIBLE_CHARACTER_EMPTY.getMessage()));
        }
        String[] ids = id.split(",");
        List<String> idList = Arrays.asList(ids);
        List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        boolean flag = this.removeByIds(cdids);
        List confRoles = this.sysConfRolesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysConfRoles::getSetId, cdids));
        this.sysConfRolesMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysConfRoles::getSetId, cdids));
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        List roleIds = confRoles.stream().map(SysConfRoles::getRoleId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(roleIds)) {
            this.roleUserAuthorizationChangeReporter.report(new Object[]{"roleBatch", roleIds});
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    public List<Long> getRoleView(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_INCOMPATIBLE_ROLE_ID_EMPTY.getMessage()));
        }
        ArrayList<Long> result = new ArrayList<Long>();
        List<SysConfRolesVo> roleList = this.getSelectInRoles(id);
        if (ToolUtil.isNotEmpty(roleList)) {
            for (SysConfRolesVo sysConfRolesVo : roleList) {
                result.add(sysConfRolesVo.getRoleId());
            }
        }
        return result;
    }

    public List<Long> getRoleView(String id) {
        return this.getRoleView(Long.parseLong(id));
    }

    public IPage<SysConfRolesetVo> getRolesList(Page<SysConfRolesetVo> page, SysConfRolesetDto sysConfRolesetDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        if (sysConfRolesetDto == null) {
            sysConfRolesetDto = new SysConfRolesetDto();
        }
        String name = sysConfRolesetDto.getSetName() == null ? "" : sysConfRolesetDto.getSetName();
        String org = sysConfRolesetDto.getOrgId() == null ? "" : sysConfRolesetDto.getOrgId();
        return page.setRecords(this.sysConfRolesetMapper.getRolesList(page, name, org));
    }

    public List<SysConfRolesetVo> getTransferData() {
        List roleList = this.sysRolesMapper.selectList((Wrapper)new LambdaQueryWrapper());
        ArrayList<SysConfRolesetVo> result = new ArrayList<SysConfRolesetVo>();
        for (SysRoles role : roleList) {
            SysConfRolesetVo sysConfRolesetVo = new SysConfRolesetVo();
            sysConfRolesetVo.setKey(role.getId());
            sysConfRolesetVo.setLabel(role.getRoleName());
            sysConfRolesetVo.setDisabled(false);
            result.add(sysConfRolesetVo);
        }
        return result;
    }

    public List<SysConfRolesVo> getSelectInRoles(Long id) {
        return this.sysConfRolesMapper.getSelectInRoles(id);
    }

    public List<SysConfRolesVo> getSelectInRoles(String id) {
        return this.sysConfRolesMapper.getSelectInRoles(Long.parseLong(id));
    }

    private void sameRoleName(SysConfRoleset sysConfRoleset, String comefrom) {
        List list;
        if ("add".equals(comefrom)) {
            List list2 = this.list((Wrapper)new LambdaQueryWrapper().eq(SysConfRoleset::getSetName, (Object)sysConfRoleset.getSetName()));
            if (ToolUtil.isNotEmpty((Object)list2)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NEW_ADDITION_FAILED.getMessage()));
            }
        } else if ("edit".equals(comefrom) && ToolUtil.isNotEmpty((Object)(list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysConfRoleset::getId, (Object)sysConfRoleset.getId())).eq(SysConfRoleset::getSetName, (Object)sysConfRoleset.getSetName()))))) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_FAILED_NAME_EXISTS_OR_DEL.getMessage()));
        }
    }
}

