/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dto.FuncInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncPermitDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncResDelDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.FunctionExportDto;
import com.jxdinfo.hussar.authorization.permit.dto.ModuleTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryFuncOrderTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryResTransferTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResListDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResModuleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResPermitDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDtoByAppRole;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourcePathDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceRoleRelationDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeByIdDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceUniqueDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.CheckResourceVo;
import com.jxdinfo.hussar.authorization.permit.vo.FuncDumpTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.ImportVueFuncVo;
import com.jxdinfo.hussar.authorization.permit.vo.ImportVueResVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResMapperSelectVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleBasicVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysFunctionVO;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8d44\u6e90\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/resourceFront"})
public class SysResManageFrontController
extends HussarBaseController<SysResources, ISysResManageService> {
    @Resource
    ISysResManageService sysResManageService;
    @Resource
    ISysStruResourcesService iSysStruResourcesService;
    @Resource
    ISysStruFunctionsService iSysStruFunctionsService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private ISysFunctionResourcesService iSysFunctionResourcesService;

    @ApiOperation(value="\u529f\u80fd\u8d44\u6e90\u6811", notes="\u529f\u80fd\u8d44\u6e90\u6811")
    @GetMapping(value={"/resTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resTree(@ApiParam(value="\u8d44\u6e90\u6811dto") ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)this.sysResManageService.getFunResource(resTreeDto));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u8d44\u6e90\u6811", notes="\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u8d44\u6e90\u6811")
    @GetMapping(value={"/resTreeForOrgRes"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resTreeForOrgRes(@ApiParam(value="\u8d44\u6e90\u6811dto") ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)this.sysResManageService.getFunResourceForOrg(resTreeDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u6811\u5f62\u6570\u636e", notes="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u6811\u5f62\u6570\u636e")
    @GetMapping(value={"/resFuncTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u6811\u5f62\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resFuncModuleTree(@ApiParam(value="\u8d44\u6e90\u6811dto") ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)this.sysResManageService.getResFunTree(resTreeDto));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u6811\u8282\u70b9\u83b7\u53d6\u4e0b\u7ea7\u5217\u8868", notes="\u6839\u636e\u8d44\u6e90\u6811\u8282\u70b9\u83b7\u53d6\u4e0b\u7ea7\u5217\u8868")
    @GetMapping(value={"/resInfoList"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90\u6811\u8282\u70b9\u83b7\u53d6\u4e0b\u7ea7\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage> resInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u8d44\u6e90\u6811\u67e5\u8be2dto") ResTreeQueryDto resTreeQueryDto) {
        return ApiResponse.success((Object)this.sysResManageService.getResNodeSubList(page, resTreeQueryDto));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u6811", notes="\u6839\u636e\u8d44\u6e90\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u6811")
    @GetMapping(value={"/moduleTreeById"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> moduleTreeById(@ApiParam(value="\u6a21\u5757id") @RequestParam String moduleId, @ApiParam(value="\u662f\u5426\u4e3a\u6839\u8282\u70b9") @RequestParam boolean isRoot) {
        return ApiResponse.success((Object)this.sysResManageService.moduleTreeById(moduleId, isRoot));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u6a21\u5757\u65f6\u83b7\u53d6\u6a21\u5757\u7f16\u7801", notes="\u65b0\u589e\u8d44\u6e90\u6a21\u5757\u65f6\u83b7\u53d6\u6a21\u5757\u7f16\u7801")
    @CheckPermission(value={"resourceFront:moduleAdd"})
    @GetMapping(value={"moduleAdd"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u6a21\u5757\u65f6\u83b7\u53d6\u6a21\u5757\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> moduleAdd() {
        return ApiResponse.success((String)this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_RESOURCE_MODULES"));
    }

    @ApiOperation(value="\u67e5\u770b\u8d44\u6e90\u6a21\u5757\u4fe1\u606f", notes="\u67e5\u770b\u8d44\u6e90\u6a21\u5757\u4fe1\u606f")
    @GetMapping(value={"moduleView"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u770b\u8d44\u6e90\u6a21\u5757\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysResourceModules> moduleView(@ApiParam(value="\u6a21\u5757id") @RequestParam String moduleId) {
        return ApiResponse.success((Object)this.sysResManageService.getModuleInfoById(moduleId));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u6a21\u5757", notes="\u65b0\u589e\u8d44\u6e90\u6a21\u5757")
    @CheckPermission(value={"resourceFront:moduleSave"})
    @PostMapping(value={"moduleSave"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse moduleSave(@ApiParam(value="\u6a21\u5757\u4fe1\u606f") @RequestBody SysResourceModules sysResourceModules) {
        return this.sysResManageService.saveModules(sysResourceModules);
    }

    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u6a21\u5757", notes="\u4fee\u6539\u8d44\u6e90\u6a21\u5757")
    @CheckPermission(value={"resourceFront:moduleEditSave"})
    @PostMapping(value={"moduleEditSave"})
    @CacheEvict(value={"authorization_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse moduleEditSave(@ApiParam(value="\u6a21\u5757\u4fe1\u606f") @RequestBody SysResourceModules sysResourceModules) {
        return this.sysResManageService.saveModules(sysResourceModules);
    }

    @ApiOperation(value="\u5220\u9664\u8d44\u6e90\u6a21\u5757", notes="\u5220\u9664\u8d44\u6e90\u6a21\u5757")
    @CheckPermission(value={"resourceFront:delModule"})
    @PostMapping(value={"delModule"})
    @CacheEvict(value={"authorization_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5220\u9664\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delModule(@ApiParam(value="\u6a21\u5757id") @RequestBody Long moduleId) {
        return this.sysResManageService.delModuleResCascade(moduleId, null);
    }

    @Deprecated
    @ApiOperation(value="\u65b0\u589e\u529f\u80fd\u65f6\u83b7\u53d6\u529f\u80fd\u7f16\u7801", notes="\u65b0\u589e\u529f\u80fd\u65f6\u83b7\u53d6\u529f\u80fd\u7f16\u7801")
    @CheckPermission(value={"resourceFront:functionAdd"})
    @GetMapping(value={"functionAdd"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u65b0\u589e\u529f\u80fd\u65f6\u83b7\u53d6\u529f\u80fd\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> functionAdd(@ApiParam(value="\u4e0a\u7ea7\u6a21\u5757\u7f16\u7801") @RequestParam String moduleCode) {
        return ApiResponse.success((String)this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS", moduleCode));
    }

    @ApiOperation(value="\u529f\u80fd\u4fe1\u606f\u67e5\u770b", notes="\u529f\u80fd\u4fe1\u606f\u67e5\u770b")
    @GetMapping(value={"functionView"})
    @CheckPermission(value={"resourceFront:functionView"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4fe1\u606f\u67e5\u770b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysFunctionVO> functionView(@ApiParam(value="\u529f\u80fdid") @RequestParam String functionId) {
        return ApiResponse.success((Object)this.sysResManageService.getFunctionInfoById(functionId));
    }

    @ApiOperation(value="\u529f\u80fd\u65b0\u589e", notes="\u529f\u80fd\u65b0\u589e")
    @CheckPermission(value={"resourceFront:functionSave"})
    @PostMapping(value={"functionSave"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse functionSave(@ApiParam(value="\u529f\u80fd\u4fe1\u606f") @RequestBody SysFunctions sysFunctions) {
        return this.sysResManageService.saveFunction(sysFunctions);
    }

    @ApiOperation(value="\u529f\u80fd\u4fee\u6539", notes="\u529f\u80fd\u4fee\u6539")
    @PostMapping(value={"functionEditSave"})
    @CacheEvict(value={"authorization_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse functionEditSave(@ApiParam(value="\u529f\u80fd\u4fe1\u606f") @RequestBody SysFunctions sysFunctions) {
        return this.sysResManageService.updateFunction(sysFunctions);
    }

    @ApiOperation(value="\u5220\u9664\u529f\u80fd", notes="\u5220\u9664\u529f\u80fd")
    @CheckPermission(value={"resourceFront:delFunction"})
    @PostMapping(value={"delFunction"})
    @CacheEvict(value={"authorization_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5220\u9664\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> delFunction(@ApiParam(value="\u529f\u80fdid") @RequestBody Long functionId) {
        return ApiResponse.success((Object)this.iSysFunctionsService.deleteFunction(functionId));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u65f6\u83b7\u53d6\u8d44\u6e90\u7f16\u7801", notes="\u65b0\u589e\u8d44\u6e90\u65f6\u83b7\u53d6\u8d44\u6e90\u7f16\u7801")
    @CheckPermission(value={"resourceFront:resourceAdd"})
    @GetMapping(value={"resourceAdd"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u65f6\u83b7\u53d6\u8d44\u6e90\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> resourceAdd(@ApiParam(value="\u4e0a\u7ea7\u529f\u80fd\u7f16\u7801") @RequestParam String moduleCode) {
        return ApiResponse.success((String)this.sysResManageService.getResourceCurrentCode(moduleCode));
    }

    @ApiOperation(value="\u8d44\u6e90\u65b0\u589e", notes="\u8d44\u6e90\u65b0\u589e")
    @CheckPermission(value={"resourceFront:resourceSave"})
    @PostMapping(value={"resourceSave"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> resourceSave(@ApiParam(value="\u8d44\u6e90\u4fe1\u606f") @RequestBody ResourceDto resourceDto) {
        return ApiResponse.success((Object)this.sysResManageService.saveResource(resourceDto));
    }

    @ApiOperation(value="\u8d44\u6e90\u4fee\u6539", notes="\u8d44\u6e90\u4fee\u6539")
    @CheckPermission(value={"resourceFront:resourceEditSave"})
    @PostMapping(value={"resourceEditSave"})
    @CacheEvict(value={"authorization_info", "menu_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Long> resourceEditSave(@ApiParam(value="\u8d44\u6e90\u4fe1\u606f") @RequestBody ResourceDto resourceDto) {
        return ApiResponse.success((Object)this.sysResManageService.saveResource(resourceDto));
    }

    @ApiOperation(value="\u8d44\u6e90\u67e5\u770b", notes="\u8d44\u6e90\u67e5\u770b")
    @GetMapping(value={"resourceView"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u67e5\u770b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ResourceDetailVo> resourceView(@ApiParam(value="\u8d44\u6e90id") @RequestParam Long resourceId) {
        return ApiResponse.success((Object)this.sysResManageService.getResourceInfoById(resourceId));
    }

    @ApiOperation(value="\u5220\u9664\u8d44\u6e90", notes="\u5220\u9664\u8d44\u6e90")
    @CheckPermission(value={"resourceFront:delResource"})
    @PostMapping(value={"delResource"})
    @CacheEvict(value={"authorization_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5220\u9664\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delResource(@ApiParam(value="\u8d44\u6e90id") @RequestBody Long resourceId) {
        return this.sysResManageService.delModuleResCascade(null, resourceId);
    }

    @ApiOperation(value="\u6a21\u5757\u6392\u5e8f\u4fdd\u5b58", notes="\u6a21\u5757\u6392\u5e8f\u4fdd\u5b58")
    @PostMapping(value={"moduleTreeOrder"})
    @CheckPermission(value={"resourceFront:moduleTreeOrder"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6a21\u5757\u6392\u5e8f\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse moduleTreeOrder(@ApiParam(value="\u6392\u5e8f\u6a21\u5757id\u96c6\u5408") @RequestBody List<Long> idList) {
        this.sysResManageService.updateModuleTreeOrder(idList);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fd\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6811", notes="\u6839\u636e\u529f\u80fd\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6811")
    @CheckPermission(value={"resourceFront:functionTreeById"})
    @GetMapping(value={"/functionTreeById"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fd\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> functionTreeById(@ApiParam(value="\u67e5\u8be2\u529f\u80fd\u6392\u5e8f\u6811Dto") QueryFuncOrderTreeDto queryFuncOrderTreeDto) {
        return ApiResponse.success((Object)this.sysResManageService.getFunctionTreeByModuleId(queryFuncOrderTreeDto));
    }

    @ApiOperation(value="\u529f\u80fd\u6811\u6392\u5e8f\u4fdd\u5b58", notes="\u529f\u80fd\u6811\u6392\u5e8f\u4fdd\u5b58")
    @PostMapping(value={"functionTreeOrder"})
    @CheckPermission(value={"resourceFront:functionTreeOrder"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6811\u6392\u5e8f\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse functionTreeOrder(@ApiParam(value="\u6392\u5e8f\u529f\u80fdid\u96c6\u5408") @RequestBody List<Long> idList) {
        if (CollectionUtils.isNotEmpty(idList)) {
            this.sysResManageService.updateFunctionTreeOrder(idList);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fdID\u83b7\u53d6\u8d44\u6e90\u6811", notes="\u6839\u636e\u529f\u80fdID\u83b7\u53d6\u8d44\u6e90\u6811")
    @CheckPermission(value={"resourceFront:resourceTreeById"})
    @PostMapping(value={"resourceTreeById"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fdID\u83b7\u53d6\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resourceTreeById(@ApiParam(value="\u8d44\u6e90\u6811dto") @RequestBody ResourceTreeByIdDto resourceTreeByIdDto) {
        return ApiResponse.success((Object)this.sysResManageService.getResourceTreeByModuleId(resourceTreeByIdDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90\u6811\u6392\u5e8f", notes="\u4fdd\u5b58\u8d44\u6e90\u6811\u6392\u5e8f")
    @PostMapping(value={"/resourceTreeOrder"})
    @CheckPermission(value={"resourceFront:resourceTreeOrder"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u8d44\u6e90\u6811\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse resourceTreeOrder(@ApiParam(value="\u6392\u5e8f\u8d44\u6e90id\u96c6\u5408") @RequestBody List<String> idList) {
        ArrayList<Long> longList = new ArrayList<Long>(idList.size());
        for (int i = 0; i < idList.size(); ++i) {
            longList.add(Long.parseLong(idList.get(i)));
        }
        this.sysResManageService.updateResourceTreeOrder(longList);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u6a21\u5757\u8f6c\u79fb", notes="\u6a21\u5757\u8f6c\u79fb")
    @CheckPermission(value={"resourceFront:moduleChangeById"})
    @GetMapping(value={"moduleChangeById"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6a21\u5757\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> moduleChangeById(@ApiParam(value="\u6a21\u5757id") @RequestParam String moduleId, @ApiParam(value="\u662f\u5426\u4e3a\u672b\u7ea7\u8282\u70b9") @RequestParam String isLeaf) {
        return ApiResponse.success((Object)this.sysResManageService.getModuleChangeById(moduleId, isLeaf));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u8f6c\u79fb", notes="\u4fdd\u5b58\u6a21\u5757\u8f6c\u79fb")
    @PostMapping(value={"moduleTreeChange"})
    @CheckPermission(value={"resourceFront:moduleTreeChange"})
    @CacheEvict(value={"authorization_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u6a21\u5757\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse moduleTreeChange(@ApiParam(value="\u6a21\u5757\u8f6c\u79fbdto") @RequestBody ModuleTreeChangeDto moduleTreeChangeDto) {
        this.sysResManageService.updateModuleTreeChange(moduleTreeChangeDto);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u4fdd\u5b58\u529f\u80fd\u8f6c\u79fb", notes="\u4fdd\u5b58\u529f\u80fd\u8f6c\u79fb")
    @PostMapping(value={"functionTreeChange"})
    @CheckPermission(value={"resourceFront:functionTreeChange"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u529f\u80fd\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse functionTreeChange(@ApiParam(value="\u529f\u80fd\u8f6c\u79fbdto") @RequestBody FuncTreeChangeDto funcTreeChangeDto) {
        this.sysResManageService.updateFunctionTreeChange(funcTreeChangeDto.getFunctionId(), funcTreeChangeDto.getParentId());
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u8f6c\u79fb", notes="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u8f6c\u79fb")
    @PostMapping(value={"functionModulesTreeChange"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse functionModulesTreeChange(@ApiParam(value="\u529f\u80fd\u6a21\u5757\u8f6c\u79fbdto") @RequestBody FuncModuleTreeChangeDto funcModuleTreeChangeDto) {
        this.sysResManageService.updateFunctionModulesTreeChange(funcModuleTreeChangeDto.getFunctionModuleId(), funcModuleTreeChangeDto.getParentId());
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u8f6c\u79fb\u6811", notes="\u83b7\u53d6\u8d44\u6e90\u8f6c\u79fb\u6811")
    @CheckPermission(value={"resourceFront:resourceChangeById"})
    @GetMapping(value={"resourceChangeById"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u8d44\u6e90\u8f6c\u79fb\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resourceChangeById(@ApiParam(value="\u67e5\u8be2\u8d44\u6e90\u8f6c\u79fb\u6811Dto") QueryResTransferTreeDto queryResTransferTreeDto) {
        return ApiResponse.success((Object)this.sysResManageService.getResourceTransferTree(queryResTransferTreeDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90\u8f6c\u79fb", notes="\u4fdd\u5b58\u8d44\u6e90\u8f6c\u79fb")
    @PostMapping(value={"resourceTreeChange"})
    @CheckPermission(value={"resourceFront:resourceTreeChange"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u8d44\u6e90\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse resourceTreeChange(@ApiParam(value="\u8d44\u6e90\u8f6c\u79fbdto") @RequestBody ResourceTreeChangeDto resourceTreeChangeDto) {
        this.sysResManageService.updateResourceTreeChange(resourceTreeChangeDto);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", notes="\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811")
    @CheckPermission(value={"resourceFront:selfResourceTree"})
    @PostMapping(value={"/selfResourceTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfResourceTree(@ApiParam(value="\u8d44\u6e90ids") @RequestBody String resourceIds) {
        return ApiResponse.success((Object)this.sysResManageService.getSelfResourceTree(resourceIds));
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709url", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709url")
    @GetMapping(value={"/sameUrl"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u662f\u5426\u5df2\u6709url", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> sameUrl(@ApiParam(value="\u8d44\u6e90\u4fe1\u606fdto") ResourceUniqueDto resourceUniqueDto) {
        return ApiResponse.success((Object)this.sysResManageService.getSameUrl(resourceUniqueDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811", notes="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811")
    @CheckPermission(value={"resourceFront:roleTreeView"})
    @GetMapping(value={"/roleTreeView"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleTreeView(@ApiParam(value="\u8d44\u6e90id") @RequestParam String resourceId) {
        return ApiResponse.success((Object)this.sysResManageService.getRoleTreeByResourceId(resourceId));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", notes="\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @CheckPermission(value={"resourceFront:resourceAddSaveRole"})
    @PostMapping(value={"/resourceAddSaveRole"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse resourceAddSaveRole(@ApiParam(value="\u8d44\u6e90\u89d2\u8272\u5173\u8054dto") @RequestBody ResourceRoleRelationDto resourceRoleRelationDto) {
        return this.sysResManageService.saveResourceRelationRole(resourceRoleRelationDto);
    }

    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", notes="\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @CheckPermission(value={"resourceFront:resourceEditSaveRole"})
    @PostMapping(value={"/resourceEditSaveRole"})
    @CacheEvict(value={"authorization_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse resourceEditSaveRole(@ApiParam(value="\u8d44\u6e90\u89d2\u8272dto") @RequestBody ResRoleDto resRoleDto) {
        return this.sysResManageService.updateResourceRelationRole(resRoleDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272", notes="\u83b7\u53d6\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272")
    @GetMapping(value={"/getResourceRoles"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> getResourceRoles(@ApiParam(value="\u8d44\u6e90id") @RequestParam Long resourceId) {
        return ApiResponse.success((Object)this.sysRoleResourceService.getResourceRoles(resourceId));
    }

    @ApiOperation(value="\u8d44\u6e90\u6570\u636e\u5bfc\u51fa", notes="\u8d44\u6e90\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/exportRes"})
    @CheckPermission(value={"resourceFront:exportRes"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@ApiParam(value="\u5bfc\u51fa\u7684\u8d44\u6e90ids") @RequestBody String ids, HttpServletResponse response) {
        this.sysResManageService.exportRes(ids, response);
    }

    @ApiOperation(value="\u8d44\u6e90\u6570\u636e\u5bfc\u5165", notes="\u8d44\u6e90\u6570\u636e\u5bfc\u5165")
    @PostMapping(path={"/importData"})
    @CheckPermission(value={"resourceFront:importData"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u6570\u636e\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<ImportVueResVo> importData(@ApiParam(value="\u8d44\u6e90\u6570\u636e\u6587\u4ef6") @RequestParam(value="file") MultipartFile hussarFile) throws IOException {
        if (ToolUtil.isEmpty((Object)hussarFile)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RESOURCE_IMPORT_FILE_EMPTY.getMessage()));
        }
        byte[] content = hussarFile.getBytes();
        return ApiResponse.success((Object)this.sysResManageService.importVueRes(content));
    }

    @ApiOperation(value="\u5f53\u524d\u6a21\u5757\u3001\u529f\u80fd\u662f\u5426\u6709\u53ef\u4e0b\u653e\u7684\u8d44\u6e90", notes="\u5f53\u524d\u6a21\u5757\u3001\u529f\u80fd\u662f\u5426\u6709\u53ef\u4e0b\u653e\u7684\u8d44\u6e90")
    @GetMapping(value={"/checkHasResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5f53\u524d\u6a21\u5757\u3001\u529f\u80fd\u662f\u5426\u6709\u53ef\u4e0b\u653e\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckResourceVo> checkHasResources(@ApiParam(value="\u8d44\u6e90id") @RequestParam Long resourceId, @ApiParam(value="\u8d44\u6e90\u7c7b\u578b") @RequestParam String type) {
        return ApiResponse.success((Object)this.sysResManageService.checkHasResources(resourceId, type));
    }

    @ApiOperation(value="\u8d44\u6e90\u4e0b\u653e", notes="\u8d44\u6e90\u4e0b\u653e")
    @CheckPermission(value={"resourceFront:delegateResource"})
    @PostMapping(value={"/delegateResource"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u4e0b\u653e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse delegateResource(@ApiParam(value="\u8d44\u6e90\u4e0b\u653e\u56de\u6536dto") @RequestBody ResPermitDto resPermitDto) {
        return this.iSysStruResourcesService.saveDelegateResource(resPermitDto);
    }

    @ApiOperation(value="\u529f\u80fd\u4e0b\u653e", notes="\u529f\u80fd\u4e0b\u653e")
    @PostMapping(value={"/delegateFunction"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4e0b\u653e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse delegateFunction(@ApiParam(value="\u8d44\u6e90\u4e0b\u653e\u56de\u6536dto") @RequestBody FuncPermitDto funcPermitDto) {
        return this.iSysStruFunctionsService.saveDelegateFunction(funcPermitDto);
    }

    @ApiOperation(value="\u8d44\u6e90\u56de\u6536", notes="\u8d44\u6e90\u56de\u6536")
    @CheckPermission(value={"resourceFront:retrieveResource"})
    @PostMapping(value={"/retrieveResource"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u56de\u6536", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse retrieveResource(@ApiParam(value="\u8d44\u6e90\u4e0b\u653e\u56de\u6536dto") @RequestBody ResPermitDto resPermitDto) {
        return this.iSysStruResourcesService.saveRetrieveResource(resPermitDto);
    }

    @ApiOperation(value="\u529f\u80fd\u56de\u6536", notes="\u529f\u80fd\u56de\u6536")
    @PostMapping(value={"/retrieveFuntion"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u56de\u6536", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse retrieveFuntion(@ApiParam(value="\u529f\u80fd\u4e0b\u653e\u56de\u6536dto") @RequestBody FuncPermitDto funcPermitDto) {
        return this.iSysStruFunctionsService.saveRetrieveFunction(funcPermitDto);
    }

    @ApiOperation(value="\u89d2\u8272\u4fee\u6539\u5c55\u793a\u529f\u80fd\u8d44\u6e90\u6811", notes="\u89d2\u8272\u4fee\u6539\u5c55\u793a\u529f\u80fd\u8d44\u6e90\u6811")
    @GetMapping(value={"/editResTree"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ba1\u7406", eventDesc="\u89d2\u8272\u4fee\u6539\u5c55\u793a\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> editResTree() {
        return ApiResponse.success((Object)this.sysResManageService.getEditResTree());
    }

    @ApiOperation(value="\u9a8c\u8bc1\u8d44\u6e90\u662f\u5426\u4e8c\u6b21\u9a8c\u8bc1", notes="\u9a8c\u8bc1\u8d44\u6e90\u662f\u5426\u4e8c\u6b21\u9a8c\u8bc1")
    @PostMapping(value={"/checkResource"})
    @Inner
    public ApiResponse<JSONObject> checkResource(@ApiParam(value="\u8d44\u6e90\u8def\u5f84") @RequestBody String resourceUrl) {
        return ApiResponse.success((Object)this.sysResManageService.queryIsCheckResource(resourceUrl));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", notes="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811")
    @GetMapping(value={"/funcModuleTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> funcModuleTree(@ApiParam(value="\u662f\u5426\u52a0\u8f7d\u529f\u80fd") @RequestParam(required=false) String functionFlag) {
        List result = this.iSysFunctionModulesService.getFunModuleMergeTreeForOrg(functionFlag);
        return ApiResponse.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u6a21\u5757\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u6a21\u5757\u6811")
    @GetMapping(value={"/funTreeForOrgFun"})
    @AuditLog(moduleName="\u89d2\u8272\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> funTreeForOrgFun(@ApiParam(value="\u662f\u5426\u52a0\u8f7d\u529f\u80fd") @RequestParam String functionFlag) {
        List result = this.iSysFunctionModulesService.getFunModuleMergeTreeForOrg(functionFlag);
        return ApiResponse.success((Object)result);
    }

    @ApiOperation(value="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u5217\u8868\u6570\u636e")
    @GetMapping(value={"/functionAndModuleList"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage> functionAndModuleList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u529f\u80fd\u6a21\u5757\u6811\u67e5\u8be2dto") FuncModuleTreeQueryDto funcModuleTreeQueryDto) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.getFunctionAndModuleList(page, funcModuleTreeQueryDto));
    }

    @ApiOperation(value="\u529f\u80fd\u6216\u529f\u80fd\u6a21\u5757\u8be6\u60c5", notes="\u529f\u80fd\u6216\u529f\u80fd\u6a21\u5757\u8be6\u60c5")
    @GetMapping(value={"/functionsDetail"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6216\u529f\u80fd\u6a21\u5757\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysModuleFunctionsVo> functionsDetail(@ApiParam(value="\u529f\u80fdid") @RequestParam Long functionId, @ApiParam(value="\u529f\u80fd\u6a21\u5757id") @RequestParam Long functionModuleId) {
        return ApiResponse.success((Object)this.sysResManageService.functionsDetail(functionId, functionModuleId));
    }

    @ApiOperation(value="\u5220\u9664\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u5220\u9664\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"/delFunRes"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5220\u9664\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Integer> delFunRes(@ApiParam(value="\u529f\u80fd\u8d44\u6e90\u5220\u9664\u6761\u4ef6dto") @RequestBody FuncResDelDto funcResDelDto) {
        if (ToolUtil.isEmpty((Object)funcResDelDto.getResourceIds())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_RESOURCE_ID_NOT_NULL.getMessage()));
        }
        return ApiResponse.success((Object)this.iSysFunctionResourcesService.deleteFunRes(funcResDelDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u548c\u529f\u80fd\u8d44\u6e90\u5173\u8054", notes="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u548c\u529f\u80fd\u8d44\u6e90\u5173\u8054")
    @PostMapping(value={"/saveFunRes"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u548c\u529f\u80fd\u8d44\u6e90\u5173\u8054", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"resourceFront:saveFunRes"})
    public ApiResponse<Boolean> devolutionAuthority(@ApiParam(value="\u529f\u80fd\u4fdd\u5b58\u4fe1\u606fdto") @RequestBody FuncInfoDto funcInfoDto) {
        return ApiResponse.success((Object)this.iSysFunctionsService.saveOrUpdateFunction(funcInfoDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u6a21\u5757", notes="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u6a21\u5757")
    @PostMapping(value={"/saveFunModule"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"resourceFront:saveFunModule"})
    public ApiResponse<Boolean> saveFunModule(@ApiParam(value="\u529f\u80fd\u6a21\u5757\u4fdd\u5b58\u4fe1\u606fdto") @RequestBody FuncModuleInfoDto funcModuleInfoDto) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.saveOrUpdateFunctionModule(funcModuleInfoDto));
    }

    @ApiOperation(value="\u5220\u9664\u529f\u80fd\u6a21\u5757", notes="\u5220\u9664\u529f\u80fd\u6a21\u5757")
    @PostMapping(value={"/delFunctionModules"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5220\u9664\u529f\u80fd\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"resourceFront:delFunctionModules"})
    public ApiResponse<Boolean> delFunctionModules(@ApiParam(value="\u529f\u80fd\u6a21\u5757id") @RequestBody Long functionModuleId) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.deleteFunctionModules(functionModuleId));
    }

    @ApiOperation(value="\u529f\u80fd\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f", notes="\u529f\u80fd\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f")
    @PostMapping(value={"/functionModuleTreeOrder"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"resourceFront:functionModuleTreeOrder"})
    public ApiResponse functionModuleTreeOrder(@ApiParam(value="\u6392\u5e8f\u529f\u80fdid\u96c6\u5408") @RequestBody List<Long> idList) {
        if (CollectionUtils.isNotEmpty(idList)) {
            this.iSysFunctionModulesService.saveFunctionModuleTreeOrder(idList);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6a21\u5757\u6811", notes="\u6839\u636e\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6a21\u5757\u6811")
    @GetMapping(value={"/functionModuleTreeById"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> functionModuleTreeById(@ApiParam(value="\u6a21\u5757id") QueryFuncOrderTreeDto queryFuncOrderTreeDto) {
        return ApiResponse.success((Object)this.sysResManageService.getFunctionModuleTreeByModuleId(queryFuncOrderTreeDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90", notes="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90")
    @GetMapping(value={"/getResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> getResources(@ApiParam(value="\u524d\u53f0\u9875\u9762\u7c7b\u578b") @RequestParam String type) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        String locale = LocaleContextHolder.getLocale().toLanguageTag();
        return ApiResponse.success((Object)this.sysResManageService.getResources(shiroUser, type, locale));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u5e93\u4e0b\u5e94\u7528\u7684\u8d44\u6e90", notes="\u83b7\u53d6\u4e3b\u5e93\u4e0b\u5e94\u7528\u7684\u8d44\u6e90")
    @GetMapping(value={"/getMasterResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4e3b\u5e93\u4e0b\u5e94\u7528\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> getMasterResources(@ApiParam(value="\u524d\u53f0\u9875\u9762\u7c7b\u578b") @RequestParam String type) {
        return ApiResponse.success((Object)this.sysResManageService.getResourcesListByApp(type));
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u4e0b\u7684\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u6a21\u5757\u4e0b\u7684\u8d44\u6e90\u5217\u8868")
    @GetMapping(value={"/resourceList"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6a21\u5757\u4e0b\u7684\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage> resourceList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") @RequestParam Page page, @ApiParam(value="\u8d44\u6e90\u5217\u8868dto") @RequestParam ResListDto resListDto) {
        return ApiResponse.success((Object)this.sysResManageService.getResourceList(resListDto, page));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u6811", notes="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u6811")
    @GetMapping(value={"/resModuleTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u8d44\u6e90\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resModuleTree(@ApiParam(value="\u8d44\u6e90\u6a21\u5757\u6811\u67e5\u8be2\u6761\u4ef6dto") ResModuleTreeDto resModuleTreeDto) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.getResModuleTree(resModuleTreeDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u8d44\u6e90\u6811", notes="\u83b7\u53d6\u529f\u80fd\u8d44\u6e90\u6811")
    @GetMapping(value={"/getFunResChooseAuthority"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FuncResVo>> getFunResChooseAuthority(@ApiParam(value="\u529f\u80fdid") @RequestParam Long functionId) {
        return ApiResponse.success((Object)this.iSysFunctionResourcesService.getFunctionResourceList(functionId));
    }

    @ApiOperation(value="\u529f\u80fd\u6a21\u5757\u4e0a\u79fb\u4e0b\u79fb", notes="\u529f\u80fd\u6a21\u5757\u4e0a\u79fb\u4e0b\u79fb")
    @PostMapping(value={"/singleMoveFuncModules"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6a21\u5757\u4e0a\u79fb\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse updateMoveNodeFuncModules(@ApiParam(value="\u529f\u80fd\u6a21\u5757\u4e0a\u4e0b\u79fbdto") @RequestBody FuncModuleOrderDto funcModuleOrderDto) {
        return this.iSysFunctionModulesService.updateMoveNode(funcModuleOrderDto);
    }

    @ApiOperation(value="\u529f\u80fd\u4e0a\u79fb\u4e0b\u79fb", notes="\u529f\u80fd\u4e0a\u79fb\u4e0b\u79fb")
    @PostMapping(value={"/singleMoveFuncs"})
    @CacheEvict(value={"resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4e0a\u79fb\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse updateMoveNodeFuncs(@ApiParam(value="\u529f\u80fd\u4e0a\u4e0b\u79fbdto") @RequestBody FuncOrderDto funcOrderDto) {
        return this.iSysFunctionsService.updateMoveNode(funcOrderDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u8def\u7531", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u8def\u7531")
    @GetMapping(value={"/samePath"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u8def\u7531", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> samePath(@ApiParam(value="\u8def\u7531\u6821\u9a8cdto") ResourcePathDto resourcePathDto) {
        return ApiResponse.success((Object)this.sysResManageService.getSamePath(resourcePathDto));
    }

    @ApiOperation(value="\u529f\u80fd\u5bfc\u51fa", notes="\u529f\u80fd\u5bfc\u51fa")
    @PostMapping(value={"/exportFunction"})
    @CheckPermission(value={"resourceFront:exportFunction"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportFunction(@ApiParam(value="\u529f\u80fd\u5bfc\u51fadto") @RequestBody FunctionExportDto functionExportDto, HttpServletResponse response) {
        this.iSysFunctionsService.exportFunction(functionExportDto, response);
    }

    @ApiOperation(value="\u529f\u80fd\u5bfc\u5165", notes="\u529f\u80fd\u5bfc\u5165")
    @CheckPermission(value={"resourceFront:exportFunction"})
    @PostMapping(value={"/importFunction"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<ImportVueFuncVo> importFuncData(@ApiParam(value="\u529f\u80fd\u5bfc\u5165") @RequestParam(value="file") MultipartFile hussarFile) {
        return ApiResponse.success((Object)this.iSysFunctionsService.importFunction(hussarFile), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_SUC.getMessage()));
    }

    @ApiOperation(value="\u83b7\u53d6mapper", notes="\u83b7\u53d6mapper")
    @GetMapping(value={"/getMapper"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6mapper", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ResMapperSelectVo>> getMapper(@ApiParam(value="\u83b7\u53d6mapper") @RequestParam(value="moduleId") Long moduleId, @RequestParam(required=false) String serviceName) {
        return ApiResponse.success((Object)this.sysResManageService.getMapper(moduleId, serviceName));
    }

    @ApiOperation(value="\u83b7\u53d6mapperkey", notes="\u83b7\u53d6mapperKey")
    @GetMapping(value={"/getMapperKey"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6mapperKey", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<String>> getMapperKey() {
        return ApiResponse.success((Object)this.sysResManageService.getMapperKey());
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u8fc1\u51fa\u5411\u5bfc\u6811", notes="\u83b7\u53d6\u529f\u80fd\u8fc1\u51fa\u5411\u5bfc\u6811")
    @GetMapping(value={"/migratExportFunction"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u8fc1\u51fa\u5411\u5bfc\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FuncDumpTreeVo>> getFuncDumpGuideTree() {
        return ApiResponse.success((Object)this.iSysFunctionsService.getFuncDumpGuideTree());
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811", notes="\u61d2\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811")
    @GetMapping(value={"/lazyLoadFuncModuleTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> lazyLoadFuncModuleTree(@ApiParam(value="\u8d44\u6e90\u6811dto") ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)this.iSysFunctionsService.lazyLoadFuncModuleTree(resTreeDto));
    }

    @ApiOperation(value="\u5168\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811", notes="\u5168\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811")
    @GetMapping(value={"/loadFuncModuleTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5168\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> loadFuncModuleTree(@ApiParam(value="\u662f\u5426\u52a0\u8f7d\u529f\u80fd") @RequestParam(required=false) String functionFlag, @ApiParam(value="\u5e94\u7528id") @RequestParam(required=false) Long applicationId, @ApiParam(value="\u662f\u5426\u5c55\u793a\u96f6\u4ee3\u7801\u751f\u6210\u7684\u529f\u80fd") @RequestParam(required=false) String showFlag) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.loadFuncModuleTree(functionFlag, applicationId, showFlag));
    }

    @ApiOperation(value="\u5e94\u7528\u4e0b\u89d2\u8272\u5168\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811", notes="\u5e94\u7528\u4e0b\u89d2\u8272\u5168\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811")
    @PostMapping(value={"/loadFuncModuleTreeByAppRole"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5e94\u7528\u4e0b\u89d2\u8272\u5168\u52a0\u8f7d\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> loadFuncModuleTreeByAppRole(@ApiParam(value="\u5e94\u7528\u4e0b\u8d44\u6e90\u6811dto") @RequestBody ResTreeDtoByAppRole resTreeDto) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.loadFuncModuleTreeByAppRole(resTreeDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u548c\u529f\u80fd\u5173\u8054\u7684\u89d2\u8272\u4fe1\u606f", notes="\u83b7\u53d6\u548c\u529f\u80fd\u5173\u8054\u7684\u89d2\u8272\u4fe1\u606f")
    @GetMapping(value={"/getFuncRelateRoles"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u548c\u529f\u80fd\u5173\u8054\u7684\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<RoleBasicVo>> getFuncRelateRoles(@ApiParam(value="\u529f\u80fdid") @RequestParam Long functionId) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.getFuncRelateRoles(functionId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f00\u653e\u63a5\u53e3\u8d44\u6e90\u662f\u5426\u5df2\u6709url", notes="\u67e5\u8be2\u5f00\u653e\u63a5\u53e3\u8d44\u6e90\u662f\u5426\u5df2\u6709url")
    @GetMapping(value={"/checkOpenResUrl"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u5f00\u653e\u63a5\u53e3\u8d44\u6e90\u662f\u5426\u5df2\u6709url", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> checkOpenResUrl(@ApiParam(value="\u8d44\u6e90\u4fe1\u606fdto") ResourceUniqueDto resourceUniqueDto) {
        return ApiResponse.success((Object)this.sysResManageService.checkOpenResUrl(resourceUniqueDto));
    }

    @ApiOperation(value="\u53ea\u52a0\u8f7d\u5f53\u524d\u8d44\u6e90\u7684\u529f\u80fd\u6811", notes="\u53ea\u52a0\u8f7d\u5f53\u524d\u8d44\u6e90\u7684\u529f\u80fd\u6811")
    @GetMapping(value={"/selfResFunctionTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u53ea\u52a0\u8f7d\u5f53\u524d\u8d44\u6e90\u7684\u529f\u80fd\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfResFunctionTree(@ApiParam(value="\u8d44\u6e90id") @RequestParam Long resourceId) {
        return ApiResponse.success((Object)this.iSysFunctionResourcesService.selfResFunctionTree(resourceId));
    }
}

