/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAssistOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.StaffUserMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.StaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.staffmanager.StaffChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonStaffManager {
    protected static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    protected IHussarPwdConfigService pwdConfigService;
    @Resource
    protected HussarBaseProperties hussarBaseProperties;
    @Autowired
    protected ISysStruService sysStruService;
    @Autowired
    protected ISysStruUserService sysStruUserService;
    @Autowired
    protected ISysStruStaffService sysStruStaffService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysOrganMapper sysOrganMapper;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    protected SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Autowired
    protected ISysStaffService sysStaffService;
    @Autowired
    protected ISysOfficeService sysOfficeService;
    @Autowired
    protected ISysStruAssistOrganService sysStruAssistOrganService;
    @Autowired
    protected ISysOrganAuditService sysOrganAuditService;
    @Autowired
    protected ISysStaffAuditService sysStaffAuditService;
    @Autowired
    protected ISysOfficeAuditService sysOfficeAuditService;
    @Autowired
    protected ISysStruAuditService sysStruAuditService;
    @Autowired
    protected ISysUsersAuditService sysUsersAuditService;
    @Autowired
    protected ISysStruAssistOrganAuditService sysStruAssistOrganAuditService;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    protected AddOrganizationManager addOrganizationManager;
    @Autowired
    protected ICreateUserConfigService createUserConfigService;
    @Autowired
    protected ISysUsersService sysUsersService;
    @Resource
    protected StaffUserMapper staffUserMapper;
    @Autowired
    protected ISysOrganService sysOrganService;
    @Resource
    protected SysStaffMapper sysStaffMapper;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Autowired
    protected ISysStruStaffAuditService sysStruStaffAuditService;
    @Resource
    protected StaffChangeNotify staffChangeNotify;
    @Autowired
    protected UserChangeNotify userChangeNotify;

    protected void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if ("2".equals(flag) || "1".equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setId(null);
        }
        this.sysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getId());
        if ("2".equals(flag) || "1".equals(flag)) {
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.sysStruAuditService.save((Object)sysStruAudit);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag) || "1".equals(flag)) {
                sysStaffAudit.setRealStaffId(sysStaff.getId());
                sysStaffAudit.setId(null);
            }
            this.sysStaffAuditService.save((Object)sysStaffAudit);
        }
    }

    protected String getCode(SysOrgan sysOrgan) {
        String fieldName = "STAFF_CODE";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        String code = StringUtils.trimToEmpty((String)sysOrgan.getOrganCode());
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode(fieldName, "SYS_ORGAN");
                ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysOrgan::getOrganType, (Object)"9")).eq(SysOrgan::getOrganCode, (Object)code);
                currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)code);
            lambdaQueryWrapper.eq(SysOrgan::getOrganType, (Object)"9");
            currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_CODE_DUPLICATED.getMessage()));
            }
        }
        return code;
    }

    protected void parentOrganizationAuditDataExists(Long id) {
        if (!this.sysStruAuditService.checkCanOperate(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAILED_PARENT_ORG_HAS_UNAPPROVED.getMessage()));
        }
    }

    protected boolean delStaffByStru(SysStru sysStru) {
        long id = sysStru.getId();
        boolean flag = this.sysStruMapper.deleteById(Long.valueOf(id)) > 0;
        LambdaQueryWrapper delOrgan = new LambdaQueryWrapper();
        delOrgan.eq(SysOrgan::getId, (Object)sysStru.getOrganId());
        this.sysOrganMapper.delete((Wrapper)delOrgan);
        LambdaQueryWrapper delOffice = new LambdaQueryWrapper();
        delOffice.eq(SysOffice::getStruId, (Object)id);
        this.sysOfficeMapper.delete((Wrapper)delOffice);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysStruRoleAudit::getStruId, (Object)id);
        this.sysStruRoleAuditMapper.delete((Wrapper)queryWrapper);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruAssistOrgan::getStruId, (Object)id);
        this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
        Long organId = sysStru.getOrganId();
        if (ToolUtil.isNotEmpty((Object)organId)) {
            this.sysOrganMapper.deleteById(organId);
        }
        QueryWrapper sysStaffQueryWrapper = new QueryWrapper();
        sysStaffQueryWrapper.lambda().eq(SysStaff::getStruId, (Object)id);
        this.sysStaffMapper.delete((Wrapper)sysStaffQueryWrapper);
        return flag;
    }

    protected List<Long> dealSaveOrUpdate(StaffDto staffDto) {
        return this.dealOrganStaffAndUserRole(staffDto);
    }

    protected void auditDealSaveOrUpdate(StaffDto staffDto) {
        this.auditDealOrganStaff(staffDto);
    }

    protected List<Long> dealOrganStaffAndUserRole(StaffDto staffDto) {
        List<Long> organIdList;
        if (HussarUtils.isEmpty((Object)staffDto.getOrganId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        String regex = "[,\uff0c]";
        String[] organIds = staffDto.getOrganId().split(regex);
        List<Long> organId = organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
        List<Long> delIdList = new ArrayList<Long>();
        List sysOrganStaffs = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffDto.getId()));
        if (HussarUtils.isNotEmpty((Object)sysOrganStaffs)) {
            List<Long> dataBankOrganIds = sysOrganStaffs.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
            organId = this.contrastAddOrDel(organIdList, dataBankOrganIds);
            delIdList = this.contrastAddOrDel(dataBankOrganIds, organIdList);
            if (HussarUtils.isNotEmpty(delIdList)) {
                this.sysStruStaffService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffDto.getId())).in(SysStruStaff::getStruId, delIdList));
            }
        }
        ArrayList<SysStruStaff> struStaffs = new ArrayList<SysStruStaff>();
        for (Long id : organId) {
            SysStruStaff sysOrganStaff = new SysStruStaff();
            sysOrganStaff.setStruId(id);
            sysOrganStaff.setStaffId(staffDto.getId());
            struStaffs.add(sysOrganStaff);
        }
        this.sysStruStaffService.saveBatch(struStaffs);
        return delIdList;
    }

    protected void auditDealOrganStaff(StaffDto staffDto) {
        if (HussarUtils.isEmpty((Object)staffDto.getOrganId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        String regex = "[,\uff0c]";
        String[] organIds = staffDto.getOrganId().split(regex);
        List organIdList = Arrays.stream(organIds).map(Long::valueOf).collect(Collectors.toList());
        this.sysStruStaffAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaffAudit::getStaffId, (Object)staffDto.getId()));
        for (Long id : organIdList) {
            SysStruStaffAudit sysStruStaffAudit = new SysStruStaffAudit();
            sysStruStaffAudit.setStruId(id);
            sysStruStaffAudit.setStaffId(staffDto.getId());
            sysStruStaffAudit.setAuditStatus("0");
            sysStruStaffAudit.setOperateType("1");
            this.sysStruStaffAuditService.save((Object)sysStruStaffAudit);
        }
    }

    protected List<Long> contrastAddOrDel(List<Long> list, List<Long> secondList) {
        return list.stream().filter(item -> !secondList.contains(item)).collect(Collectors.toList());
    }
}

