/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.PermissionEnum;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.common.treemodel.HussarTreePermission;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;

public abstract class CommonQueryOrganizationManager {
    protected static final String STRUFID = "struFid";
    protected static final String STRULEVEL = "struLevel";
    protected static final String PARENTID = "parentId";
    protected static final String NOT_FIND_SYSORGAN = "\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784";
    protected static final String NOT_FIND_SYSSTAFF = "\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f";
    protected static final String NOT_FIND_SYSSTRU = "\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784";
    protected static final String PARENTIDS = "parentIds";
    protected static final String ORGANPROPERTY = "organProperty";
    protected static final String GRADEROOTID = "gradeRootId";
    protected static final int SELECT_BATCH_SIZE = 500;
    protected static final int SELECT_BATCH_LIKE_SIZE = 200;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysStaffMapper sysStaffMapper;
    @Resource
    protected SysOrganMapper sysOrganMapper;
    @Resource
    protected SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Autowired
    protected ISysOrganTypeService organTypeService;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysStruRuleMapper sysStruRuleMapper;
    @Autowired
    protected ISysDicRefService sysDicRefService;
    @Autowired
    protected ISysStruPostService sysStruPostService;
    @Autowired
    protected ISysStruStaffService sysStruStaffService;
    @Autowired
    protected ISysStruRoleService sysStruRoleService;
    @Resource
    protected SysStruPostMapper sysStruPostMapper;
    @Resource
    protected SysStruRoleMapper sysStruRoleMapper;
    @Resource
    protected SysRolesMapper sysRolesMapper;
    @Resource
    protected SysPostMapper sysPostMapper;
    @Autowired
    protected ISysStaffService sysStaffService;
    @Autowired
    protected ISysUsersService sysUsersService;
    @Autowired
    protected ISysStruUserService sysStruUserService;
    @Resource
    protected SysStruUserMapper sysStruUserMapper;
    @Autowired
    protected ISysUserPostService sysUserPostService;
    @Autowired
    protected ICreateUserConfigService createUserConfigService;
    @Resource
    protected SysUserPostMapper sysUserPostMapper;
    @Resource
    protected SysOrgManageService sysOrgManageService;
    @Resource
    protected HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    protected List<OrganizationTreeVo> getOrganizationTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENTID, parentId);
        return this.searchOrganizationTree(queryParams);
    }

    protected List<OrganizationTreeVo> getOrganizationTree(Long parentId, String organProperty) {
        return this.getGradeOrganizationTree(parentId, organProperty, null);
    }

    protected List<OrganizationTreeVo> getGradeOrganizationTree(Long parentId, String organProperty, Long gardeRootId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENTID, parentId);
        queryParams.put(ORGANPROPERTY, organProperty);
        queryParams.put(GRADEROOTID, gardeRootId);
        return this.sysStruMapper.searchOrganizationTreeWithProperty(queryParams);
    }

    protected List<StaffTreeVo> getStaffTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENTID, parentId);
        return this.sysStruMapper.searchStaffTree(queryParams);
    }

    protected List<OrganizationTreeVo> searchOrganizationTree(Map<String, Object> queryParams) {
        return this.sysStruMapper.searchOrganizationTree(queryParams);
    }

    protected void fillSingleOrganizationPermissions(OrganizationTreeVo organizationTreeVo, List<SysStruRule> list) {
        String struType = organizationTreeVo.getStruType();
        Boolean hasChildren = organizationTreeVo.getHasChildren();
        List permissions = organizationTreeVo.getPermissions();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (SysStruRule ssr : list) {
            map.add((Object)ssr.getSysOrganType(), (Object)ssr.getOrganType());
        }
        List rules = (List)map.get((Object)struType);
        if (organizationTreeVo.getStruLevel() >= 1) {
            organizationTreeVo.setDisabled(Boolean.valueOf(false));
        }
        permissions.add(new HussarTreePermission(PermissionEnum.ADD.getId(), PermissionEnum.ADD.getName(), Boolean.valueOf(HussarUtils.isNotEmpty((Object)rules))));
        permissions.add(new HussarTreePermission(PermissionEnum.EDIT.getId(), PermissionEnum.EDIT.getName(), Boolean.valueOf(true)));
        permissions.add(new HussarTreePermission(PermissionEnum.DELETE.getId(), PermissionEnum.DELETE.getName(), Boolean.valueOf(true)));
        organizationTreeVo.setPermissions(permissions);
    }

    protected void fillOrganizationPermissions(List<OrganizationTreeVo> result) {
        List<SysStruRule> list = this.searchWithoutStaffRuleList();
        for (OrganizationTreeVo organizationTreeVo : result) {
            this.fillSingleOrganizationPermissions(organizationTreeVo, list);
        }
    }

    protected void fillStaffPermissions(List<StaffTreeVo> data) {
        List<SysStruRule> list = this.searchWithStaffRuleList();
        for (StaffTreeVo vo : data) {
            this.fillSingleStaffPermissions(vo, list);
        }
    }

    protected void fillSingleStaffPermissions(StaffTreeVo staffTreeVo, List<SysStruRule> list) {
        List permissions = staffTreeVo.getPermissions();
        String struType = staffTreeVo.getStruType();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (SysStruRule ssr : list) {
            map.add((Object)ssr.getSysOrganType(), (Object)ssr.getOrganType());
        }
        List rules = (List)map.get((Object)struType);
        staffTreeVo.setDisabled(Boolean.valueOf(false));
        permissions.add(new HussarTreePermission(PermissionEnum.ADD.getId(), TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_PERSON.getMessage()), Boolean.valueOf(HussarUtils.isNotEmpty((Object)rules))));
        staffTreeVo.setPermissions(permissions);
    }

    protected void fillUserPermissions(List<UserTreeVo> data) {
        List<SysStruRule> list = this.searchWithStaffRuleList();
        for (UserTreeVo vo : data) {
            this.fillSingleUserPermissions(vo, list);
        }
    }

    protected void fillSingleUserPermissions(UserTreeVo vo, List<SysStruRule> list) {
        List permissions = vo.getPermissions();
        String struType = vo.getStruType();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (SysStruRule ssr : list) {
            map.add((Object)ssr.getSysOrganType(), (Object)ssr.getOrganType());
        }
        List rules = (List)map.get((Object)struType);
        vo.setDisabled(Boolean.valueOf(false));
        permissions.add(new HussarTreePermission(PermissionEnum.ADD.getId(), TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER.getMessage()), Boolean.valueOf(HussarUtils.isNotEmpty((Object)rules))));
        vo.setPermissions(permissions);
    }

    protected List<SysStruRule> searchWithStaffRuleList() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getOrganType, (Object)"9");
        return this.sysStruRuleMapper.selectList((Wrapper)wrapper);
    }

    protected List<SysStruRule> searchWithoutStaffRuleList() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(SysStruRule::getOrganType, (Object)"9");
        return this.sysStruRuleMapper.selectList((Wrapper)wrapper);
    }

    protected static <T> List<List<T>> getSplitList(List<T> list) {
        if (HussarUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        int size = list.size();
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < size; i += 999) {
            if (i + 999 < size) {
                result.add(list.subList(i, i + 999));
                continue;
            }
            result.add(list.subList(i, size));
        }
        return result;
    }

    protected Map<Long, Integer> getUserCountByOrganId(List<Long> organIds) {
        HashMap<Long, Integer> countMap = new HashMap<Long, Integer>();
        List list = this.sysStruMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds));
        List seqList = list.stream().map(SysStru::getStruFid).distinct().collect(Collectors.toList());
        Map<String, Long> sqpStruIds = list.stream().distinct().collect(Collectors.toMap(SysStru::getStruFid, SysStru::getId));
        ArrayList sysStrus = new ArrayList();
        this.executeInBatches(seqList, 200, currentFIds -> {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String fid : currentFIds) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
            }
            List strus = this.sysStruMapper.selectList((Wrapper)wrapper);
            sysStrus.addAll(strus);
        }, this.hussarThreadPoolConfiguration.getAsyncExecutor());
        List struIdList = sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
        ArrayList sysOrganUsers = new ArrayList();
        if (HussarUtils.isNotEmpty(struIdList)) {
            this.executeInBatches(organIds, 500, currentStruIds -> {
                List<SysStruUser> struUsers = this.sysStruUserMapper.getStruUserByStruIds((List<Long>)currentStruIds);
                sysOrganUsers.addAll(struUsers);
            }, this.hussarThreadPoolConfiguration.getAsyncExecutor());
        }
        for (String seq : seqList) {
            List struIds = sysStrus.stream().filter(item -> item.getStruFid().contains(seq)).map(SysStru::getId).distinct().collect(Collectors.toList());
            int count = 0;
            if (HussarUtils.isNotEmpty(sysOrganUsers)) {
                List hasList = sysOrganUsers.stream().filter(item -> struIds.contains(item.getStruId())).collect(Collectors.toList());
                List userIds = hasList.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
                count = userIds.size();
            }
            countMap.put(sqpStruIds.get(seq), count);
        }
        return countMap;
    }

    protected List<Long> getSubOrganByIds(List<Long> organIds) {
        if (HussarUtils.isEmpty(organIds)) {
            return new ArrayList<Long>();
        }
        List list = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        List fidList = list.stream().map(SysStru::getStruFid).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        for (String fid : fidList) {
            ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
        }
        List sysStrus = this.sysStruMapper.selectList((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0')));
        return sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
    }

    protected List<Long> getParentByIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStru::getId, struIds);
        List strus = this.sysStruMapper.selectList((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List fidList = strus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
        HashSet<Long> finalStruIds = new HashSet<Long>();
        for (String fid : fidList) {
            String[] struIdArr = fid.split("/");
            ArrayList<String> ids = new ArrayList<String>(Arrays.asList(struIdArr));
            ids.remove(0);
            for (String id : ids) {
                finalStruIds.add(Long.valueOf(id));
            }
        }
        return new ArrayList<Long>(finalStruIds);
    }

    protected static <K, V> List<V> getCollection(Map<K, V> map, Iterable<K> keys) {
        ArrayList result = new ArrayList();
        if (map != null && !map.isEmpty() && keys != null) {
            keys.forEach(key -> Optional.ofNullable(map.get(key)).ifPresent(result::add));
        }
        return result;
    }

    private <T> void executeInBatches(List<T> dataSet, int batchSize, Consumer<List<T>> task, Executor threadPool) {
        if (HussarUtils.isEmpty(dataSet) || task == null || threadPool == null) {
            return;
        }
        List batches = Lists.partition(dataSet, (int)batchSize);
        CountDownLatch countDownLatch = new CountDownLatch(batches.size());
        for (List batch : batches) {
            threadPool.execute(() -> {
                try {
                    task.accept(batch);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("\u4efb\u52a1\u6267\u884c\u88ab\u4e2d\u65ad", e);
        }
    }
}

