/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysMenuManageBoServiceImpl
implements ISysMenuManageBoService {
    @Resource
    private ISysMenuManageService sysMenuManageService;

    public Boolean delByFunId(List<Long> funIds) {
        return this.sysMenuManageService.remove((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionId, funIds));
    }

    public ApiResponse updateMenu(SysMenu sysMenu) {
        return this.sysMenuManageService.updateMenu(sysMenu);
    }

    public ApiResponse deleteMenus(String menuIds) {
        return this.sysMenuManageService.deleteMenus(menuIds);
    }

    public void insertOrUpdateMenuList(List<SysMenu> sysMenuList) {
        this.sysMenuManageService.insertOrUpdateMenuList(sysMenuList);
    }

    public Integer getMaxOrderByParentId(Long parentId) {
        Integer order = this.sysMenuManageService.getMaxOrderByParentId(parentId);
        if (HussarUtils.isEmpty((Object)order)) {
            return 0;
        }
        return order;
    }

    public void flagDelApp(Long appId) {
        this.sysMenuManageService.flagDelApp(appId);
    }

    public void recycleApp(Long appId) {
        this.sysMenuManageService.recycleApp(appId);
    }

    public void deleteRecycleApp(Long appId) {
        this.sysMenuManageService.deleteRecycleApp(appId);
    }
}

