/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.manager.DeleteOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.relational.dao.SysPostRoleMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.deleteOutsidePostManagerImpl")
public class DeleteOutsidePostManagerImpl
implements DeleteOutsidePostManager {
    @Autowired
    private SysPostMapper sysPostMapper;
    @Autowired
    private SysStruPostMapper sysStruPostMapper;
    @Autowired
    private SysPostRoleMapper sysPostRoleMapper;
    @Autowired
    private SysUserPostMapper sysUserPostMapper;

    @Override
    public R<String> deletePost(String postCode) {
        String code;
        SysPost post;
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)postCode)) {
            OrganUtil.addErrorMsg(errors, (Object)postCode, (String)"postCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_POST_CODE_NO_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(post = (SysPost)this.sysPostMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysPost::getPostCode, (Object)(code = StringUtils.trimToEmpty((String)postCode))))))) {
            Long postId = post.getId();
            this.sysUserPostMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)postId));
            this.sysPostRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getPostId, (Object)postId));
            this.sysStruPostMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postId));
            this.sysPostMapper.deleteById(postId);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(postId, code)}));
        }
        return result;
    }
}

