/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.UserRoleAduitDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserRoleVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleUserChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysUserroleAuditServiceImpl
extends HussarServiceImpl<SysUserroleAuditMapper, SysUserroleAudit>
implements ISysUserroleAuditService {
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysRolesService iSysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private RoleUserChangeNotify roleUserChangeNotify;
    @Resource
    @Lazy
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;

    public IPage<SysUserRoleVo> getUserRoleReviewList(Page<SysUserRoleVo> page, UserRoleAduitDto userRoleAduitDto) {
        String type;
        String userAccount;
        String userName;
        List<SysUserRoleVo> userRoleList;
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        if (userRoleAduitDto == null) {
            userRoleAduitDto = new UserRoleAduitDto();
        }
        if (HussarUtils.isNotEmpty(userRoleList = this.sysUserroleAuditMapper.getUserRoleReviewList(page, userName = userRoleAduitDto.getUserName(), userAccount = userRoleAduitDto.getUserAccount(), type = userRoleAduitDto.getStatus()))) {
            this.wrapSearchUsers(userRoleList);
        }
        ArrayList result = new ArrayList();
        userRoleList.forEach(userRole -> {
            if (HussarUtils.isNotEmpty((Object)userRole.getUserAccount())) {
                result.add(userRole);
            }
        });
        return page.setRecords(result);
    }

    @HussarTransactional
    public void reviewSubmit(UserRoleAduitDto sysUserroleAudit) {
        if (ToolUtil.isEmpty((Object)sysUserroleAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_REVIEW_EMPTY.getMessage()));
        }
        String userId = sysUserroleAudit.getUserIds();
        String roleId = sysUserroleAudit.getRoleIds();
        String opsType = sysUserroleAudit.getOperationType();
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        Long[] roleIds = new Long[rids.length];
        for (int i = 0; i < rids.length; ++i) {
            roleIds[i] = Long.valueOf(rids[i]);
        }
        for (String uid : uids) {
            this.iSysRolesService.delAuthCacheInfo(Long.valueOf(uid));
        }
        if (uids.length == oids.length && rids.length == oids.length) {
            ArrayList<SysUserRole> addBpmList = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> deleteBpmList = new ArrayList<SysUserRole>();
            List uidL = Arrays.asList(uids).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, uidL));
            ArrayList<SysUserRole> addList = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> updateList = new ArrayList<SysUserRole>();
            ArrayList<SysUserroleAudit> auditList = new ArrayList<SysUserroleAudit>();
            for (int i = 0; i < uids.length; ++i) {
                int count = 0;
                for (SysUserRole userRole : userRoleList) {
                    if (!uids[i].equals(userRole.getUserId().toString()) || !roleIds[i].equals(userRole.getGrantedRole())) continue;
                    ++count;
                    break;
                }
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setUserId(Long.valueOf(uids[i]));
                sysUserRole.setGrantedRole(roleIds[i]);
                if (ADD.equals(oids[i])) {
                    sysUserRole.setAdminOption(UserStatus.OK.getCode());
                } else {
                    sysUserRole.setAdminOption(UserStatus.LOCKED.getCode());
                }
                if (count == 0) {
                    sysUserRole.setId(Long.valueOf(IdWorker.getId((Object)sysUserRole)));
                    addList.add(sysUserRole);
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else {
                        deleteBpmList.add(sysUserRole);
                    }
                } else {
                    updateList.add(sysUserRole);
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else {
                        deleteBpmList.add(sysUserRole);
                    }
                }
                SysUserroleAudit userroleAudit = new SysUserroleAudit();
                userroleAudit.setStatus(UserRoleStatus.OK.getCode());
                userroleAudit.setUserId(Long.valueOf(uids[i]));
                userroleAudit.setRoleId(roleIds[i]);
                userroleAudit.setOperationType(oids[i]);
                auditList.add(userroleAudit);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                this.sysUserRoleMapper.insertUserRoleBatch(addList);
            }
            if (ToolUtil.isNotEmpty(updateList)) {
                this.sysUserRoleMapper.updateUserRoleBatch(updateList);
            }
            if (ToolUtil.isNotEmpty(auditList)) {
                auditList.forEach(auditLog -> this.sysUserroleAuditMapper.updateIsAuditBatch((SysUserroleAudit)auditLog));
            }
            this.abstractPushMsgMatcher.insertOperation("userRole", "add", addBpmList, Constants.NONE_ID);
            this.abstractPushMsgMatcher.insertOperation("userRole", "delete", deleteBpmList, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushUserRole(addBpmList, "add");
            this.bpmAbstractPushMsgMatcher.pushUserRole(deleteBpmList, "delete");
            List rolesList = this.iSysRolesService.listByIds(Arrays.asList(rids));
            Map addUserIdMap = addList.stream().collect(Collectors.groupingBy(SysUserRole::getGrantedRole, Collectors.mapping(SysUserRole::getUserId, Collectors.toList())));
            Map updateUserIdMap = updateList.stream().collect(Collectors.groupingBy(SysUserRole::getGrantedRole, Collectors.mapping(SysUserRole::getUserId, Collectors.toList())));
            for (SysRoles role : rolesList) {
                if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
                    this.roleUserChangeNotify.notify(DataChangeType.RELATE, new Object[]{role.getId(), null});
                }
                if (!HussarUtils.isEmpty((Object)role.getAppId()) && role.getAppId() != 1L) continue;
                List ids = new ArrayList();
                List adds = addUserIdMap.get(role.getId());
                List updates = updateUserIdMap.get(role.getId());
                if (HussarUtils.isNotEmpty(updates)) {
                    ids.addAll(updates);
                }
                if (HussarUtils.isNotEmpty(adds)) {
                    ids.addAll(adds);
                }
                ids = ids.stream().distinct().collect(Collectors.toList());
                this.userAuthorizationChangeReporter.report(new Object[]{"user", ids});
            }
        }
    }

    @HussarTransactional
    public void refuseSubmit(UserRoleAduitDto sysUserroleAudit) {
        if (ToolUtil.isEmpty((Object)sysUserroleAudit)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_REVIEW_EMPTY.getMessage()));
        }
        String userId = sysUserroleAudit.getUserIds();
        String roleId = sysUserroleAudit.getRoleIds();
        String opsType = sysUserroleAudit.getOperationType();
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        ArrayList<SysUserroleAudit> auditList = new ArrayList<SysUserroleAudit>();
        if (uids.length == oids.length && rids.length == oids.length) {
            for (int i = 0; i < uids.length; ++i) {
                SysUserroleAudit userroleAudit = new SysUserroleAudit();
                userroleAudit.setStatus(UserRoleStatus.REFUSE.getCode());
                userroleAudit.setUserId(Long.valueOf(uids[i]));
                userroleAudit.setRoleId(Long.valueOf(rids[i]));
                userroleAudit.setOperationType(oids[i]);
                auditList.add(userroleAudit);
            }
            if (ToolUtil.isNotEmpty(auditList)) {
                auditList.forEach(auditLog -> this.sysUserroleAuditMapper.updateIsAuditBatch((SysUserroleAudit)auditLog));
            }
        }
    }

    public int isDelete(Long id) {
        return this.sysUserroleAuditMapper.isDelete(id);
    }

    public List<SysUserroleAudit> getHasReviewList(Long userId) {
        return this.sysUserroleAuditMapper.getHasReviewList(userId);
    }

    public void updateAuditBatch(Map<String, Object> paramMap) {
        this.sysUserroleAuditMapper.updateAuditBatch(paramMap);
    }

    private void wrapSearchUsers(List<SysUserRoleVo> userRoleList) {
        List ids = userRoleList.stream().map(u -> Long.parseLong(u.getUserId())).distinct().collect(Collectors.toList());
        List struUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, ids));
        Map<Long, List<SysStruUser>> map = struUsers.stream().collect(Collectors.groupingBy(SysStruUser::getUserId));
        List<Long> struIds = struUsers.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        List<OrganVo> organVos = this.sysStruMapper.getOrganNameAndId(struIds);
        Map organVoMap = organVos.stream().collect(Collectors.toMap(OrganVo::getId, Function.identity()));
        for (SysUserRoleVo userRoleVo : userRoleList) {
            List<SysStruUser> struUserList = map.get(Long.valueOf(userRoleVo.getUserId()));
            if (!HussarUtils.isNotEmpty(struUserList)) continue;
            List list = struUserList.stream().map(v -> String.valueOf(v.getStruId())).distinct().collect(Collectors.toList());
            List vos = SysUserroleAuditServiceImpl.getCollection(organVoMap, list);
            String organNames = null;
            if (HussarUtils.isNotEmpty(vos)) {
                organNames = vos.stream().map(OrganVo::getLabel).collect(Collectors.joining(","));
            }
            userRoleVo.setOrganAlias(organNames);
        }
    }

    private static <K, V> List<V> getCollection(Map<K, V> map, Iterable<K> keys) {
        ArrayList result = new ArrayList();
        if (map != null && !map.isEmpty() && keys != null) {
            keys.forEach(key -> Optional.ofNullable(map.get(key)).ifPresent(result::add));
        }
        return result;
    }
}

