/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.adapter.function.IHussarBaseFunctionAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteRoleStruRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleFunctionChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleResourceChangeNotify;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleFunctionsServiceImpl
extends HussarBaseServiceImpl<SysRoleFunctionsMapper, SysRoleFunctions>
implements ISysRoleFunctionsService {
    private static Logger logger = LoggerFactory.getLogger(SysRoleFunctionsServiceImpl.class);
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Lazy
    @Resource
    private ISysFunctionResourcesService iSysFunctionResourcesService;
    @Lazy
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private IHussarBaseFunctionAdapter hussarBaseFunctionAdapter;
    @Resource
    private RoleFunctionChangeNotify roleFunctionChangeNotify;
    @Resource
    private RoleResourceChangeNotify roleResourceChangeNotify;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;
    @Resource
    private DeleteRoleStruRightManager deleteRoleStruRightManager;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private ISysFunctionsService functionsService;
    @Resource
    private ISysResourcesService resourcesService;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;

    public void saveFunctions(String functionsIds, Long roleId) {
        SysRoles sysRoles;
        String[] ids = functionsIds.split(",");
        Long[] idl = (Long[])ConvertUtils.convert((String[])ids, Long.class);
        List roleFunctions = this.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getRoleId, (Object)roleId));
        if (HussarUtils.isNotEmpty((Object)roleFunctions)) {
            List<Long> dataList = roleFunctions.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
            List<Long> idList = Arrays.asList(idl);
            if (HussarUtils.isNotEmpty(dataList = dataList.stream().filter(id -> !idList.contains(id)).collect(Collectors.toList()))) {
                List<Long> functionIds;
                List roleDataRights = this.sysRoleDataRightService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleDataRight::getRoleId, (Object)roleId)).in(SysRoleDataRight::getFunctionId, dataList));
                if (HussarUtils.isNotEmpty((Object)roleDataRights)) {
                    List<Long> rightIds = roleDataRights.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
                    this.sysRoleDataRightService.removeByIds(rightIds);
                    this.deleteRoleStruRightManager.deleteCustomStruBatch(rightIds);
                }
                if (HussarUtils.isNotEmpty(dataList) && HussarUtils.isNotEmpty(functionIds = this.sysFunctionsMapper.getNodeCodeAppFunctionIds(dataList))) {
                    ArrayList<String> finalIdsList = new ArrayList<String>();
                    ArrayList<Long> finalIdlList = new ArrayList<Long>();
                    List<String> list = Arrays.asList(ids);
                    List<Long> idlList = Arrays.asList(idl);
                    finalIdsList.addAll(list);
                    finalIdlList.addAll(idlList);
                    for (Long id2 : functionIds) {
                        finalIdsList.add(String.valueOf(id2));
                        finalIdlList.add(id2);
                    }
                    ids = finalIdsList.toArray(new String[finalIdsList.size()]);
                    idl = finalIdlList.toArray(new Long[finalIdlList.size()]);
                }
            }
        }
        LambdaQueryWrapper deleteWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getRoleId, (Object)roleId);
        LambdaQueryWrapper resDeleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)roleId)).eq(SysRoleResource::getRelationSource, (Object)"1");
        SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
        if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
            List resourcesList;
            List sysRoleResourceList;
            List sysFunctions;
            List funIds = roleFunctions.stream().map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(funIds) && HussarUtils.isNotEmpty((Object)(sysFunctions = this.functionsService.listByIds(funIds)))) {
                List sysFunIds = sysFunctions.stream().filter(f -> "1".equals(f.getIsSys())).map(SysFunctions::getId).collect(Collectors.toList());
                deleteWrapper.notIn(CollectionUtils.isNotEmpty(sysFunIds), SysRoleFunctions::getFunctionId, sysFunIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)(sysRoleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysRoleResource::getRoleId, (Object)roleId)))) && CollectionUtils.isNotEmpty((Collection)(resourcesList = this.resourcesService.listByIds((Collection)sysRoleResourceList.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList()))))) {
                List list = resourcesList.stream().filter(s -> "1".equals(s.getIsSys())).map(SysResources::getId).collect(Collectors.toList());
                resDeleteWrapper.notIn(CollectionUtils.isNotEmpty(list), SysRoleResource::getResourceId, list);
            }
        }
        this.sysRoleFunctionsMapper.delete((Wrapper)deleteWrapper);
        this.sysRoleResourceMapper.delete((Wrapper)resDeleteWrapper);
        ArrayList<SysRoleFunctions> sysRoleFunctionsList = new ArrayList<SysRoleFunctions>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        for (String functionId : ids) {
            if (ToolUtil.isEmpty((Object)functionId)) continue;
            SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
            sysRoleFunctions.setRoleId(roleId);
            sysRoleFunctions.setFunctionId(Long.valueOf(functionId));
            sysRoleFunctions.setCreator(securityUser.getId());
            sysRoleFunctions.setLastEditor(securityUser.getId());
            sysRoleFunctions.setLastTime(now);
            sysRoleFunctions.setCreateTime(now);
            sysRoleFunctionsList.add(sysRoleFunctions);
        }
        if (ToolUtil.isNotEmpty(sysRoleFunctionsList)) {
            super.saveBatch(sysRoleFunctionsList, sysRoleFunctionsList.size());
            List list = this.iSysFunctionResourcesService.selectFunctionResByFuncIds(Arrays.asList(idl));
            ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
            for (SysFunctionResources functionResources : list) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(roleId);
                sysRoleResource.setResourceId(functionResources.getResourceId());
                sysRoleResource.setRelationSource("1");
                sysRoleResource.setCreator(securityUser.getId());
                sysRoleResource.setLastEditor(securityUser.getId());
                sysRoleResource.setLastTime(now);
                sysRoleResource.setCreateTime(now);
                sysRoleResourceList.add(sysRoleResource);
            }
            if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
                this.iSysRoleResourceService.saveBatch(sysRoleResourceList);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(sysRoles = (SysRoles)this.sysRolesService.getById((Serializable)roleId)).getAppId()) && sysRoles.getAppId() != 1L) {
            this.roleFunctionChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
            this.roleResourceChangeNotify.notify(DataChangeType.RELATE, new Object[]{roleId, null});
        }
        if (HussarUtils.isEmpty((Object)sysRoles.getAppId()) || sysRoles.getAppId() == 1L) {
            this.userAuthorizationChangeReporter.report(new Object[]{"function", roleId});
        }
    }

    public List<SysRoleFunctions> getRoleFunctions(Long roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ROLE_ID", (Object)roleId);
        return super.list((Wrapper)queryWrapper);
    }

    public List<SysRoleFunctions> getRoleFunctions(String roleId) {
        return this.getRoleFunctions(Long.parseLong(roleId));
    }

    public List<JSTreeModel> selfFunctionTree(String functionIds) {
        String[] functionIdArr = ToolUtil.isEmpty((Object)functionIds) ? new String[]{} : functionIds.trim().split(",");
        Long[] functionIdLArr = (Long[])ConvertUtils.convert((String[])functionIdArr, Long.class);
        List splitIdList = LambdaQueryUtil.getSplitList(Arrays.asList(functionIdLArr));
        List<JSTreeModel> functionTreeData = new ArrayList<JSTreeModel>();
        if (ToolUtil.isNotEmpty((Object)functionIdLArr)) {
            functionTreeData = this.sysRoleFunctionsMapper.selfFunctionTree(splitIdList);
        }
        return TreeModelUtils.merge(this.doRecursive(functionTreeData));
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList childList = new ArrayList();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        list.forEach(m -> {
            if ("1".equals(m.getIsRes())) {
                childList.add(m);
                parentIdList.add(m.getParent());
            } else {
                otherList.add((JSTreeModel)m);
            }
        });
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>(childList);
        if (ToolUtil.isNotEmpty(otherList)) {
            this.recursive(otherList, result, parentIdList);
        }
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setCode("GROUP");
        model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        model.setId(Constants.RES_NODE_ID);
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, List<Long> idList) {
        ArrayList currentList = new ArrayList();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        list.forEach(model -> {
            if (idList.contains(model.getId())) {
                currentList.add(model);
                parentIdList.add(model.getParent());
            } else {
                otherList.add((JSTreeModel)model);
            }
        });
        if (ToolUtil.isNotEmpty(currentList)) {
            result.addAll(currentList);
            this.recursive(otherList, result, parentIdList);
        }
    }

    public void insertOrUpdateRoleFunction(List<SysRoleFunctions> roleFunctionsList) {
        if (ToolUtil.isEmpty(roleFunctionsList)) {
            logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_FUNCTION_ADD_DATA.getMessage()), (Object)roleFunctionsList.size());
            return;
        }
        List<SysRoleFunctions> excistData = this.selectExistList(roleFunctionsList);
        List<SysRoleFunctions> addList = roleFunctionsList;
        if (ToolUtil.isNotEmpty(excistData)) {
            addList = this.getAddList(roleFunctionsList, excistData);
        }
        if (ToolUtil.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_FUNCTION_ADD_DATA.getMessage()), (Object)addList.size());
    }

    public void dataSyncByRoleFunc(List<SysRoleFunctions> roleFunctionsList) {
        List functionIdList = roleFunctionsList.stream().map(SysRoleFunctions::getFunctionId).distinct().collect(Collectors.toList());
        List functionResourcesList = this.iSysFunctionResourcesService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysFunctionResources::getFunctionId, functionIdList));
        List syncRoleFunc = this.sysRoleFunctionsMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getFunctionId, functionIdList));
        List roleIdList = syncRoleFunc.stream().map(SysRoleFunctions::getRoleId).distinct().collect(Collectors.toList());
        if (ToolUtil.isNotEmpty((Object)functionResourcesList)) {
            List roleResourceExistList = new ArrayList();
            List resourceIds = functionResourcesList.stream().map(SysFunctionResources::getResourceId).distinct().collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(roleIdList)) {
                LambdaQueryWrapper roleResWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getRoleId, roleIdList);
                LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)roleResWrapper, SysRoleResource::getResourceId, resourceIds);
                roleResWrapper.eq(SysRoleResource::getRelationSource, (Object)"1");
                roleResourceExistList = this.iSysRoleResourceService.list((Wrapper)roleResWrapper);
            }
            HashMap existMap = new HashMap();
            roleResourceExistList.forEach(rr -> existMap.put(rr.getRoleId() + "-" + rr.getResourceId(), "1"));
            ArrayList<SysRoleResource> addList = new ArrayList<SysRoleResource>();
            SecurityUser user = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            for (Long resId : resourceIds) {
                for (Long roleId : roleIdList) {
                    if (!ToolUtil.isEmpty(existMap.get(roleId + "-" + resId))) continue;
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource.setRoleId(roleId);
                    sysRoleResource.setResourceId(resId);
                    sysRoleResource.setRelationSource("1");
                    sysRoleResource.setCreator(user.getId());
                    sysRoleResource.setLastEditor(user.getId());
                    sysRoleResource.setCreateTime(now);
                    sysRoleResource.setLastTime(now);
                    addList.add(sysRoleResource);
                }
            }
            if (ToolUtil.isNotEmpty(addList)) {
                this.iSysRoleResourceService.saveBatch(addList);
            }
            logger.info("\u4ece\u529f\u80fd\u5173\u8054\u89d2\u8272\u8d44\u6e90\u65b0\u589e{}\u6761", (Object)addList.size());
        }
    }

    public List<SysRoleFunctions> selectRoleFuncByDoubleId(List<SysRoleFunctions> sysRoleFunctions) {
        ArrayList<SysRoleFunctions> retunList = new ArrayList<SysRoleFunctions>();
        LambdaQueryWrapper roleFunctionsLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysRoleFunctions.size(); i += 999) {
            List<SysRoleFunctions> temp;
            if (i + 999 >= sysRoleFunctions.size()) {
                temp = sysRoleFunctions.subList(i, sysRoleFunctions.size());
                roleFunctionsLambdaQueryWrapper.clear();
                for (SysRoleFunctions roleFunc : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
                }
                retunList.addAll(this.sysRoleFunctionsMapper.selectList((Wrapper)roleFunctionsLambdaQueryWrapper));
                continue;
            }
            temp = sysRoleFunctions.subList(i, i + 999);
            roleFunctionsLambdaQueryWrapper.clear();
            for (SysRoleFunctions roleFunc : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
            }
            retunList.addAll(this.sysRoleFunctionsMapper.selectList((Wrapper)roleFunctionsLambdaQueryWrapper));
        }
        return retunList;
    }

    public void delRoleFuncByDoubleId(List<SysRoleFunctions> sysRoleFunctionsList) {
        LambdaQueryWrapper roleFunctionsLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < sysRoleFunctionsList.size(); i += 999) {
            List<SysRoleFunctions> temp;
            if (i + 999 >= sysRoleFunctionsList.size()) {
                temp = sysRoleFunctionsList.subList(i, sysRoleFunctionsList.size());
                roleFunctionsLambdaQueryWrapper.clear();
                for (SysRoleFunctions roleFunc : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
                }
                this.sysRoleFunctionsMapper.delete((Wrapper)roleFunctionsLambdaQueryWrapper);
                continue;
            }
            temp = sysRoleFunctionsList.subList(i, i + 999);
            roleFunctionsLambdaQueryWrapper.clear();
            for (SysRoleFunctions roleFunc : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)roleFunctionsLambdaQueryWrapper.or()).eq(SysRoleFunctions::getRoleId, (Object)roleFunc.getRoleId())).eq(SysRoleFunctions::getFunctionId, (Object)roleFunc.getFunctionId());
            }
            this.sysRoleFunctionsMapper.delete((Wrapper)roleFunctionsLambdaQueryWrapper);
        }
    }

    public List<SysRoleFunctions> selectRoleFunsByFunctionIds(List<Long> functionIds) {
        if (HussarUtils.isEmpty(functionIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long funcId : functionIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysRoleFunctions::getFunctionId, (Object)funcId);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    private List<SysRoleFunctions> selectExistList(List<SysRoleFunctions> sysRoleFunctions) {
        List<Object> returnList = new ArrayList<SysRoleFunctions>();
        ArrayList roleIds = new ArrayList();
        ArrayList functionIds = new ArrayList();
        sysRoleFunctions.forEach(fr -> {
            roleIds.add(fr.getRoleId());
            functionIds.add(fr.getFunctionId());
        });
        if (ToolUtil.isNotEmpty(functionIds) && ToolUtil.isNotEmpty(roleIds)) {
            List distRoleIds = roleIds.stream().distinct().collect(Collectors.toList());
            List distFuncIds = functionIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper roleFuncQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getRoleId, distRoleIds);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)roleFuncQueryWrapper, SysRoleFunctions::getFunctionId, distFuncIds);
            returnList = this.sysRoleFunctionsMapper.selectList((Wrapper)roleFuncQueryWrapper);
        }
        return returnList;
    }

    private List<SysRoleFunctions> getAddList(List<SysRoleFunctions> roleFunctionsList, List<SysRoleFunctions> existList) {
        ArrayList<SysRoleFunctions> addList = new ArrayList<SysRoleFunctions>();
        HashMap existMap = new HashMap();
        existList.forEach(fr -> existMap.put(fr.getRoleId() + "-" + fr.getFunctionId(), "1"));
        for (SysRoleFunctions roleFunctions : roleFunctionsList) {
            String idStr = roleFunctions.getRoleId() + "-" + roleFunctions.getFunctionId();
            if (!ToolUtil.isEmpty(existMap.get(idStr))) continue;
            addList.add(roleFunctions);
        }
        return addList;
    }

    public boolean saveBatch(Collection<SysRoleFunctions> entityList) {
        return this.hussarBaseFunctionAdapter.saveBatchRoleFunc((List)entityList);
    }

    public List<SysRoleFunctions> listByRoleIds(List<Long> roleIds) {
        return this.hussarBaseFunctionAdapter.listByRoleIds(roleIds);
    }

    public List<SysRoleFunctions> listByFunctionId(Long functionId) {
        return this.hussarBaseFunctionAdapter.listByFuncId(functionId);
    }
}

