/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.CopyUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserActivateDto;
import com.jxdinfo.hussar.authorization.permit.enums.UserAttachmentBusiTypeEnum;
import com.jxdinfo.hussar.authorization.permit.enums.UserAttachmentFileTypeEnum;
import com.jxdinfo.hussar.authorization.permit.manager.EditUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserAttachment;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.impl.FunctionRoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.util.UserLogoutCacheUtil;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.editUserManagerImpl")
public class EditUserManagerImpl
extends CommonUserManager
implements EditUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditUserManagerImpl.class);
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Autowired
    private ISysRolesService sysRolesService;
    @Resource
    private FunctionRoleUserAuthorizationChangeReporter functionRoleUserAuthorizationChangeReporter;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Autowired
    private IConvertPinyinService convertPinyinService;
    @Autowired
    private IHussarBaseUserAttachmentService userAttachmentService;

    @Override
    public String editUser(EditUserDto editUserDto) {
        String validateMsg = this.validateService.validate((Object)editUserDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String allowedIps = StringUtils.trimToEmpty((String)editUserDto.getAllowedIps());
        String roleIds = StringUtils.trimToEmpty((String)editUserDto.getRoleIds());
        ArrayList<Object> listRoles = new ArrayList<Object>();
        if (HussarUtils.isNotBlank((CharSequence)roleIds)) {
            Object[] temp = (Long[])ConvertUtils.convert((String[])roleIds.split(","), Long.class);
            if (!ArrayUtils.contains((Object[])temp, (Object)SysUserAndRole.PUBLIC_ROLE.getValue())) {
                listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
            }
            listRoles.addAll(Arrays.asList(temp));
        } else {
            listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
        }
        Long[] roleIdsArray = listRoles.toArray(new Long[0]);
        this.checkRelation(editUserDto);
        SysUsers user = this.initialization(editUserDto);
        this.handleRelation(editUserDto);
        this.checkIncludeConfRole(roleIdsArray, "edit");
        String result = this.processAuditIfNecessary(user, allowedIps, roleIdsArray, editUserDto.isNeedAudit());
        this.editUserSignPic(editUserDto, user.getId());
        return result;
    }

    @Override
    public String copyUserRole(CopyUserRoleDto copyRoleDto) {
        String validateMsg = this.validateService.validate((Object)copyRoleDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        boolean result = this.copyRole(copyRoleDto.getSource(), copyRoleDto.getTarget());
        if (!result) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.COPY_ROLE_FAIL_CONFLICT.getMessage()));
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.COPY_ROLE_SUCCESS.getMessage());
    }

    @Override
    public String dormancyUser(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DORMANCY_THIS_USER.getMessage()), (Object)id);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        sysUsers.setAccountStatus(UserStatus.DORMANCY.getCode());
        sysUsers.setLockTime(Java8DateUtils.currentLocalDateTime());
        this.sysUsersMapper.updateById(sysUsers);
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUsers});
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.DORMANCY_SUCCESS.getMessage());
    }

    @Override
    public String cancelUser(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_THIS_USER.getMessage()), (Object)id);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysUser, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_FAIL_ADMIN.getMessage()));
        }
        if (shiroUser.getId().equals(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_FAIL_ACTIVE_USER.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_FAIL_EXIST_REVIEW.getMessage()));
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("4");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_SUCCESS_WAIT_REVIEW.getMessage());
        }
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUser.getId()));
        sysUser.setAccountStatus(UserStatus.CANCEL.getCode());
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        this.sysUsersMapper.updateById(sysUser);
        UserLogoutCacheUtil.kickOutUser((Long)id);
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUser});
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_SUCCESS.getMessage());
    }

    @Override
    public String activateUser(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_THIS_USER.getMessage()), (Object)id);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        this.dealLock(sysUsers);
        boolean flag = true;
        if ("0".equals(sysUsers.getTypeProperty())) {
            LocalDateTime nowDay = LocalDateTime.now();
            LocalDateTime expiredDay = sysUsers.getExpiredTime();
            LocalDateTime startDay = sysUsers.getStartTime();
            flag = nowDay.isAfter(startDay);
            if (flag) {
                flag = expiredDay.isAfter(nowDay);
            }
        }
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.TMP_ACCOUNT_CANNOT_ACTIVE.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_FAIL_EXIST_REVIEW.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsers);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUsers.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("5");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        this.sysUsersMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).set(SysUsers::getLastLoginTime, (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()))).eq(SysUsers::getId, (Object)id));
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUsers});
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_SUCCESS.getMessage());
    }

    @Override
    public String activateTempUser(UserActivateDto activateDto) {
        LOGGER.info("\u6fc0\u6d3b\u7528\u6237\uff1a{}", (Object)activateDto.getId());
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(activateDto.getId());
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        AssertUtil.isNotNull((Object)activateDto.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        this.dealLock(sysUsers);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(activateDto.getId())) {
            throw new BaseException("\u6fc0\u6d3b\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff01");
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsers);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUsers.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("5");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return "\u6fc0\u6d3b\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        }
        LocalDateTime endTime = Java8DateUtils.convertStringToLocalDateTime((String)StringUtils.trimToEmpty((String)activateDto.getEndTime()));
        AssertUtil.isNotNull((Object)endTime, (String)"\u7ed3\u675f\u65f6\u95f4\u83b7\u53d6\u5f02\u5e38");
        this.sysUsersMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).set(SysUsers::getLastLoginTime, (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()))).set(SysUsers::getExpiredTime, (Object)Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()))).eq(SysUsers::getId, (Object)activateDto.getId()));
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUsers});
        return "\u6fc0\u6d3b\u6210\u529f\uff01";
    }

    private void dealLock(SysUsers sysUsers) {
        if (sysUsers != null) {
            HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsers.getId()));
            HussarCacheUtil.evictKeysLike((String)"hussar_cas_login_lock", (String)String.valueOf(sysUsers.getId()));
        }
    }

    public boolean copyRole(Long copyFrom, Long copyTo) {
        if (HussarUtils.isEmpty((Object)copyTo)) {
            return true;
        }
        List rolesFrom = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)copyFrom)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        List rolesTo = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)copyTo)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        ArrayList<Long> adds = new ArrayList<Long>();
        for (SysUserRole from : rolesFrom) {
            if (ToolUtil.isEmpty((Object)from.getGrantedRole())) continue;
            boolean isSame = false;
            for (SysUserRole to : rolesTo) {
                if (!from.getGrantedRole().equals(to.getGrantedRole())) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            adds.add(from.getGrantedRole());
        }
        int size = adds.size();
        Long[] toRolesArray = new Long[rolesTo.size()];
        Long[] addArray = adds.toArray(new Long[size]);
        for (int i = 0; i < rolesTo.size(); ++i) {
            toRolesArray[i] = ((SysUserRole)rolesTo.get(i)).getGrantedRole();
        }
        int arryLen1 = addArray.length;
        int arryLen2 = toRolesArray.length;
        if ((addArray = Arrays.copyOf(addArray, arryLen1 + arryLen2)).length == 0) {
            return true;
        }
        System.arraycopy(toRolesArray, 0, addArray, arryLen1, arryLen2);
        if (this.sysConfRolesService.isIncludeConfRole(addArray)) {
            return false;
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(copyTo);
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, copyTo, "1");
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (Long roleId : adds) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(copyTo);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
        return true;
    }

    private String processAuditIfNecessary(SysUsers user, String allowedIps, Long[] roleIds, boolean needAudit) {
        boolean userRoleAuditFlag = this.processRoleAuditIfNecessary(user, roleIds);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.doProcessUserAudit(user, allowedIps, roleIds);
        } else {
            this.doProcessUser(user, allowedIps, roleIds);
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && needAudit) {
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit() && userRoleAuditFlag && needAudit) {
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
    }

    private void doProcessUser(SysUsers user, String allowedIps, Long[] roleIds) {
        boolean flag;
        Long userId = user.getId();
        SysUsers old = (SysUsers)this.sysUsersMapper.selectById(userId);
        if (!"1".equals(old.getAccountStatus()) && "1".equals(user.getAccountStatus())) {
            user.setLastLoginTime(LocalDateTime.now());
            LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
            loginLock.removeUserCache(String.valueOf(userId));
        }
        if (!(flag = this.compareUser(user, old, allowedIps))) {
            this.sysUsersMapper.updateById(user);
            this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userId));
            this.saveUserIP(userId, allowedIps);
        }
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
        this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"user", Collections.singletonList(userId)});
        HussarCacheUtil.evictKeysLike((String)"low_code_user_info", (String)"*");
    }

    private void doProcessUserAudit(SysUsers user, String allowedIps, Long[] roleIds) {
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        SysUsers oldUser = (SysUsers)this.sysUsersMapper.selectById(user.getId());
        boolean flag = this.compareUser(user, oldUser, allowedIps);
        if (!flag) {
            this.userAuditDataExists(user.getId());
            Long oldEmployeeId = oldUser.getEmployeeId();
            Long newEmployeeId = user.getEmployeeId();
            AssertUtil.isTrue((boolean)this.sysStaffAuditService.checkStaffCanOperate(oldEmployeeId), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
            if (!oldEmployeeId.equals(newEmployeeId)) {
                AssertUtil.isTrue((boolean)this.sysStaffAuditService.checkStaffCanOperate(newEmployeeId), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
            }
            BeanUtils.copyProperties((Object)user, (Object)sysUsersAudit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
            sysUsersAudit.setUserId(user.getId());
            sysUsersAudit.setCurrentStatus("1");
            sysUsersAudit.setIsAudit("0");
            LocalDateTime now = LocalDateTime.now();
            sysUsersAudit.setCreateTime(now);
            sysUsersAudit.setCreateTime(now);
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            this.saveUserAuditIP(user.getId(), allowedIps, "1");
        }
    }

    private boolean processRoleAuditIfNecessary(SysUsers user, Long[] roleIds) {
        boolean userRoleAuditFlag = false;
        Long userId = user.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(userId);
            List connList = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
            ArrayList<Long> adds = new ArrayList<Long>();
            ArrayList<Long> dels = new ArrayList<Long>();
            if (HussarUtils.isNotEmpty((Object)connList)) {
                for (SysUserRole sysUserRole : connList) {
                    boolean isSame = false;
                    if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                        for (Long roleId : roleIds) {
                            if (ToolUtil.isEmpty((Object)roleId) || !roleId.equals(sysUserRole.getGrantedRole())) continue;
                            isSame = true;
                            break;
                        }
                    }
                    if (isSame) continue;
                    dels.add(sysUserRole.getGrantedRole());
                }
            }
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    boolean isSame = false;
                    for (SysUserRole sysUserRole : connList) {
                        if (!roleId.equals(sysUserRole.getGrantedRole())) continue;
                        isSame = true;
                        break;
                    }
                    if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                    adds.add(roleId);
                }
            }
            if (HussarUtils.isNotEmpty(adds) || HussarUtils.isNotEmpty(dels)) {
                List audits = this.sysUserroleAuditMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)userId)).eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode()));
                AssertUtil.isFalse((boolean)HussarUtils.isNotEmpty((Object)audits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_ROLE.getMessage()));
                userRoleAuditFlag = true;
            }
            if (HussarUtils.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, userId, "1");
            }
            if (HussarUtils.isNotEmpty(dels)) {
                this.insertAndUpdateUserRoleAudit(dels, auditList, userId, "2");
            }
        } else {
            this.sysRolesService.delAuthCacheInfo(userId);
            if (BaseSecurityUtil.getUser().isGradeadmin()) {
                List<Long> roleList = this.sysUserRoleMapper.delOrganRoleIdByUserId(userId);
                if (roleList.size() > 0) {
                    List cdidList = LambdaQueryUtil.getSplitList(roleList);
                    this.sysUserRoleMapper.delUserRoleByRoleId(userId, cdidList);
                }
            } else {
                List sysUserRoles = this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
                List roleList = sysUserRoles.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(roleList)) {
                    List cdids = roleList.stream().distinct().collect(Collectors.toList());
                    List cdidList = LambdaQueryUtil.getSplitList(cdids);
                    this.sysUserRoleMapper.delSysRolesByUserId(userId, cdidList);
                }
            }
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    if (SysUserAndRole.PUBLIC_ROLE.getValue().toString().equals(roleId) && BaseSecurityUtil.getUser().isGradeadmin()) continue;
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(userId);
                    sysUserRole.setGrantedRole(roleId);
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    userRoleList.add(sysUserRole);
                }
                this.fillCommonFields(userRoleList);
            }
            this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.GRADEADMIN_ROLE.getValue()));
            if (HussarUtils.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
        return userRoleAuditFlag;
    }

    private void insertAndUpdateUserRoleAudit(List<Long> roleIds, List<SysUserroleAudit> auditList, Long userId, String operationType) {
        Long account;
        ArrayList<SysUserroleAudit> updateAuditList = new ArrayList<SysUserroleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<SysUserroleAudit> addAuditList = new ArrayList<SysUserroleAudit>();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Long l = account = ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser()) ? BaseSecurityUtil.getUser().getId() : null;
        if (HussarUtils.isNotEmpty(roleIds)) {
            for (Long roleId : roleIds) {
                if (ToolUtil.isEmpty((Object)roleId) || Objects.equals(roleId, SysUserAndRole.PUBLIC_ROLE.getValue())) continue;
                boolean isExist = false;
                for (SysUserroleAudit sysUserroleAudit : auditList) {
                    if (!roleId.equals(sysUserroleAudit.getRoleId())) continue;
                    isExist = true;
                    updateAuditList.add(sysUserroleAudit);
                    break;
                }
                if (isExist) continue;
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setUserId(userId);
                sysUserroleAudit.setRoleId(roleId);
                sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                sysUserroleAudit.setOperationType(operationType);
                addAuditList.add(sysUserroleAudit);
            }
        }
        if (updateAuditList.size() > 0) {
            updateMap.put("userId", userId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("lastTime", currentDate);
            updateMap.put("lastEditor", account);
            updateMap.put("updateAuditList", updateAuditList);
            this.sysUserroleAuditMapper.updateAuditBatch(updateMap);
        }
        if (addAuditList.size() > 0) {
            this.sysUserroleAuditService.saveBatch(addAuditList);
        }
    }

    private void userAuditDataExists(Long userId) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_VERIFY_ON_AUDIT.getMessage()));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
        }
    }

    private SysUsers initialization(EditUserDto editUserDto) {
        String struIds;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EDIT_USER_DTO_INITIALIZE_PARAM.getMessage()), (Object)JSON.toJSONString((Object)editUserDto));
        long id = editUserDto.getId();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(Long.valueOf(id));
        AssertUtil.isNotNull((Object)user, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_NO_EXIST_USER.getMessage()));
        Long employeeId = editUserDto.getEmployeeId();
        String mail = StringUtils.trimToEmpty((String)editUserDto.getMail());
        Integer maxSessions = editUserDto.getMaxSessions();
        if (HussarUtils.isNotEmpty((Object)editUserDto.getUserSecurityLevel())) {
            Integer securityLevel = Integer.valueOf(editUserDto.getUserSecurityLevel());
            user.setSecurityLevel(securityLevel);
        }
        String weChat = StringUtils.trimToEmpty((String)editUserDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)editUserDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)editUserDto.getTelephone());
        String accountProperty = StringUtils.trimToEmpty((String)editUserDto.getAccountProperty());
        boolean isLoginTimeLimit = editUserDto.getLoginTimeLimit();
        String accessLoginStartTime = StringUtils.trimToEmpty((String)editUserDto.getAccessLoginStartTime());
        String accessLoginEndTime = StringUtils.trimToEmpty((String)editUserDto.getAccessLoginEndTime());
        String startTime = StringUtils.trimToEmpty((String)editUserDto.getStartTime());
        String endTime = StringUtils.trimToEmpty((String)editUserDto.getEndTime());
        boolean isLoginIpLimit = editUserDto.getLoginIpLimit();
        SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)employeeId);
        AssertUtil.isNotNull((Object)sysStaff, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_NO_EXIST_STAFF.getMessage()));
        List sysUsers = this.sysUsersMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)employeeId)).ne(SysUsers::getAccountStatus, (Object)"2"));
        List userIds = sysUsers.stream().map(SysUsers::getId).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)sysUsers) && !userIds.contains(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_USER.getMessage()));
        }
        List usersAudits = this.sysUsersAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsersAudit::getEmployeeId, (Object)employeeId)).eq(SysUsersAudit::getIsAudit, (Object)"0")).ne(SysUsersAudit::getUserId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)usersAudits)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_USER_REVIEW.getMessage()));
        }
        user.setUserName(sysStaff.getName());
        user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(sysStaff.getName()));
        user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(sysStaff.getName()));
        user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)startTime));
        user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)endTime));
        user.seteMail(mail);
        user.setEmployeeId(employeeId);
        user.setTypeProperty(accountProperty);
        user.setTelephone(telephone);
        user.setMobile(mobile);
        user.setWeChat(weChat);
        user.setMaxSessions(maxSessions);
        user.setLoginTimeLimit(isLoginTimeLimit ? "1" : "0");
        user.setLoginIpLimit(isLoginIpLimit ? "1" : "0");
        if (isLoginTimeLimit) {
            user.setAccessLoginStartTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginStartTime));
            user.setAccessLoginEndTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginEndTime));
        }
        if (HussarUtils.isNotBlank((CharSequence)(struIds = StringUtils.trimToEmpty((String)editUserDto.getStruIds())))) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            user.setCorporationId(temp[0]);
            user.setDepartmentId(temp[0]);
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            user.setUserAccount(user.getUserAccount().toUpperCase());
        }
        if (UserStatus.TEMPORARY.getCode().equals(user.getTypeProperty())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(startTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    user.setAccountStatus(UserStatus.DORMANCY.getCode());
                    user.setLockTime(Java8DateUtils.currentLocalDateTime());
                }
            }
            catch (ParseException e) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_DATE_FORMAT_ERROR.getMessage()));
            }
        }
        return user;
    }

    private void handleRelation(EditUserDto editUserDto) {
        Long userId = editUserDto.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.saveUserPostAudit(editUserDto, userId);
            this.saveStruUserAudit(editUserDto, userId);
        } else {
            this.saveStruUser(editUserDto, userId);
            this.saveUserPost(editUserDto, userId);
        }
    }

    private void saveStruUser(EditUserDto editUserDto, Long userId) {
        String struIds = StringUtils.trimToEmpty((String)editUserDto.getStruIds());
        ArrayList<Long> struIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            struIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(struIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId));
        ArrayList<SysStruUser> struUsers = new ArrayList<SysStruUser>();
        LocalDateTime now = LocalDateTime.now();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        for (Long struId : struIdList) {
            SysStruUser struUser = new SysStruUser();
            struUser.setStruId(struId);
            struUser.setUserId(userId);
            struUser.setCreateTime(now);
            struUser.setLastTime(now);
            struUser.setCreator(securityUser.getId());
            struUser.setLastEditor(securityUser.getId());
            struUsers.add(struUser);
        }
        this.sysStruUserService.saveBatch(struUsers, struUsers.size());
    }

    private void saveUserPostAudit(EditUserDto editUserDto, Long userId) {
        SysUserPostAudit userPostAudit;
        ArrayList<SysUserPostAudit> userPostAudits = new ArrayList<SysUserPostAudit>();
        List userPostList = this.sysUserPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
        List oldMainPostIds = userPostList.stream().filter(item -> "0".equals(item.getRelateType())).map(SysUserPost::getPostId).collect(Collectors.toList());
        if (!oldMainPostIds.contains(editUserDto.getPostId())) {
            if (HussarUtils.isNotEmpty(oldMainPostIds)) {
                for (Long postId : oldMainPostIds) {
                    SysUserPostAudit userPostAudit2 = new SysUserPostAudit();
                    userPostAudit2.setPostId(postId);
                    userPostAudit2.setUserId(userId);
                    userPostAudit2.setRelateType("0");
                    userPostAudit2.setOperateType("2");
                    userPostAudit2.setAuditStatus("0");
                    userPostAudits.add(userPostAudit2);
                }
            }
            if (HussarUtils.isNotEmpty((Object)editUserDto.getPostId())) {
                SysUserPostAudit userPostAudit3 = new SysUserPostAudit();
                userPostAudit3.setPostId(editUserDto.getPostId());
                userPostAudit3.setUserId(userId);
                userPostAudit3.setRelateType("0");
                userPostAudit3.setOperateType("1");
                userPostAudit3.setAuditStatus("0");
                userPostAudits.add(userPostAudit3);
            }
        }
        String partPostIds = StringUtils.trimToEmpty((String)editUserDto.getPartPostIds());
        ArrayList<Long> newPartPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            newPartPostIdList.addAll(Arrays.asList(temp));
        }
        List oldPartPostIds = userPostList.stream().filter(item -> "1".equals(item.getRelateType())).map(SysUserPost::getPostId).collect(Collectors.toList());
        List<Object> addPartPostIds = new ArrayList();
        List<Object> delPartPostIds = new ArrayList();
        if (HussarUtils.isEmpty(oldPartPostIds) && HussarUtils.isNotEmpty(newPartPostIdList)) {
            addPartPostIds = newPartPostIdList;
        }
        if (HussarUtils.isEmpty(newPartPostIdList) && HussarUtils.isNotEmpty(oldPartPostIds)) {
            delPartPostIds = oldPartPostIds;
        }
        if (HussarUtils.isNotEmpty(newPartPostIdList) && HussarUtils.isNotEmpty(oldPartPostIds)) {
            addPartPostIds = newPartPostIdList.stream().filter(item -> !oldPartPostIds.contains(item)).collect(Collectors.toList());
            delPartPostIds = oldPartPostIds.stream().filter(item -> !newPartPostIdList.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addPartPostIds)) {
            for (Long postId : addPartPostIds) {
                userPostAudit = new SysUserPostAudit();
                userPostAudit.setPostId(postId);
                userPostAudit.setUserId(userId);
                userPostAudit.setRelateType("1");
                userPostAudit.setOperateType("1");
                userPostAudit.setAuditStatus("0");
                userPostAudits.add(userPostAudit);
            }
        }
        if (HussarUtils.isNotEmpty(delPartPostIds)) {
            for (Long postId : delPartPostIds) {
                userPostAudit = new SysUserPostAudit();
                userPostAudit.setPostId(postId);
                userPostAudit.setUserId(userId);
                userPostAudit.setRelateType("1");
                userPostAudit.setOperateType("2");
                userPostAudit.setAuditStatus("0");
                userPostAudits.add(userPostAudit);
            }
        }
        if (HussarUtils.isNotEmpty(userPostAudits)) {
            List audits = this.sysUserPostAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getAuditStatus, (Object)"0")).eq(SysUserPostAudit::getUserId, (Object)userId)).isNotNull(SysUserPostAudit::getPostId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)audits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_POST.getMessage()));
            this.sysUserPostAuditService.saveBatch(userPostAudits, userPostAudits.size());
        }
    }

    private void saveUserPost(EditUserDto editUserDto, Long userId) {
        this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
        ArrayList<SysUserPost> userPosts = new ArrayList<SysUserPost>();
        Long postId = editUserDto.getPostId();
        if (HussarUtils.isNotEmpty((Object)postId)) {
            SysUserPost userPost = new SysUserPost();
            userPost.setPostId(postId);
            userPost.setUserId(userId);
            userPost.setRelateType("0");
            userPosts.add(userPost);
        }
        String partPostIds = StringUtils.trimToEmpty((String)editUserDto.getPartPostIds());
        ArrayList<Long> partPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            partPostIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isNotEmpty(partPostIdList)) {
            for (Long partPostId : partPostIdList) {
                SysUserPost userPost = new SysUserPost();
                userPost.setPostId(partPostId);
                userPost.setUserId(userId);
                userPost.setRelateType("1");
                userPosts.add(userPost);
            }
        }
        if (HussarUtils.isNotEmpty(userPosts)) {
            this.sysUserPostService.saveBatch(userPosts, userPosts.size());
        }
    }

    private void saveStruUserAudit(EditUserDto editUserDto, Long userId) {
        SysStruUserAudit sysStruUserAudit;
        ArrayList<SysStruUserAudit> sysStruUserAudits = new ArrayList<SysStruUserAudit>();
        String struIds = StringUtils.trimToEmpty((String)editUserDto.getStruIds());
        ArrayList<Long> newStruIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            newStruIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(newStruIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        List struUserList = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List oldStruIds = struUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
        List<Object> addStruIds = new ArrayList();
        List<Object> delStruIds = new ArrayList();
        if (HussarUtils.isEmpty(oldStruIds) && HussarUtils.isNotEmpty(newStruIdList)) {
            addStruIds = newStruIdList;
        }
        if (HussarUtils.isEmpty(newStruIdList) && HussarUtils.isNotEmpty(oldStruIds)) {
            delStruIds = oldStruIds;
        }
        if (HussarUtils.isNotEmpty(newStruIdList) && HussarUtils.isNotEmpty(oldStruIds)) {
            addStruIds = newStruIdList.stream().filter(item -> !oldStruIds.contains(item)).collect(Collectors.toList());
            delStruIds = oldStruIds.stream().filter(item -> !newStruIdList.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addStruIds) || HussarUtils.isNotEmpty(delStruIds)) {
            List audits = this.sysStruUserAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getAuditStatus, (Object)"0")).eq(SysStruUserAudit::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)audits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_ORGAN.getMessage()));
        }
        if (HussarUtils.isNotEmpty(addStruIds)) {
            for (Long struId : addStruIds) {
                sysStruUserAudit = new SysStruUserAudit();
                sysStruUserAudit.setStruId(struId);
                sysStruUserAudit.setUserId(userId);
                sysStruUserAudit.setOperateType("1");
                sysStruUserAudit.setAuditStatus("0");
                sysStruUserAudits.add(sysStruUserAudit);
            }
        }
        if (HussarUtils.isNotEmpty(delStruIds)) {
            for (Long struId : delStruIds) {
                sysStruUserAudit = new SysStruUserAudit();
                sysStruUserAudit.setStruId(struId);
                sysStruUserAudit.setUserId(userId);
                sysStruUserAudit.setOperateType("2");
                sysStruUserAudit.setAuditStatus("0");
                sysStruUserAudits.add(sysStruUserAudit);
            }
        }
        if (HussarUtils.isNotEmpty(sysStruUserAudits)) {
            this.sysStruUserAuditService.saveBatch(sysStruUserAudits, sysStruUserAudits.size());
        }
    }

    private boolean compareUser(SysUsers newUser, SysUsers oldUser, String allowedIps) {
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getUserAccount()), (Object)StringUtils.trimToEmpty((String)oldUser.getUserAccount()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getMaxSessions(), (Object)oldUser.getMaxSessions())) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getSecurityLevel(), (Object)oldUser.getSecurityLevel())) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.geteMail()), (Object)StringUtils.trimToEmpty((String)oldUser.geteMail()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getWeChat()), (Object)StringUtils.trimToEmpty((String)oldUser.getWeChat()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getMobile()), (Object)StringUtils.trimToEmpty((String)oldUser.getMobile()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getTelephone()), (Object)StringUtils.trimToEmpty((String)oldUser.getTelephone()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getTypeProperty()), (Object)StringUtils.trimToEmpty((String)oldUser.getTypeProperty()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getStartTime(), (Object)oldUser.getStartTime())) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getExpiredTime(), (Object)oldUser.getExpiredTime())) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getLoginTimeLimit()), (Object)StringUtils.trimToEmpty((String)oldUser.getLoginTimeLimit()))) {
            return false;
        }
        if ("1".equals(newUser.getLoginTimeLimit())) {
            if (!HussarUtils.equals((Object)newUser.getAccessLoginStartTime(), (Object)oldUser.getAccessLoginStartTime())) {
                return false;
            }
            if (!HussarUtils.equals((Object)newUser.getAccessLoginEndTime(), (Object)oldUser.getAccessLoginEndTime())) {
                return false;
            }
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getLoginIpLimit()), (Object)StringUtils.trimToEmpty((String)oldUser.getLoginIpLimit()))) {
            return false;
        }
        if ("1".equals(newUser.getLoginIpLimit())) {
            List list = this.sysUserIpService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)newUser.getId()));
            List oldIpList = list.stream().map(SysUserIp::getUserIp).collect(Collectors.toList());
            List<String> ipList = Arrays.asList(allowedIps.split(","));
            if (!HussarUtils.equals((Object)oldIpList.size(), (Object)ipList.size())) {
                return false;
            }
            List delIps = oldIpList.stream().filter(item -> !ipList.contains(item)).collect(Collectors.toList());
            return !HussarUtils.isNotEmpty(delIps);
        }
        return oldUser.getEmployeeId().equals(newUser.getEmployeeId());
    }

    private void checkRelation(EditUserDto editUserDto) {
        Long[] struIdArray = (Long[])ConvertUtils.convert((String[])editUserDto.getStruIds().split(","), Long.class);
        List<Long> struIds = Arrays.asList(struIdArray);
        ArrayList<Long> postIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)editUserDto.getPartPostIds())) {
            Long[] postIdArray = (Long[])ConvertUtils.convert((String[])editUserDto.getPartPostIds().split(","), Long.class);
            postIds.addAll(Arrays.asList(postIdArray));
        }
        postIds.add(editUserDto.getPostId());
        List posts = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPost::getId, postIds)).isNotNull(SysPost::getOrganTypeCode)).ne(SysPost::getOrganTypeCode, (Object)""));
        if (HussarUtils.isNotEmpty((Object)posts)) {
            List postIdList = posts.stream().map(SysPost::getId).collect(Collectors.toList());
            List struPosts = this.sysStruPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, struIds)).in(SysStruPost::getPostId, postIdList));
            Map<Long, List<SysStruPost>> postMap = struPosts.stream().collect(Collectors.groupingBy(SysStruPost::getPostId));
            if (!HussarUtils.equals((Object)posts.size(), (Object)postMap.size())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EDIT_FAIL_EXIST_RELATE_USER_ORGAN_POST.getMessage()));
            }
        }
    }

    private void editUserSignPic(EditUserDto editUserDto, Long userId) {
        SysUserAttachment sysUserAttachment = new SysUserAttachment();
        Integer fileType = null;
        if (ToolUtil.isNotEmpty((Object)editUserDto.getUserSignImgBase64())) {
            fileType = UserAttachmentFileTypeEnum.ATTACHMENT_BASE64.getValue();
        }
        if (ToolUtil.isNotEmpty((Object)editUserDto.getUserSignFileId())) {
            fileType = UserAttachmentFileTypeEnum.ATTACHMENT_FILE.getValue();
        }
        sysUserAttachment.setFileType(fileType);
        sysUserAttachment.setBusiType(Integer.valueOf(UserAttachmentBusiTypeEnum.USER_SIGN.getValue()));
        sysUserAttachment.setImgBase64(editUserDto.getUserSignImgBase64());
        sysUserAttachment.setFileId(editUserDto.getUserSignFileId());
        sysUserAttachment.setUserId(userId);
        this.userAttachmentService.updateUserSignInfo(sysUserAttachment);
    }
}

