/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.adapter.organ.IHussarBaseOrganizationAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryAssistPostDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.StaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.SortStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.TransferStaffManager;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleStaffVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffListVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseStaffServiceImpl")
public class HussarBaseStaffServiceImpl
implements IHussarBaseStaffService {
    @Resource
    private AddStaffManager addStaffManager;
    @Autowired
    private EditStaffManager editStaffManager;
    @Autowired
    private QueryStaffManager queryStaffManager;
    @Autowired
    private DeleteStaffManager deleteStaffManager;
    @Autowired
    private SortStaffManager sortStaffManager;
    @Autowired
    private TransferStaffManager transferStaffManager;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    private IHussarBaseOrganizationAdapter hussarBaseOrganizationAdapter;

    public ApiResponse<List<StaffTreeVo>> lazyLoadingStaffTree(Long parentId) {
        return ApiResponse.success(this.queryStaffManager.lazyLoadingStaffTree(parentId));
    }

    public ApiResponse<Page<StaffListVo>> queryStaff(PageInfo pageInfo, QueryStaffDto queryStaffDto) {
        return ApiResponse.success(this.queryStaffManager.queryStaff(pageInfo, queryStaffDto));
    }

    public ApiResponse<List<StaffTreeVo>> getOrderStaffTree(Long parentId) {
        return ApiResponse.success(this.queryStaffManager.getOrderStaffTree(parentId));
    }

    public ApiResponse<List<StaffTreeVo>> backStaffTree(Long id) {
        return ApiResponse.success(this.queryStaffManager.backStaffTree(id));
    }

    @HussarTransactional
    public ApiResponse<Long> addStaff(AddStaffDto addStaffDto) {
        return this.addStaffManager.addStaff(addStaffDto);
    }

    public ApiResponse<StaffPartialVo> viewStaff(Long id) {
        return ApiResponse.success((Object)this.queryStaffManager.viewStaff(id));
    }

    public ApiResponse<StaffInfoVo> loadStaff(Long id) {
        return ApiResponse.success((Object)this.queryStaffManager.loadStaff(id));
    }

    @HussarTransactional
    public ApiResponse<String> deleteStaff(Long id) {
        return ApiResponse.success((String)this.deleteStaffManager.deleteStaff(id));
    }

    @HussarTransactional
    public ApiResponse<String> editStaff(EditStaffDto editStaffDto) {
        return ApiResponse.success((String)this.editStaffManager.editStaff(editStaffDto));
    }

    @HussarTransactional
    public ApiResponse<String> sortStaff(List<Long> idList) {
        return ApiResponse.success((String)this.sortStaffManager.sortStaff(idList));
    }

    @HussarTransactional
    public ApiResponse<String> transferStaff(TransferStaffDto transferStaffDto) {
        return ApiResponse.success((String)this.transferStaffManager.transferStaff(transferStaffDto));
    }

    public ApiResponse<Page<OrganizationVo>> loadAssistPostByStaffId(PageInfo pageInfo, QueryAssistPostDto queryAssistPostDto) {
        return ApiResponse.success(this.queryStaffManager.loadAssistPostByStaffId(pageInfo, queryAssistPostDto));
    }

    public ApiResponse<List<StaffTreeVo>> selectStaffTree(Long parentId) {
        return ApiResponse.success(this.queryStaffManager.selectStaffTree(parentId));
    }

    public ApiResponse<List<OrganTreeInitVo>> getStaffsByParentId(Long parentId) {
        String fid = "";
        if (!parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            fid = this.sysStruMapper.getStruFidByOrganId(parentId);
        }
        List<OrganTreeInitVo> staffs = this.sysStruMapper.queryStaffsByParentId(fid);
        return ApiResponse.success(staffs);
    }

    public ApiResponse<Page<SimpleStaffVo>> unRelateUserStaffList(PageInfo pageInfo, Long organId, String staffName, Long userId) {
        return ApiResponse.success(this.queryStaffManager.unRelateUserStaffList(pageInfo, organId, staffName, userId));
    }

    public ApiResponse<Page<StaffVo>> list(PageInfo pageInfo, Long organId, String staffName, String staffCode) {
        return ApiResponse.success(this.queryStaffManager.list(pageInfo, organId, staffName, staffCode));
    }

    @HussarTransactional
    public ApiResponse<String> add(StaffDto staffDto) {
        return ApiResponse.success((String)this.addStaffManager.add(staffDto));
    }

    @HussarTransactional
    public ApiResponse<String> edit(StaffDto staffDto) {
        return ApiResponse.success((String)this.editStaffManager.edit(staffDto));
    }

    @HussarTransactional
    public ApiResponse<String> delete(Long staffId) {
        return ApiResponse.success((String)this.deleteStaffManager.delete(staffId));
    }

    public ApiResponse<StaffVo> detail(Long staffId) {
        return ApiResponse.success((Object)this.queryStaffManager.detail(staffId));
    }

    public List<SimpleOrganVo> getSimpleOrgan(List<Long> struId) {
        return this.hussarBaseOrganizationAdapter.getSimpleOrgan(struId);
    }

    public List<SimpleStaffVo> getByStaffId(List<Long> staffIds) {
        return this.queryStaffManager.getByStaffId(staffIds);
    }

    public ApiResponse<Page<StaffVo>> organDataAuthorityStaff(PageInfo pageInfo, String staffName, String workId) {
        return ApiResponse.success(this.queryStaffManager.organDataAuthorityStaff(pageInfo, staffName, workId));
    }

    public ApiResponse<SimpleOrganVo> getOrderUnifyStaffTree(Long struId) {
        return ApiResponse.success((Object)this.queryStaffManager.getOrderUnifyStaffTree(struId));
    }

    public ApiResponse<String> sortUnifyStaff(List<Long> idList) {
        return ApiResponse.success((String)this.sortStaffManager.sortUnifyStaff(idList));
    }

    public List<OrganTreeInitVo> getStaffTreeInitVos(Long parentId, int ifLazy, Integer defaultLevel) {
        if (ifLazy != 0 && ifLazy != 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTER_TRUE_LAZY_PARAM.getMessage()));
        }
        int defaultLevelNum = 1;
        if (defaultLevel != null && defaultLevel > 0) {
            defaultLevelNum = defaultLevel;
        }
        if (ifLazy == 0) {
            defaultLevelNum = 0;
        }
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getOrgansByParentIdAndLevel(parentId, defaultLevelNum, true, false);
        ArrayList<Long> organIds = new ArrayList<Long>();
        for (OrganTreeInitVo organ : organs) {
            if (defaultLevelNum != 0) {
                int level = organ.getChangedLevel();
                if (level >= defaultLevelNum) continue;
                organIds.add((Long)organ.getId());
                continue;
            }
            organIds.add((Long)organ.getId());
        }
        List<Object> staffs = new ArrayList();
        if (organIds.size() != 0) {
            staffs = this.queryStaffManager.getStaffsByOrganIdS(organIds);
        }
        if (parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            OrganTreeInitVo firstOrgan = this.sysStruMapper.queryOrganInfoById(OrganConstants.ROOT_ORGAN_ID);
            organs.add(firstOrgan);
        }
        organs.addAll(staffs);
        List<OrganTreeInitVo> organTree = this.queryOrganizationManager.getOrganTree(organs);
        return organTree;
    }

    public List<OrganTreeInitVo> getChildrenStaffAndOrgan(Long parentId) {
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getChildrenOrgan(parentId, true, false);
        List<OrganTreeInitVo> staffs = this.queryStaffManager.getChildrenStaffsByParentId(parentId);
        organs.addAll(staffs);
        return organs;
    }

    public List<OrganTreeInitVo> getStaffsLikeName(String searchValue) {
        List<OrganTreeInitVo> staffs = this.queryStaffManager.getStaffsLikeName(searchValue);
        return staffs;
    }

    public List<OrganTreeInitVo> getUpStaffTreeByOrganId(Long staffId, Long parentId) {
        Integer defaultLevel = 0;
        Integer parentLevel = 0;
        if (!staffId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            parentLevel = this.queryOrganizationManager.getOrganLevelByOrganId(parentId);
            if (parentLevel != null) {
                defaultLevel = parentLevel + 1;
            } else {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTER_TRUE_PARAM.getMessage()));
            }
        }
        List<OrganTreeInitVo> parentLevelOrganStaffList = this.sysStruMapper.queryUpOrgansByFidAndLevelForStaffTree("", defaultLevel, true, false);
        for (OrganTreeInitVo organ : parentLevelOrganStaffList) {
            organ.setChangedLevel(organ.getStruLevel() + 1);
        }
        OrganTreeInitVo firstOrgan = this.sysStruMapper.queryOrganInfoById(OrganConstants.ROOT_ORGAN_ID);
        parentLevelOrganStaffList.add(firstOrgan);
        List<OrganTreeInitVo> staffs = this.queryStaffManager.queryUpStaffsByFidAndLevel("", parentLevel);
        parentLevelOrganStaffList.addAll(staffs);
        List<OrganTreeInitVo> brotherStaffs = this.queryStaffManager.queryBrotherStaffsByParentId(parentId);
        List<OrganTreeInitVo> brotherOrgans = this.sysStruMapper.queryBrotherOrganForUserTree(parentId, true, false);
        ArrayList<OrganTreeInitVo> organsAndStaffs = new ArrayList<OrganTreeInitVo>();
        organsAndStaffs.addAll(parentLevelOrganStaffList);
        organsAndStaffs.addAll(brotherOrgans);
        organsAndStaffs.addAll(brotherStaffs);
        return this.queryOrganizationManager.getOrganTree(organsAndStaffs);
    }

    public OrganTreeInitVo getStaffInfoById(Long staffId) {
        List<OrganTreeInitVo> staffs = this.queryStaffManager.getStaffInfoByStaffId(staffId);
        if (HussarUtils.isEmpty(staffs)) {
            return null;
        }
        OrganTreeInitVo staff = staffs.get(0);
        String firstFId = staff.getStruFid();
        String firstFName = staff.getParentName();
        for (int i = 1; i < staffs.size(); ++i) {
            String fId = staffs.get(i).getStruFid();
            String fName = staffs.get(i).getParentName();
            firstFId = firstFId + "," + fId;
            firstFName = firstFName + "," + fName;
        }
        staff.setStruFid(firstFId);
        staff.setParentName(firstFName);
        return staff;
    }
}

