/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.service.impl;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsideStruPostDto;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsideUserPostDto;
import com.jxdinfo.hussar.authorization.post.dto.EditOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.manager.AddBatchOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.manager.AddOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.manager.DeleteBatchOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.manager.DeleteOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.manager.EditBatchOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.manager.EditOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.service.IHussarBaseSyncPostService;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.post.service.impl.hussarBaseSyncPostServiceImpl")
public class HussarBaseSyncPostServiceImpl
implements IHussarBaseSyncPostService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseSyncPostServiceImpl.class);
    private static final String CACHE = "hussarOrganizationJob";
    @Autowired
    private AddOutsidePostManager addOutsidePostManager;
    @Autowired
    private AddBatchOutsidePostManager addBatchOutsidePostManager;
    @Autowired
    private EditOutsidePostManager editOutsidePostManager;
    @Autowired
    private EditBatchOutsidePostManager editBatchOutsidePostManager;
    @Autowired
    private DeleteOutsidePostManager deleteOutsidePostManager;
    @Autowired
    private DeleteBatchOutsidePostManager deleteBatchOutsidePostManager;

    @HussarTransactional
    public synchronized R<AddOutsidePostDto> addPost(AddOutsidePostDto addOutsidePostDto) {
        R<AddOutsidePostDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsidePostManager.addPost(addOutsidePostDto);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_POST_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsidePostDto> editPost(EditOutsidePostDto editOutsidePostDto) {
        R<EditOutsidePostDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editOutsidePostManager.editPost(editOutsidePostDto);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MODIFY_POST_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deletePost(String postCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsidePostManager.deletePost(postCode);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DEL_POST_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<AddOutsidePostDto> addBatchPosts(List<AddOutsidePostDto> posts) {
        R<AddOutsidePostDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addBatchOutsidePostManager.addBatchPosts(posts);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_ADD_POST_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsidePostDto> editBatchPosts(List<EditOutsidePostDto> posts) {
        R<EditOutsidePostDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editBatchOutsidePostManager.editBatchPosts(posts);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_MODIFY_POST_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchPosts(List<String> postCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_POST_LOCKED.getMessage()));
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_POST_LOCKED.getMessage()));
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsidePostManager.deleteBatchPosts(postCodes);
        }
        catch (BaseException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_BATCH_DEL_POST_ERROR.getMessage()) + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public Boolean saveStruPost(AddOutsideStruPostDto struPostDto) {
        return this.addOutsidePostManager.saveStruPost(struPostDto);
    }

    @HussarTransactional
    public Boolean saveUserPost(AddOutsideUserPostDto userPostDto) {
        return this.addOutsidePostManager.saveUserPost(userPostDto);
    }
}

