/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserDataScopeMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserDataScope;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserDataScopeService;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysUserDataScopeServiceImpl
extends ServiceImpl<SysUserDataScopeMapper, SysUserDataScope>
implements ISysUserDataScopeService {
    @Resource
    private SysUserDataScopeMapper sysUserDataScopeMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;

    public List<Long> getOrgListByUserId(String userId) {
        return this.sysUserDataScopeMapper.getOrgListByUserId(userId);
    }

    @HussarTransactional
    public ApiResponse saveDataScope(DataScopeVo userDataScopeVo) {
        boolean flag;
        if (ToolUtil.isEmpty((Object)userDataScopeVo)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_PERMISSIONS_EMPTY.getMessage()));
        }
        Long userId = userDataScopeVo.getUserId();
        List orgIds = userDataScopeVo.getOrgIds();
        String type = userDataScopeVo.getType();
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserDataScope::getUserId, (Object)userId));
        if ("5".equals(type)) {
            if (ToolUtil.isNotEmpty((Object)orgIds)) {
                ArrayList<SysUserDataScope> list = new ArrayList<SysUserDataScope>();
                for (Long id : orgIds) {
                    SysUserDataScope sysUserDataScope = new SysUserDataScope();
                    sysUserDataScope.setUserId(userId);
                    sysUserDataScope.setOrgId(id);
                    list.add(sysUserDataScope);
                }
                this.saveBatch(list);
            } else {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
            }
        }
        if (flag = SqlHelper.retBool((Integer)this.sysUsersMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getDataScopeType, (Object)type)).eq(SysUsers::getId, (Object)userId)))) {
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
    }

    public DataScopeVo queryUserDataScope(String userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_EMPTY.getMessage()));
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById((Serializable)((Object)userId));
        DataScopeVo userDataScopeVo = new DataScopeVo();
        String dataScopeType = ToolUtil.isNotEmpty((Object)sysUsers.getDataScopeType()) ? sysUsers.getDataScopeType() : "";
        userDataScopeVo.setType(dataScopeType);
        List<Long> orgIds = this.getOrgListByUserId(userId);
        userDataScopeVo.setOrgIds(orgIds);
        userDataScopeVo.setUserId(Long.valueOf(userId));
        return userDataScopeVo;
    }
}

