/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.adapter.role.IHussarBaseRoleAdapter;
import com.jxdinfo.hussar.authorization.adapter.user.IHussarBaseUserBoAdapter;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleFuncDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleResDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.SysRolesDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataScopeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.impl.RoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.vo.RoleGroupVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.RoleUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRoleAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleFunctionChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleGroupChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.rolemanager.RoleResourceChangeNotify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRolesServiceImpl
extends HussarBaseServiceImpl<SysRolesMapper, SysRoles>
implements ISysRolesService {
    private Logger logger = LoggerFactory.getLogger(SysRolesServiceImpl.class);
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysUserroleAuditMapper auditMapper;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private IGlobalService globalservice;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private ISysRoleDataScopeService roleDataScopeService;
    @Resource
    @Lazy
    private ISysConfRolesService isConfRolesService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Resource
    private QueryDataRightManager queryDataRightManager;
    @Autowired
    private ISysResManageService sysResManageService;
    @Resource
    private ISysStruRoleAuditService sysStruRoleAuditService;
    @Resource
    private ISysPostRoleAuditService sysPostRoleAuditService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysPostRoleService sysPostRoleService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private IHussarBaseRoleAdapter hussarBaseRoleAdapter;
    @Resource
    private RoleChangeNotify roleChangeNotify;
    @Resource
    private RoleGroupChangeNotify roleGroupChangeNotify;
    @Resource
    private RoleResourceChangeNotify roleResourceChangeNotify;
    @Resource
    private RoleFunctionChangeNotify roleFunctionChangeNotify;
    @Resource
    private RoleUserAuthorizationChangeReporter userAuthorizationChangeReporter;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    IHussarBaseUserBoAdapter hussarBaseUserBoAdapter;

    public List<SysRoles> listByIds(Collection<? extends Serializable> idList) {
        return this.hussarBaseRoleAdapter.listByIds(idList);
    }

    @HussarTransactional
    public Long saveRole(SysRolesDto sysRolesDto) {
        if (ToolUtil.isEmpty((Object)sysRolesDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_INFO_EMPTY.getMessage()));
        }
        try {
            this.validateParam(sysRolesDto, "roleAdd");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        SysRoles sysRoles = new SysRoles();
        BeanUtils.copyProperties((Object)sysRolesDto, (Object)sysRoles);
        Long checkNodeId = sysRolesDto.getGroupId();
        boolean isOrganRoleAdd = false;
        if (currentUser.isGradeadmin() && "organRoleAdd".equals(sysRolesDto.getRoleType())) {
            isOrganRoleAdd = true;
        }
        sysRoles.setId(null);
        sysRoles.setIsSys("0");
        if (isOrganRoleAdd) {
            sysRoles.setCorporationId(checkNodeId);
            sysRoles.setGroupId(null);
        } else {
            sysRoles.setCorporationId(Long.valueOf(0L));
            sysRoles.setGroupId(checkNodeId);
        }
        this.sysRolesMapper.insert(sysRoles);
        if (HussarUtils.isNotEmpty((Object)sysRoles.getAppId()) && sysRoles.getAppId() != 1L) {
            this.roleChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysRoles});
        }
        this.bpmAbstractPushMsgMatcher.pushRole("add", sysRoles, null);
        return sysRoles.getId();
    }

    @HussarTransactional
    public void updateRole(SysRoles sysRoles) {
        int num;
        if (ToolUtil.isEmpty((Object)sysRoles)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_INFO_EMPTY.getMessage()));
        }
        if (!BaseSecurityUtil.isGradeadmin()) {
            try {
                this.validateParam(sysRoles, "roleEdit");
            }
            catch (BaseException e) {
                throw new BaseException(e.getMessage());
            }
        }
        if ((num = this.sysRolesMapper.updateById(sysRoles)) == 0) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
        }
        SysRoles role = (SysRoles)this.sysRolesMapper.selectById(sysRoles.getId());
        sysRoles.setAppId(role.getAppId());
        if (HussarUtils.isNotEmpty((Object)sysRoles.getAppId()) && sysRoles.getAppId() != 1L) {
            this.roleChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysRoles});
        }
        this.bpmAbstractPushMsgMatcher.pushRole("update", sysRoles, null);
        List<Long> userIds = this.delCacheAuthInfo(sysRoles.getId());
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
    }

    public RoleInfoVO getRoleViewMap(Long id) {
        SysRoleGroup group;
        HashMap map = new HashMap();
        SysRoles role = (SysRoles)this.sysRolesMapper.selectById(id);
        RoleInfoVO roleInfoVO = new RoleInfoVO();
        BeanUtils.copyProperties((Object)role, (Object)roleInfoVO);
        Long groupId = role.getGroupId();
        if (groupId != null && (group = (SysRoleGroup)this.sysRoleGroupMapper.selectById(groupId)) != null) {
            roleInfoVO.setGroupName(group.getGroupName());
        }
        return roleInfoVO;
    }

    public RoleInfoVO getRoleViewMap(String id) {
        return this.getRoleViewMap(Long.parseLong(id));
    }

    public List<SysRoleResource> getRoleResource(String id) {
        String[] idStr = id == null ? "".split(",") : id.split(",");
        Long[] idStrl = new Long[idStr.length];
        for (int i = 0; i < idStr.length; ++i) {
            idStrl[i] = Long.parseLong(idStr[i]);
        }
        return this.sysRoleResourceMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleResource::getRoleId, Arrays.asList(idStrl)));
    }

    @HussarTransactional
    public ApiResponse deleteRole(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ID_EMPTY.getMessage()));
        }
        this.judgeWhetherItCanBeDelete(id);
        SysRoles role = (SysRoles)this.getById(id);
        boolean flag = this.removeById(id);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        this.sysRoleResourceMapper.deleteById(id);
        LambdaQueryWrapper roleFuncQueryWrapper = new LambdaQueryWrapper();
        roleFuncQueryWrapper.eq(SysRoleFunctions::getRoleId, (Object)id);
        this.sysRoleFunctionsService.remove((Wrapper)roleFuncQueryWrapper);
        this.auditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)id));
        List userVos = null;
        if (HussarUtils.isEmpty((Object)role.getAppId()) || role.getAppId() == 1L) {
            userVos = this.hussarBaseUserBoAdapter.getUserInfoByRoleId(Collections.singletonList(id));
        }
        this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getGrantedRole, (Object)id));
        this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRole::getRoleId, (Object)id));
        this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)id));
        this.sysStruRoleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruRoleAudit::getRoleId, (Object)id));
        this.sysPostRoleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysPostRoleAudit::getRoleId, (Object)id));
        this.bpmAbstractPushMsgMatcher.delete("role", id, null);
        this.bpmAbstractPushMsgMatcher.delete("userRole", id, "deleteByRoleId");
        if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
            this.roleChangeNotify.notify(DataChangeType.DELETE, new Object[]{role});
        }
        if (HussarUtils.isNotEmpty((Object)userVos)) {
            List userIds = userVos.stream().map(UserVo::getId).distinct().collect(Collectors.toList());
            this.userAuthorizationChangeReporter.report(new Object[]{"user", userIds});
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    public List<Long> delCacheAuthInfo(Long roleId) {
        return this.sysRolesMapper.getUserIdByRoleId(roleId);
    }

    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public void delAuthCacheInfo(Long userId) {
        HussarCacheUtil.evict((String)"menu_info", (Object)("hussar_menus:" + userId));
    }

    public List<JSTreeModel> getRoleTree() {
        return this.sysRoleGroupMapper.getRoleTree();
    }

    public List<JSTreeModel> getRoleTreeWithApp(Long appId, String isSys) {
        return this.sysRoleGroupMapper.getRoleTreeWithApp(appId, isSys);
    }

    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        List<JSTreeModel> jsTreeModels;
        if (ToolUtil.isEmpty((Object)nodeId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NODE_ID_EMPTY.getMessage()));
        }
        if (nodeId.equals(Constants.ROOT_NODE_PARENT)) {
            jsTreeModels = this.sysRoleGroupMapper.getFirstRoleTree();
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
            jsTreeModel.setId(Constants.ROLE_ROOT_ID);
            jsTreeModel.setType("isRoot");
            jsTreeModels.add(jsTreeModel);
        } else {
            jsTreeModels = this.sysRoleGroupMapper.getLazyRoleTree(nodeId);
        }
        return jsTreeModels;
    }

    public List<JSTreeModel> getRoleGroupTree(Long appId) {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        boolean hasUnifyApp = HussarUtils.isNotEmpty((Object)application);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        ArrayList jsTreeModels = Lists.newArrayList();
        JSTreeModel root = new JSTreeModel();
        root.setCode("GROUP");
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
        root.setType("isRoot");
        jsTreeModels.add(root);
        ArrayList<Long> appIds = new ArrayList();
        List<Object> allGroup = new ArrayList();
        if (HussarUtils.isEmpty((Object)appId)) {
            if (hasUnifyApp) {
                root.setParent(Constants.ROOT_NODE_PARENT);
                root.setId(Constants.ROOT_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(false));
                List applicationVos = this.sysApplicationService.getUserApplications(securityUser.getId());
                if (HussarUtils.isNotEmpty((Object)applicationVos)) {
                    appIds = applicationVos.stream().map(SysApplication::getId).distinct().collect(Collectors.toList());
                }
                if (HussarUtils.isEmpty(appIds)) {
                    return jsTreeModels;
                }
                List appList = this.sysResManageService.getAppTree("roleGroup", appIds);
                jsTreeModels.addAll(appList);
                allGroup = this.sysRoleGroupMapper.getUnifyRoleGroupTree(appIds);
            } else {
                appId = 1L;
                root.setId(Constants.RES_NODE_ID);
                root.setCanAddModule(Boolean.valueOf(true));
                allGroup = this.sysRoleGroupMapper.getRoleGroupTree(appId);
            }
        } else {
            root.setId(Constants.RES_NODE_ID);
            allGroup = this.sysRoleGroupMapper.getRoleGroupTree(appId);
        }
        jsTreeModels.addAll(allGroup);
        return TreeModelUtils.merge((List)jsTreeModels);
    }

    public List<JSTreeModel> getGroupOrderTree(Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List<JSTreeModel> result = this.sysRoleGroupMapper.getGroupOrderTree(appId);
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
        jsTreeModel.setId(Constants.RES_NODE_ID);
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getRoleOrderTree(Long parent) {
        List<Object> result = new ArrayList();
        if (BaseSecurityUtil.getUser().isGradeadmin()) {
            List<JSTreeModel> result1 = this.getLazyOrganRoleTree(parent, false, true);
            Long parentId = parent;
            for (JSTreeModel jsTreeModel : result1) {
                String type = jsTreeModel.getType();
                if (!"ORGANROLE".equals(type)) continue;
                result.add(jsTreeModel);
                parentId = jsTreeModel.getParent();
            }
            JSTreeModel root = new JSTreeModel();
            root.setId(parentId);
            root.setCode("ORGANROLEROOT");
            root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_ROLE_TREE.getMessage()));
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setType("ORGANROLEROOT");
            result.add(root);
        } else {
            String isSys = "";
            SysBaseConfig sysBaseConfig = this.baseConfigService.getSysBaseConfig("protection_status");
            if (HussarUtils.isNotEmpty((Object)sysBaseConfig) && "3".equals(sysBaseConfig.getConfigValue())) {
                isSys = "0";
            }
            result = this.sysRoleGroupMapper.getRoleOrderTree(parent, isSys);
            JSTreeModel root = new JSTreeModel();
            SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById(parent);
            if (ToolUtil.isNotEmpty((Object)group)) {
                root.setParent(Constants.ROOT_NODE_PARENT);
                root.setCode("GROUP");
                root.setText(group.getGroupName());
                root.setId(group.getId());
                root.setType("GROUP");
            } else {
                root.setParent(Constants.ROOT_NODE_PARENT);
                root.setCode("GROUP");
                root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
                root.setId(Constants.RES_NODE_ID);
                root.setType("isRoot");
            }
            result.add(root);
        }
        return TreeModelUtils.merge(result);
    }

    @HussarTransactional
    public boolean updateGroupOrder(List<Long> idList) {
        ArrayList<SysRoleGroup> list = new ArrayList<SysRoleGroup>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysRoleGroup group = new SysRoleGroup();
            group.setId(id);
            group.setGroupOrder(Integer.valueOf(i + 1));
            list.add(group);
        }
        this.bpmAbstractPushMsgMatcher.pushRoleSort(list, null);
        return ToolUtil.isNotEmpty(list) && this.sysRoleGroupService.updateBatchById(list, list.size());
    }

    @HussarTransactional
    public boolean updateRoleOrder(List<Long> idList) {
        ArrayList<SysRoles> list = new ArrayList<SysRoles>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysRoles role = new SysRoles();
            role.setId(id);
            role.setRoleOrder(Integer.valueOf(i + 1));
            list.add(role);
        }
        this.bpmAbstractPushMsgMatcher.pushRoleSort(null, list);
        return ToolUtil.isNotEmpty(list) && super.updateBatchById(list, list.size());
    }

    @HussarTransactional
    public ApiResponse saveGroup(SysRoleGroup sysRoleGroup) {
        if (ToolUtil.isEmpty((Object)sysRoleGroup)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_GROUP_RULE_EMPTY.getMessage()));
        }
        try {
            this.validateParam(sysRoleGroup, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        int groupOrder = this.sysRoleGroupMapper.getMaxOrder() + 1;
        sysRoleGroup.setGroupOrder(Integer.valueOf(groupOrder));
        int count = this.sysRoleGroupMapper.insert(sysRoleGroup);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.pushRole("add", null, sysRoleGroup);
            if (HussarUtils.isNotEmpty((Object)sysRoleGroup.getAppId()) && sysRoleGroup.getAppId() != 1L) {
                this.roleGroupChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysRoleGroup});
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
    }

    @HussarTransactional
    public ApiResponse updateGroup(SysRoleGroup sysRoleGroup) {
        if (ToolUtil.isEmpty((Object)sysRoleGroup)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_GROUP_RULE_EMPTY.getMessage()));
        }
        int count = this.sysRoleGroupMapper.updateById(sysRoleGroup);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.pushRole("update", null, sysRoleGroup);
            SysRoleGroup roleGroup = (SysRoleGroup)this.sysRoleGroupMapper.selectById(sysRoleGroup.getId());
            if (HussarUtils.isNotEmpty((Object)roleGroup.getAppId()) && roleGroup.getAppId() != 1L) {
                sysRoleGroup.setAppId(roleGroup.getAppId());
                this.roleGroupChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysRoleGroup});
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
    }

    public ApiResponse deleteGroup(Long groupId) {
        SysRoleGroup roleGroup = (SysRoleGroup)this.sysRoleGroupMapper.selectById(groupId);
        int count = this.sysRoleGroupMapper.deleteById(groupId);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.delete("role", groupId, null);
            if (HussarUtils.isNotEmpty((Object)roleGroup.getAppId()) && roleGroup.getAppId() != 1L) {
                this.roleGroupChangeNotify.notify(DataChangeType.DELETE, new Object[]{roleGroup});
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
    }

    public List<JSTreeModel> getLazyOrganRoleTree(Long nodeId, boolean isExport, boolean isLazy) {
        Long parentId = nodeId;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long empolyeeId = securityUser.getEmployeeId();
        int userLevel = 0;
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            userLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_ROLE_TREE.getMessage()));
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("isOrganRoleTree", true);
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List<Object> list = new ArrayList();
        List list1 = new ArrayList();
        if (this.globalservice.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
                parentId = Constants.ROOT_NODE_ID;
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.geOrganRoleTree(parentId);
        } else {
            result.add(jsTreeModel);
        }
        if (isGradeAdmin) {
            if (isLazy) {
                list = this.sysOrgManageService.getGradeStruTree(list1, userLevel);
                for (JSTreeModel treeModel : list) {
                    treeModel.getState().put("isOrganRoleTree", true);
                }
            } else {
                List<JSTreeModel> organRoleList = this.getGradeAdminOrganRoleTree();
                for (JSTreeModel treeModel : organRoleList) {
                    treeModel.getState().put("isOrganRoleTree", true);
                }
                list = organRoleList;
            }
        } else {
            list = list1;
        }
        result.addAll(list);
        if (isExport) {
            for (JSTreeModel model : result) {
                String type = model.getType();
                if ("ORGANROLE".equals(type)) {
                    model.setState(false, false, false);
                    continue;
                }
                model.setState(false, false, true);
            }
        }
        return result;
    }

    public void exportData(List<String> idList, HttpServletResponse response) {
        List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List roleGroups = this.sysRoleGroupMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleGroup::getId, cdids));
        List roles = this.sysRolesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, cdids));
        List roleResources = this.sysRoleResourceMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getRoleId, cdids));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("roleGroups", roleGroups);
        data.put("roles", roles);
        data.put("roleResources", roleResources);
        data.put("export_type", "role");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SERIALIZATION_ERROR.getMessage()));
        }
        String fileName = "role_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @HussarTransactional
    public Map<String, String> importVueData(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DESERIALIZATION_ERROR.getMessage()), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_IMPORT_FAILED_PLATFORM.getMessage()));
        }
        String export_type = (String)data.get("export_type");
        if (!"role".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "role");
            return map;
        }
        List roleGroups = (List)data.get("roleGroups");
        List roles = (List)data.get("roles");
        List roleResources = (List)data.get("roleResources");
        Map<String, Integer> roleGroupsCount = this.insertOrUpdateList(roleGroups);
        Map<String, Integer> rolesCount = this.insertOrUpdateList(roles);
        Map<String, Integer> roleResourcesCount = this.insertOrUpdateList(roleResources);
        map.put("success", "true");
        map.put("insertGroups", "" + roleGroupsCount.get("insert"));
        map.put("updateGroups", "" + roleGroupsCount.get("update"));
        map.put("insertRoles", "" + rolesCount.get("insert"));
        map.put("updateRoles", "" + rolesCount.get("update"));
        map.put("insertRoleResources", "" + roleResourcesCount.get("insert"));
        map.put("updateRoleResources", "" + roleResourcesCount.get("update"));
        return map;
    }

    public List<JSTreeModel> getGradeAdminOrganRoleTree() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long empolyeeId = securityUser.getEmployeeId();
        ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
        Long organId = empolyeeId;
        JSTreeModel organ = new JSTreeModel();
        List childSysStruIdList = this.sysStruService.getChildOrgId(securityUser.getDeptId(), "01");
        List<JSTreeModel> roleLists = new ArrayList<JSTreeModel>();
        childSysStruIdList.add(securityUser.getDeptId());
        for (Long id : childSysStruIdList) {
            if (!id.equals(securityUser.getDeptId())) {
                organ = this.sysOrgManageService.getThisOneOrg(id);
                list.add(organ);
            }
            List<JSTreeModel> roleList = this.sysStruMapper.getRoleTree(id);
            if (ToolUtil.isEmpty(roleLists)) {
                roleLists = roleList;
                continue;
            }
            roleLists.addAll(roleList);
        }
        while (ToolUtil.isNotEmpty((Object)organ)) {
            organ = this.sysOrgManageService.getOneOrg(organId);
            if (!ToolUtil.isNotEmpty((Object)organ)) continue;
            organId = organ.getId();
            list.add(organ);
        }
        ArrayList<JSTreeModel> lists = list;
        list = roleLists;
        list.addAll(lists);
        return list;
    }

    public List<JSTreeModel> getRoleTree(RoleTreeDto roleTreeDto) {
        Long nodeId = roleTreeDto.getNodeId();
        Long userId = roleTreeDto.getUserId();
        String functionType = roleTreeDto.getFunctionType();
        Long appId = roleTreeDto.getApplicationId();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        Object result = new ArrayList();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            List<JSTreeModel> gradeAdminStruList = this.getLazyOrganRoleTree(nodeId, false, false);
            List<Object> rolesList = new ArrayList();
            if (userId != null) {
                rolesList = this.sysUserRoleMapper.getRolesByUserId(userId);
            }
            if ("view".equals(functionType)) {
                ArrayList roleResult = new ArrayList();
                for (JSTreeModel iterator : gradeAdminStruList) {
                    String type = iterator.getType();
                    if ("ORGANROLE".equals(type)) {
                        Long roleId = iterator.getId();
                        if (rolesList.contains(roleId)) {
                            iterator.setState(true, true, true);
                            result.add(iterator);
                            roleResult.add(iterator);
                            continue;
                        }
                        iterator.setState(false, false, true);
                        continue;
                    }
                    iterator.setState(false, false, true);
                    result.add(iterator);
                }
                HashSet<JSTreeModel> delResult = new HashSet<JSTreeModel>();
                Iterator iterator = roleResult.iterator();
                while (iterator.hasNext()) {
                    JSTreeModel node = (JSTreeModel)iterator.next();
                    this.getOwnTreeModel(node, (List<JSTreeModel>)result, delResult);
                }
                result = roleResult;
                result.addAll(new ArrayList(delResult));
            }
            if ("edit".equals(functionType) || "add".equals(functionType)) {
                for (JSTreeModel jsTreeModel : gradeAdminStruList) {
                    String string = jsTreeModel.getType();
                    if ("ORGANROLE".equals(string)) {
                        Long roleId = jsTreeModel.getId();
                        if (rolesList.contains(roleId)) {
                            jsTreeModel.setState(true, true, false);
                        } else {
                            jsTreeModel.setState(false, false, false);
                        }
                        result.add(jsTreeModel);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                    result.add(jsTreeModel);
                }
            }
            List listOrganType = this.organTypeService.list();
            Map mapOrganType = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
            if (CollectionUtils.isNotEmpty(result)) {
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    JSTreeModel jsTreeModel = (JSTreeModel)iterator.next();
                    if (!HussarUtils.isNotBlank((CharSequence)jsTreeModel.getStruType())) continue;
                    jsTreeModel.setImgUrl(((SysOrganType)mapOrganType.get(jsTreeModel.getStruType())).getImgUrl());
                }
            }
        } else {
            String isSys = "";
            SysBaseConfig sysBaseConfig = this.baseConfigService.getSysBaseConfig("protection_status");
            if (HussarUtils.isNotEmpty((Object)sysBaseConfig) && "3".equals(sysBaseConfig.getConfigValue())) {
                isSys = "0";
            }
            result = this.getRoleTreeWithApp(appId, isSys);
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
            jsTreeModel.setId(Constants.RES_NODE_ID);
            jsTreeModel.setType("isRoot");
            result.add(jsTreeModel);
        }
        return result;
    }

    public List<JSTreeModel> getRoleMergeTree(RoleTreeDto roleTreeDto) {
        return TreeModelUtils.merge(this.getRoleTree(roleTreeDto));
    }

    private void getOwnTreeModel(JSTreeModel node, List<JSTreeModel> total, Set<JSTreeModel> result) {
        for (JSTreeModel jsTreeModel : total) {
            if (!HussarUtils.equals((Object)node.getParent(), (Object)jsTreeModel.getId())) continue;
            result.add(jsTreeModel);
            if (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)jsTreeModel.getId())) break;
            this.getOwnTreeModel(jsTreeModel, total, result);
            break;
        }
    }

    public boolean isContainsOrganRole(RoleTreeDto roleTreeDto) {
        List<JSTreeModel> struRoleList = this.getRoleTree(roleTreeDto);
        boolean flag = false;
        for (JSTreeModel stru : struRoleList) {
            String type = stru.getType();
            if (!"ORGANROLE".equals(type)) continue;
            flag = true;
        }
        return flag;
    }

    public List<JSTreeModel> getSelfRoleTree(String[] roleIds) {
        List<Object> tree = new ArrayList();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (!isGradeAdmin) {
            List result = this.sysOrgManageService.selfRoleTree(roleIds);
            tree = this.doRecursive(result);
        }
        return TreeModelUtils.merge(tree);
    }

    public List<Long> getUserRoleList(Long userId) {
        return this.sysUserRoleMapper.getRolesByUserId(userId);
    }

    public String getRoleDataScopeByUserId(Set<Long> orgList, Long userId) {
        List<Long> roleIds = this.getUserRoleList(userId);
        String type = "";
        if (ToolUtil.isNotEmpty(roleIds)) {
            List roles = this.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
            for (SysRoles role : roles) {
                String roleType = role.getDataScopeType();
                if (ToolUtil.isEmpty((Object)roleType)) continue;
                if (ToolUtil.isEmpty((Object)type)) {
                    type = roleType;
                }
                if (Long.parseLong(roleType) < Long.parseLong(type)) {
                    type = roleType;
                }
                if (!"5".equals(roleType)) continue;
                List orgIds = this.roleDataScopeService.getOrgListByRoleId(role.getId());
                orgList.addAll(orgIds);
            }
        }
        if (ToolUtil.isEmpty((Object)type)) {
            type = "1";
        }
        return type;
    }

    public IPage getRoleInfoList(Page page, RoleTreeQueryDto roleTreeQueryDto) {
        Long roleGroupOrDepId = roleTreeQueryDto.getNodeId();
        if (ToolUtil.isEmpty((Object)roleGroupOrDepId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NODE_ID_CANNOT_EMPTY.getMessage()));
        }
        Long appId = roleTreeQueryDto.getApplicationId();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        String containSys = "";
        SysBaseConfig sysBaseConfig = this.baseConfigService.getSysBaseConfig("protection_status");
        if (HussarUtils.isNotEmpty((Object)sysBaseConfig) && "3".equals(sysBaseConfig.getConfigValue())) {
            containSys = "0";
        }
        if (isGradeAdmin) {
            String roleName;
            HashMap mapperQuery = Maps.newHashMap();
            mapperQuery.put("deptId", roleGroupOrDepId);
            String string = roleName = roleTreeQueryDto.getRoleName() == null ? "" : roleTreeQueryDto.getRoleName().trim();
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                mapperQuery.put("roleName", roleName);
            }
            List<RoleInfoVO> roleInfoVOList = this.sysRolesMapper.findRoleList(page, mapperQuery);
            for (RoleInfoVO roleInfoVO : roleInfoVOList) {
                roleInfoVO.setRoleType("STRU_ROLE");
            }
            page.setRecords(roleInfoVOList);
        } else if (Constants.RES_NODE_ID.equals(roleGroupOrDepId) || HussarUtils.equals((Object)roleGroupOrDepId, (Object)appId)) {
            String groupName;
            if (HussarUtils.isEmpty((Object)appId)) {
                appId = 1L;
            }
            Page roleGroupPage = new Page(page.getCurrent(), page.getSize());
            LambdaQueryWrapper queryRoleCondition = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId)).eq(SysRoleGroup::getFromAppId, (Object)1L);
            String string = groupName = roleTreeQueryDto.getGroupName() == null ? "" : roleTreeQueryDto.getGroupName().trim();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                queryRoleCondition.like(SysRoleGroup::getGroupName, (Object)groupName);
            }
            queryRoleCondition.orderByAsc(SysRoleGroup::getGroupOrder);
            queryRoleCondition.orderByDesc(HussarBaseEntity::getCreateTime);
            queryRoleCondition.orderByDesc(SysRoleGroup::getId);
            this.sysRoleGroupMapper.selectPage((IPage)roleGroupPage, (Wrapper)queryRoleCondition);
            ArrayList fmtGroupDataList = Lists.newArrayList();
            for (SysRoleGroup roleGroup : roleGroupPage.getRecords()) {
                RoleGroupVo roleGroupVO = new RoleGroupVo();
                BeanUtils.copyProperties((Object)roleGroup, (Object)roleGroupVO);
                roleGroupVO.setRoleType("GROUP");
                fmtGroupDataList.add(roleGroupVO);
            }
            if (securityUser.getRolesList().contains(Constants.BUSSINESSADMIN_ROLE_ID)) {
                fmtGroupDataList.removeIf(l -> l.getId().equals(Constants.SYSTEM_ROLE_GROUP));
                page.setTotal(roleGroupPage.getTotal() - 1L);
            } else {
                page.setTotal(roleGroupPage.getTotal());
            }
            page.setRecords((List)fmtGroupDataList);
        } else {
            String roleName;
            HashMap mapperQuery = Maps.newHashMap();
            mapperQuery.put("roleGroupId", roleGroupOrDepId);
            String string = roleName = roleTreeQueryDto.getRoleName() == null ? "" : roleTreeQueryDto.getRoleName().trim();
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                mapperQuery.put("roleName", roleName);
            }
            if (StringUtils.isNotBlank((CharSequence)containSys)) {
                mapperQuery.put("containSys", containSys);
            }
            List<Object> roleInfoVOList = this.sysRolesMapper.findRoleList(page, mapperQuery);
            for (RoleInfoVO roleInfoVO : roleInfoVOList) {
                roleInfoVO.setRoleType("ROLE");
            }
            SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
            if (null != protectStatus && "3".equals(protectStatus.getConfigValue())) {
                roleInfoVOList = roleInfoVOList.stream().filter(r -> "0".equals(r.getIsSys())).collect(Collectors.toList());
            }
            page.setRecords(roleInfoVOList);
        }
        return page;
    }

    public IPage getRoleInfoListForGradeadmin(Page page) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        assert (securityUser != null);
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
            Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
            List childrenStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "01");
            childrenStruIdList.add(gradeParentId);
            QueryWrapper sysRolesQueryWrapper = new QueryWrapper();
            sysRolesQueryWrapper.lambda().in(SysRoles::getCorporationId, (Collection)childrenStruIdList);
            List sysRolesList = this.iSysRolesService.list((Wrapper)sysRolesQueryWrapper);
            ArrayList roleInfoVOList = new ArrayList();
            sysRolesList.forEach(o -> {
                RoleInfoVO roleInfoVO = new RoleInfoVO();
                BeanUtils.copyProperties((Object)o, (Object)roleInfoVO);
                roleInfoVO.setRoleType("STRU_ROLE");
                roleInfoVOList.add(roleInfoVO);
            });
            page.setRecords(roleInfoVOList);
            page.setTotal((long)roleInfoVOList.size());
        }
        return page;
    }

    public List<JSTreeModel> getRoleTreeByLazy(RoleTreeDto roleTreeDto) {
        Long nodeId = roleTreeDto.getNodeId();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            boolean isExport = roleTreeDto.isExport();
            return TreeModelUtils.merge(this.getLazyOrganRoleTree(nodeId, isExport, true));
        }
        return TreeModelUtils.merge(this.getLazyRoleTree(nodeId));
    }

    public List<JSTreeModel> getRoleUserTreeAdd() {
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ASSOCIATE_USER.getMessage()));
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (!"USER".equals(model.getType()) || !Constants.ROOT_NODE_ID.equals(model.getParent())) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return TreeModelUtils.merge((List)result);
    }

    public List<JSTreeModel> getRoleUserTreeEdit(String roleId) {
        boolean isSysRole = false;
        SysRoles role = (SysRoles)this.getById((Serializable)((Object)roleId));
        if (ToolUtil.isEmpty((Object)role)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_FIND_ROLE.getMessage()));
        }
        String sysRoleGroup = "sys_role_group";
        if (sysRoleGroup.equals(role.getGroupId())) {
            isSysRole = true;
        }
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ASSOCIATE_USER.getMessage()));
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        List<String> userRoles = this.sysUserRoleMapper.selectUserIdByRoleId(roleId);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (userRoles.contains(model.getId())) {
                model.setState(true, true, false);
            }
            if (!isSysRole && (!"USER".equals(model.getType()) || !Constants.ROOT_NODE_ID.equals(model.getParent()))) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return TreeModelUtils.merge((List)result);
    }

    public List<JSTreeModel> getRoleUserTreeView(Long roleId) {
        List result = this.sysUsersService.getUserByRole(roleId);
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ASSOCIATE_USER.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("isRoot");
        result.add(root);
        for (JSTreeModel model : result) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return this.filterNoChildNode(TreeModelUtils.merge((List)result));
    }

    private List<JSTreeModel> filterNoChildNode(List<JSTreeModel> items) {
        ArrayList<JSTreeModel> newItems = new ArrayList<JSTreeModel>();
        for (JSTreeModel model : items) {
            List children = model.getChildrenList();
            if ("USER".equals(model.getType())) {
                newItems.add(model);
                continue;
            }
            if (ToolUtil.isNotEmpty((Object)children)) {
                List<JSTreeModel> newChildren = this.filterNoChildNode(children);
                if (ToolUtil.isNotEmpty(newChildren)) {
                    model.setChildrenList(newChildren);
                    newItems.add(model);
                } else if (Constants.ROOT_NODE_ID.equals(model.getId())) {
                    model.setChildrenList(newChildren);
                }
            }
            if (!Constants.ROOT_NODE_ID.equals(model.getId()) || newItems.contains(model)) continue;
            newItems.add(model);
        }
        return newItems;
    }

    public List<JSTreeModel> getRoleUserTreeView(String roleId) {
        return this.getRoleUserTreeView(Long.parseLong(roleId));
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        ArrayList<Long> ids = new ArrayList<Long>();
        list.forEach(r -> {
            if ("ROLE".equals(r.getCode())) {
                ids.add(r.getId());
            }
        });
        this.recursive(list, result, ids);
        JSTreeModel model = new JSTreeModel();
        model.setId(Constants.RES_NODE_ID);
        model.setCode("GROUP");
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_TREE.getMessage()));
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, List<Long> ids) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<JSTreeModel> tempList = new ArrayList<JSTreeModel>();
        for (JSTreeModel map : list) {
            if (ids.contains(map.getId())) {
                result.add(map);
                if (map.getParent() == null) continue;
                parentIds.add(map.getParent());
                continue;
            }
            tempList.add(map);
        }
        if (ToolUtil.isNotEmpty(parentIds)) {
            this.recursive(tempList, result, parentIds);
        }
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object obj = objects.get(i);
                if (obj instanceof SysRoles) {
                    SysRoles role = (SysRoles)obj;
                    if (this.updateById((BaseEntity)role)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((BaseEntity)role);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysRoleGroup) {
                    SysRoleGroup roleGroup = (SysRoleGroup)obj;
                    if (SqlHelper.retBool((Integer)this.sysRoleGroupMapper.updateById(roleGroup))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysRoleGroupMapper.insert(roleGroup);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysRoleResource) {
                    SysRoleResource roleResource = (SysRoleResource)obj;
                    if (SqlHelper.retBool((Integer)this.sysRoleResourceMapper.update(roleResource, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysRoleResource::getRoleId, (Object)roleResource.getRoleId())).eq(SysRoleResource::getResourceId, (Object)roleResource.getResourceId())))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysRoleResourceMapper.insert(roleResource);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public void saveFunctions(RoleFuncDto roleFuncDto) {
        String functionsIds = roleFuncDto.getFunctionsIds();
        Long roleId = roleFuncDto.getRoleId();
        this.sysRoleFunctionsService.saveFunctions(functionsIds, roleId);
        List<Long> userIds = this.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        roleIdList.add(roleId);
        this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIdList);
    }

    public void saveResources(RoleResDto roleResDto) {
        String resourceId = roleResDto.getResourceId();
        Long roleId = roleResDto.getRoleId();
        this.sysRoleResourceService.saveRoleResourceAndRelation(resourceId, roleId);
        List<Long> userIds = this.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
    }

    private void validateParam(Object o, String mdType) {
        SysRoleGroup reqBO;
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysRoleGroup) {
            reqBO = (SysRoleGroup)o;
            if ("edit".equals(mdType) && null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_ID_NOT_NULL.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getGroupName())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_NAME_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getGroupName()) && 32 < reqBO.getGroupName().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_NAME_MAX_LENGTH.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getGroupAlias())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_ALIAS_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getGroupAlias()) && 32 < reqBO.getGroupAlias().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_ALIAS_MAX_LENGTH.getMessage()));
            }
        }
        if ("roleAdd".equals(mdType) && o instanceof SysRolesDto) {
            reqBO = (SysRolesDto)o;
            if (null == reqBO.getGroupId()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_ID_NOT_NULL.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleName())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_NAME_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleName()) && 32 < reqBO.getRoleName().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_NAME_MAX_LENGTH.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleAlias())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ALIAS_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleAlias()) && 32 < reqBO.getRoleAlias().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ALIAS_MAX_LENGTH.getMessage()));
            }
            this.checkRoleCode((SysRoles)reqBO, sBuffer);
        }
        if ("roleEdit".equals(mdType) && o instanceof SysRoles) {
            reqBO = (SysRoles)o;
            if (null == reqBO.getGroupId()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_ID_NOT_NULL.getMessage()));
            }
            if (null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_NULL.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleName())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_NAME_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleName()) && 32 < reqBO.getRoleName().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_NAME_MAX_LENGTH.getMessage()));
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleAlias())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ALIAS_NOT_NULL.getMessage()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleAlias()) && 32 < reqBO.getRoleAlias().length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ALIAS_MAX_LENGTH.getMessage()));
            }
            this.checkRoleCode((SysRoles)reqBO, sBuffer);
        }
        if (0 < sBuffer.length()) {
            String rspStr = sBuffer.substring(1);
            throw new BaseException(rspStr);
        }
    }

    private void checkRoleCode(SysRoles reqBO, StringBuffer sBuffer) {
        String roleCode = reqBO.getRoleCode();
        if (StringUtils.isNotBlank((CharSequence)roleCode)) {
            SysRoles sysRoles;
            if (128 < roleCode.length()) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_CODE_MAX_LENGTH.getMessage()));
            }
            if (HussarUtils.isNotEmpty((Object)(sysRoles = (SysRoles)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getRoleCode, (Object)roleCode)))) && !HussarUtils.equals((Object)sysRoles.getId(), (Object)reqBO.getId())) {
                sBuffer.append(",");
                sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.ROLE_CODE_EXIST.getMessage()));
            }
        }
    }

    public void insertOrUpdateRoleList(List<SysRoles> rolesList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(rolesList)) {
            this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ADD_DATA.getMessage()), (Object)rolesList.size());
            this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_EDIT_DATA.getMessage()), (Object)rolesList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysRoles::getId).collect(Collectors.toList());
        ArrayList<SysRoles> insertData = new ArrayList<SysRoles>();
        ArrayList<SysRoles> updateData = new ArrayList<SysRoles>();
        Integer maxOrder = this.sysRolesMapper.getMaxOrder();
        for (SysRoles item : rolesList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            item.setRoleOrder(maxOrder);
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ADD_DATA.getMessage()), (Object)insertData.size());
        this.logger.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_EDIT_DATA.getMessage()), (Object)updateData.size());
    }

    public Integer getMaxOrder() {
        return this.sysRolesMapper.getMaxOrder();
    }

    @HussarTransactional
    public ApiResponse<Long> addAppDevRole(String appName, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        SysRoles sysRoles = new SysRoles();
        Long roleId = IdWorker.getId((Object)sysRoles);
        String roleName = appName + "\u5f00\u53d1\u8005";
        sysRoles.setId(roleId);
        sysRoles.setRoleName(roleName);
        sysRoles.setRoleAlias(roleName);
        sysRoles.setCorporationId(Long.valueOf(0L));
        sysRoles.setIsSys("2");
        sysRoles.setAppId(appId);
        sysRoles.setFromAppId(Long.valueOf(1L));
        Integer order = this.iSysRolesService.getMaxOrder();
        order = HussarUtils.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
        sysRoles.setRoleOrder(order);
        int insert = this.sysRolesMapper.insert(sysRoles);
        if (insert > 0) {
            return ApiResponse.success((Object)roleId);
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_DEVELOP_ROLE.getMessage()));
    }

    public void reclaimPerm(Long id) {
        this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getRoleId, (Object)id));
        List<Long> userIds = this.delCacheAuthInfo(id);
        HashMap<String, Long> columnMap = new HashMap<String, Long>();
        columnMap.put("ROLE_ID", id);
        this.sysRoleFunctionsService.removeByMap(columnMap);
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
        SysRoles role = (SysRoles)this.getById(id);
        if (HussarUtils.isNotEmpty((Object)role.getAppId()) && role.getAppId() != 1L) {
            this.roleFunctionChangeNotify.notify(DataChangeType.RELATE, new Object[]{id, null});
            this.roleResourceChangeNotify.notify(DataChangeType.RELATE, new Object[]{id, null});
        }
        HussarCacheUtil.evict((String)"data_scope_type", (Object)("'data_scope_type:'" + id));
    }

    public Page<RoleUserVo> searchUserListBatch(PageInfo pageInfo, QueryUserDto userDto) {
        String userAccountStr;
        String userNameStr = HussarUtils.isNotBlank((CharSequence)userDto.getUserName()) ? userDto.getUserName() : "";
        String string = userAccountStr = HussarUtils.isNotBlank((CharSequence)userDto.getUserAccount()) ? userDto.getUserAccount() : "";
        if (HussarUtils.isBlank((CharSequence)userNameStr) && HussarUtils.isBlank((CharSequence)userAccountStr)) {
            return this.sysUsersService.getUsersByNameSingle(pageInfo, userDto);
        }
        if (!(userNameStr.contains(",") || userNameStr.contains("\uff0c") || userAccountStr.contains(",") || userAccountStr.contains("\uff0c"))) {
            return this.sysUsersService.getUsersByNameSingle(pageInfo, userDto);
        }
        List<Object> userNameList = new ArrayList();
        if (HussarUtils.isNotBlank((CharSequence)userNameStr) && (userNameStr.contains(",") || userNameStr.contains("\uff0c"))) {
            String userName = userNameStr.replace("\uff0c", ",");
            String[] userNameArray = userName.split(",");
            userNameList = Arrays.asList(userNameArray);
        }
        List<Object> userAccountList = new ArrayList();
        if (HussarUtils.isNotBlank((CharSequence)userAccountStr) && (userAccountStr.contains(",") || userAccountStr.contains("\uff0c"))) {
            String userAccount = userAccountStr.replace("\uff0c", ",");
            String[] userAccountArray = userAccount.split(",");
            userAccountList = Arrays.asList(userAccountArray);
        }
        return this.sysUsersService.getUsersByNameList(pageInfo, userNameList, userAccountList, userDto);
    }

    public Long saveRoleNoSign(SysRolesDto sysRolesDto) {
        if (ToolUtil.isEmpty((Object)sysRolesDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_INFO_EMPTY.getMessage()));
        }
        if (StringUtils.isBlank((CharSequence)sysRolesDto.getRoleAlias())) {
            sysRolesDto.setRoleAlias(sysRolesDto.getRoleName());
        }
        try {
            this.validateParam(sysRolesDto, "roleAdd");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        SysRoles sysRoles = new SysRoles();
        BeanUtils.copyProperties((Object)sysRolesDto, (Object)sysRoles);
        if (HussarUtils.isEmpty((Object)sysRoles.getRoleOrder())) {
            Integer order = this.iSysRolesService.getMaxOrder();
            order = HussarUtils.isEmpty((Object)order) ? Integer.valueOf(1) : Integer.valueOf(order + 1);
            sysRoles.setRoleOrder(order);
        }
        Long checkNodeId = sysRolesDto.getGroupId();
        sysRoles.setIsSys("0");
        sysRoles.setCorporationId(Long.valueOf(0L));
        sysRoles.setGroupId(checkNodeId);
        this.sysRolesMapper.insert(sysRoles);
        if (HussarUtils.isNotEmpty((Object)sysRoles.getAppId()) && sysRoles.getAppId() != 1L) {
            this.roleChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysRoles});
        }
        this.bpmAbstractPushMsgMatcher.pushRole("add", sysRoles, null);
        return sysRoles.getId();
    }

    public void updateRoleNoSign(SysRoles sysRoles) {
        if (ToolUtil.isEmpty((Object)sysRoles)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_INFO_EMPTY.getMessage()));
        }
        if (StringUtils.isBlank((CharSequence)sysRoles.getRoleAlias())) {
            sysRoles.setRoleAlias(sysRoles.getRoleName());
        }
        try {
            this.validateParam(sysRoles, "roleEdit");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        this.sysRolesMapper.updateById(sysRoles);
        SysRoles role = (SysRoles)this.sysRolesMapper.selectById(sysRoles.getId());
        sysRoles.setAppId(role.getAppId());
        if (HussarUtils.isNotEmpty((Object)sysRoles.getAppId()) && sysRoles.getAppId() != 1L) {
            this.roleChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysRoles});
        }
        this.bpmAbstractPushMsgMatcher.pushRole("update", sysRoles, null);
        List<Long> userIds = this.delCacheAuthInfo(sysRoles.getId());
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
    }

    private void judgeWhetherItCanBeDelete(Long roleId) {
        List list = this.isConfRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getRoleId, (Object)roleId));
        if (ToolUtil.isNotEmpty((Object)list)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_ALREADY_ASSOCIATED_INCOMPATIBLE_USER.getMessage()));
        }
    }

    public void fillHasChildren(AbstractNoIconHussarLazyTreeDefinition hussarLazyTreeDefinition) {
        if (HussarUtils.isNotEmpty((Object)hussarLazyTreeDefinition.getChildren())) {
            hussarLazyTreeDefinition.setHasChildren(Boolean.TRUE);
            for (Object child : hussarLazyTreeDefinition.getChildren()) {
                this.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)child);
            }
        } else {
            hussarLazyTreeDefinition.setHasChildren(Boolean.FALSE);
        }
    }
}

